/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.Env;
import com.fr.general.DefaultValues;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.stable.LicUtils;
import java.io.InputStream;
import java.util.Locale;

public class FRContext {
    private FRContext() {
    }

    public static Locale getLocale() {
        return GeneralContext.getLocale();
    }

    public static void setLanguage(int n2) {
        GeneralContext.setLanguage(n2);
    }

    public static FRLogger getLogger() {
        return FRLogger.getLogger();
    }

    public static DefaultValues getDefaultValues() {
        return GeneralContext.getDefaultValues();
    }

    public static InputStream getResourceStream(String string) {
        Env env = FRContext.getCurrentEnv();
        if (env != null) {
            try {
                InputStream inputStream = env.readResource(string);
                if (inputStream != null) {
                    FRContext.getLogger().info(Inter.getLocText("FR-Base-Load_Resource_File") + ":\"" + string + "\".");
                }
                return inputStream;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Env getCurrentEnv() {
        return (Env)GeneralContext.getEnvProvider();
    }

    public static void setCurrentEnv(Env env) {
        GeneralContext.setEnvProvider(env);
        GeneralContext.fireEnvChangeListener();
        GeneralContext.resetDefaultValues();
    }

    public static String getCompanyName() {
        return LicUtils.getItemFromLic("COMPANYNAME");
    }

    public static boolean isChineseEnv() {
        return GeneralContext.isChineseEnv();
    }
}

