/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.DeploymentQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.ProcessDefinitionQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.ModelEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Job;

public class DeploymentEntityManager
extends AbstractManager {
    public void insertDeployment(DeploymentEntity deployment) {
        this.getDbSqlSession().insert(deployment);
        for (ResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceManager().insertResource(resource);
        }
    }

    public void deleteDeployment(String deploymentId, boolean cascade) {
        String processDefinitionId;
        List processDefinitions = this.getDbSqlSession().createProcessDefinitionQuery().deploymentId(deploymentId).list();
        List models = this.getDbSqlSession().createModelQueryImpl().deploymentId(deploymentId).list();
        for (Model model : models) {
            ModelEntity modelEntity = (ModelEntity)model;
            modelEntity.setDeploymentId(null);
            this.getModelManager().updateModel(modelEntity);
        }
        if (cascade) {
            for (ProcessDefinition processDefinition : processDefinitions) {
                processDefinitionId = processDefinition.getId();
                this.getProcessInstanceManager().deleteProcessInstancesByProcessDefinition(processDefinitionId, "deleted deployment", cascade);
            }
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionId = processDefinition.getId();
            this.getIdentityLinkManager().deleteIdentityLinksByProcDef(processDefinitionId);
            this.getEventSubscriptionManager().deleteEventSubscriptionsForProcessDefinition(processDefinitionId);
            this.getProcessDefinitionInfoManager().deleteProcessDefinitionInfo(processDefinitionId);
        }
        this.getProcessDefinitionManager().deleteProcessDefinitionsByDeploymentId(deploymentId);
        for (ProcessDefinition processDefinition : processDefinitions) {
            List<Job> timerStartJobs = Context.getCommandContext().getJobEntityManager().findJobsByTypeAndProcessDefinitionId("timer-start-event", processDefinition.getId());
            if (timerStartJobs != null && timerStartJobs.size() > 0) {
                for (Job timerStartJob : timerStartJobs) {
                    if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, timerStartJob, null, null, processDefinition.getId()));
                    }
                    ((JobEntity)timerStartJob).delete();
                }
            }
            ProcessDefinitionEntity latestProcessDefinition = null;
            latestProcessDefinition = processDefinition.getTenantId() != null && !"".equals(processDefinition.getTenantId()) ? Context.getCommandContext().getProcessDefinitionEntityManager().findLatestProcessDefinitionByKeyAndTenantId(processDefinition.getKey(), processDefinition.getTenantId()) : Context.getCommandContext().getProcessDefinitionEntityManager().findLatestProcessDefinitionByKey(processDefinition.getKey());
            if (processDefinition.getId().equals(latestProcessDefinition.getId())) {
                ProcessDefinitionEntity resolvedProcessDefinition;
                List timerDeclarations;
                ProcessDefinitionEntity previousProcessDefinition = null;
                for (int previousVersion = processDefinition.getVersion() - 1; previousProcessDefinition == null && previousVersion > 0; --previousVersion) {
                    ProcessDefinitionQueryImpl previousProcessDefinitionQuery = new ProcessDefinitionQueryImpl(Context.getCommandContext()).processDefinitionVersion(previousVersion).processDefinitionKey(processDefinition.getKey());
                    if (processDefinition.getTenantId() != null && !"".equals(processDefinition.getTenantId())) {
                        previousProcessDefinitionQuery.processDefinitionTenantId(processDefinition.getTenantId());
                    } else {
                        previousProcessDefinitionQuery.processDefinitionWithoutTenantId();
                    }
                    previousProcessDefinition = (ProcessDefinitionEntity)previousProcessDefinitionQuery.singleResult();
                }
                if (previousProcessDefinition != null && (timerDeclarations = (List)(resolvedProcessDefinition = Context.getProcessEngineConfiguration().getDeploymentManager().resolveProcessDefinition(previousProcessDefinition)).getProperty("timerStart")) != null) {
                    for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                        TimerEntity timer = timerDeclaration.prepareTimerEntity(null);
                        timer.setProcessDefinitionId(previousProcessDefinition.getId());
                        if (previousProcessDefinition.getTenantId() != null) {
                            timer.setTenantId(previousProcessDefinition.getTenantId());
                        }
                        Context.getCommandContext().getJobEntityManager().schedule(timer);
                    }
                }
            }
            List<EventSubscriptionEntity> findEventSubscriptionsByConfiguration = Context.getCommandContext().getEventSubscriptionEntityManager().findEventSubscriptionsByConfiguration("message", processDefinition.getId(), processDefinition.getTenantId());
            for (EventSubscriptionEntity eventSubscriptionEntity : findEventSubscriptionsByConfiguration) {
                eventSubscriptionEntity.delete();
            }
        }
        this.getResourceManager().deleteResourcesByDeploymentId(deploymentId);
        this.getDbSqlSession().delete("deleteDeployment", deploymentId);
    }

    public DeploymentEntity findLatestDeploymentByName(String deploymentName) {
        List list = this.getDbSqlSession().selectList("selectDeploymentsByName", deploymentName, 0, 1);
        if (list != null && !list.isEmpty()) {
            return (DeploymentEntity)list.get(0);
        }
        return null;
    }

    public DeploymentEntity findDeploymentById(String deploymentId) {
        return (DeploymentEntity)this.getDbSqlSession().selectOne("selectDeploymentById", deploymentId);
    }

    public long findDeploymentCountByQueryCriteria(DeploymentQueryImpl deploymentQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectDeploymentCountByQueryCriteria", deploymentQuery);
    }

    public List<Deployment> findDeploymentsByQueryCriteria(DeploymentQueryImpl deploymentQuery, Page page) {
        String query = "selectDeploymentsByQueryCriteria";
        return this.getDbSqlSession().selectList("selectDeploymentsByQueryCriteria", deploymentQuery, page);
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.getDbSqlSession().getSqlSession().selectList("selectResourceNamesByDeploymentId", (Object)deploymentId);
    }

    public List<Deployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectDeploymentByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectDeploymentCountByNativeQuery", parameterMap);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

