/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d;

import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.line.LinearShape2D;

public class Angle2D {
    public static final double M_PI = Math.PI;
    public static final double M_2PI = Math.PI * 2;
    public static final double M_PI_2 = 1.5707963267948966;
    public static final double M_3PI_2 = 4.71238898038469;
    public static final double M_PI_4 = 0.7853981633974483;

    public static double formatAngle(double angle) {
        return (angle % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2);
    }

    public static double horizontalAngle(Point2D point) {
        return (Math.atan2(point.y, point.x) + Math.PI * 2) % (Math.PI * 2);
    }

    public static double horizontalAngle(double x, double y) {
        return (Math.atan2(y, x) + Math.PI * 2) % (Math.PI * 2);
    }

    public static double horizontalAngle(Vector2D vect) {
        return (Math.atan2(vect.y, vect.x) + Math.PI * 2) % (Math.PI * 2);
    }

    public static double horizontalAngle(LinearShape2D object) {
        Vector2D vect = object.supportingLine().direction();
        return (Math.atan2(vect.y, vect.x) + Math.PI * 2) % (Math.PI * 2);
    }

    public static double horizontalAngle(Point2D p1, Point2D p2) {
        return (Math.atan2(p2.y - p1.y, p2.x - p1.x) + Math.PI * 2) % (Math.PI * 2);
    }

    public static double horizontalAngle(double x1, double y1, double x2, double y2) {
        return (Math.atan2(y2 - y1, x2 - x1) + Math.PI * 2) % (Math.PI * 2);
    }

    public static double pseudoAngle(Point2D p1, Point2D p2) {
        double t;
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        double s = Math.abs(dx) + Math.abs(dy);
        double d = t = s == 0.0 ? 0.0 : dy / s;
        if (dx < 0.0) {
            t = 2.0 - t;
        } else if (dy < 0.0) {
            t += 4.0;
        }
        return t * 90.0;
    }

    public static double angle(LinearShape2D obj1, LinearShape2D obj2) {
        double angle1 = obj1.horizontalAngle();
        double angle2 = obj2.horizontalAngle();
        return (angle2 - angle1 + Math.PI * 2) % (Math.PI * 2);
    }

    public static double angle(Vector2D vect1, Vector2D vect2) {
        double angle1 = Angle2D.horizontalAngle(vect1);
        double angle2 = Angle2D.horizontalAngle(vect2);
        return (angle2 - angle1 + Math.PI * 2) % (Math.PI * 2);
    }

    public static double angle(Point2D p1, Point2D p2, Point2D p3) {
        double angle1 = Angle2D.horizontalAngle(p2, p1);
        double angle2 = Angle2D.horizontalAngle(p2, p3);
        return (angle2 - angle1 + Math.PI * 2) % (Math.PI * 2);
    }

    public static double angle(double x1, double y1, double x2, double y2, double x3, double y3) {
        double angle1 = Angle2D.horizontalAngle(x2, y2, x1, y1);
        double angle2 = Angle2D.horizontalAngle(x2, y2, x3, y3);
        return (angle2 - angle1 + Math.PI * 2) % (Math.PI * 2);
    }

    public static double absoluteAngle(Point2D p1, Point2D p2, Point2D p3) {
        double angle1 = Angle2D.horizontalAngle(new Vector2D(p2, p1));
        double angle2 = Angle2D.horizontalAngle(new Vector2D(p2, p3));
        angle1 = (angle2 - angle1 + Math.PI * 2) % (Math.PI * 2);
        if (angle1 < Math.PI) {
            return angle1;
        }
        return Math.PI * 2 - angle1;
    }

    public static double absoluteAngle(double x1, double y1, double x2, double y2, double x3, double y3) {
        double angle1 = Angle2D.horizontalAngle(x2, y2, x1, y1);
        double angle2 = Angle2D.horizontalAngle(x2, y2, x3, y3);
        angle1 = (angle2 - angle1 + Math.PI * 2) % (Math.PI * 2);
        if (angle1 < Math.PI) {
            return angle1;
        }
        return Math.PI * 2 - angle1;
    }

    public static boolean almostEquals(double angle1, double angle2, double eps) {
        double diff = Angle2D.formatAngle((angle1 = Angle2D.formatAngle(angle1)) - (angle2 = Angle2D.formatAngle(angle2)));
        if (diff < eps) {
            return true;
        }
        return Math.abs(diff - Math.PI * 2) < eps;
    }

    public static boolean equals(double angle1, double angle2) {
        double diff = Angle2D.formatAngle((angle1 = Angle2D.formatAngle(angle1)) - (angle2 = Angle2D.formatAngle(angle2)));
        if (diff < 1.0E-12) {
            return true;
        }
        return Math.abs(diff - Math.PI * 2) < 1.0E-12;
    }

    public static boolean containsAngle(double startAngle, double endAngle, double angle) {
        startAngle = Angle2D.formatAngle(startAngle);
        endAngle = Angle2D.formatAngle(endAngle);
        angle = Angle2D.formatAngle(angle);
        if (startAngle < endAngle) {
            return angle >= startAngle && angle <= endAngle;
        }
        return angle <= endAngle || angle >= startAngle;
    }

    public static boolean containsAngle(double startAngle, double endAngle, double angle, boolean direct) {
        startAngle = Angle2D.formatAngle(startAngle);
        endAngle = Angle2D.formatAngle(endAngle);
        angle = Angle2D.formatAngle(angle);
        if (direct) {
            if (startAngle < endAngle) {
                return angle >= startAngle && angle <= endAngle;
            }
            return angle <= endAngle || angle >= startAngle;
        }
        if (startAngle < endAngle) {
            return angle <= startAngle || angle >= endAngle;
        }
        return angle >= endAngle && angle <= startAngle;
    }
}

