/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.platform.tables;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dialect.SybaseDialect;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.AbstractModuleTables;
import com.fr.data.core.db.tableObject.AbstractTableObject;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.core.db.tableObject.ColumnSize;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class QuartzTables
extends AbstractModuleTables {
    public static void main(String[] stringArray) {
        new QuartzTables().loadSybaseCreateTableSql();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generatorModuleTables(Connection connection) {
        if (DialectFactory.generateDialect((Connection)connection) instanceof SybaseDialect) {
            if (new QRTZ_JOB_DETAILS().checkExist(connection)) {
                return;
            }
            Object var2_2 = null;
            try {
                List list = this.loadSybaseCreateTableSql();
                Statement statement = connection.createStatement();
                for (int i = 0; i < list.size(); ++i) {
                    String string = list.get(i).toString();
                    statement.addBatch(string);
                    FRContext.getLogger().info("Execute SQL: " + string);
                }
                statement.executeBatch();
            }
            catch (SQLException sQLException) {
                FRContext.getLogger().errorWithServerLevel(sQLException.getMessage(), (Throwable)sQLException);
                DBUtils.closeStatement(var2_2);
                var2_2 = null;
            }
            finally {
                DBUtils.closeStatement(var2_2);
                var2_2 = null;
            }
            return;
        }
        super.generatorModuleTables(connection);
        this.initQRTZ_LOCKSData(connection);
    }

    protected void initTableObjectList() {
        this.tableObjectList.add(new QRTZ_JOB_DETAILS());
        this.tableObjectList.add(new QRTZ_JOB_LISTENERS());
        this.tableObjectList.add(new QRTZ_TRIGGERS());
        this.tableObjectList.add(new QRTZ_SIMPLE_TRIGGERS());
        this.tableObjectList.add(new QRTZ_CRON_TRIGGERS());
        this.tableObjectList.add(new QRTZ_BLOB_TRIGGERS());
        this.tableObjectList.add(new QRTZ_TRIGGER_LISTENERS());
        this.tableObjectList.add(new QRTZ_CALENDARS());
        this.tableObjectList.add(new QRTZ_PAUSED_TRIGGER_GRPS());
        this.tableObjectList.add(new QRTZ_FIRED_TRIGGERS());
        this.tableObjectList.add(new QRTZ_SCHEDULER_STATE());
        this.tableObjectList.add(new QRTZ_LOCKS());
    }

    public void removeModuleTables(Connection connection) {
        this.droptableList.clear();
        this.droptableList.add(new QRTZ_JOB_LISTENERS());
        this.droptableList.add(new QRTZ_SIMPLE_TRIGGERS());
        this.droptableList.add(new QRTZ_CRON_TRIGGERS());
        this.droptableList.add(new QRTZ_BLOB_TRIGGERS());
        this.droptableList.add(new QRTZ_TRIGGER_LISTENERS());
        this.droptableList.add(new QRTZ_CALENDARS());
        this.droptableList.add(new QRTZ_PAUSED_TRIGGER_GRPS());
        this.droptableList.add(new QRTZ_FIRED_TRIGGERS());
        this.droptableList.add(new QRTZ_SCHEDULER_STATE());
        this.droptableList.add(new QRTZ_LOCKS());
        this.droptableList.add(new QRTZ_TRIGGERS());
        this.droptableList.add(new QRTZ_JOB_DETAILS());
        super.removeModuleTables(connection);
    }

    private List loadSybaseCreateTableSql() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = BaseUtils.readResourceAsString((String)"com/fr/web/platform/tables/tables_sybase.sql").split("go");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].replaceAll("/\\*.*", "").trim();
            if ((string = string.replaceAll("IF.*", "").trim()).equals("")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initQRTZ_LOCKSData(Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM QRTZ_LOCKS");
            if (resultSet.next()) {
                return;
            }
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
        }
        try {
            statement = connection.createStatement();
            statement.addBatch("INSERT INTO QRTZ_LOCKS values('TRIGGER_ACCESS')");
            statement.addBatch("INSERT INTO QRTZ_LOCKS values('JOB_ACCESS')");
            statement.addBatch("INSERT INTO QRTZ_LOCKS values('CALENDAR_ACCESS')");
            statement.addBatch("INSERT INTO QRTZ_LOCKS values('STATE_ACCESS')");
            statement.addBatch("INSERT INTO QRTZ_LOCKS values('MISFIRE_ACCESS')");
            statement.executeBatch();
            statement.close();
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (SQLException sQLException2) {
                FRContext.getLogger().error(sQLException2.getMessage(), (Throwable)sQLException2);
            }
        }
    }

    private class QRTZ_LOCKS
    extends AbstractTableObject {
        private QRTZ_LOCKS() {
        }

        public void initColumns() {
            this.addColumn("LOCK_NAME", 12, new ColumnSize(40), false, true);
        }

        public Table getTable() {
            return new Table("QRTZ_LOCKS");
        }
    }

    private class QRTZ_SCHEDULER_STATE
    extends AbstractTableObject {
        private QRTZ_SCHEDULER_STATE() {
        }

        public void initColumns() {
            this.addColumn("INSTANCE_NAME", 12, new ColumnSize(200), false, true);
            this.addColumn("LAST_CHECKIN_TIME", -5, new ColumnSize(13), false);
            this.addColumn("CHECKIN_INTERVAL", -5, new ColumnSize(13), false);
        }

        public Table getTable() {
            return new Table("QRTZ_SCHEDULER_STATE");
        }
    }

    private class QRTZ_FIRED_TRIGGERS
    extends AbstractTableObject {
        private QRTZ_FIRED_TRIGGERS() {
        }

        public void initColumns() {
            this.addColumn("ENTRY_ID", 12, new ColumnSize(95), false, true);
            this.addColumn("TRIGGER_NAME", 12, new ColumnSize(200), false);
            this.addColumn("TRIGGER_GROUP", 12, new ColumnSize(200), false);
            this.addColumn("IS_VOLATILE", -7, new ColumnSize(1), false);
            this.addColumn("INSTANCE_NAME", 12, new ColumnSize(200), false);
            this.addColumn("FIRED_TIME", -5, new ColumnSize(13), false);
            this.addColumn("PRIORITY", 4, new ColumnSize(13), false);
            this.addColumn("STATE", 12, new ColumnSize(16), false);
            this.addColumn("JOB_NAME", 12, new ColumnSize(200));
            this.addColumn("JOB_GROUP", 12, new ColumnSize(200));
            this.addColumn("IS_STATEFUL", -7, new ColumnSize(1));
            this.addColumn("REQUESTS_RECOVERY", -7, new ColumnSize(1));
        }

        public Table getTable() {
            return new Table("QRTZ_FIRED_TRIGGERS");
        }
    }

    private class QRTZ_PAUSED_TRIGGER_GRPS
    extends AbstractTableObject {
        private QRTZ_PAUSED_TRIGGER_GRPS() {
        }

        public void initColumns() {
            this.addColumn("TRIGGER_GROUP", 12, new ColumnSize(200), false, true);
        }

        public Table getTable() {
            return new Table("QRTZ_PAUSED_TRIGGER_GRPS");
        }
    }

    private class QRTZ_CALENDARS
    extends AbstractTableObject {
        private QRTZ_CALENDARS() {
        }

        public void initColumns() {
            this.addColumn("CALENDAR_NAME", 12, new ColumnSize(200), false, true);
            this.addColumn("CALENDAR", 2004, new ColumnSize(2000), false);
        }

        public Table getTable() {
            return new Table("QRTZ_CALENDARS");
        }
    }

    private class QRTZ_TRIGGER_LISTENERS
    extends AbstractTableObject {
        private QRTZ_TRIGGER_LISTENERS() {
        }

        public void initColumns() {
            Column column = new Column("TRIGGER_NAME", 12, new ColumnSize(200), null, false, true, false);
            column.setForeignKey(true);
            this.addColumn(column);
            column = new Column("TRIGGER_GROUP", 12, new ColumnSize(200), null, false, true, false);
            column.setForeignKey(true);
            this.addColumn(column);
            this.addColumn("TRIGGER_LISTENER", 12, new ColumnSize(200), false, true);
        }

        public String foreignReference() {
            return "QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)";
        }

        public Table getTable() {
            return new Table("QRTZ_TRIGGER_LISTENERS");
        }
    }

    private class QRTZ_BLOB_TRIGGERS
    extends AbstractTableObject {
        private QRTZ_BLOB_TRIGGERS() {
        }

        public void initColumns() {
            Column column = new Column("TRIGGER_NAME", 12, new ColumnSize(200), null, false, true, false);
            column.setForeignKey(true);
            this.addColumn(column);
            column = new Column("TRIGGER_GROUP", 12, new ColumnSize(200), null, false, true, false);
            column.setForeignKey(true);
            this.addColumn(column);
            this.addColumn("BLOB_DATA", 2004, new ColumnSize(2000));
        }

        public String foreignReference() {
            return "QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)";
        }

        public Table getTable() {
            return new Table("QRTZ_BLOB_TRIGGERS");
        }
    }

    private class QRTZ_CRON_TRIGGERS
    extends AbstractTableObject {
        private QRTZ_CRON_TRIGGERS() {
        }

        public void initColumns() {
            Column column = new Column("TRIGGER_NAME", 12, new ColumnSize(200), null, false, true, false);
            column.setForeignKey(true);
            this.addColumn(column);
            column = new Column("TRIGGER_GROUP", 12, new ColumnSize(200), null, false, true, false);
            column.setForeignKey(true);
            this.addColumn(column);
            this.addColumn("CRON_EXPRESSION", 12, new ColumnSize(120), false);
            this.addColumn("TIME_ZONE_ID", 12, new ColumnSize(80));
        }

        public String foreignReference() {
            return "QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)";
        }

        public Table getTable() {
            return new Table("QRTZ_CRON_TRIGGERS");
        }
    }

    private class QRTZ_SIMPLE_TRIGGERS
    extends AbstractTableObject {
        private QRTZ_SIMPLE_TRIGGERS() {
        }

        public void initColumns() {
            Column column = new Column("TRIGGER_NAME", 12, new ColumnSize(200), null, false, true, false);
            column.setForeignKey(true);
            this.addColumn(column);
            column = new Column("TRIGGER_GROUP", 12, new ColumnSize(200), null, false, true, false);
            column.setForeignKey(true);
            this.addColumn(column);
            this.addColumn("REPEAT_COUNT", -5, new ColumnSize(7), false);
            this.addColumn("REPEAT_INTERVAL", -5, new ColumnSize(12), false);
            this.addColumn("TIMES_TRIGGERED", -5, new ColumnSize(10), false);
        }

        public String foreignReference() {
            return "QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)";
        }

        public Table getTable() {
            return new Table("QRTZ_SIMPLE_TRIGGERS");
        }
    }

    private class QRTZ_TRIGGERS
    extends AbstractTableObject {
        private QRTZ_TRIGGERS() {
        }

        public void initColumns() {
            this.addColumn("TRIGGER_NAME", 12, new ColumnSize(200), false, true);
            this.addColumn("TRIGGER_GROUP", 12, new ColumnSize(200), false, true);
            Column column = new Column("JOB_NAME", 12, new ColumnSize(200), null, false, false, false);
            column.setForeignKey(true);
            this.addColumn(column);
            column = new Column("JOB_GROUP", 12, new ColumnSize(200), null, false, false, false);
            column.setForeignKey(true);
            this.addColumn(column);
            this.addColumn("IS_VOLATILE", -7, new ColumnSize(1), false);
            this.addColumn("DESCRIPTION", 12, new ColumnSize(250));
            this.addColumn("NEXT_FIRE_TIME", -5, new ColumnSize(13));
            this.addColumn("PREV_FIRE_TIME", -5, new ColumnSize(13));
            this.addColumn("PRIORITY", 4, new ColumnSize(13));
            this.addColumn("TRIGGER_STATE", 12, new ColumnSize(16), false);
            this.addColumn("TRIGGER_TYPE", 12, new ColumnSize(8), false);
            this.addColumn("START_TIME", -5, new ColumnSize(13), false);
            this.addColumn("END_TIME", -5, new ColumnSize(13));
            this.addColumn("CALENDAR_NAME", 12, new ColumnSize(200));
            this.addColumn("MISFIRE_INSTR", 5, new ColumnSize(2));
            this.addColumn("JOB_DATA", 2004, new ColumnSize(2000));
        }

        public String foreignReference() {
            return "QRTZ_JOB_DETAILS(JOB_NAME,JOB_GROUP)";
        }

        public Table getTable() {
            return new Table("QRTZ_TRIGGERS");
        }
    }

    private class QRTZ_JOB_LISTENERS
    extends AbstractTableObject {
        private QRTZ_JOB_LISTENERS() {
        }

        public void initColumns() {
            Column column = new Column("JOB_NAME", 12, new ColumnSize(200), null, false, true, false);
            column.setForeignKey(true);
            this.addColumn(column);
            column = new Column("JOB_GROUP", 12, new ColumnSize(200), null, false, true, false);
            column.setForeignKey(true);
            this.addColumn(column);
            this.addColumn("JOB_LISTENER", 12, new ColumnSize(200), false, true);
        }

        public String foreignReference() {
            return "QRTZ_JOB_DETAILS(JOB_NAME,JOB_GROUP)";
        }

        public Table getTable() {
            return new Table("QRTZ_JOB_LISTENERS");
        }
    }

    private class QRTZ_JOB_DETAILS
    extends AbstractTableObject {
        private QRTZ_JOB_DETAILS() {
        }

        public void initColumns() {
            this.addColumn("JOB_NAME", 12, new ColumnSize(200), false, true);
            this.addColumn("JOB_GROUP", 12, new ColumnSize(200), false, true);
            this.addColumn("DESCRIPTION", 12, new ColumnSize(250));
            this.addColumn("JOB_CLASS_NAME", 12, new ColumnSize(250), false);
            this.addColumn("IS_DURABLE", -7, new ColumnSize(1), false);
            this.addColumn("IS_VOLATILE", -7, new ColumnSize(1), false);
            this.addColumn("IS_STATEFUL", -7, new ColumnSize(1), false);
            this.addColumn("REQUESTS_RECOVERY", 12, new ColumnSize(1), false);
            this.addColumn("JOB_DATA", 2004, new ColumnSize(2000));
        }

        public Table getTable() {
            return new Table("QRTZ_JOB_DETAILS");
        }
    }
}

