/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.CompatiableIDFCMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.fs.fun.FileSenderProcessor;
import com.fr.fs.plugin.ExtraPlatformClassManager;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.general.FRLogger;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.schedule.output.AbstractOutputFileAction;
import com.fr.schedule.output.DefaultFileSenderProcessor;
import com.fr.schedule.output.OutputFileAction;
import com.fr.schedule.output.ftp.DefaultFTPTransmit;
import com.fr.schedule.plugin.ExtraPlatformScheduleClassManager;
import com.fr.schedule.plugin.FTPTransmitProcessor;
import com.fr.schedule.util.ScheduleLogUtils;
import java.io.File;

public class FTPTransmission
extends AbstractOutputFileAction {
    public static final String TABLE_NAME = "fr_schedule_ftp";
    private static FRLogger log = FRLogger.getLogger();
    public static final ObjectTableMapper OBJECT_MAPPER = new ObjectTableMapper(FTPTransmission.class, new Table("fr_schedule_ftp"), new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", 4, new ColumnSize(20), false, true), new CommonFieldColumnMapper("serverAddress", 12, "serverAddress", new ColumnSize(255), true), new CommonFieldColumnMapper("port", 4, "port", new ColumnSize(255), true), new CommonFieldColumnMapper("savePath", 12, "savePath", new ColumnSize(255), true), new CommonFieldColumnMapper("username", 12, "username", new ColumnSize(255), true), new CommonFieldColumnMapper("password", 12, "password", new ColumnSize(255), true)});
    private static final long serialVersionUID = 1L;
    private long id = -1L;
    private String serverAddress = null;
    private int port = -1;
    private String savePath = null;
    private String username = null;
    private String password = null;

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String string) {
        this.serverAddress = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getSavePath() {
        return this.savePath;
    }

    public void setSavePath(String string) {
        this.savePath = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public ObjectTableMapper objectTableMapper2Register() {
        return OBJECT_MAPPER;
    }

    public File[] getFilesToDealWith(File[] fileArray) {
        FileSenderProcessor fileSenderProcessor = (FileSenderProcessor)ExtraPlatformClassManager.getInstance().getSingle("FileSenderProcessor");
        if (fileSenderProcessor == null) {
            fileSenderProcessor = new DefaultFileSenderProcessor();
        }
        return fileSenderProcessor.filterFiles(fileArray);
    }

    public CompatiableIDFCMapper getExtraOutputFileActionForeignKey() {
        return null;
    }

    public void doFileAction(File[] fileArray) throws Exception {
        try {
            FTPTransmitProcessor fTPTransmitProcessor = (FTPTransmitProcessor)ExtraPlatformScheduleClassManager.getInstance().getSingle("FTPTransmitProcessor");
            if (fTPTransmitProcessor == null) {
                fTPTransmitProcessor = new DefaultFTPTransmit();
            }
            fTPTransmitProcessor.transmit(fileArray, this.serverAddress, this.port, this.username, this.password, this.savePath);
        }
        catch (Exception exception) {
            ScheduleLogUtils.error(exception);
            throw exception;
        }
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.getId());
        jSONObject.put("serverAddress", (Object)this.getServerAddress());
        jSONObject.put("port", this.getPort());
        jSONObject.put("savePath", (Object)this.getSavePath());
        jSONObject.put("username", (Object)this.getUsername());
        jSONObject.put("password", (Object)this.getPassword());
        return jSONObject;
    }

    public OutputFileAction analyzeJSON(JSONObject jSONObject) {
        try {
            FTPTransmission fTPTransmission = null;
            fTPTransmission = jSONObject.has("id") ? (FTPTransmission)ScheduleContext.createDAOSession().load(FTPTransmission.class, jSONObject.optLong("id")) : new FTPTransmission();
            String string = jSONObject.optString("serverAddress");
            int n = jSONObject.optInt("port", 21);
            String string2 = jSONObject.optString("savePath", "/");
            String string3 = jSONObject.optString("username", "anonymous");
            String string4 = jSONObject.optString("password");
            fTPTransmission.setServerAddress(string);
            fTPTransmission.setPort(n);
            fTPTransmission.setSavePath(string2);
            fTPTransmission.setUsername(string3);
            fTPTransmission.setPassword(string4);
            return fTPTransmission;
        }
        catch (Exception exception) {
            ScheduleLogUtils.error(exception);
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getJsonTag() {
        return "ftpTransmission";
    }

    public boolean isEmailNotification() {
        return false;
    }
}

