/*
 * Decompiled with CFR 0.152.
 */
package com.fr.schedule.output;

import com.fr.fs.cache.EntryCacheImpl;
import com.fr.fs.fun.impl.AbstractOutputFormatProcessor;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.web.platform.entry.FileEntry;
import com.fr.general.DateUtils;
import com.fr.json.JSONObject;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.schedule.output.OutputFormatFactory;
import com.fr.schedule.plugin.OutputFormatProvider;
import com.fr.schedule.util.ScheduleConstants;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOutputFileFormat
extends AbstractOutputFormatProcessor
implements Serializable {
    public static final long HIDE_FILEENTRY_PARENTID = -1L;
    private int format = 1;

    @Override
    public void setFormat(int n) {
        this.format = n;
    }

    @Override
    public int getFormat() {
        return this.format;
    }

    @Override
    public void output(ResultWorkBook resultWorkBook, File file, String string, String string2, String string3, String string4, List<File> list) throws Exception {
        OutputFormatProvider[] outputFormatProviderArray;
        for (OutputFormatProvider outputFormatProvider : outputFormatProviderArray = OutputFormatFactory.getOutputFormatProviderArray()) {
            if (!outputFormatProvider.accept(this.getFormat())) continue;
            String string5 = outputFormatProvider.fileSuffix();
            File file2 = this.generateUnExsitFile(file, string, string5, string2);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            outputFormatProvider.flush(fileOutputStream, resultWorkBook);
            list.add(file2);
            FileEntry fileEntry = new FileEntry(string3 + string5, string4, file2.getAbsolutePath());
            fileEntry.setParentId(-1L);
            if (!ScheduleContext.createDAOSession().saveOrUpdate((Object)fileEntry)) continue;
            EntryCacheImpl.getInstance().cache(fileEntry);
        }
    }

    protected File generateUnExsitFile(File file, String string, String string2, String string3) {
        File file2 = new File(file, string3 + string2);
        while (file2.exists()) {
            file2 = new File(file, string + "_" + DateUtils.getDate2AllIncludeSSS((Date)new Date()) + "_" + ScheduleConstants.RANDOM.nextInt(1000) + string2);
        }
        return file2;
    }

    public JSONObject createJSON() throws Exception {
        OutputFormatProvider[] outputFormatProviderArray;
        JSONObject jSONObject = JSONObject.create();
        for (OutputFormatProvider outputFormatProvider : outputFormatProviderArray = OutputFormatFactory.getOutputFormatProviderArray()) {
            jSONObject.put(outputFormatProvider.markString(), outputFormatProvider.accept(this.format));
        }
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        OutputFormatProvider[] outputFormatProviderArray;
        for (OutputFormatProvider outputFormatProvider : outputFormatProviderArray = OutputFormatFactory.getOutputFormatProviderArray()) {
            boolean bl = jSONObject.optBoolean(outputFormatProvider.markString());
            this.setConvertToFormat(bl, outputFormatProvider.markNumber());
        }
    }

    public void setConvertToFormat(boolean bl, int n) {
        if (bl) {
            this.setFormat(this.getFormat() | n);
        } else {
            this.setFormat(this.getFormat() & ~n);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultOutputFileFormat defaultOutputFileFormat = (DefaultOutputFileFormat)super.clone();
        defaultOutputFileFormat.format = this.format;
        return defaultOutputFileFormat;
    }
}

