/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service.ldap;

import com.fr.fs.FSConfig;
import com.fr.fs.auth.LdapAuthenticateObjectType;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONObject;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSLoadGetLdapAttrsAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        Object object2;
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 3L)) {
            throw new NoPrivilegeException();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        LdapAuthenticateObjectType ldapAuthenticateObjectType = FSConfig.getProviderInstance().getAuthenticateObjectType(LdapAuthenticateObjectType.class);
        if (ldapAuthenticateObjectType != null) {
            hashMap.put("ldapUrl", ldapAuthenticateObjectType.getLdapUrl());
            hashMap.put("ldapSearchBase", ldapAuthenticateObjectType.getLdapSearchBase());
            hashMap.put("retrieveLocAsBaseDN", ldapAuthenticateObjectType.isRetrieveLocAsBaseDN());
            hashMap.put("principalSuffix", ldapAuthenticateObjectType.getPrincipalSuffix());
            hashMap.put("ldapSystemName", ldapAuthenticateObjectType.getLdapSystemName());
            hashMap.put("ldapSystemPassword", ldapAuthenticateObjectType.getLdapSystemPassword());
            object2 = ldapAuthenticateObjectType.getReferral();
            object = ldapAuthenticateObjectType.getContextFactory();
            String string = ldapAuthenticateObjectType.getAuthentication();
            hashMap.put("referral", this.getReferralInteger((String)object2) + "");
            hashMap.put("contextFactory", this.getContextFactoryInteger((String)object) + "");
            hashMap.put("authentication", this.getAuthentication(string) + "");
        }
        object2 = new JSONObject(hashMap);
        object = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        ((PrintWriter)object).write(object2.toString());
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    private int getReferralInteger(String string) {
        if (ComparatorUtils.equals((String)"follow", (String)string)) {
            return 1;
        }
        if (ComparatorUtils.equals((String)"ignore", (String)string)) {
            return 2;
        }
        if (ComparatorUtils.equals((String)"throw", (String)string)) {
            return 3;
        }
        return 1;
    }

    private int getContextFactoryInteger(String string) {
        if (ComparatorUtils.equals((String)"com.sun.jndi.ldap.LdapCtxFactory", (String)string)) {
            return 1;
        }
        if (ComparatorUtils.equals((String)"com.sun.jndi.ldap.connect.pool", (String)string)) {
            return 2;
        }
        return 1;
    }

    private int getAuthentication(String string) {
        if (ComparatorUtils.equals((String)"simple", (String)string)) {
            return 1;
        }
        if (ComparatorUtils.equals((String)"strong", (String)string)) {
            return 2;
        }
        if (ComparatorUtils.equals((String)"none", (String)string)) {
            return 3;
        }
        return 1;
    }

    public String getCMD() {
        return "loginLdapAttrs";
    }
}

