/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.stable.StableUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.core.db.FineDB;
import com.fr.web.utils.WebUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerConfigRestoreAction
extends ActionNoSessionCMD {
    private static final String MANUAL_BACKUP = "manualbackup";
    private static final String AUTO_BACKUP = "autobackup";

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 5L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"backupname");
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"backuptype");
        if (ComparatorUtils.equals((String)string2, (String)"auto")) {
            FineDB.setServerConfigBackupPath((String)StableUtils.pathJoin((String[])new String[]{AUTO_BACKUP, string}));
        } else if (ComparatorUtils.equals((String)string2, (String)"manual")) {
            FineDB.setServerConfigBackupPath((String)StableUtils.pathJoin((String[])new String[]{MANUAL_BACKUP, string}));
        } else {
            FRLogger.getLogger().error("backup type error.");
        }
    }

    public String getCMD() {
        return "restore";
    }
}

