/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.data.AbstractParameterTableData;
import com.fr.data.VersionInfoTableData;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FUNC;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerConfigGetRegisterInfoAction
extends ActionNoSessionCMD {
    private static final int NAME = 0;
    private static final int SUPPORT = 1;
    private static final int VALUE = 2;
    private static final int LOCALE_KEY = 3;

    public String getCMD() {
        return "sc_get_registerinfo";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 8L)) {
            throw new NoPrivilegeException();
        }
        JSONObject jSONObject = this.getRegistMatchJo();
        JSONArray jSONArray = this.getFuncListJo();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("appinfo", (Object)jSONObject);
        jSONObject2.put("functionlist", (Object)jSONArray);
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        printWriter.print(jSONObject2);
        printWriter.flush();
        printWriter.close();
    }

    private JSONArray getFuncListJo() throws TableDataException, JSONException {
        JSONArray jSONArray = new JSONArray();
        FunctionListTableData functionListTableData = new FunctionListTableData();
        DataModel dataModel = functionListTableData.createDataModel(Calculator.createCalculator());
        int n = dataModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!((Boolean)dataModel.getValueAt(i, 1)).booleanValue()) continue;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("name", dataModel.getValueAt(i, 3));
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray;
    }

    private JSONObject getRegistMatchJo() throws TableDataException, JSONException {
        VersionInfoTableData versionInfoTableData = new VersionInfoTableData();
        DataModel dataModel = versionInfoTableData.createDataModel(Calculator.createCalculator());
        JSONObject jSONObject = new JSONObject();
        int n = dataModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            jSONObject.put(String.valueOf(dataModel.getValueAt(i, 0)), dataModel.getValueAt(i, 1));
        }
        return jSONObject;
    }

    public static class FunctionListTableData
    extends AbstractParameterTableData
    implements DataModel {
        private FunctionAndSupport[] datas;
        private String[] names = new String[]{"name", "support", "value", "localeKey"};

        private static FunctionAndSupport as(FUNC fUNC) {
            FunctionAndSupport functionAndSupport = new FunctionAndSupport();
            functionAndSupport.name = fUNC.toString();
            functionAndSupport.support = fUNC.support();
            functionAndSupport.value = BigInteger.ONE.shiftLeft(fUNC.marker());
            functionAndSupport.localeKey = fUNC.getLocaleKey();
            return functionAndSupport;
        }

        public FunctionListTableData() {
            ArrayList<FunctionAndSupport> arrayList = new ArrayList<FunctionAndSupport>();
            Iterator iterator = FUNC.getAllFunctionIterator();
            while (iterator.hasNext()) {
                arrayList.add(FunctionListTableData.as((FUNC)iterator.next()));
            }
            this.datas = arrayList.toArray(new FunctionAndSupport[arrayList.size()]);
        }

        public DataModel createDataModel(Calculator calculator) {
            return this;
        }

        public int getColumnCount() throws TableDataException {
            return this.names.length;
        }

        public int getColumnIndex(String string) throws TableDataException {
            int n = Integer.MIN_VALUE;
            int n2 = this.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                if (!ComparatorUtils.tableDataColumnNameEquals((String)string, (String)this.getColumnName(i))) continue;
                n = i;
                break;
            }
            return n;
        }

        public String getColumnName(int n) throws TableDataException {
            return this.names[n];
        }

        public int getRowCount() throws TableDataException {
            return this.datas.length;
        }

        public Object getValueAt(int n, int n2) throws TableDataException {
            FunctionAndSupport functionAndSupport = this.datas[n];
            switch (n2) {
                case 0: {
                    return functionAndSupport.name;
                }
                case 1: {
                    return functionAndSupport.support;
                }
                case 2: {
                    return functionAndSupport.value;
                }
            }
            return functionAndSupport.localeKey;
        }

        public boolean hasRow(int n) throws TableDataException {
            return this.datas.length > n && n >= 0;
        }

        public void release() throws Exception {
        }

        private static final class FunctionAndSupport {
            String name;
            boolean support;
            BigInteger value;
            String localeKey;

            private FunctionAndSupport() {
            }
        }
    }
}

