/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.dao.tabledata.TableDataCustomRoleDAO;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSSetAuthGetCustomRoleAuthAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 18L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"name");
        long l2 = Long.valueOf(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"id"));
        JSONObject jSONObject = this.getCustomRolePrivileges(l2, string, l);
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        printWriter.print(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    public JSONObject getCustomRolePrivileges(long l, String string, long l2) throws Exception {
        JSONObject jSONObject = new JSONObject();
        if (l <= -1000L) {
            jSONObject.put("users", (Object)CustomRoleControl.getInstance().getUsersInfo(l));
            jSONObject.put("reports", (Object)(this.getSyncRoleEntryPrivilegesJO(string, l2) + ""));
            jSONObject.put("modules", (Object)(this.getSyncRoleModulePrivilegesJO(string, l2) + ""));
            jSONObject.put("depandcroles", (Collection)this.getSyncDepAndCRolePrivileges(string, l2));
            jSONObject.put("templates", (Object)(this.getSyncRoleTemplatePrivilegesJO(string, l2) + ""));
            jSONObject.put("dataconnections", this.getSyncRoleDataConnectionsPrivileges(string, l2));
            jSONObject.put("homepages", (Collection)this.getSyncRoleHomePagePrivilegesJO(string, l2));
        } else {
            jSONObject.put("users", (Object)CustomRoleControl.getInstance().getUsersInfo(l));
            jSONObject.put("reports", (Object)(this.getAllEntryPrivilege(l, l2) + ""));
            jSONObject.put("modules", (Object)(this.getAllModulePrivilege(l, l2) + ""));
            jSONObject.put("depandcroles", this.getAllDepAndCRolePrivilege(l, l2));
            jSONObject.put("templates", (Object)(this.getAllTemplatePrivileges(l, l2) + ""));
            jSONObject.put("dataconnections", this.getAllDataConnectionPrivileges(l, l2));
            jSONObject.put("homepages", (Object)(this.getAllHomePagePrivilege(l, l2) + ""));
        }
        Iterator<String> iterator = PlateFactory.plateNameIterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            jSONObject.put(string2, CustomRoleControl.getInstance().getAllPlatePrivileges(l, string2));
        }
        return jSONObject;
    }

    private List getAllEntryPrivilege(long l, long l2) throws Exception {
        LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
        List<EntryTypeAndID> list = CustomRoleControl.getInstance().getAllEntryPrivileges(l);
        for (EntryTypeAndID entryTypeAndID : list) {
            linkedList.add(entryTypeAndID.toJSONObject());
        }
        return linkedList;
    }

    private List getAllModulePrivilege(long l, long l2) throws Exception {
        LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
        List<RoleModulePrivilege> list = CustomRoleControl.getInstance().getAllModulePrivileges(l);
        Set set = UserControl.getInstance().getAllModulePrivileges(l2);
        for (RoleModulePrivilege roleModulePrivilege : list) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !this.hasModulePrivilege(set, roleModulePrivilege)) continue;
            linkedList.add(roleModulePrivilege.toJSONObject());
        }
        return linkedList;
    }

    private boolean hasModulePrivilege(Set<RoleModulePrivilege> set, RoleModulePrivilege roleModulePrivilege) {
        for (RoleModulePrivilege roleModulePrivilege2 : set) {
            if (roleModulePrivilege2.getModuleid() != roleModulePrivilege.getModuleid()) continue;
            return true;
        }
        return false;
    }

    private List<JSONObject> getAllHomePagePrivilege(long l, long l2) throws Exception {
        LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
        List<RoleHomePagePrivilege> list = CustomRoleControl.getInstance().getAllHomePagePrivileges(l);
        Set<RoleHomePagePrivilege> set = UserControl.getInstance().getAllHomePagePrivileges(l2);
        for (RoleHomePagePrivilege roleHomePagePrivilege : list) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !this.hasHomePagePrivilege(set, roleHomePagePrivilege)) continue;
            linkedList.add(roleHomePagePrivilege.toJSONObject());
        }
        return linkedList;
    }

    private boolean hasHomePagePrivilege(Set<RoleHomePagePrivilege> set, RoleHomePagePrivilege roleHomePagePrivilege) {
        for (RoleHomePagePrivilege roleHomePagePrivilege2 : set) {
            if (roleHomePagePrivilege2.getHomePageId() != roleHomePagePrivilege.getHomePageId()) continue;
            return true;
        }
        return false;
    }

    private List<String> getAllDepAndCRolePrivilege(long l, long l2) throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        List<String> list = CustomRoleControl.getInstance().getAllDepAndCRolePrivilegeDescriptions(l);
        JSONArray jSONArray = UserControl.getInstance().getAllDepAndCRoleInfo(l2);
        LinkedList<String> linkedList2 = new LinkedList<String>();
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            if (jSONObject.has("departmentid")) {
                linkedList2.add("1" + jSONObject.getLong("departmentid"));
                continue;
            }
            linkedList2.add("2" + jSONObject.getLong("id"));
        }
        for (String string : list) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !linkedList2.contains(string)) continue;
            linkedList.add(string);
        }
        return linkedList;
    }

    private List<JSONObject> getAllTemplatePrivileges(long l, long l2) throws Exception {
        LinkedList<JSONObject> linkedList = new LinkedList<JSONObject>();
        List<RoleTemplatePrivilege> list = CustomRoleControl.getInstance().getAllTemplatePrivileges(l);
        Set set = UserControl.getInstance().getAllTemplatePrivileges(l2);
        for (RoleTemplatePrivilege roleTemplatePrivilege : list) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !FSPrivilegeTools.getInstance().hasPageOrWritePrivilege(roleTemplatePrivilege.getPath(), set)) continue;
            linkedList.add(roleTemplatePrivilege.toJSONObject());
        }
        return linkedList;
    }

    private List<String> getAllDataConnectionPrivileges(long l, long l2) throws Exception {
        LinkedList<String> linkedList = new LinkedList<String>();
        Set<RoleDataConnectionPrivilege> set = CustomRoleControl.getInstance().getAllDataConnectionPrivileges(l);
        Set<RoleDataConnectionPrivilege> set2 = UserControl.getInstance().getAllDataConnectionPrivileges(l2);
        for (RoleDataConnectionPrivilege roleDataConnectionPrivilege : set) {
            if (l2 != CustomRoleControl.getInstance().getSuperCustomRoleID() && !set2.contains((Object)roleDataConnectionPrivilege)) continue;
            linkedList.add(roleDataConnectionPrivilege.getName());
        }
        return linkedList;
    }

    private List getSyncRoleEntryPrivilegesJO(String string, long l) throws Exception {
        Set<RoleEntryPrivilege> set = TableDataCustomRoleDAO.getInstance().getEntryPrivileges(string);
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        for (RoleEntryPrivilege roleEntryPrivilege : set) {
            arrayList.add(EntryTypeAndID.getInstance(roleEntryPrivilege.getType(), roleEntryPrivilege.getEntryid(), roleEntryPrivilege.getView(), roleEntryPrivilege.getAuthorized(), roleEntryPrivilege.getEdit()).toJSONObject());
        }
        return arrayList;
    }

    private List getSyncRoleModulePrivilegesJO(String string, long l) throws Exception {
        Set<RoleModulePrivilege> set = TableDataCustomRoleDAO.getInstance().getModulePrivileges(string);
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        Set set2 = UserControl.getInstance().getAllModulePrivileges(l);
        for (RoleModulePrivilege roleModulePrivilege : set) {
            if (l != CustomRoleControl.getInstance().getSuperCustomRoleID() && !this.hasModulePrivilege(set2, roleModulePrivilege)) continue;
            arrayList.add(roleModulePrivilege.toJSONObject());
        }
        return arrayList;
    }

    private List getSyncRoleHomePagePrivilegesJO(String string, long l) throws Exception {
        Set<RoleHomePagePrivilege> set = TableDataCustomRoleDAO.getInstance().getHomePagePrivileges(string);
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        Set<RoleHomePagePrivilege> set2 = UserControl.getInstance().getAllHomePagePrivileges(l);
        for (RoleHomePagePrivilege roleHomePagePrivilege : set) {
            if (l != CustomRoleControl.getInstance().getSuperCustomRoleID() && !this.hasHomePagePrivilege(set2, roleHomePagePrivilege)) continue;
            arrayList.add(roleHomePagePrivilege.toJSONObject());
        }
        return arrayList;
    }

    private List getSyncDepAndCRolePrivileges(String string, long l) throws Exception {
        Set<RoleDepAndCRolePrivilege> set = TableDataCustomRoleDAO.getInstance().getDepAndCrolePrivileges(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        JSONArray jSONArray = UserControl.getInstance().getAllDepAndCRoleInfo(l);
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            if (jSONObject.has("departmentid")) {
                linkedList.add("1" + jSONObject.getLong("departmentid"));
                continue;
            }
            linkedList.add("2" + jSONObject.getLong("id"));
        }
        for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
            if (l != CustomRoleControl.getInstance().getSuperCustomRoleID() && !linkedList.contains(roleDepAndCRolePrivilege.getType() + "" + roleDepAndCRolePrivilege.getDeporcroleid())) continue;
            arrayList.add(roleDepAndCRolePrivilege.getType() + "" + roleDepAndCRolePrivilege.getDeporcroleid());
        }
        return arrayList;
    }

    private List getSyncRoleTemplatePrivilegesJO(String string, long l) throws Exception {
        Set<RoleTemplatePrivilege> set = TableDataCustomRoleDAO.getInstance().getTemplatePrivileges(string);
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        Set set2 = UserControl.getInstance().getAllTemplatePrivileges(l);
        for (RoleTemplatePrivilege roleTemplatePrivilege : set) {
            if (l != CustomRoleControl.getInstance().getSuperCustomRoleID() && !FSPrivilegeTools.getInstance().hasPageOrWritePrivilege(roleTemplatePrivilege.getPath(), set2)) continue;
            arrayList.add(roleTemplatePrivilege.toJSONObject());
        }
        return arrayList;
    }

    private List<String> getSyncRoleDataConnectionsPrivileges(String string, long l) throws Exception {
        Set<RoleDataConnectionPrivilege> set = TableDataCustomRoleDAO.getInstance().getDataConnectionPrivileges(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<RoleDataConnectionPrivilege> set2 = UserControl.getInstance().getAllDataConnectionPrivileges(l);
        for (RoleDataConnectionPrivilege roleDataConnectionPrivilege : set) {
            if (l != CustomRoleControl.getInstance().getSuperCustomRoleID() && !set2.contains((Object)roleDataConnectionPrivilege)) continue;
            arrayList.add(roleDataConnectionPrivilege.getName());
        }
        return arrayList;
    }

    public String getCMD() {
        return "auth_getsroleauth";
    }
}

