/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.base.entity.User;
import com.fr.fs.comparator.ComparatorHelper;
import com.fr.fs.control.LoginUserControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.privilege.PrivilegeManager;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSSetAuthGetAllUserAction
extends ActionNoSessionCMD {
    public String getCMD() {
        return "auth_getallusers";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 3L) || !UserControl.getInstance().hasModulePrivilege(l, 18L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"startIndex");
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"limitIndex");
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.valueOf(string);
            n2 = Integer.valueOf(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string3 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"dataFilter");
        if (string3 == null) {
            string3 = "";
        } else {
            int n3 = Math.max(string3.lastIndexOf(","), string3.lastIndexOf("\uff0c"));
            string3 = string3.substring(n3 + 1);
        }
        String string4 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"exclude");
        String string5 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"includeroot");
        List<User> list = this.getFilteredUsers(l, string3, string4);
        Collections.sort(list, ComparatorHelper.USER_NAME_USERNAME_COMPARATOR);
        JSONArray jSONArray = this.getUsersByStartAndLimit(list, n, n2);
        if (ComparatorUtils.equals((String)string5, (String)"true")) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("username", (Object)PrivilegeManager.getProviderInstance().getRootManagerName());
            jSONObject.put("realname", (Object)PrivilegeManager.getProviderInstance().getRootManagerRealname());
            jSONArray.put((Object)jSONObject);
        }
        printWriter.print(jSONArray.toString());
        printWriter.flush();
        printWriter.close();
    }

    private JSONArray getUsersByStartAndLimit(List<User> list, int n, int n2) throws JSONException {
        JSONArray jSONArray;
        block4: {
            jSONArray = new JSONArray();
            int n3 = list.size();
            if (n >= n3) break block4;
            if (n2 == 0 && n == 0) {
                for (User user : list) {
                    jSONArray.put((Object)user.createUnEditInfoJSONConfig());
                }
            } else {
                int n4 = Math.min(n + n2, n3);
                for (int i = n; i < n4; ++i) {
                    User user = list.get(i);
                    jSONArray.put((Object)user.createUnEditInfoJSONConfig());
                }
            }
        }
        return jSONArray;
    }

    private List<User> getFilteredUsers(long l, String string, String string2) throws Exception {
        List list = UserControl.getInstance().findAllAuthUser(l);
        ArrayList<User> arrayList = new ArrayList();
        if (StringUtils.isEmpty((String)(string + string2))) {
            arrayList = list;
        } else {
            for (User user : list) {
                if (!this.isKeywordInUserInfo(user, string) || this.isUserExcluded(user, string2)) continue;
                arrayList.add(user);
            }
        }
        return arrayList;
    }

    private boolean isKeywordInUserInfo(User user, String string) {
        if (StringUtils.isEmpty((String)string)) {
            return true;
        }
        return this.containsNoCase(user.getUsername(), string) || this.containsNoCase(user.getRealname(), string);
    }

    private boolean containsNoCase(String string, String string2) {
        return string.toUpperCase().contains(string2.toUpperCase());
    }

    private boolean isUserExcluded(User user, String string) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        if (ComparatorUtils.equalsIgnoreCase((String)string, (String)"fs_login")) {
            return LoginUserControl.hasFSLoginUser(user.getUsername());
        }
        if (ComparatorUtils.equalsIgnoreCase((String)string, (String)"mobile_login")) {
            return LoginUserControl.hasMobileLoginUser(user.getUsername());
        }
        return false;
    }
}

