/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.FRContext;
import com.fr.fs.FSConfig;
import com.fr.fs.FSContext;
import com.fr.fs.FSTheme;
import com.fr.fs.basic.Theme;
import com.fr.fs.control.UserControl;
import com.fr.fs.fun.FSUACompatibleProcessor;
import com.fr.fs.fun.ThemeFinder;
import com.fr.fs.fun.impl.AbstractThemeFinder;
import com.fr.fs.plugin.ExtraPlatformClassManager;
import com.fr.fs.web.service.AbstractFSAuthService;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.FArray;
import com.fr.general.GeneralUtils;
import com.fr.privilege.Authentication;
import com.fr.privilege.authentication.AuthenticationFactory;
import com.fr.privilege.base.PrivilegeVote;
import com.fr.privilege.session.PrivilegeInfoSessionMananger;
import com.fr.stable.StringUtils;
import com.fr.web.Browser;
import com.fr.web.utils.WebUtils;
import java.util.Calendar;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSOpenEntryService
extends AbstractFSAuthService {
    private int expires = -10;
    private static final String DEFAULT_UA_COMPATIABLE = "chrome=1";

    public String actionOP() {
        return "fs";
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if (this.checkDispatch(httpServletRequest, httpServletResponse, string)) {
            return;
        }
        FSContext.initData();
        this.syncUserID(httpServletRequest);
        this.recordSignIn(httpServletRequest);
        httpServletRequest.getSession(true).removeAttribute("originalURL");
        PrivilegeVote privilegeVote = this.getFSVote(httpServletRequest, httpServletResponse);
        Authentication authentication = AuthenticationFactory.exAuth4CommonAccess((HttpServletRequest)httpServletRequest);
        if (!(privilegeVote.isPermitted() || authentication != null && authentication.isRoot())) {
            privilegeVote.action(httpServletRequest, httpServletResponse);
            return;
        }
        this.init(httpServletRequest, httpServletResponse);
    }

    private void recordSignIn(HttpServletRequest httpServletRequest) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession();
        String string = WebUtils.getIpAddr((HttpServletRequest)httpServletRequest);
        String string2 = PrivilegeInfoSessionMananger.getCurrentUserName((HttpSession)httpSession);
        if (string2 == null) {
            return;
        }
        FArray fArray = PrivilegeInfoSessionMananger.getCurrentDepartmentAndPost((HttpSession)httpSession);
        String string3 = fArray == null ? "" : fArray.toString();
        FRContext.getLogger().getRecordManager().recordFSInfo(string, string2, string3);
    }

    private void putFSUA(Map<String, Object> map, Browser browser) {
        String string = DEFAULT_UA_COMPATIABLE;
        FSUACompatibleProcessor fSUACompatibleProcessor = (FSUACompatibleProcessor)ExtraPlatformClassManager.getInstance().getSingle("FSUACompatibleProcessor");
        if (null != fSUACompatibleProcessor) {
            string = fSUACompatibleProcessor.getUACompatible(browser);
        }
        map.put("fsUA", string);
    }

    protected void init(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.setHeader("Pragma", "No-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store");
        httpServletResponse.setDateHeader("Expires", (long)this.expires);
        String string = FSOpenEntryService.getUserShowName(httpServletRequest);
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        Map<String, Object> map = FSConfig.getProviderInstance().getFSParaMap(string, l);
        map.put("homePageUrl", UserControl.getInstance().getHomePageURL(l, this.getCheckTimestamp(httpServletRequest), WebUtils.getDevice((HttpServletRequest)httpServletRequest)));
        map.put("__v__", GeneralUtils.readBuildNO());
        map.put("__locale__", WebUtils.getLocale((HttpServletRequest)httpServletRequest));
        this.loadFSTheme(httpServletRequest, map);
        this.putFSUA(map, Browser.resolve((HttpServletRequest)httpServletRequest));
        WebUtils.writeOutTemplate((String)this.searchTemplatePath(httpServletRequest), (HttpServletResponse)httpServletResponse, map);
    }

    private void loadFSTheme(HttpServletRequest httpServletRequest, Map<String, Object> map) throws Exception {
        Theme theme;
        String string = "";
        String string2 = FSOpenEntryService.getUsername(httpServletRequest);
        ThemeFinder themeFinder = (ThemeFinder)ExtraPlatformClassManager.getInstance().getSingle("ThemeFinder");
        if (themeFinder == null) {
            themeFinder = DefaultThemeFinder.getInstance();
        }
        if ((theme = themeFinder.find(string2)).isCustom()) {
            FSTheme.getInstance().loadThemeByName(theme);
            String string3 = theme.getJavaScriptPath();
            String string4 = theme.getStylePath();
            String string5 = WebUtils.createServletURL((HttpServletRequest)httpServletRequest);
            if (StringUtils.isNotEmpty((String)string3)) {
                string = string + "<script type=\"text/javascript\" src=\"" + string5 + "?op=resource&resource=" + string3 + "\"></script>";
            }
            if (StringUtils.isNotEmpty((String)string4)) {
                string = string + "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + string5 + "?op=resource&resource=" + string4 + "\"/>";
            }
        } else {
            map.put("theme", theme.createJSONObject());
        }
        map.put("ThemeSrc", string);
    }

    protected String searchTemplatePath(HttpServletRequest httpServletRequest) {
        if ("true".equals(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"debug"))) {
            return "/com/fr/fs/web/frame/fs_debug.html";
        }
        return "/com/fr/fs/web/frame/fs.html";
    }

    protected String getCheckTimestamp(HttpServletRequest httpServletRequest) {
        String string = Calendar.getInstance().getTime().toString();
        boolean bl = Boolean.valueOf(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"notchecked"));
        if (bl) {
            string = "";
        }
        return string;
    }

    public static class DefaultThemeFinder
    extends AbstractThemeFinder {
        private static DefaultThemeFinder finder = new DefaultThemeFinder();

        public static DefaultThemeFinder getInstance() {
            return finder;
        }

        public Theme find(String string) {
            Theme theme = FSConfig.getProviderInstance().getTheme();
            return theme;
        }
    }
}

