/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.basic.SystemAttr;
import com.fr.fs.cache.CustomRoleCacheImpl;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.dao.tabledata.TableDataCustomRoleDAO;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.file.XMLFileManagerProvider;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSManagerSetHomePageRolesAction
extends ActionNoSessionCMD {
    public static final String ADD = "add";
    public static final String REMOVE = "remove";
    private final Object lock = new Object();

    public String getCMD() {
        return "fs_set_homepage_roles";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        SystemAttr systemAttr;
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 14L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"homepageURL");
        boolean bl = false;
        if (!StringUtils.isEmpty((String)string)) {
            systemAttr = FSConfig.getProviderInstance().getSystemAttr();
            systemAttr.setHomePageURL(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"homepageURL"));
            FSConfig.getProviderInstance().setSystemAttr(systemAttr);
            bl = FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getProviderInstance());
        } else {
            systemAttr = (JSONArray)BaseUtils.jsonDecode((String)WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"companyRole"));
            object = (JSONArray)BaseUtils.jsonDecode((String)WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"customRole"));
            try {
                this.addCompanyRolePrivilege((JSONArray)systemAttr);
                this.addCustomRolePrivilege((JSONArray)object);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        systemAttr = new JSONObject();
        systemAttr.put("success", bl);
        object = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        ((PrintWriter)object).write(systemAttr.toString());
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    private void addCompanyRolePrivilege(JSONArray jSONArray) throws Exception {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            long l = jSONObject.getLong("departmentId");
            long l2 = CompanyRoleControl.getInstance().getPostAllID();
            if (jSONObject.has("postId")) {
                l2 = jSONObject.getLong("postId");
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject("homepages");
            Set<RoleHomePagePrivilege> set = FSManagerSetHomePageRolesAction.string2HomePageSet(jSONObject2.getString(ADD));
            Set<RoleHomePagePrivilege> set2 = FSManagerSetHomePageRolesAction.string2HomePageSet(jSONObject2.getString(REMOVE));
            CompanyRole companyRole = CompanyRoleControl.getInstance().getOrCreateAllRole(l, l2);
            if (companyRole == null) {
                return;
            }
            CompanyRoleControl.getInstance().updateHomePagePrivileges(companyRole.getId(), set, set2);
        }
    }

    private void addCustomRolePrivilege(JSONArray jSONArray) throws Exception {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            CustomRole customRole;
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            JSONObject jSONObject2 = jSONObject.getJSONObject("homepages");
            Set<RoleHomePagePrivilege> set = FSManagerSetHomePageRolesAction.string2HomePageSet(jSONObject2.getString(ADD));
            Set<RoleHomePagePrivilege> set2 = FSManagerSetHomePageRolesAction.string2HomePageSet(jSONObject2.getString(REMOVE));
            long l = jSONObject.getLong("roleId");
            if (l <= -1000L) {
                customRole = CustomRoleControl.getInstance().getCustomRole(l);
                this.addSyncCustomRoleHomePagePrivilege(customRole, set, set2);
                continue;
            }
            customRole = CustomRoleControl.getInstance().getCustomRole(l);
            CustomRoleControl.getInstance().updateHomePagePrivileges(customRole.getId(), set, set2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSyncCustomRoleHomePagePrivilege(CustomRole customRole, Set<RoleHomePagePrivilege> set, Set<RoleHomePagePrivilege> set2) throws Exception {
        String string = customRole.getRolename();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            ArrayList<RoleHomePagePrivilege> arrayList = new ArrayList<RoleHomePagePrivilege>();
            if (set != null) {
                arrayList.addAll(set);
            }
            ArrayList<RoleHomePagePrivilege> arrayList2 = new ArrayList<RoleHomePagePrivilege>();
            if (set2 != null) {
                arrayList2.addAll(set2);
            }
            TableDataCustomRoleDAO.getInstance().updateHomePagePrivileges(string, arrayList, arrayList2);
        }
        try {
            CustomRoleCacheImpl.getInstance().refreshHomePagePrivileges(customRole.getId(), TableDataCustomRoleDAO.getInstance().getHomePagePrivileges(string));
        }
        catch (Exception exception) {
            CustomRoleCacheImpl.getInstance().reInitCache();
        }
    }

    private static Set<RoleHomePagePrivilege> string2HomePageSet(String string) throws JSONException {
        HashSet<RoleHomePagePrivilege> hashSet = new HashSet<RoleHomePagePrivilege>();
        JSONArray jSONArray = (JSONArray)BaseUtils.jsonDecode((String)string);
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            long l = jSONObject.getLong("id");
            long l2 = jSONObject.optLong("view", 0L);
            RoleHomePagePrivilege roleHomePagePrivilege = new RoleHomePagePrivilege(l, l2);
            hashSet.add(roleHomePagePrivilege);
        }
        return hashSet;
    }
}

