/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.FRContext;
import com.fr.base.TableData;
import com.fr.data.impl.RecursionDataModel;
import com.fr.data.impl.RecursionTableData;
import com.fr.file.DatasourceManager;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.DepartmentCacheImpl;
import com.fr.fs.cache.UserCacheImpl;
import com.fr.fs.cache.tabledata.TableDataUser;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.dao.hsqldb.HSQLDBDAOControl;
import com.fr.fs.web.FSConstants;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.file.XMLFileManagerProvider;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSManagerModuleImportUserAction
extends ActionNoSessionCMD {
    private static final long DEFAULT_ID_FIX = 40L;
    private static final long ROOT_PID = -2L;
    private long id_for_fix = 40L;
    private String ROOT = "-1";
    private Map<String, Long> deparIdMap = new HashMap<String, Long>();

    public String getCMD() {
        return "importUser";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 3L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"res");
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"override");
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        JSONObject jSONObject = new JSONObject();
        if (string2 != null) {
            List list = UserCacheImpl.getInstance().getDuplicatedUsers();
            boolean bl = this.updateHSQLUsers(list);
            jSONObject.put("success", bl);
        } else {
            JSONObject jSONObject2 = new JSONObject(string);
            String string3 = null;
            boolean bl = false;
            String string4 = jSONObject2.optString("dsName", "");
            TableData tableData = DatasourceManager.getProviderInstance().getTableData(string4);
            if (tableData != null) {
                if (!this.needQuery(httpServletRequest, tableData, jSONObject2, jSONObject)) {
                    List list = this.getImportUsers(jSONObject2, tableData);
                    DepartmentCacheImpl.getInstance().reInit();
                    if (!list.isEmpty()) {
                        bl = true;
                        UserCacheImpl.getInstance().setDuplicatedUsers(list);
                        string3 = this.getDuplicatedInfo(list);
                    }
                    jSONObject.put("hasDuplicated", bl).put("warnings", string3);
                }
            } else {
                jSONObject.put("error", (Object)Inter.getLocText((String)"FS-Admin-Can_not_find_Data_Connection", (Locale)WebUtils.getLocale((HttpServletRequest)httpServletRequest)));
            }
        }
        printWriter.write(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    private boolean needQuery(HttpServletRequest httpServletRequest, TableData tableData, JSONObject jSONObject, JSONObject jSONObject2) throws Exception {
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"clearall");
        boolean bl = false;
        if (string != null) {
            bl = Boolean.valueOf(string);
        }
        if (this.isEncryptChanged(jSONObject)) {
            if (bl) {
                this.clearTables();
                HSQLDBDAOControl.getInstance().parseJSON(jSONObject);
                FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getProviderInstance());
                return false;
            }
            jSONObject2.put("query", (Object)Inter.getLocText((String)"FS-Admin-Modify_Secret_Will_Remove_User", (Locale)WebUtils.getLocale((HttpServletRequest)httpServletRequest)));
            return true;
        }
        if (tableData instanceof RecursionTableData) {
            if (bl) {
                this.clearTables();
                return false;
            }
            jSONObject2.put("query", (Object)Inter.getLocText((String)"FS-Admin-Use_Tree_Will_Remove_User", (Locale)WebUtils.getLocale((HttpServletRequest)httpServletRequest)));
            return true;
        }
        return false;
    }

    private boolean isEncryptChanged(JSONObject jSONObject) throws Exception {
        int n = jSONObject.optInt("encrypt", -1);
        String string = jSONObject.optString("myencrypt", "");
        JSONObject jSONObject2 = HSQLDBDAOControl.getInstance().getPv().toJSONObject();
        if (n == jSONObject2.getInt("encrypt")) {
            if (n == 1) {
                return !ComparatorUtils.equals((String)string, (String)jSONObject2.getString("myencrypt"));
            }
            return false;
        }
        return true;
    }

    private List getImportUsers(JSONObject jSONObject, TableData tableData) throws Exception {
        ArrayList<TableDataUser> arrayList = new ArrayList<TableDataUser>();
        if (!jSONObject.has("dsName")) {
            return arrayList;
        }
        DataModel dataModel = tableData.createDataModel(Calculator.createCalculator());
        int n = jSONObject.optInt("userName", -1);
        int n2 = jSONObject.optInt("password", -1);
        int n3 = jSONObject.optInt("name", -1);
        int n4 = jSONObject.optInt("email", -1);
        int n5 = jSONObject.optInt("mobile", -1);
        int n6 = jSONObject.optInt("department", -1);
        int n7 = jSONObject.optInt("post", -1);
        int n8 = jSONObject.optInt("role", -1);
        Department department = FSConfig.getProviderInstance().getControl().getDepartmentDAO().findByNameAndPid(FSConstants.COMPANYROLE.DEPARTMENT_ALL_NAME, -2L);
        if (department != null) {
            this.id_for_fix = department.getId() + 1L;
        }
        int n9 = dataModel.getRowCount();
        for (int i = 0; i < n9; ++i) {
            Object object;
            Object object2;
            TableDataUser tableDataUser = this.initUserFormDS(dataModel, i, n, n2, n3, n4, n5);
            if (tableDataUser == null) continue;
            Department department2 = null;
            Post post = null;
            if (n6 > -1 && n7 > -1) {
                object2 = dataModel.getValueAt(i, n6);
                object = dataModel.getValueAt(i, n7);
                String string = object2 != null ? object2.toString() : "";
                String string2 = object != null ? object.toString() : "";
                department2 = this.initDepartment(tableData, dataModel, i, tableDataUser, department2, string);
                post = this.initPosition(tableDataUser, post, string2);
            }
            if (n8 > -1) {
                object2 = dataModel.getValueAt(i, n8);
                Object object3 = object = object2 != null ? object2.toString() : "";
                if (StringUtils.isNotEmpty((String)object)) {
                    tableDataUser.setRoleValue((String)object);
                }
            }
            if (this.importUser2HSQL(tableDataUser, department2, post)) continue;
            arrayList.add(tableDataUser);
        }
        return arrayList;
    }

    private Post initPosition(TableDataUser tableDataUser, Post post, String string) throws Exception {
        if (StringUtils.isNotEmpty((String)string)) {
            post = new Post(string, "");
            if (!PostControl.getInstance().addPost(post)) {
                post = PostControl.getInstance().getPostByName(string);
            }
            tableDataUser.setPostValue(string);
        }
        return post;
    }

    private Department initDepartment(TableData tableData, DataModel dataModel, int n, TableDataUser tableDataUser, Department department, String string) throws Exception {
        if (StringUtils.isNotEmpty((String)string)) {
            department = new Department(string, "", -1L);
            if (tableData instanceof RecursionTableData) {
                this.generateRecursionDepartment(department, (RecursionTableData)tableData, (RecursionDataModel)dataModel, n);
            }
            DepartmentControl.getInstance().addDepartment(department);
            tableDataUser.setDepartmentValue(string);
        }
        return department;
    }

    private TableDataUser initUserFormDS(DataModel dataModel, int n, int n2, int n3, int n4, int n5, int n6) throws TableDataException {
        Object object;
        String string;
        Object object2 = dataModel.getValueAt(n, n2);
        String string2 = string = object2 != null ? object2.toString() : "";
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Object object3 = dataModel.getValueAt(n, n3);
        TableDataUser tableDataUser = new TableDataUser(n, string, object3 != null ? object3.toString() : "");
        if (n4 > -1) {
            object = dataModel.getValueAt(n, n4);
            tableDataUser.setName(object != null ? object.toString() : "");
        }
        if (n5 > -1) {
            object = dataModel.getValueAt(n, n5);
            tableDataUser.setEmail(object != null ? object.toString() : "");
        }
        if (n6 > -1) {
            object = dataModel.getValueAt(n, n6);
            tableDataUser.setMobile(object != null ? object.toString() : "");
        }
        return tableDataUser;
    }

    private boolean importUser2HSQL(TableDataUser tableDataUser, Department department, Post post) throws Exception {
        String string;
        User user = tableDataUser.getUser();
        if (!UserControl.getInstance().addUser(user)) {
            long l = UserControl.getInstance().getUser(tableDataUser.getUserName());
            user.setId(l);
        }
        if (department != null && post != null) {
            CompanyRole companyRole = new CompanyRole(post.getId(), department.getId(), null);
            CompanyRoleControl.getInstance().addCompanyRole(companyRole);
            try {
                UserControl.getInstance().addDepartmentAndPost2User(user.getId(), department.getId(), post.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((String)(string = tableDataUser.getRoleValue()))) {
            CustomRole customRole = CustomRoleControl.getInstance().findByCustomRoleName(string);
            try {
                if (customRole == null) {
                    customRole = new CustomRole(string, "");
                    if (CustomRoleControl.getInstance().addCustomRole(customRole)) {
                        CustomRoleControl.getInstance().addUsers(customRole.getId(), new long[]{user.getId()});
                    }
                } else {
                    CustomRoleControl.getInstance().addUsers(customRole.getId(), new long[]{user.getId()});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private void generateRecursionDepartment(Department department, RecursionTableData recursionTableData, RecursionDataModel recursionDataModel, int n) throws Exception {
        String string;
        int n2 = recursionTableData.getMarkFieldIndex();
        int n3 = recursionTableData.getParentmarkFieldIndex();
        String string2 = recursionDataModel.getValueAt(n, n2).toString();
        if (n3 < 0) {
            string = recursionDataModel.getParentValue(n);
        } else {
            Object object = recursionDataModel.getValueAt(n, n3);
            String string3 = string = object == null ? this.ROOT : object.toString();
        }
        if (StringUtils.isEmpty((String)string)) {
            string = this.ROOT;
        }
        department.setId(this.genIdFromString(string2));
        department.setPid(this.genIdFromString(string));
    }

    private long genIdFromString(String string) {
        if (string == this.ROOT) {
            return -1L;
        }
        Long l = this.deparIdMap.get(string);
        if (l == null) {
            long l2 = (long)this.deparIdMap.size() + this.id_for_fix;
            while (this.deparIdMap.containsValue(new Long(l2))) {
                ++l2;
            }
            this.deparIdMap.put(string, new Long(l2));
            return l2;
        }
        return l;
    }

    private String getDuplicatedInfo(List<TableDataUser> list) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (list.isEmpty()) {
            return stringBuilder.toString();
        }
        stringBuilder.append(Inter.getLocText((String)"FS-User-Duplicated_Username"));
        int n2 = n = list.size() > 3 ? 3 : list.size();
        for (int i = 0; i < n; ++i) {
            TableDataUser tableDataUser = list.get(i);
            stringBuilder.append(tableDataUser.getUserName());
            if (i == n - 1) continue;
            stringBuilder.append(Inter.getLocText((String)"FS-Frame-Simple_Comma"));
        }
        stringBuilder.append("...(");
        stringBuilder.append(Inter.getLocText((String)"FS-Generic-Page_Total"));
        stringBuilder.append(list.size());
        stringBuilder.append(Inter.getLocText((String)"FS-Generic-Simple_Ge"));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private boolean updateHSQLUsers(List<TableDataUser> list) throws Exception {
        boolean bl = true;
        for (TableDataUser tableDataUser : list) {
            UserControl.getInstance().deleteUser(tableDataUser.getId());
            this.importDuplicatedUser2HSQL(tableDataUser);
        }
        return bl;
    }

    private boolean importDuplicatedUser2HSQL(TableDataUser tableDataUser) throws Exception {
        String string = tableDataUser.getDepartmentValue();
        Department department = null;
        Post post = null;
        if (StringUtils.isNotEmpty((String)string)) {
            post = new Post(tableDataUser.getPostValue(), "");
            department = new Department(string, "", -1L);
            DepartmentControl.getInstance().addDepartment(department);
            if (!PostControl.getInstance().addPost(post)) {
                post = PostControl.getInstance().getPostByName(post.getPostname());
            }
        }
        return this.importUser2HSQL(tableDataUser, department, post);
    }

    private void clearTables() throws Exception {
        List<CustomRole> list;
        int n;
        List list2;
        Long[] longArray;
        int n2;
        List list3 = UserControl.getInstance().findAllUserWithoutSort();
        if (list3 != null) {
            n2 = list3.size();
            for (int i = 0; i < n2; ++i) {
                User user = (User)((Object)list3.get(i));
                UserControl.getInstance().deleteUser(user.getId());
            }
        }
        if ((longArray = DepartmentControl.getInstance().getDpidsByPid(-1L)) != null) {
            int n3 = longArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                DepartmentControl.getInstance().deleteDepartment(longArray[n2]);
            }
        }
        if ((list2 = PostControl.getInstance().getAllPost(false)) != null) {
            n = list2.size();
            for (int i = 0; i < n; ++i) {
                Post post = (Post)((Object)list2.get(i));
                PostControl.getInstance().deletePost(post.getId());
            }
        }
        if ((list = CustomRoleControl.getInstance().getAllCustomRole()) != null) {
            int n4 = list.size();
            for (n = 0; n < n4; ++n) {
                CustomRole customRole = list.get(n);
                CustomRoleControl.getInstance().deleteCustomRole(customRole.getId());
            }
        }
        this.deparIdMap.clear();
    }
}

