/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import com.fr.fs.base.entity.User;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.DateUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.record.DBRecordManager;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSManagerModuleGetVisitorInfoAction
extends ActionNoSessionCMD {
    private JSONArray ja;
    private Map statisticsInfos;

    public String getCMD() {
        return "getVisitorInfo";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        SimpleDateFormat simpleDateFormat;
        Object object;
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 9L)) {
            throw new NoPrivilegeException();
        }
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"startTime");
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"endTime");
        if (StringUtils.isNotBlank((String)string2)) {
            object = Calendar.getInstance();
            ((Calendar)object).setTime(DateUtils.string2Date((String)string2, (boolean)false));
            ((Calendar)object).set(5, ((Calendar)object).get(5) + 1);
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            string2 = simpleDateFormat.format(((Calendar)object).getTime());
        }
        this.ja = new JSONArray();
        this.statisticsInfos = new HashMap();
        object = this.getVisitorInfo(string, string2);
        this.getInfos((List<VisitorInfo>)object);
        simpleDateFormat = new JSONObject();
        simpleDateFormat.put("infos", this.ja);
        simpleDateFormat.put("statisticsInfos", this.getstatisticsTimes());
        printWriter.print(simpleDateFormat.toString());
        printWriter.flush();
        printWriter.close();
    }

    private Select getSingleSelectSQL(String string, Date date, Date date2, Connection connection) throws Exception {
        try {
            Where where = new Where();
            where.addColumn("logtime", 93, 3, (Object)date);
            where.addColumn("logtime", 93, 5, (Object)date2);
            Select select = new Select(new Table(string), where, DialectFactory.generateDialect((Connection)connection));
            select.addColumnName("tname");
            select.addColumnName("logtime");
            select.addColumnName("type");
            select.addColumnName("ip");
            select.addColumnName("userrole");
            select.addColumnName("username");
            return select;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VisitorInfo> getVisitorInfo(String string, String string2) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (StringUtils.isBlank((String)string)) {
            string = "1970-01-01 00:00:00";
        }
        if (StringUtils.isBlank((String)string2)) {
            string2 = simpleDateFormat.format(new Date());
        }
        Date date = simpleDateFormat.parse(string);
        Date date2 = simpleDateFormat.parse(string2);
        String[] stringArray = new String[]{"fr_exerecord", "fr_exprecord", "fr_ptrecord"};
        ArrayList<VisitorInfo> arrayList = new ArrayList<VisitorInfo>();
        Connection connection = DBRecordManager.getDB().createConnection();
        for (int i = 0; i < 3; ++i) {
            Select select = this.getSingleSelectSQL(stringArray[i], date, date2, connection);
            try {
                preparedStatement = select.createPreparedStatement(connection);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    arrayList.add(new VisitorInfo(resultSet.getString("tname"), resultSet.getTimestamp("logtime"), resultSet.getString("ip"), resultSet.getInt("type"), resultSet.getString("userrole"), resultSet.getString("username")));
                }
            }
            catch (SQLException sQLException) {
                try {
                    FRLogger.getLogger().error(sQLException.getMessage(), (Throwable)sQLException);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(resultSet);
                    DBUtils.closeStatement((Statement)preparedStatement);
                    throw throwable;
                }
                DBUtils.closeResultSet((ResultSet)resultSet);
                DBUtils.closeStatement((Statement)preparedStatement);
                continue;
            }
            DBUtils.closeResultSet((ResultSet)resultSet);
            DBUtils.closeStatement((Statement)preparedStatement);
            continue;
        }
        DBUtils.closeConnection((Connection)connection);
        return arrayList;
    }

    private void getInfos(List<VisitorInfo> list) throws Exception {
        for (VisitorInfo visitorInfo : list) {
            JSONObject jSONObject = new JSONObject();
            String string = String.valueOf(visitorInfo.getPath());
            int n = Integer.parseInt(String.valueOf(visitorInfo.getOpType()));
            this.statisticsTimes(string, n);
            jSONObject.put("path", (Object)string);
            String string2 = String.valueOf(visitorInfo.getLogtime());
            jSONObject.put("logtime", (Object)string2.substring(0, 19));
            jSONObject.put("ip", (Object)visitorInfo.getIp());
            jSONObject.put("opType", n);
            jSONObject.put("userrole", (Object)visitorInfo.getUserrole());
            String string3 = visitorInfo.getUsername();
            User user = UserControl.getInstance().getByUserName(string3);
            string3 = "(" + string3 + ")";
            if (user != null) {
                string3 = user.getRealname() + string3;
            }
            jSONObject.put("username", (Object)string3);
            this.ja.put((Object)jSONObject);
        }
    }

    private void statisticsTimes(String string, int n) {
        if (this.statisticsInfos.containsKey(string)) {
            Map map = (Map)this.statisticsInfos.get(string);
            if (map.containsKey(new Integer(n))) {
                Integer n2 = (Integer)map.get(new Integer(n));
                int n3 = n2 + 1;
                map.put(new Integer(n), new Integer(n3));
            } else {
                map.put(new Integer(n), new Integer(1));
            }
        } else {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            hashMap.put(new Integer(n), new Integer(1));
            this.statisticsInfos.put(string, hashMap);
        }
    }

    public JSONArray getstatisticsTimes() throws Exception {
        JSONArray jSONArray = new JSONArray();
        for (Map.Entry entry : this.statisticsInfos.entrySet()) {
            String string = String.valueOf(entry.getKey());
            Map map = (Map)entry.getValue();
            for (Map.Entry entry2 : map.entrySet()) {
                int n = Integer.parseInt(String.valueOf(entry2.getKey()));
                int n2 = Integer.parseInt(String.valueOf(entry2.getValue()));
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("path", (Object)string);
                jSONObject.put("opType", n);
                jSONObject.put("times", n2);
                jSONArray.put((Object)jSONObject);
            }
        }
        return jSONArray;
    }

    private class VisitorInfo {
        private String path;
        private Date logtime;
        private String ip;
        private int opType;
        private String userrole;
        private String username;

        public VisitorInfo(String string, Date date, String string2, int n, String string3, String string4) {
            this.path = string;
            this.logtime = date;
            this.ip = string2;
            this.opType = n;
            this.userrole = string3;
            this.username = string4;
        }

        public Date getLogtime() {
            return this.logtime;
        }

        public String getIp() {
            return this.ip;
        }

        public int getOpType() {
            return this.opType;
        }

        public String getPath() {
            return this.path;
        }

        public String getUserrole() {
            return this.userrole;
        }

        public String getUsername() {
            return this.username;
        }
    }
}

