/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.data.dao.DAOBean;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.NoPrivilegeException;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSManagerGetHomePageRolesAction
extends ActionNoSessionCMD {
    public String getCMD() {
        return "fs_get_homepage_roles";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        long l = ServiceUtils.getCurrentUserID(httpServletRequest);
        if (!UserControl.getInstance().hasModulePrivilege(l, 14L)) {
            throw new NoPrivilegeException();
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"homepageId");
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        JSONArray jSONArray = new JSONArray();
        if (ComparatorUtils.equals((String)string, (String)String.valueOf(0L))) {
            object = new JSONObject();
            object.put("homepageUrl", (Object)FSConfig.getProviderInstance().getSystemAttr().getHomePageURL());
            jSONArray.put(object);
        } else {
            object = UserControl.getInstance().getAllDepAndCRoleInfo(l);
            this.addCompanyRole(jSONArray, string, (JSONArray)object);
            this.addCustomRole(jSONArray, string, (JSONArray)object);
        }
        object = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        ((PrintWriter)object).print(jSONArray);
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    private void addCompanyRole(JSONArray jSONArray, String string, JSONArray jSONArray2) throws Exception {
        List<CompanyRole> list = CompanyRoleControl.getInstance().getAllCompanyRole();
        for (CompanyRole companyRole : list) {
            if (!this.hasDepOrCRolePrivilege(companyRole, jSONArray2)) continue;
            List<RoleHomePagePrivilege> list2 = CompanyRoleControl.getInstance().getAllHomePagePrivileges(companyRole.getId());
            for (RoleHomePagePrivilege roleHomePagePrivilege : list2) {
                if (!ComparatorUtils.equals((Object)string, (Object)roleHomePagePrivilege.getHomePageId())) continue;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("view", roleHomePagePrivilege.getView());
                jSONObject.put("departmentId", companyRole.getDepartmentId());
                jSONObject.put("postId", companyRole.getPostId());
                jSONObject.put("id", (Object)("10086" + companyRole.getPostId()));
                jSONArray.put((Object)jSONObject);
            }
        }
    }

    private void addCustomRole(JSONArray jSONArray, String string, JSONArray jSONArray2) throws Exception {
        List<CustomRole> list = CustomRoleControl.getInstance().getAllCustomRole();
        for (CustomRole customRole : list) {
            if (!this.hasDepOrCRolePrivilege(customRole, jSONArray2)) continue;
            List<RoleHomePagePrivilege> list2 = CustomRoleControl.getInstance().getAllHomePagePrivileges(customRole.getId());
            for (RoleHomePagePrivilege roleHomePagePrivilege : list2) {
                if (!ComparatorUtils.equals((Object)string, (Object)roleHomePagePrivilege.getHomePageId())) continue;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("view", roleHomePagePrivilege.getView());
                jSONObject.put("id", customRole.getId());
                jSONArray.put((Object)jSONObject);
            }
        }
    }

    private boolean hasDepOrCRolePrivilege(DAOBean dAOBean, JSONArray jSONArray) throws Exception {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            if (!jSONObject.has("id")) continue;
            if (jSONObject.has("departmentid")) {
                long l = jSONObject.getLong("departmentid");
                if (!(dAOBean instanceof CompanyRole) || l != ((CompanyRole)dAOBean).getDepartmentId()) continue;
                return true;
            }
            String string = jSONObject.optString("text", "");
            if (!(dAOBean instanceof CustomRole) || !ComparatorUtils.equals((String)string, (String)((CustomRole)dAOBean).getRolename())) continue;
            return true;
        }
        return false;
    }
}

