/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.Base64;
import com.fr.cache.Attachment;
import com.fr.cache.AttachmentSource;
import com.fr.stable.StableUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSMainGetReportCoverAction
extends ActionNoSessionCMD {
    private static final int INDATASIZE = 8192;

    public String getCMD() {
        return "get_report_cover";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"id");
        if (string != null) {
            byte[] byArray = this.getCoverBytes(httpServletRequest, string);
            if (WebUtils.getDevice((HttpServletRequest)httpServletRequest).isMobile()) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
                String string2 = Base64.encode((Image)bufferedImage, (String)"png");
                PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
                printWriter.print(string2);
                printWriter.flush();
                printWriter.close();
            } else {
                httpServletResponse.setContentType("image/png");
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                try {
                    servletOutputStream.write(byArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    servletOutputStream.flush();
                    servletOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private byte[] getCoverBytes(HttpServletRequest httpServletRequest, String string) throws Exception {
        byte[] byArray;
        Attachment attachment = AttachmentSource.getDelegateAttachment((String)string);
        if (attachment == null) {
            int n;
            String string2 = httpServletRequest.getSession().getServletContext().getRealPath("/");
            string2 = StableUtils.pathJoin((String[])new String[]{string2, "WEB-INF", "resources", "mobile", "cover", string});
            FileInputStream fileInputStream = new FileInputStream(string2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[8192];
            while ((n = ((InputStream)fileInputStream).read(byArray2, 0, byArray2.length)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            AttachmentSource.putDelegateAttachment((String)string, (Attachment)new Attachment(string, "image", string, byArray));
        } else {
            byArray = attachment.getBytes();
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }
}

