/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.TemplateUtils;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.UserInfo;
import com.fr.fs.control.UserControl;
import com.fr.fs.fun.LoginUIProcessor;
import com.fr.fs.plugin.ExtraPlatformClassManager;
import com.fr.fs.privilege.auth.FSAuthentication;
import com.fr.fs.privilege.base.DefaultLoginUIProcessor;
import com.fr.plugin.ExtraClassManager;
import com.fr.stable.fun.BuiltInParametersProvider;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FSLoadLogoutAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession(true);
        FSLoadLogoutAction.logout2RemoveInfo(httpSession, httpServletResponse);
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        this.writeSignOutInfo(httpServletRequest, printWriter);
        printWriter.flush();
        printWriter.close();
    }

    protected void writeSignOutInfo(HttpServletRequest httpServletRequest, PrintWriter printWriter) throws Exception {
        LoginUIProcessor loginUIProcessor = (LoginUIProcessor)ExtraPlatformClassManager.getInstance().getSingle("LoginUIProcessor");
        if (loginUIProcessor == null || "default".equals(FSConfig.getProviderInstance().getLoginPluginId())) {
            loginUIProcessor = DefaultLoginUIProcessor.getInstance();
        }
        printWriter.print(TemplateUtils.render((String)("${servletURL}?" + loginUIProcessor.loginFace(httpServletRequest) + "&_=" + System.currentTimeMillis())));
    }

    public String getCMD() {
        return "logout";
    }

    public static void logout2RemoveInfo(HttpSession httpSession, HttpServletResponse httpServletResponse) {
        Object object;
        if (httpSession == null) {
            return;
        }
        httpSession.removeAttribute("originalURL");
        FSAuthentication fSAuthentication = (FSAuthentication)httpSession.getAttribute("fr_fs_auth_key");
        if (fSAuthentication != null) {
            httpSession.removeAttribute("fr_fs_auth_key");
            httpSession.removeAttribute("fr_username");
            httpSession.removeAttribute("fr_authority");
            httpSession.removeAttribute("fr_userposition");
            httpSession.removeAttribute("fr_current_privilege_loader");
            object = ExtraClassManager.getInstance().getArray("BuiltInParametersProvider");
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                BuiltInParametersProvider builtInParametersProvider = (BuiltInParametersProvider)iterator.next();
                builtInParametersProvider.removeBuiltInParameters(httpSession);
            }
            UserControl.getInstance().logout(fSAuthentication.getUserInfo().getId());
        }
        object = new UserInfo();
        ((UserInfo)object).removeCookies(httpServletResponse);
    }
}

