/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.base.ExcelUtils;
import com.fr.base.FRContext;
import com.fr.file.CacheManager;
import com.fr.general.DeclareRecordType;
import com.fr.io.exporter.AppExporter;
import com.fr.io.exporter.CSVExporter;
import com.fr.io.exporter.HTMLExporter;
import com.fr.io.exporter.ImageExporter;
import com.fr.io.exporter.SVGExporter;
import com.fr.io.exporter.TextExporter;
import com.fr.io.exporter.WordExporter;
import com.fr.log.LogUtils;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.plugin.ExtraClassManager;
import com.fr.report.fun.ExportImageProcessor;
import com.fr.report.report.LazyPage;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.web.core.ReportRepositoryDeal;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.core.reserve.ExcelOperate;
import com.fr.web.core.reserve.PDFExporterFactory;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEmailActionTools {
    protected String fileName = "report";
    protected PrintWriter writer;
    protected ReportSessionIDInfor sessionIDInfor = null;
    protected File attachFile = null;

    protected void getPrintWriterWhileSendFailed() {
        if (this.writer == null) {
            return;
        }
        this.writer.println("{\"status\":\"error\"}");
    }

    protected void getPrintWriterSuccessful() {
        if (this.writer == null) {
            return;
        }
        this.writer.println("{\"status\":\"success\"}");
    }

    protected void closePrintWriter() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
    }

    protected AppExporter getExporterFormat(String string, HttpServletRequest httpServletRequest, ReportSessionIDInfor reportSessionIDInfor) {
        if (string.equalsIgnoreCase("PDF")) {
            return PDFExporterFactory.getPDFExporter();
        }
        if (string.equalsIgnoreCase("Excel")) {
            return new ExcelOperate().createExcelExporter(httpServletRequest, reportSessionIDInfor);
        }
        if (string.equalsIgnoreCase("SVG")) {
            return new SVGExporter();
        }
        if (string.equalsIgnoreCase("CSV")) {
            return new CSVExporter();
        }
        if (string.equalsIgnoreCase("Text")) {
            return new TextExporter();
        }
        if (string.equalsIgnoreCase("Word")) {
            return new WordExporter();
        }
        if (string.equalsIgnoreCase("Html")) {
            return new HTMLExporter();
        }
        return null;
    }

    protected DeclareRecordType getExporterType(String string) {
        if (string.equalsIgnoreCase("PDF")) {
            return DeclareRecordType.EXPORT_TYPE_PDF;
        }
        if (string.equalsIgnoreCase("Excel")) {
            return DeclareRecordType.EXPORT_TYPE_EXCEL_ORIGINAL;
        }
        if (string.equalsIgnoreCase("SVG")) {
            return DeclareRecordType.EXPORT_TYPE_SVG;
        }
        if (string.equalsIgnoreCase("CSV")) {
            return DeclareRecordType.EXPORT_TYPE_CSV;
        }
        if (string.equalsIgnoreCase("Text")) {
            return DeclareRecordType.EXPORT_TYPE_TEXT;
        }
        if (string.equalsIgnoreCase("Word")) {
            return DeclareRecordType.EXPORT_TYPE_WORD;
        }
        if (string.equalsIgnoreCase("Html")) {
            return DeclareRecordType.EXPORT_TYPE_HTML;
        }
        return null;
    }

    protected String getAttachFileName(HttpServletRequest httpServletRequest) throws Exception {
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"__filename__");
        if (StringUtils.isEmpty((String)string)) {
            string = this.sessionIDInfor.getWebTitle().replaceAll("\\s", "_");
            string = string.replaceAll(",", "_");
        }
        return string;
    }

    protected String getAttachFileFormat(String string) {
        if (string.equalsIgnoreCase("PDF")) {
            return "pdf";
        }
        if (string.equalsIgnoreCase("Excel")) {
            ResultWorkBook resultWorkBook = this.sessionIDInfor.getWorkBook2Show();
            boolean bl = false;
            for (int i = 0; i < resultWorkBook.getReportCount(); ++i) {
                if (!(resultWorkBook.getResultReport(i) instanceof LazyPage)) continue;
                bl = true;
                break;
            }
            return bl ? "zip" : (ExcelUtils.checkThirdJarSupportPOI() ? "xlsx" : "xls");
        }
        if (string.equalsIgnoreCase("SVG")) {
            return "svg";
        }
        if (string.equalsIgnoreCase("HTML")) {
            return "zip";
        }
        if (string.equalsIgnoreCase("CSV")) {
            return "csv";
        }
        if (string.equalsIgnoreCase("Text")) {
            return "txt";
        }
        if (string.equalsIgnoreCase("Word")) {
            return "doc";
        }
        if (string.equalsIgnoreCase("Html")) {
            return "html";
        }
        return null;
    }

    protected List<File> exportTemplateAsImage(HttpServletRequest httpServletRequest) throws Exception {
        String string = "png";
        File file = new File(CacheManager.getProviderInstance().getCacheDirectory(), "_" + System.currentTimeMillis() + File.separator + this.fileName + "." + string);
        ArrayList<File> arrayList = new ArrayList<File>();
        ExportImageProcessor exportImageProcessor = (ExportImageProcessor)ExtraClassManager.getInstance().getSingle("ExportImageProcessor");
        if (exportImageProcessor == null) {
            StableUtils.mkdirs((File)file.getParentFile());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ImageExporter imageExporter = new ImageExporter(string);
            try {
                LogUtils.exportAndLogRecord((AppExporter)imageExporter, (OutputStream)fileOutputStream, (ReportRepositoryDeal)new ReportRepositoryDeal(httpServletRequest, this.sessionIDInfor), (DeclareRecordType)DeclareRecordType.EXPORT_TYPE_IMAGE_PNG);
                file.deleteOnExit();
                file.getParentFile().deleteOnExit();
                arrayList.add(file);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
            return arrayList;
        }
        return exportImageProcessor.exportImage((Object)this.sessionIDInfor.getWorkBook2Show(), this.fileName);
    }
}

