/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule;

import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.JDBCDataAccessObjectOperator;
import com.fr.fs.dao.properties.ScheduleDAOProperties;
import com.fr.fs.schedule.ScheduleContextImpl;
import com.fr.fs.schedule.ScheduleJdbcDaoOperator;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.third.org.quartz.Scheduler;

public abstract class ScheduleContext {
    private static JDBCDataAccessObjectOperator jdbcDaoManager;
    private static Scheduler scheduler;

    public static JDBCDataAccessObjectOperator getJdbcDaoManager() {
        if (jdbcDaoManager == null) {
            ScheduleDAOProperties scheduleDAOProperties = ScheduleDAOProperties.getInstance();
            jdbcDaoManager = new ScheduleJdbcDaoOperator(scheduleDAOProperties.createDatabaseConnection(), scheduleDAOProperties.getAllObjTableMappers());
        }
        return jdbcDaoManager;
    }

    public static DataAccessObjectSession createDAOSession() {
        return ScheduleContextImpl.getInstance().createDAOSession();
    }

    public static void setScheduler(Scheduler scheduler) {
        ScheduleContext.scheduler = scheduler;
    }

    public static Scheduler getScheduler() {
        return scheduler;
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                jdbcDaoManager = null;
            }
        });
    }
}

