/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.process;

import com.fr.base.FRContext;
import com.fr.fs.DefaultPlate;
import com.fr.fs.FSConfig;
import com.fr.fs.basic.AutoBackupTimerAttr;
import com.fr.fs.process.FSBackupFolderType;
import com.fr.fs.web.service.ServerConfigBackupFileFilter;
import com.fr.general.DateUtils;
import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.file.XMLFileManagerProvider;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import com.fr.stable.web.ServletContextListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class FSConfigBackupRestoreProcessPlate
extends DefaultPlate {
    public static Timer autoBackupTimer = null;
    public static AutoBackupTimerTask autoBackupTimerTask = null;
    private static boolean isOverInterval = false;
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyy.MM.dd HH.mm.ss");
    private static final int AUTO_BACKUP_TASK_ID = 100;
    private static final long MILLISECOND_OF_ONE_DAY = 86400000L;

    public String[] getPlateJavaScriptFiles4WebClient() {
        return new String[]{"com/fr/fs/web/js/manager/fs_serconfmgr.js"};
    }

    public static void updateTimer(boolean bl, long l) {
        AutoBackupTimerAttr autoBackupTimerAttr = FSConfig.getProviderInstance().getAutoBackupTimerAttr();
        String string = autoBackupTimerAttr.getAutoBackupNextStartDate();
        int n = 100;
        if (null != autoBackupTimerTask) {
            n = autoBackupTimerTask.getID();
            autoBackupTimerTask.cancel();
        }
        if (bl) {
            if (null == autoBackupTimer) {
                autoBackupTimer = new Timer("AutoBackupTimer");
            }
            FSConfigBackupRestoreProcessPlate.processExecuteInterval(string, autoBackupTimerAttr, l, ++n, false);
        } else if (null != autoBackupTimer) {
            autoBackupTimer.cancel();
            autoBackupTimer = null;
        }
        autoBackupTimerAttr.setIsAutoBackupStart(bl);
        autoBackupTimerAttr.setAutoBackupFrequency(l);
        FSConfig.getProviderInstance().setAutoBackupTimerAttr(autoBackupTimerAttr);
        try {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getProviderInstance());
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
    }

    private static void processExecuteInterval(String string, AutoBackupTimerAttr autoBackupTimerAttr, long l, int n, boolean bl) {
        Date date = FSConfigBackupRestoreProcessPlate.processTimerDate(string);
        if (date.before(new Date())) {
            isOverInterval = true;
            Date date2 = new Date();
            while (date.before(date2)) {
                date.setTime(date.getTime() + l * 86400000L);
            }
            if (bl) {
                date.setTime(date.getTime() - l * 86400000L);
            }
            autoBackupTimerAttr.setAutoBackupNextStartDate(FORMATTER.format(date));
        }
        autoBackupTimerTask = new AutoBackupTimerTask(n);
        autoBackupTimer.scheduleAtFixedRate((TimerTask)autoBackupTimerTask, date, l * 86400000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date processTimerDate(String string) {
        Date date = new Date();
        try {
            SimpleDateFormat simpleDateFormat = FORMATTER;
            synchronized (simpleDateFormat) {
                date = FORMATTER.parse(string);
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return date;
    }

    private static void shutdownAutoBackupTimer() {
        if (autoBackupTimerTask != null) {
            autoBackupTimerTask.cancel();
            autoBackupTimerTask = null;
        }
        if (autoBackupTimer != null) {
            autoBackupTimer.cancel();
            autoBackupTimer = null;
        }
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.getActualMaximum(5));
        String string = FORMATTER.format(calendar.getTime());
        String string2 = "autoBackup";
        boolean bl = true;
        long l = AutoBackupTimerAttr.DEFAULT_FREQ;
        AutoBackupTimerAttr autoBackupTimerAttr = FSConfig.getProviderInstance().getAutoBackupTimerAttr();
        if (StringUtils.isEmpty((String)autoBackupTimerAttr.getAutoBackupTaskName())) {
            autoBackupTimerAttr.setAutoBackupTaskName(string2);
            autoBackupTimerAttr.setIsAutoBackupStart(bl);
            autoBackupTimerAttr.setAutoBackupNextStartDate(string);
            autoBackupTimerAttr.setAutoBackupFrequency(l);
            FSConfig.getProviderInstance().setAutoBackupTimerAttr(autoBackupTimerAttr);
            try {
                FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getProviderInstance());
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
            }
        } else {
            bl = autoBackupTimerAttr.isAutoBackupStart();
            string = autoBackupTimerAttr.getAutoBackupNextStartDate();
            l = autoBackupTimerAttr.getAutoBackupFrequency();
            if (l >= 86400000L) {
                autoBackupTimerAttr.setAutoBackupFrequency(l /= 86400000L);
            }
        }
        if (bl) {
            autoBackupTimer = new Timer("AutoBackupTimer");
            FSConfigBackupRestoreProcessPlate.processExecuteInterval(string, autoBackupTimerAttr, l, 100, true);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    FSConfigBackupRestoreProcessPlate.shutdownAutoBackupTimer();
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage());
                }
            }
        });
        ServletContext.addServletContextListener((ServletContextListener)new ServletContextAdapter(){

            public void onServletStop() {
                try {
                    FSConfigBackupRestoreProcessPlate.shutdownAutoBackupTimer();
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage());
                }
            }
        });
    }

    private static class AutoBackupTimerTask
    extends TimerTask {
        private static final String FRCONFIG_BAK = "frbak";
        private static final String FINEDB = "finedb";
        private static final String AUTO_BACKUP = "autobackup";
        private static final int AUTO_BACKUP_NUM_MAX = 30;
        private int id;

        public AutoBackupTimerTask(int n) {
            this.id = n;
        }

        public int getID() {
            return this.id;
        }

        public void run() {
            AutoBackupTimerAttr autoBackupTimerAttr = FSConfig.getProviderInstance().getAutoBackupTimerAttr();
            Date date = FSConfigBackupRestoreProcessPlate.processTimerDate(autoBackupTimerAttr.getAutoBackupNextStartDate());
            long l = autoBackupTimerAttr.getAutoBackupFrequency();
            String string = FORMATTER.format(date.getTime() + l * 86400000L);
            if (!this.executeAutoBackup(autoBackupTimerAttr.getAutoBackupNextStartDate())) {
                FRLogger.getLogger().error("auto back up failed.");
            }
            isOverInterval = false;
            autoBackupTimerAttr.setAutoBackupNextStartDate(string);
            FSConfig.getProviderInstance().setAutoBackupTimerAttr(autoBackupTimerAttr);
            try {
                FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getProviderInstance());
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
            }
        }

        private boolean executeAutoBackup(String string) {
            String string2 = StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), FRCONFIG_BAK});
            String[] stringArray = ServerConfigBackupFileFilter.listFilteredFiles(string2, AUTO_BACKUP);
            if (stringArray.length >= 30) {
                this.deleteDirectory(StableUtils.pathJoin((String[])new String[]{string2, AUTO_BACKUP, stringArray[stringArray.length - 1]}));
            }
            String string3 = StableUtils.pathJoin((String[])new String[]{string2, AUTO_BACKUP, isOverInterval ? string : DateUtils.getDate2Str((String)"yyyy.MM.dd HH.mm.ss", (Date)new Date())});
            return FSBackupFolderType.backupServerProjectFiles(string3);
        }

        private boolean backupServerConfigFiles(String string, String string2, String string3, String string4, String[] stringArray) {
            String string5 = StableUtils.pathJoin((String[])new String[]{string4, AUTO_BACKUP, isOverInterval ? string : DateUtils.getDate2Str((String)"yyyy.MM.dd HH.mm.ss", (Date)new Date())});
            try {
                for (String string6 : stringArray) {
                    IOUtils.copy((File)new File(StableUtils.pathJoin((String[])new String[]{string2, string6})), (File)new File(StableUtils.pathJoin((String[])new String[]{string5, FINEDB})));
                }
                this.copy(new File(string3), new File(string5));
            }
            catch (IOException iOException) {
                FRLogger.getLogger().error(iOException.getMessage());
                return false;
            }
            Object[] objectArray = new File(string5).listFiles();
            return ArrayUtils.getLength((Object)objectArray) > 0;
        }

        private File[] getFileFilter(File file) {
            return file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".xml");
                }
            });
        }

        private void copy(File file, File file2) throws IOException {
            File file3;
            if (file.isFile()) {
                IOUtils.copy((InputStream)new FileInputStream(file), (String)file.getName(), (File)file2);
            } else if (file.isDirectory() && file.getName().endsWith("resources") && StableUtils.mkdirs((File)(file3 = new File(file2, file.getName())))) {
                File[] fileArray = this.getFileFilter(file);
                for (int i = 0; i < fileArray.length; ++i) {
                    this.copy(fileArray[i], file3);
                }
            }
        }

        private void deleteDirectory(String string) {
            try {
                File file = new File(string);
                if (file.isDirectory()) {
                    File[] fileArray;
                    for (File file2 : fileArray = file.listFiles()) {
                        this.deleteDirectory(file2.toString());
                        file2.delete();
                    }
                } else {
                    file.delete();
                }
                file.delete();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
            }
        }
    }
}

