/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.process;

import com.fr.base.FRContext;
import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StableUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FSBackupFolderType {
    FineDB{

        public void backupServerProjectFile(String string, String string2) throws IOException {
            String[] stringArray;
            String string3 = StableUtils.pathJoin((String[])new String[]{string, "finedb"});
            for (String string4 : stringArray = new String[]{"db.backup", "db.data", "db.properties", "db.script"}) {
                IOUtils.copy((File)new File(StableUtils.pathJoin((String[])new String[]{string3, string4})), (File)new File(StableUtils.pathJoin((String[])new String[]{string2, "finedb"})));
            }
        }
    }
    ,
    Designer{

        public void backupServerProjectFile(String string, String string2) throws IOException {
            String[] stringArray = new String[]{"fr-designer-chart-8.0.jar", "fr-designer-core-8.0.jar", "fr-designer-report-8.0.jar"};
            String string3 = StableUtils.pathJoin((String[])new String[]{StableUtils.getInstallHome(), "lib"});
            for (String string4 : stringArray) {
                IOUtils.copy((File)new File(StableUtils.pathJoin((String[])new String[]{string3, string4})), (File)new File(StableUtils.pathJoin((String[])new String[]{string2, "designer"})));
            }
        }
    }
    ,
    Resources{

        public void backupServerProjectFile(String string, String string2) throws IOException {
            String string3 = StableUtils.pathJoin((String[])new String[]{string, "resources"});
            super.backupServerProjectFile(string3, string2);
        }
    }
    ,
    Lib{

        public void backupServerProjectFile(String string, String string2) throws IOException {
            String string3 = StableUtils.pathJoin((String[])new String[]{string, "lib"});
            super.backupServerProjectFile(string3, string2);
        }
    }
    ,
    ReportLets{

        public void backupServerProjectFile(String string, String string2) throws IOException {
            String string3 = StableUtils.pathJoin((String[])new String[]{string, "reportlets"});
            super.backupServerProjectFile(string3, string2);
        }
    }
    ,
    Plugins{

        public void backupServerProjectFile(String string, String string2) throws IOException {
            String string3 = StableUtils.pathJoin((String[])new String[]{string, "plugins"});
            super.backupServerProjectFile(string3, string2);
        }
    }
    ,
    Classes{

        public void backupServerProjectFile(String string, String string2) throws IOException {
            String string3 = StableUtils.pathJoin((String[])new String[]{string, "classes"});
            super.backupServerProjectFile(string3, string2);
        }
    };


    public void backupServerProjectFile(String string, String string2) throws IOException {
        FSBackupFolderType.backup(new File(string), new File(string2));
    }

    private static File[] getXMLFileFilter(File file) {
        return file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".xml");
            }
        });
    }

    private static void backup(File file, File file2) throws IOException {
        File file3;
        if (file.isFile()) {
            IOUtils.copy((InputStream)new FileInputStream(file), (String)file.getName(), (File)file2);
        } else if (file.isDirectory() && StableUtils.mkdirs((File)(file3 = new File(file2, file.getName())))) {
            File[] fileArray = file.listFiles();
            if (file.getName().endsWith("resources")) {
                fileArray = FSBackupFolderType.getXMLFileFilter(file);
            }
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                FSBackupFolderType.backup(fileArray[i], file3);
            }
        }
    }

    public static boolean backupServerProjectFiles(String string) {
        Object[] objectArray;
        try {
            objectArray = FSBackupFolderType.values();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                objectArray[i].backupServerProjectFile(FRContext.getCurrentEnv().getPath(), string);
            }
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage());
            return false;
        }
        objectArray = new File(string).listFiles();
        return ArrayUtils.getLength((Object)objectArray) > 0;
    }
}

