/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.plugin.op.web.helper;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.fs.plugin.op.web.helper.DeleteHelper;
import com.fr.fs.plugin.op.web.helper.Procedure;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.general.Inter;
import com.fr.general.SiteCenter;
import com.fr.general.http.HttpClient;
import com.fr.plugin.Plugin;
import com.fr.plugin.PluginConfigManager;
import com.fr.plugin.PluginLoader;
import com.fr.plugin.PluginManagerHelper;
import com.fr.plugin.PluginVerifyException;
import com.fr.plugin.dependence.PluginDependence;
import com.fr.plugin.dependence.PluginDependenceException;
import com.fr.plugin.dependence.PluginDependenceUnit;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebHelper {
    private static final String TEMP_PATH = StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), "/tmp"});
    public static final String DOWNLOAD_PATH = StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), "/cache"});
    public static final String DEPENDENCE_DOWNLOAD_PATH = StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), "/cache/dependence"});
    public static final String TEMP_FILE = "temp.zip";
    public static final String CONNECTION_404 = "404";
    private static final int KB = 1024;

    private static String getDownloadPath(String string, String string2) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", string);
        hashMap.put("username", string2);
        HttpClient httpClient = new HttpClient(SiteCenter.getInstance().acquireUrlByKind("plugin.download"), hashMap);
        String string3 = httpClient.getResponseText();
        String string4 = "UTF-8";
        string3 = URLDecoder.decode(URLDecoder.decode(string3, string4), string4);
        return string3;
    }

    public static void downloadPluginFile(String string, String string2, Procedure<Double> procedure) throws Exception {
        FileOutputStream fileOutputStream;
        InputStream inputStream;
        HttpClient httpClient = new HttpClient(WebHelper.getDownloadPath(string, string2));
        if (httpClient.getResponseCode() == 200) {
            int n = httpClient.getContentLength();
            inputStream = httpClient.getResponseStream();
            String string3 = StableUtils.pathJoin((String[])new String[]{DOWNLOAD_PATH, TEMP_FILE});
            StableUtils.makesureFileExist((File)new File(string3));
            fileOutputStream = new FileOutputStream(string3);
            byte[] byArray = new byte[1024];
            int n2 = 0;
            int n3 = 0;
            while ((n2 = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n2);
                byArray = new byte[1024];
                procedure.procedure((double)(n3 += n2) / (double)n);
            }
        } else {
            throw new PluginVerifyException(Inter.getLocText((String)"FS-Web-Plugin_Connect_Server_Error"));
        }
        inputStream.close();
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public static void downloadPluginDependenceFile(String string, Procedure<Double> procedure) throws Exception {
        try {
            WebHelper.readPluginFormTemp();
        }
        catch (PluginDependenceException pluginDependenceException) {
            List list = pluginDependenceException.getDependenceUnitList();
            try {
                WebHelper.downloadAndInstallPluginDependenceFile(list, procedure);
            }
            catch (Exception exception) {
                throw new Exception(Inter.getLocText((String)"FR-Designer-Dependence_Install_Failed"));
            }
        }
    }

    private static void downloadAndInstallPluginDependenceFile(List<PluginDependenceUnit> list, Procedure<Double> procedure) throws Exception {
        int n = 0;
        int n2 = WebHelper.getTotalDependenceLength(list);
        for (int i = 0; i < list.size(); ++i) {
            FileOutputStream fileOutputStream;
            String string;
            InputStream inputStream;
            PluginDependenceUnit pluginDependenceUnit = list.get(i);
            HttpClient httpClient = new HttpClient(SiteCenter.getInstance().acquireUrlByKind(pluginDependenceUnit.getDependenceID()));
            if (httpClient.getResponseCode() == 200) {
                inputStream = httpClient.getResponseStream();
                string = StableUtils.pathJoin((String[])new String[]{DEPENDENCE_DOWNLOAD_PATH, TEMP_FILE});
                StableUtils.makesureFileExist((File)new File(string));
                fileOutputStream = new FileOutputStream(string);
                byte[] byArray = new byte[1024];
                int n3 = 0;
                while ((n3 = inputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n3);
                    byArray = new byte[1024];
                    procedure.procedure((double)(n += n3) / (double)n2);
                }
            } else {
                throw new PluginDependenceException(Inter.getLocText((String)"FS-Web-Dependence_Connect_Server_Error"));
            }
            inputStream.close();
            fileOutputStream.flush();
            fileOutputStream.close();
            IOUtils.unZipFilesGBK((String)string, (String)(FRContext.getCurrentEnv().getPath() + pluginDependenceUnit.getDependenceDir()));
        }
    }

    public static File getDownloadTempFile() {
        return new File(StableUtils.pathJoin((String[])new String[]{DOWNLOAD_PATH, TEMP_FILE}));
    }

    public static Plugin readPlugin(File file) throws Exception {
        StableUtils.deleteFile((File)new File(TEMP_PATH));
        IOUtils.unzip((File)file, (String)TEMP_PATH);
        return WebHelper.readPluginFormTemp();
    }

    public static Plugin readPluginFormTemp() throws Exception {
        Object[] objectArray;
        File file = WebHelper.getTempPluginFileDirectory();
        if (file == null) {
            return null;
        }
        Plugin plugin = null;
        if (file.isDirectory() && ArrayUtils.isNotEmpty((Object[])(objectArray = file.listFiles()))) {
            for (Object object : objectArray) {
                if (!((File)object).getName().equals("plugin.xml")) continue;
                plugin = new Plugin();
                InputStream inputStream = plugin.readEncryptXml((InputStream)new FileInputStream((File)object));
                XMLTools.readInputStreamXML((XMLReadable)plugin, (InputStream)inputStream);
                WebHelper.checkDependenceEnv(plugin);
                if (!plugin.isValidate()) {
                    return null;
                }
                inputStream.close();
                break;
            }
        }
        return plugin;
    }

    private static void checkDependenceEnv(Plugin plugin) throws PluginDependenceException {
        PluginDependence pluginDependence = plugin.getDependence();
        if (pluginDependence == null) {
            return;
        }
        PluginDependenceException pluginDependenceException = new PluginDependenceException();
        String string = plugin.getId();
        pluginDependenceException.setPluginID(string);
        List list = pluginDependence.getDependPlugins();
        for (int i = 0; list != null && i < list.size(); ++i) {
            PluginDependenceUnit pluginDependenceUnit = (PluginDependenceUnit)list.get(i);
            if (pluginDependenceUnit.checkFileEnv()) continue;
            pluginDependenceException.addPluginDependence(pluginDependenceUnit);
        }
        List list2 = pluginDependenceException.getDependenceUnitList();
        if (list2.isEmpty()) {
            return;
        }
        pluginDependenceException.setPluginLength(WebHelper.getTotalDependenceLength(list2));
        throw pluginDependenceException;
    }

    private static int getTotalDependenceLength(List<PluginDependenceUnit> list) {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            PluginDependenceUnit pluginDependenceUnit = list.get(i);
            HttpClient httpClient = new HttpClient(SiteCenter.getInstance().acquireUrlByKind(pluginDependenceUnit.getDependenceID()));
            if (httpClient.getResponseCode() == 200) {
                n += httpClient.getContentLength();
                continue;
            }
            return -1;
        }
        return n;
    }

    public static File getTempPluginFileDirectory() {
        Object[] objectArray;
        File file = new File(TEMP_PATH);
        if (file.isDirectory() && !file.getName().startsWith(".") && ArrayUtils.isNotEmpty((Object[])(objectArray = file.listFiles()))) {
            for (Object object : objectArray) {
                if (!WebHelper.foundConfigFile((File)object)) continue;
                return object;
            }
        }
        return null;
    }

    private static boolean foundConfigFile(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        Object[] objectArray = file.listFiles();
        if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                if (!"plugin.xml".equals(((File)object).getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static void installFromDisk(File file) throws Exception {
        Plugin plugin = WebHelper.readPlugin(file);
        WebHelper.installPluginFromUnzippedDir(FRContext.getCurrentEnv(), plugin);
    }

    public static void updateFromDisk(File file) throws Exception {
        Plugin plugin = WebHelper.readPlugin(file);
        if (plugin == null) {
            throw new Exception(Inter.getLocText((String)"FS-Msg-Invalid_Plugin_Zip_File"));
        }
        Plugin plugin2 = PluginLoader.getLoader().getPluginById(plugin.getId());
        if (plugin2 != null) {
            if (WebHelper.isNewThan(plugin, plugin2)) {
                String[] stringArray = WebHelper.uninstallPlugin(FRContext.getCurrentEnv(), plugin2);
                DeleteHelper.saveFilesWhichToDelete(stringArray);
                DeleteHelper.removeFilesFromDir();
                WebHelper.installPluginFromUnzippedDir(FRContext.getCurrentEnv(), plugin);
            }
        } else {
            throw new Exception(Inter.getLocText((String)"FS-Msg-Not_Found_Plugin"));
        }
    }

    public static void installPluginFromUnzippedDir(Env env, Plugin plugin) throws Exception {
        WebHelper.validPlugin(plugin);
        if (plugin.isValidate()) {
            File file = WebHelper.getTempPluginFileDirectory();
            env.copyFilesToPluginAndLibFolder(file, plugin);
            env.movePluginEmbFile(file, plugin);
        }
        StableUtils.deleteFile((File)new File(TEMP_PATH));
        PluginConfigManager.getProviderInstance().pushNewPlugin(plugin);
        PluginConfigManager.getProviderInstance().syncPluginConfig();
    }

    private static void validPlugin(Plugin plugin) throws Exception {
        if (plugin == null) {
            throw new PluginVerifyException(Inter.getLocText((String)"FS-Web-Plugin_Illegal_Plugin_Zip_Cannot_Be_Install"));
        }
        if (PluginLoader.getLoader().isInstalled(plugin)) {
            throw new PluginVerifyException(Inter.getLocText((String)"FS-Web-Plugin_Has_Been_Installed"));
        }
        if (plugin.checkIfJarExpired()) {
            String string = Inter.getLocText((String[])new String[]{"FS-Web-Plugin_Jar_Expired", ",", "FS-Web-Plugin_Install_Failed", ",", "FS-Web-Plugin_Please_Update_Jar", ":", plugin.getRequiredJarTime()});
            FRLogger.getLogger().error(string);
            throw new PluginVerifyException(string);
        }
        File file = WebHelper.getTempPluginFileDirectory();
        File file2 = new File(StableUtils.pathJoin((String[])new String[]{FRContext.getCurrentEnv().getPath(), "plugins", "plugin-" + plugin.getId()}));
        if (!PluginManagerHelper.checkLic((Plugin)plugin, (File)file) && !PluginManagerHelper.checkLic((Plugin)plugin, (File)file2)) {
            String string = Inter.getLocText((String)"FS-Web-PluginLicense_Check_Failed");
            FRLogger.getLogger().error(string);
            throw new PluginVerifyException(string);
        }
    }

    public static String[] uninstallPlugin(Env env, Plugin plugin) throws Exception {
        if (plugin == null || env == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        PluginLoader.getLoader().deletePlugin(plugin);
        return env.deleteFileFromPluginAndLibFolder(plugin);
    }

    public static boolean isNewThan(Plugin plugin, Plugin plugin2) {
        return ComparatorUtils.compare((Object)plugin.getVersion(), (Object)plugin2.getVersion()) >= 0;
    }
}

