/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.datainit;

import com.fr.base.FRContext;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.DataInitJob;
import com.fr.fs.FSConfig;
import com.fr.fs.base.PriorityGenerator;
import com.fr.fs.base.entity.PlatformManageModule;
import com.fr.fs.plugin.ExtraPlatformClassManager;
import com.fr.plugin.proxy.PluginProxyCompatibleUtils;
import java.util.Set;

public class PlatformManageModuleDataInitJob
implements DataInitJob {
    private static PlatformManageModuleDataInitJob SC = new PlatformManageModuleDataInitJob();

    private PlatformManageModuleDataInitJob() {
    }

    public static PlatformManageModuleDataInitJob getInstance() {
        return SC;
    }

    public String errorMessage() {
        return "Default module data init failed!";
    }

    public void initData(DataAccessObjectSession dataAccessObjectSession, boolean bl) throws Exception {
        try {
            dataAccessObjectSession.beginTransaction();
            this.updateModule(dataAccessObjectSession);
            PlatformManageModule platformManageModule = new PlatformManageModule("FS-Module-Platform_Manager", "", 1L, -1L);
            long l = platformManageModule.getId();
            dataAccessObjectSession.save((Object)platformManageModule);
            Set set = ExtraPlatformClassManager.getInstance().getArray("PlatformManageModule");
            set = PluginProxyCompatibleUtils.toOriObjectHashSet((Set)set);
            PlatformManageModule[] platformManageModuleArray = set.toArray(new PlatformManageModule[set.size()]);
            int[] nArray = new int[platformManageModuleArray.length];
            for (int i = 0; i < platformManageModuleArray.length; ++i) {
                nArray[i] = platformManageModuleArray[i].getPriority();
            }
            PlatformManageModule platformManageModule2 = this.createPlatformManageModule("FS-Module-Report_Manager", 2, l, nArray);
            dataAccessObjectSession.saveOrUpdate((Object)platformManageModule2);
            platformManageModule2 = this.createPlatformManageModule("FS-Module-User_Manager", 3, l, nArray);
            dataAccessObjectSession.saveOrUpdate((Object)platformManageModule2);
            platformManageModule2 = this.createPlatformManageModule("FS-Module-Privilege_Manager", 18, l, nArray);
            dataAccessObjectSession.saveOrUpdate((Object)platformManageModule2);
            platformManageModule2 = this.createPlatformManageModule("FS-Module-Server_Setting", 5, l, nArray);
            dataAccessObjectSession.saveOrUpdate((Object)platformManageModule2);
            platformManageModule2 = this.createPlatformManageModule("FS-Module-Look_And_Feel", 14, l, nArray);
            dataAccessObjectSession.saveOrUpdate((Object)platformManageModule2);
            platformManageModule2 = this.createPlatformManageModule("FS-Module-Simple_Register", 8, l, nArray);
            dataAccessObjectSession.saveOrUpdate((Object)platformManageModule2);
            for (PlatformManageModule platformManageModule3 : platformManageModuleArray) {
                if (platformManageModule3.isAppendToLast()) {
                    platformManageModule3.setPriority(PriorityGenerator.generate(nArray));
                }
                dataAccessObjectSession.saveOrUpdate((Object)platformManageModule3);
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            try {
                dataAccessObjectSession.rollback();
            }
            catch (Exception exception2) {
                FRContext.getLogger().error("RollBack Failed : " + exception.getMessage(), (Throwable)exception);
            }
            throw exception;
        }
        finally {
            dataAccessObjectSession.closeTransaction();
        }
    }

    private PlatformManageModule createPlatformManageModule(String string, int n, long l, int[] nArray) {
        int n2 = PriorityGenerator.generate(nArray);
        return new PlatformManageModule(string, "", (long)n, l, n2);
    }

    private void updateModule(DataAccessObjectSession dataAccessObjectSession) throws Exception {
        if (FSConfig.getProviderInstance().needUpdate()) {
            dataAccessObjectSession.delete(PlatformManageModule.class);
        }
    }
}

