/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.dao;

import com.fr.data.dao.DAOException;
import com.fr.data.dao.DatabaseAction;
import com.fr.fs.dao.EntryDAO;
import com.fr.fs.web.platform.entry.ReportProcessEntry;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportProcessEntryDAO
extends EntryDAO<ReportProcessEntry> {
    private static final ReportProcessEntryDAO SC = new ReportProcessEntryDAO();

    public static ReportProcessEntryDAO getInstance() {
        return SC;
    }

    private ReportProcessEntryDAO() {
    }

    public void save(ReportProcessEntry reportProcessEntry) throws Exception {
        this.createSession().save((Object)reportProcessEntry);
    }

    public void transfer(ReportProcessEntry reportProcessEntry) throws Exception {
        this.createSession(DatabaseAction.TRANSFER).transfer((Object)reportProcessEntry);
    }

    public boolean delete(ReportProcessEntry reportProcessEntry) throws Exception {
        long l = reportProcessEntry.getId();
        if (l < 0L) {
            throw new DAOException("The object is not a persistent Object. Can not find a right id.");
        }
        return this.deleteByID(l);
    }

    public ReportProcessEntry findByID(long l) throws Exception {
        return (ReportProcessEntry)this.createSession().load(ReportProcessEntry.class, l);
    }

    public List<ReportProcessEntry> listAllReportProcessEntry() throws Exception {
        return this.createSession().list(ReportProcessEntry.class);
    }

    public List<ReportProcessEntry> findReportProcessEntryByProcessType(long l) throws Exception {
        return this.createSession().listByFieldValue(ReportProcessEntry.class, "processType", (Object)l);
    }

    @Override
    protected Class getEntryClass() {
        return ReportProcessEntry.class;
    }

    @Override
    protected int getEntryType() {
        return 8;
    }
}

