/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.dao;

import com.fr.base.FRContext;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.AddColumn;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.DAOUtils;
import com.fr.data.dao.DataAccessObjectOperator;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CompanyRoleEntryPrivilege;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.CustomRoleEntryPrivilege;
import com.fr.fs.base.entity.HomePage;
import com.fr.fs.basic.DatabaseAdapterAttr;
import com.fr.fs.control.EntryPoolFactory;
import com.fr.fs.dao.PlatformJDBCDataAccessObjectOperator;
import com.fr.fs.dao.properties.PlatformJDBCDataAccessObjectProperties;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.stable.ArrayUtils;
import com.fr.stable.EnvChangedListener;
import com.fr.web.core.db.PlatformDB;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public class FSDAOManager {
    private static DataAccessObjectOperator manager = null;

    public static DataAccessObjectSession createSession() {
        return FSDAOManager.getJDBCDAOManager().startSession();
    }

    private static DataAccessObjectOperator getJDBCDAOManager() {
        if (manager == null) {
            FSDAOManager.refreshManager();
        }
        return manager;
    }

    private static synchronized void refreshManager() {
        PlatformJDBCDataAccessObjectProperties platformJDBCDataAccessObjectProperties = new PlatformJDBCDataAccessObjectProperties();
        manager = new PlatformJDBCDataAccessObjectOperator(platformJDBCDataAccessObjectProperties.createDatabaseConnection(), platformJDBCDataAccessObjectProperties.getAllObjTableMappers());
        try {
            manager.checkTables();
            Connection connection = PlatformDB.getDB().createConnection();
            DatabaseAdapterAttr databaseAdapterAttr = FSConfig.getProviderInstance().getDatabaseAdapterAttr();
            if (databaseAdapterAttr == null || !databaseAdapterAttr.isAdapted()) {
                FSDAOManager.dealWithJSRoleTable(connection);
                FSDAOManager.dealWithDepartmentTable(connection);
                FSDAOManager.dealWithUnAdaptedEntryTable4SortColumn(connection);
                FSDAOManager.dealWithRoleTable4SortColumn(connection);
                FSDAOManager.dealWithMobileConfigColumns(connection);
                FSDAOManager.dealWithHomePageColumns(connection);
            } else {
                FSDAOManager.dealWithAdaptedEntryTable4SortColumn(connection);
                FSDAOManager.dealWithAdaptedRoleTable4SortColumn(connection);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    private static void dealWithUnAdaptedEntryTable4SortColumn(Connection connection) {
        String[] stringArray = EntryPoolFactory.getEntryTableNames();
        FSDAOManager.dealWithEntryTable4SortColumn(connection, stringArray);
    }

    private static void dealWithEntryTable4SortColumn(Connection connection, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!FSDAOManager.shouldAddTableColumn(connection, string, "sortindex")) continue;
            FSDAOManager.addTableColumn4NewConnection(string, new Column("sortindex", -5, new ColumnSize(10)));
        }
    }

    private static void dealWithRoleTable4SortColumn(Connection connection) {
        String string = "FR_T_CUSTOMROLE";
        String[] stringArray = new String[]{string};
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!FSDAOManager.shouldAddTableColumn(connection, string2, "sortindex")) continue;
            FSDAOManager.addTableColumn4NewConnection(string2, new Column("sortindex", -5, new ColumnSize(10)));
        }
    }

    private static void dealWithAdaptedRoleTable4SortColumn(Connection connection) {
        FSDAOManager.dealWithRoleTable4SortColumn(connection);
    }

    private static void dealWithAdaptedEntryTable4SortColumn(Connection connection) {
        Object[] objectArray = new String[]{"FR_FOLDERENTRY", "FR_REPORTLETENTRY", "FR_FILEENTRY", "FR_URLENTRY", "FR_RPPE"};
        Object[] objectArray2 = EntryPoolFactory.getExtraEntryTableNames();
        String[] stringArray = (String[])ArrayUtils.addAll((Object[])objectArray, (Object[])objectArray2);
        FSDAOManager.dealWithEntryTable4SortColumn(connection, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTableColumn4NewConnection(String string, Column column) {
        Connection connection = null;
        try {
            connection = PlatformDB.getDB().createConnection();
            connection.setAutoCommit(false);
            Dialect dialect = DialectFactory.generateDialect((Connection)connection);
            FSDAOManager.addTableColumn(connection, dialect, column, string);
            connection.commit();
        }
        catch (Exception exception) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    FRContext.getLogger().error(sQLException.getMessage(), (Throwable)sQLException);
                }
            }
            FRContext.getLogger().error("Add" + string + "SortColumn Action Failed!");
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTableColumn(Connection connection, Dialect dialect, Column column, String string) throws SQLException {
        Table table = new Table(string);
        AddColumn addColumn = new AddColumn(table, column, dialect);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = addColumn.createPreparedStatement(connection);
            preparedStatement.execute();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean shouldAddTableColumn(Connection connection, String string, String string2) {
        Table table = new Table(string);
        Select select = new Select(table, DialectFactory.generateDialect((Connection)connection));
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int sQLException;
            preparedStatement = select.createPreparedStatement(connection);
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int bl = resultSetMetaData.getColumnCount();
            for (sQLException = 1; sQLException <= bl; ++sQLException) {
                if (!string2.equalsIgnoreCase(resultSetMetaData.getColumnName(sQLException))) continue;
                boolean bl2 = false;
                return bl2;
            }
            sQLException = 1;
            return sQLException != 0;
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().error("Check" + string + "SortColumn Action Failed!");
            FRContext.getLogger().error(sQLException.getMessage(), (Throwable)sQLException);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private static void dealWithJSRoleTable(Connection connection) {
        FSDAOManager.writeDataToNewTable(connection);
        FSDAOManager.deletJSRoleTable(connection);
        FSDAOManager.addPrivilegeTypeColumn(connection);
        FSDAOManager.writeModuleDataToNewTable(connection);
    }

    private static void dealWithDepartmentTable(Connection connection) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        String string = "FR_T_DEPARTMENT";
        Table table = new Table("INFORMATION_SCHEMA.SYSTEM_TABLE_CONSTRAINTS");
        Where where = new Where();
        where.addColumn("TABLE_NAME", (Object)string);
        where.addColumn("CONSTRAINT_TYPE", (Object)"UNIQUE");
        Select select = new Select(table, where, DialectFactory.generateDialect((Connection)connection));
        try {
            preparedStatement = select.createPreparedStatement(connection);
        }
        catch (SQLException sQLException) {
            return;
        }
        try {
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException2) {
                FRContext.getLogger().error(sQLException2.getMessage(), (Throwable)sQLException2);
            }
            return;
        }
        try {
            while (resultSet.next()) {
                String string2 = resultSet.getString("CONSTRAINT_NAME");
                Statement statement = connection.createStatement();
                statement.execute("ALTER TABLE " + string + " DROP CONSTRAINT " + string2);
            }
            DBUtils.closeResultSet((ResultSet)resultSet);
            DBUtils.closeStatement((Statement)preparedStatement);
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage());
        }
    }

    private static void addPrivilegeTypeColumn(Connection connection) {
        for (String string : CRoleEntryTableName.TABLENAMES) {
            String string2 = "view";
            if (FSDAOManager.shouldAddTableColumn(connection, string, string2)) {
                FSDAOManager.addTableColumn4NewConnection(string, new Column(string2, -5, new ColumnSize(10)));
                FSDAOManager.addTableColumn4NewConnection(string, new Column("authorized", -5, new ColumnSize(10)));
                FSDAOManager.addTableColumn4NewConnection(string, new Column("edit", -5, new ColumnSize(10)));
            }
            if (!FSDAOManager.shouldAddTableColumn(connection, string, string2 = "edit")) continue;
            FSDAOManager.addTableColumn4NewConnection(string, new Column("edit", -5, new ColumnSize(10)));
        }
    }

    private static void writeDataToNewTable(String string, Connection connection) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Table table = new Table(string);
        Select select = new Select(table, DialectFactory.generateDialect((Connection)connection));
        try {
            preparedStatement = select.createPreparedStatement(connection);
        }
        catch (SQLException sQLException) {
            return;
        }
        try {
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException2) {
                FRContext.getLogger().error(sQLException2.getMessage(), (Throwable)sQLException2);
            }
            return;
        }
        try {
            while (resultSet.next()) {
                FSDAOManager.dealWithTableName(string, resultSet, connection);
            }
            DBUtils.closeResultSet((ResultSet)resultSet);
            DBUtils.closeStatement((Statement)preparedStatement);
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage());
        }
    }

    private static void writeDataToNewTable(Connection connection) {
        for (int i = JSRoleTableName.JSROLETABLENAMES.length - 1; i >= 0; --i) {
            String string = JSRoleTableName.JSROLETABLENAMES[i];
            FSDAOManager.writeDataToNewTable(string, connection);
        }
    }

    private static void writeModuleDataToNewTable(Connection connection) {
        for (String string : CRoleModuleTableName.TABLENAMES) {
            FSDAOManager.writeDataToNewTable(string, connection);
        }
    }

    private static void dealWithTableName(String string, ResultSet resultSet, Connection connection) throws SQLException {
        if (ComparatorUtils.equals((String)string, (String)"FR_T_JROLE")) {
            CompanyRole companyRole = new CompanyRole(resultSet.getLong("postId"), resultSet.getLong("departmentId"), resultSet.getString("description"));
            companyRole.setId(resultSet.getLong("id"));
            manager.startSession().save((Object)companyRole);
        } else if (ComparatorUtils.equals((String)string, (String)"FR_T_SROLE")) {
            CustomRole customRole = new CustomRole(resultSet.getString("rolename"), resultSet.getString("description"));
            customRole.setId(resultSet.getLong("id"));
            manager.startSession().save((Object)customRole);
        } else if (ComparatorUtils.equals((String)string, (String)"FR_T_JROLEENTRYPRIVILEGE")) {
            CompanyRoleEntryPrivilege companyRoleEntryPrivilege = new CompanyRoleEntryPrivilege(resultSet.getLong("roleId"), resultSet.getInt("type"), resultSet.getLong("entryid"), 1L, 0L, 0L);
            companyRoleEntryPrivilege.setId(resultSet.getLong("id"));
            manager.startSession().save((Object)companyRoleEntryPrivilege);
        } else if (ComparatorUtils.equals((String)string, (String)"FR_T_SROLEENTRYPRIVILEGE")) {
            CustomRoleEntryPrivilege customRoleEntryPrivilege = new CustomRoleEntryPrivilege(resultSet.getLong("roleId"), resultSet.getInt("type"), resultSet.getLong("entryid"), 1L, 0L, 0L);
            customRoleEntryPrivilege.setId(resultSet.getLong("id"));
            manager.startSession().save((Object)customRoleEntryPrivilege);
        } else if (ComparatorUtils.equals((String)string, (String)"FR_T_JROLE_MODULE")) {
            long l = resultSet.getLong("id");
            long l2 = resultSet.getLong("jroleId");
            long l3 = resultSet.getLong("moduleId");
            Insert insert = new Insert(new Table("FR_T_COMPANYROLE_MODULE"));
            insert.addColumn("id", 4, (Object)new Long(l));
            insert.addColumn("companyroleId", 4, (Object)new Long(l2));
            insert.addColumn("moduleId", 4, (Object)new Long(l3));
            insert.execute(connection);
        } else if (ComparatorUtils.equals((String)string, (String)"FR_T_MODULE_SROLE")) {
            long l = resultSet.getLong("id");
            long l4 = resultSet.getLong("sroleId");
            long l5 = resultSet.getLong("moduleId");
            Insert insert = new Insert(new Table("FR_T_CUSTOMROLE_MODULE"));
            insert.addColumn("id", 4, (Object)new Long(l));
            insert.addColumn("customroleId", 4, (Object)new Long(l4));
            insert.addColumn("moduleId", 4, (Object)new Long(l5));
            insert.execute(connection);
        } else if (ComparatorUtils.equals((String)string, (String)"FR_T_SROLE_USER")) {
            long l = resultSet.getLong("id");
            long l6 = resultSet.getLong("sroleId");
            long l7 = resultSet.getLong("userId");
            Insert insert = new Insert(new Table("FR_T_CUSTOMROLE_USER"));
            insert.addColumn("id", 4, (Object)new Long(l));
            insert.addColumn("customroleId", 4, (Object)new Long(l6));
            insert.addColumn("userId", 4, (Object)new Long(l7));
            insert.execute(connection);
        } else if (ComparatorUtils.equals((String)string, (String)"FR_T_COMPANYROLE_MODULE")) {
            long l = resultSet.getLong("companyroleId");
            long l8 = resultSet.getLong("moduleid");
            Insert insert = new Insert(new Table("FR_T_CompanyRoleModulePrivilege"));
            insert.addColumn("roleid", -5, (Object)new Long(l));
            insert.addColumn("moduleid", -5, (Object)new Long(l8));
            insert.addColumn("view", -5, (Object)new Long(1L));
            insert.addColumn("authorized", -5, (Object)new Long(0L));
            insert.execute(connection);
        } else if (ComparatorUtils.equals((String)string, (String)"FR_T_CUSTOMROLE_MODULE")) {
            long l = resultSet.getLong("customroleId");
            long l9 = resultSet.getLong("moduleid");
            Insert insert = new Insert(new Table("FR_T_CustomRoleModulePrivilege"));
            insert.addColumn("roleid", -5, (Object)new Long(l));
            insert.addColumn("moduleid", -5, (Object)new Long(l9));
            insert.addColumn("view", -5, (Object)new Long(1L));
            insert.addColumn("authorized", -5, (Object)new Long(0L));
            insert.execute(connection);
        }
    }

    private static void deletJSRoleTable(Connection connection) {
        int n;
        String[] stringArray = new String[JSRoleTableName.JSROLETABLENAMES.length + 2];
        stringArray[0] = "FR_T_JROLE_PROCESSOB";
        stringArray[1] = "FR_T_PROCESSOB_SROLE";
        for (n = 2; n < JSRoleTableName.JSROLETABLENAMES.length + 2; ++n) {
            stringArray[n] = JSRoleTableName.JSROLETABLENAMES[n - 2];
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string = "drop table " + stringArray[n];
            try {
                Statement statement = connection.createStatement();
                statement.execute(string);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void dealWithMobileConfigColumns(Connection connection) {
        String[] stringArray = EntryPoolFactory.getMobileEntryTableNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (FSDAOManager.shouldAddTableColumn(connection, string, "mobileDeviceConfig")) {
                FSDAOManager.addTableColumn4NewConnection(string, new Column("mobileDeviceConfig", 4, new ColumnSize(10), (Object)7, true, false, false));
            }
            if (FSDAOManager.shouldAddTableColumn(connection, string, "parentDeviceConfig")) {
                FSDAOManager.addTableColumn4NewConnection(string, new Column("parentDeviceConfig", 4, new ColumnSize(10), (Object)7, true, false, false));
            }
            if (!FSDAOManager.shouldAddTableColumn(connection, string, "mobileCoverId")) continue;
            FSDAOManager.addTableColumn4NewConnection(string, new Column("mobileCoverId", 12, new ColumnSize(50), (Object)"a", true, false, false));
            String string2 = "UPDATE " + string + " SET " + "mobileCoverId" + " = CHAR(97 + FLOOR(RAND() * 26))";
            try {
                Statement statement = connection.createStatement();
                statement.execute(string2);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void dealWithHomePageColumns(Connection connection) {
        String string = "FR_T_" + DAOUtils.getClassNameWithOutPath(HomePage.class);
        if (FSDAOManager.shouldAddTableColumn(connection, string, "url4Pad")) {
            FSDAOManager.addTableColumn4NewConnection(string, new Column("url4Pad", 12, new ColumnSize(255)));
        }
        if (FSDAOManager.shouldAddTableColumn(connection, string, "url4Phone")) {
            FSDAOManager.addTableColumn4NewConnection(string, new Column("url4Phone", 12, new ColumnSize(255)));
        }
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                manager = null;
            }
        });
    }

    private static class MobileConfigColumns {
        public static final String MOBILEDEVICECONFIG = "mobileDeviceConfig";
        public static final int MOBILEDEVICECONFIGTYPE = 4;
        public static final String PARENTDEVICECONFIG = "parentDeviceConfig";
        public static final int PARENTDEVICECONFIGTYPE = 4;
        public static final String MOBILECOVERID = "mobileCoverId";
        public static final int MOBILECOVERIDTYPE = 12;

        private MobileConfigColumns() {
        }
    }

    private static class CRoleModuleTableName {
        public static final String[] TABLENAMES = new String[]{"FR_T_COMPANYROLE_MODULE", "FR_T_CUSTOMROLE_MODULE"};

        private CRoleModuleTableName() {
        }
    }

    private static class CRoleEntryTableName {
        public static final String[] TABLENAMES = new String[]{"FR_T_CompanyRoleEntryPrivilege", "FR_T_CustomRoleEntryPrivilege"};

        private CRoleEntryTableName() {
        }
    }

    private static class JSRoleTableName {
        public static final String[] JSROLETABLENAMES = new String[]{"FR_T_JROLEENTRYPRIVILEGE", "FR_T_SROLEENTRYPRIVILEGE", "FR_T_JROLE_MODULE", "FR_T_MODULE_SROLE", "FR_T_SROLE_USER", "FR_T_JROLE", "FR_T_SROLE"};

        private JSRoleTableName() {
        }
    }
}

