/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.data.dao.DAOException;
import com.fr.data.dao.DAOHashSet;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.DatabaseAction;
import com.fr.data.dao.RelationFCMapper;
import com.fr.data.dao.RelationObject;
import com.fr.data.dao.UniqueViolationException;
import com.fr.fs.PlateFactory;
import com.fr.fs.RoleCheckUtils;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.dao.RoleDAO;
import com.fr.fs.dao.PlatformDataAccessObject;
import com.fr.general.FRLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HSQLRoleDAO
extends PlatformDataAccessObject
implements RoleDAO {
    @Override
    public Set<RoleEntryPrivilege> getEntryPrivileges(long l) throws Exception {
        return this.getPrivileges(l, this.getEntryRelation());
    }

    @Override
    public Set<RoleDepAndCRolePrivilege> getDepAndCrolePrivileges(long l) throws Exception {
        return this.getPrivileges(l, this.getDepAndCroleRelation());
    }

    @Override
    public Set<RoleESPrivilege> getESPrivileges(long l) throws Exception {
        return this.getPrivileges(l, this.getESRelation());
    }

    @Override
    public Set<RoleModulePrivilege> getModulePrivileges(long l) throws Exception {
        return this.getPrivileges(l, this.getModuleRelation());
    }

    @Override
    public Set<RoleHomePagePrivilege> getHomePagePrivileges(long l) throws Exception {
        return this.getPrivileges(l, this.getHomePageRelation());
    }

    @Override
    public Set<RelationObject> getPrivilegesWithPlateName(long l, String string) throws Exception {
        return this.getPrivileges(l, this.getRelationFCMapperWithPlateName(string));
    }

    @Override
    public Set<RoleTemplatePrivilege> getTemplatePrivileges(long l) throws Exception {
        return this.getPrivileges(l, this.getTemplateRelation());
    }

    @Override
    public Set<RoleDataConnectionPrivilege> getDataConnectionPrivileges(long l) throws Exception {
        return this.getPrivileges(l, this.getDataConnectionRelation());
    }

    protected abstract RelationFCMapper getEntryRelation();

    protected abstract RelationFCMapper getESRelation();

    protected abstract RelationFCMapper getModuleRelation();

    protected abstract RelationFCMapper getHomePageRelation();

    protected abstract RelationFCMapper getTemplateRelation();

    protected abstract RelationFCMapper getDataConnectionRelation();

    protected abstract RelationFCMapper getDepAndCroleRelation();

    protected abstract RelationFCMapper getRelationFCMapperWithPlateName(String var1);

    protected abstract Class getRoleClass();

    protected abstract Class getRoleEntryPrivilegeClass();

    protected abstract Class getRoleESPrivilegeClass();

    protected abstract Class getRoleDepAndCrolePrivilegeClass();

    protected abstract Class getRoleModulePrivilegeClass();

    protected abstract Class getRoleHomePagePrivilegeClass();

    protected abstract Class getRoleTemplatePrivilegeClass();

    protected abstract Class getRoleDataConnectionPrivilegeClass();

    private Set getPrivileges(long l, RelationFCMapper relationFCMapper) throws Exception {
        if (l < 0L) {
            return null;
        }
        DataAccessObjectSession dataAccessObjectSession = this.createSession();
        DAOHashSet dAOHashSet = new DAOHashSet(dataAccessObjectSession, relationFCMapper, this.getRoleClass(), (Object)new Long(l));
        return dAOHashSet.toSet();
    }

    @Override
    public void updateDepAndCrolePrivilege(long l, List<String> list, List<String> list2) throws Exception {
        if (l < 0L) {
            return;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            Object object = dataAccessObjectSession.load(this.getRoleClass(), l);
            if (object == null) {
                throw new DAOException("The Role is not existed!");
            }
            this.removeDepAndCRolePrivilege(l, list2, dataAccessObjectSession);
            this.addDepAndCRolePrivilege(l, list, dataAccessObjectSession);
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    @Override
    public void updateEntryPrivileges(long l, List<EntryTypeAndID> list, List<EntryTypeAndID> list2) throws Exception {
        if (l < 0L) {
            return;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            EntryTypeAndID entryTypeAndID;
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            Object object = dataAccessObjectSession.load(this.getRoleClass(), l);
            if (object == null) {
                throw new DAOException("The Role is not existed!");
            }
            if (list2 != null) {
                Iterator<EntryTypeAndID> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    EntryTypeAndID entryTypeAndID2;
                    entryTypeAndID = entryTypeAndID2 = iterator.next();
                    HashMap<String, Number> hashMap = new HashMap<String, Number>(4);
                    hashMap.put("roleId", l);
                    hashMap.put("type", entryTypeAndID.getType());
                    hashMap.put("entryid", entryTypeAndID.getId());
                    dataAccessObjectSession.deleteByFields(this.getRoleEntryPrivilegeClass(), hashMap);
                }
            }
            if (list != null) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    entryTypeAndID = list.get(i);
                    RoleEntryPrivilege roleEntryPrivilege = (RoleEntryPrivilege)((Object)this.getRoleEntryPrivilegeClass().newInstance());
                    roleEntryPrivilege.setRoleId(l);
                    roleEntryPrivilege.setType(entryTypeAndID.getType());
                    roleEntryPrivilege.setEntryid(entryTypeAndID.getId());
                    roleEntryPrivilege.setView(entryTypeAndID.getView());
                    roleEntryPrivilege.setEdit(entryTypeAndID.getEdit());
                    roleEntryPrivilege.setAuthorized(entryTypeAndID.getAuthorized());
                    try {
                        dataAccessObjectSession.save((Object)roleEntryPrivilege);
                        continue;
                    }
                    catch (UniqueViolationException uniqueViolationException) {
                        // empty catch block
                    }
                }
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    @Override
    public void updateESPrivileges(long l, List<EntryTypeAndID> list, List<EntryTypeAndID> list2) throws Exception {
        if (l < 0L) {
            return;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            EntryTypeAndID entryTypeAndID;
            int n;
            int n2;
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            Object object = dataAccessObjectSession.load(this.getRoleClass(), l);
            if (object == null) {
                throw new DAOException("The Role is not existed!");
            }
            if (list2 != null) {
                n2 = list2.size();
                for (n = 0; n < n2; ++n) {
                    entryTypeAndID = list2.get(n);
                    HashMap<String, Number> hashMap = new HashMap<String, Number>(4);
                    hashMap.put("roleId", l);
                    hashMap.put("type", entryTypeAndID.getType());
                    hashMap.put("entryid", entryTypeAndID.getId());
                    dataAccessObjectSession.deleteByFields(this.getRoleESPrivilegeClass(), hashMap);
                }
            }
            if (list != null) {
                n2 = list.size();
                for (n = 0; n < n2; ++n) {
                    entryTypeAndID = list.get(n);
                    RoleESPrivilege roleESPrivilege = (RoleESPrivilege)((Object)this.getRoleESPrivilegeClass().newInstance());
                    roleESPrivilege.setRoleId(l);
                    roleESPrivilege.setType(entryTypeAndID.getType());
                    roleESPrivilege.setEntryID(entryTypeAndID.getId());
                    try {
                        dataAccessObjectSession.save((Object)roleESPrivilege);
                        continue;
                    }
                    catch (UniqueViolationException uniqueViolationException) {
                        // empty catch block
                    }
                }
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    @Override
    public void updateDataConnectionPrivileges(long l, List<String> list, List<String> list2) throws Exception {
        if (l < 0L) {
            return;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            Object object;
            String string;
            int n;
            int n2;
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            Object object2 = dataAccessObjectSession.load(this.getRoleClass(), l);
            if (object2 == null) {
                throw new DAOException("The Role is not existed!");
            }
            if (list2 != null) {
                n2 = list2.size();
                for (n = 0; n < n2; ++n) {
                    string = String.valueOf(list2.get(n));
                    object = new HashMap<String, Long>(4);
                    ((HashMap)object).put("roleId", l);
                    ((HashMap)object).put("name", string);
                    ((HashMap)object).put("view", 1);
                    dataAccessObjectSession.deleteByFields(this.getRoleDataConnectionPrivilegeClass(), (Map)object);
                }
            }
            if (list != null) {
                n2 = list.size();
                for (n = 0; n < n2; ++n) {
                    string = String.valueOf(list.get(n));
                    object = (RoleDataConnectionPrivilege)((Object)this.getRoleDataConnectionPrivilegeClass().newInstance());
                    ((RoleDataConnectionPrivilege)((Object)object)).setRoleId(l);
                    ((RoleDataConnectionPrivilege)((Object)object)).setName(string);
                    ((RoleDataConnectionPrivilege)((Object)object)).setView(1L);
                    try {
                        dataAccessObjectSession.save(object);
                        continue;
                    }
                    catch (UniqueViolationException uniqueViolationException) {
                        // empty catch block
                    }
                }
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    @Override
    public void updateTemplatePrivileges(long l, List<RoleTemplatePrivilege> list, List<RoleTemplatePrivilege> list2) throws Exception {
        this.updateTemplatePrivileges(l, this.getTemplateRelation(), list, list2);
    }

    @Override
    public void removeAllTemplatePrivileges() throws Exception {
        DataAccessObjectSession dataAccessObjectSession = this.createSession();
        dataAccessObjectSession.beginTransaction();
        dataAccessObjectSession.delete(this.getRoleTemplatePrivilegeClass());
        dataAccessObjectSession.commit();
        this.closeSession(dataAccessObjectSession);
    }

    @Override
    public void removeTemplatePrivileges(long l) throws Exception {
        DataAccessObjectSession dataAccessObjectSession = this.createDAOSession(l);
        HashMap<String, Long> hashMap = new HashMap<String, Long>(1);
        hashMap.put("roleId", l);
        dataAccessObjectSession.deleteByFields(this.getRoleTemplatePrivilegeClass(), hashMap);
        dataAccessObjectSession.commit();
        this.closeSession(dataAccessObjectSession);
    }

    @Override
    public void updateModulePrivileges(long l, List<RoleModulePrivilege> list, List<RoleModulePrivilege> list2) throws Exception {
        this.updateModulePrivileges(l, this.getModuleRelation(), list, list2);
    }

    @Override
    public void updateHomePagePrivileges(long l, List<RoleHomePagePrivilege> list, List<RoleHomePagePrivilege> list2) throws Exception {
        this.updateHomePagePrivileges(l, this.getHomePageRelation(), list, list2);
    }

    @Override
    public void updatePlatePrivileges(long l, List<RoleEntryPrivilege> list, List<RoleEntryPrivilege> list2, String string) throws Exception {
        this.updatePrivilegesWithPlateName(l, this.getRelationFCMapperWithPlateName(string), list, list2, string);
    }

    private void updateTemplatePrivileges(long l, RelationFCMapper relationFCMapper, List list, List list2) throws Exception {
        Object object;
        RoleTemplatePrivilege roleTemplatePrivilege;
        int n;
        int n2;
        DataAccessObjectSession dataAccessObjectSession = this.createDAOSession(l);
        if (dataAccessObjectSession == null) {
            return;
        }
        if (list2 != null) {
            n2 = list2.size();
            for (n = 0; n < n2; ++n) {
                roleTemplatePrivilege = (RoleTemplatePrivilege)((Object)list2.get(n));
                object = new HashMap<String, Long>(4);
                ((HashMap)object).put("roleId", l);
                ((HashMap)object).put("path", roleTemplatePrivilege.getPath());
                ((HashMap)object).put("page", roleTemplatePrivilege.getPage());
                ((HashMap)object).put("write", roleTemplatePrivilege.getWrite());
                ((HashMap)object).put("design", roleTemplatePrivilege.getDesign());
                dataAccessObjectSession.deleteByFields(this.getRoleTemplatePrivilegeClass(), (Map)object);
            }
        }
        if (list != null) {
            n2 = list.size();
            for (n = 0; n < n2; ++n) {
                roleTemplatePrivilege = (RoleTemplatePrivilege)((Object)list.get(n));
                object = (RoleTemplatePrivilege)((Object)this.getRoleTemplatePrivilegeClass().newInstance());
                ((RoleTemplatePrivilege)((Object)object)).setRoleId(l);
                ((RoleTemplatePrivilege)((Object)object)).setPath(roleTemplatePrivilege.getPath());
                ((RoleTemplatePrivilege)((Object)object)).setPage(roleTemplatePrivilege.getPage());
                ((RoleTemplatePrivilege)((Object)object)).setWrite(roleTemplatePrivilege.getWrite());
                ((RoleTemplatePrivilege)((Object)object)).setDesign(roleTemplatePrivilege.getDesign());
                try {
                    dataAccessObjectSession.save(object);
                    continue;
                }
                catch (UniqueViolationException uniqueViolationException) {
                    // empty catch block
                }
            }
        }
        dataAccessObjectSession.commit();
        this.closeSession(dataAccessObjectSession);
    }

    private void updateModulePrivileges(long l, RelationFCMapper relationFCMapper, List<RoleModulePrivilege> list, List<RoleModulePrivilege> list2) throws Exception {
        Object object;
        RoleModulePrivilege roleModulePrivilege;
        int n;
        int n2;
        DataAccessObjectSession dataAccessObjectSession = this.createDAOSession(l);
        if (dataAccessObjectSession == null) {
            return;
        }
        if (list2 != null) {
            n2 = list2.size();
            for (n = 0; n < n2; ++n) {
                roleModulePrivilege = list2.get(n);
                object = new HashMap<String, Long>(4);
                ((HashMap)object).put("roleid", l);
                ((HashMap)object).put("moduleid", roleModulePrivilege.getModuleid());
                ((HashMap)object).put("view", roleModulePrivilege.getView());
                ((HashMap)object).put("authorized", roleModulePrivilege.getAuthorized());
                dataAccessObjectSession.deleteByFields(this.getRoleModulePrivilegeClass(), (Map)object);
            }
        }
        if (list != null) {
            n2 = list.size();
            for (n = 0; n < n2; ++n) {
                roleModulePrivilege = list.get(n);
                object = (RoleModulePrivilege)((Object)this.getRoleModulePrivilegeClass().newInstance());
                ((RoleModulePrivilege)((Object)object)).setRoleId(l);
                ((RoleModulePrivilege)((Object)object)).setModuleid(roleModulePrivilege.getModuleid());
                ((RoleModulePrivilege)((Object)object)).setView(roleModulePrivilege.getView());
                ((RoleModulePrivilege)((Object)object)).setAuthorized(roleModulePrivilege.getAuthorized());
                try {
                    dataAccessObjectSession.save(object);
                    continue;
                }
                catch (UniqueViolationException uniqueViolationException) {
                    // empty catch block
                }
            }
        }
        dataAccessObjectSession.commit();
        this.closeSession(dataAccessObjectSession);
    }

    private void updateHomePagePrivileges(long l, RelationFCMapper relationFCMapper, List list, List list2) throws Exception {
        RoleHomePagePrivilege roleHomePagePrivilege;
        DataAccessObjectSession dataAccessObjectSession = this.createDAOSession(l);
        if (dataAccessObjectSession == null) {
            return;
        }
        if (list2 != null) {
            for (Object object : list2) {
                roleHomePagePrivilege = (RoleHomePagePrivilege)((Object)object);
                Object object2 = new HashMap(4);
                ((HashMap)object2).put((String)"roleid", l);
                ((HashMap)object2).put("homepageid", roleHomePagePrivilege.getHomePageId());
                ((HashMap)object2).put("view", roleHomePagePrivilege.getView());
                dataAccessObjectSession.deleteByFields(this.getRoleHomePagePrivilegeClass(), (Map)object2);
            }
        }
        if (list != null) {
            HashMap hashMap = new HashMap(2);
            for (Object object2 : list) {
                roleHomePagePrivilege = (RoleHomePagePrivilege)((Object)object2);
                RoleHomePagePrivilege roleHomePagePrivilege2 = (RoleHomePagePrivilege)((Object)this.getRoleHomePagePrivilegeClass().newInstance());
                roleHomePagePrivilege2.setRoleId(l);
                roleHomePagePrivilege2.setHomePageId(roleHomePagePrivilege.getHomePageId());
                roleHomePagePrivilege2.setView(roleHomePagePrivilege.getView());
                hashMap.put("roleid", l);
                hashMap.put("homepageid", roleHomePagePrivilege.getHomePageId());
                try {
                    dataAccessObjectSession.saveOrUpdateByFields((Object)roleHomePagePrivilege2, (Map)hashMap);
                }
                catch (UniqueViolationException uniqueViolationException) {}
            }
        }
        dataAccessObjectSession.commit();
        this.closeSession(dataAccessObjectSession);
    }

    private void updatePrivilegesWithPlateName(long l, RelationFCMapper relationFCMapper, List list, List list2, String string) throws Exception {
        int n;
        int n2;
        DataAccessObjectSession dataAccessObjectSession = this.createDAOSession(l);
        if (dataAccessObjectSession == null) {
            return;
        }
        DAOHashSet dAOHashSet = new DAOHashSet(dataAccessObjectSession, relationFCMapper, this.getRoleClass(), (Object)new Long(l));
        if (list != null) {
            n2 = list.size();
            for (n = 0; n < n2; ++n) {
                dAOHashSet.add(PlateFactory.createPrivilegeObject4Plate((Long)list.get(n), string));
            }
        }
        if (list2 != null) {
            n2 = list2.size();
            for (n = 0; n < n2; ++n) {
                dAOHashSet.remove(PlateFactory.createPrivilegeObject4Plate((Long)list2.get(n), string));
            }
        }
        dataAccessObjectSession.commit();
        this.closeSession(dataAccessObjectSession);
    }

    @Override
    public void transferEntryPrivileges(long l, Set<RoleEntryPrivilege> set) throws Exception {
        if (l < 0L) {
            return;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession(DatabaseAction.TRANSFER);
            dataAccessObjectSession.beginTransaction();
            Object object = dataAccessObjectSession.load(this.getRoleClass(), l);
            if (object == null) {
                throw new DAOException("The Role is not existed!");
            }
            if (set != null) {
                for (RoleEntryPrivilege roleEntryPrivilege : set) {
                    try {
                        dataAccessObjectSession.transfer((Object)roleEntryPrivilege);
                    }
                    catch (UniqueViolationException uniqueViolationException) {
                        FRLogger.getLogger().error(uniqueViolationException.getMessage());
                    }
                }
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    @Override
    public void transferModulePrivileges(long l, Set<RoleModulePrivilege> set) throws Exception {
        if (l < 0L) {
            return;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession(DatabaseAction.TRANSFER);
            dataAccessObjectSession.beginTransaction();
            Object object = dataAccessObjectSession.load(this.getRoleClass(), l);
            if (object == null) {
                throw new DAOException("The Role is not existed!");
            }
            if (set != null) {
                for (RoleModulePrivilege roleModulePrivilege : set) {
                    try {
                        dataAccessObjectSession.transfer((Object)roleModulePrivilege);
                    }
                    catch (UniqueViolationException uniqueViolationException) {
                        FRLogger.getLogger().error(uniqueViolationException.getMessage());
                    }
                }
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    @Override
    public void transferHomePagePrivileges(long l, Set<RoleHomePagePrivilege> set) throws Exception {
        if (l < 0L) {
            return;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession(DatabaseAction.TRANSFER);
            dataAccessObjectSession.beginTransaction();
            Object object = dataAccessObjectSession.load(this.getRoleClass(), l);
            if (object == null) {
                throw new DAOException("The Role is not existed!");
            }
            if (set != null) {
                for (RoleHomePagePrivilege roleHomePagePrivilege : set) {
                    try {
                        dataAccessObjectSession.transfer((Object)roleHomePagePrivilege);
                    }
                    catch (UniqueViolationException uniqueViolationException) {
                        FRLogger.getLogger().error(uniqueViolationException.getMessage());
                    }
                }
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    @Override
    public void transferRoleESPrivileges(long l, Set<RoleESPrivilege> set) throws Exception {
        if (l < 0L) {
            return;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession(DatabaseAction.TRANSFER);
            dataAccessObjectSession.beginTransaction();
            Object object = dataAccessObjectSession.load(this.getRoleClass(), l);
            if (object == null) {
                throw new DAOException("The Role is not existed!");
            }
            if (set != null) {
                for (RoleESPrivilege roleESPrivilege : set) {
                    try {
                        dataAccessObjectSession.transfer((Object)roleESPrivilege);
                    }
                    catch (UniqueViolationException uniqueViolationException) {
                        FRLogger.getLogger().error(uniqueViolationException.getMessage());
                    }
                }
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    @Override
    public void transferRoleDataConnectionPrivileges(long l, Set<RoleDataConnectionPrivilege> set) throws Exception {
        if (l < 0L) {
            return;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession(DatabaseAction.TRANSFER);
            dataAccessObjectSession.beginTransaction();
            Object object = dataAccessObjectSession.load(this.getRoleClass(), l);
            if (object == null) {
                throw new DAOException("The Role is not existed!");
            }
            if (set != null) {
                for (RoleDataConnectionPrivilege roleDataConnectionPrivilege : set) {
                    try {
                        dataAccessObjectSession.transfer((Object)roleDataConnectionPrivilege);
                    }
                    catch (UniqueViolationException uniqueViolationException) {
                        FRLogger.getLogger().error(uniqueViolationException.getMessage());
                    }
                }
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    @Override
    public void transferRoleTemplatePrivileges(long l, Set<RoleTemplatePrivilege> set) throws Exception {
        if (l < 0L) {
            return;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession(DatabaseAction.TRANSFER);
            dataAccessObjectSession.beginTransaction();
            Object object = dataAccessObjectSession.load(this.getRoleClass(), l);
            if (object == null) {
                throw new DAOException("The Role is not existed!");
            }
            if (set != null) {
                for (RoleTemplatePrivilege roleTemplatePrivilege : set) {
                    try {
                        dataAccessObjectSession.transfer((Object)roleTemplatePrivilege);
                    }
                    catch (UniqueViolationException uniqueViolationException) {
                        FRLogger.getLogger().error(uniqueViolationException.getMessage());
                    }
                }
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    @Override
    public void transferRoleDepAndCRolePrivileges(long l, Set<RoleDepAndCRolePrivilege> set) throws Exception {
        if (l < 0L) {
            return;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession(DatabaseAction.TRANSFER);
            dataAccessObjectSession.beginTransaction();
            Object object = dataAccessObjectSession.load(this.getRoleClass(), l);
            if (object == null) {
                throw new DAOException("The Role is not existed!");
            }
            if (set != null) {
                for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                    try {
                        dataAccessObjectSession.transfer((Object)roleDepAndCRolePrivilege);
                    }
                    catch (UniqueViolationException uniqueViolationException) {
                        FRLogger.getLogger().error(uniqueViolationException.getMessage());
                    }
                }
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    private DataAccessObjectSession createDAOSession(long l) throws Exception {
        if (RoleCheckUtils.isNotNormalID(l)) {
            return null;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            Object object = dataAccessObjectSession.load(this.getRoleClass(), l);
            if (object == null) {
                throw new DAOException("The Role is not existed!");
            }
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        return dataAccessObjectSession;
    }

    protected abstract void cache4Sort(long var1, int var3, long var4, long var6);

    public void sortByEntryID(int n, long[] lArray, DataAccessObjectSession dataAccessObjectSession) throws Exception {
        RoleEntryPrivilege roleEntryPrivilege;
        List list;
        int n2;
        if (lArray.length < 2) {
            return;
        }
        HashMap<RE, CRN> hashMap = new HashMap<RE, CRN>();
        for (n2 = 0; n2 < lArray.length - 1; ++n2) {
            list = this.findByEntryTypeAndID(n, lArray[n2], dataAccessObjectSession);
            if (list == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                roleEntryPrivilege = (RoleEntryPrivilege)((Object)list.get(i));
                hashMap.put(new RE(roleEntryPrivilege), new CRN(roleEntryPrivilege, lArray[n2 + 1]));
            }
        }
        list = this.findByEntryTypeAndID(n, lArray[lArray.length - 1], dataAccessObjectSession);
        if (list != null) {
            for (n2 = 0; n2 < list.size(); ++n2) {
                roleEntryPrivilege = (RoleEntryPrivilege)((Object)list.get(n2));
                hashMap.put(new RE(roleEntryPrivilege), new CRN(roleEntryPrivilege, lArray[0]));
            }
        }
        this.doSortByEntryID(hashMap, dataAccessObjectSession, n);
    }

    private void doSortByEntryID(Map map, DataAccessObjectSession dataAccessObjectSession, int n) {
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        ArrayList<RE> arrayList = new ArrayList<RE>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (arrayList.contains(entry.getKey())) continue;
            CRN cRN = null;
            CRN cRN2 = (CRN)entry.getValue();
            while (cRN2 != null) {
                cRN = cRN2;
                arrayList.add(new RE(cRN.rp));
                RE rE = new RE(cRN.rp);
                rE.entryid = cRN.newID;
                cRN2 = (CRN)map.get(rE);
                if (cRN2 == null || !arrayList.contains(rE)) continue;
                cRN2 = null;
            }
            cRN2 = (CRN)entry.getValue();
            long l = cRN2.rp.getEntryid();
            cRN.rp.setEntryid(cRN.newID);
            cRN.rp.setId(cRN2.rp.getId());
            if (!dataAccessObjectSession.saveOrUpdate((Object)cRN.rp)) continue;
            this.cache4Sort(cRN.rp.getRoleId(), n, l, cRN.newID);
        }
    }

    private void removeDepAndCRolePrivilege(long l, List<String> list, DataAccessObjectSession dataAccessObjectSession) {
        if (list != null) {
            for (String string : list) {
                HashMap<String, Long> hashMap = new HashMap<String, Long>(4);
                long l2 = 0L;
                if (string.startsWith("1")) {
                    hashMap.put("type", 1L);
                    l2 = new Long(string.substring(1));
                } else if (string.startsWith("2")) {
                    hashMap.put("type", 2L);
                    l2 = string.substring(1).startsWith("-") ? 0L - new Long(string.substring(2)) : new Long(string.substring(1));
                } else if (string.startsWith("-")) {
                    hashMap.put("type", 0L);
                    l2 = 0L - new Long(string.substring(1));
                }
                hashMap.put("roleid", l);
                hashMap.put("deporcroleid", l2);
                dataAccessObjectSession.deleteByFields(this.getRoleDepAndCrolePrivilegeClass(), hashMap);
            }
        }
    }

    private void addDepAndCRolePrivilege(long l, List<String> list, DataAccessObjectSession dataAccessObjectSession) throws InstantiationException, IllegalAccessException {
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                RoleDepAndCRolePrivilege roleDepAndCRolePrivilege = (RoleDepAndCRolePrivilege)((Object)this.getRoleDepAndCrolePrivilegeClass().newInstance());
                String string = list.get(i);
                roleDepAndCRolePrivilege.setRoleid(l);
                long l2 = 0L;
                if (string.startsWith("1")) {
                    roleDepAndCRolePrivilege.setType(1);
                    l2 = Long.parseLong(string.substring(1));
                } else if (string.startsWith("2")) {
                    roleDepAndCRolePrivilege.setType(2);
                    l2 = string.substring(1).startsWith("-") ? 0L - new Long(string.substring(2)) : new Long(string.substring(1));
                } else {
                    l2 = Long.parseLong(string);
                }
                roleDepAndCRolePrivilege.setDeporcroleid(l2);
                try {
                    dataAccessObjectSession.save((Object)roleDepAndCRolePrivilege);
                    continue;
                }
                catch (UniqueViolationException uniqueViolationException) {
                    // empty catch block
                }
            }
        }
    }

    protected List findByEntryTypeAndID(int n, long l, DataAccessObjectSession dataAccessObjectSession) {
        HashMap<String, Number> hashMap = new HashMap<String, Number>(2);
        hashMap.put("entryid", new Long(l));
        hashMap.put("type", new Integer(n));
        return dataAccessObjectSession.listByFieldValues(this.getRoleEntryPrivilegeClass(), hashMap);
    }

    protected static class CRN {
        private RoleEntryPrivilege rp;
        private long newID;

        protected CRN(RoleEntryPrivilege roleEntryPrivilege, long l) {
            this.rp = roleEntryPrivilege;
            this.newID = l;
        }
    }

    protected static class RE {
        private long roleid;
        private int type;
        private long entryid;

        protected RE(RoleEntryPrivilege roleEntryPrivilege) {
            this.roleid = roleEntryPrivilege.getRoleId();
            this.type = roleEntryPrivilege.getType();
            this.entryid = roleEntryPrivilege.getEntryid();
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (int)(this.entryid ^ this.entryid >>> 32);
            n2 = 31 * n2 + (int)(this.roleid ^ this.roleid >>> 32);
            n2 = 31 * n2 + this.type;
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            RE rE = (RE)object;
            if (this.entryid != rE.entryid) {
                return false;
            }
            if (this.roleid != rE.roleid) {
                return false;
            }
            return this.type == rE.type;
        }
    }
}

