/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.DatabaseAction;
import com.fr.fs.base.entity.Post;
import com.fr.fs.control.dao.PostDAO;
import com.fr.fs.dao.PlatformDataAccessObject;
import java.util.HashMap;
import java.util.List;

public class HSQLPostDAO
extends PlatformDataAccessObject
implements PostDAO {
    private static final String FIELD_POSTNAME = "postname";
    private static HSQLPostDAO SC;

    public static HSQLPostDAO getInstance() {
        if (SC == null) {
            SC = new HSQLPostDAO();
        }
        return SC;
    }

    private HSQLPostDAO() {
    }

    public void save(Post post) throws Exception {
        this.createSession().save((Object)post);
    }

    public void transfer(Post post) throws Exception {
        this.createSession(DatabaseAction.TRANSFER).transfer((Object)post);
    }

    public boolean delete(Post post) throws Exception {
        if (post == null) {
            return false;
        }
        return this.deleteByID(post.getId());
    }

    public boolean deleteByID(long l) throws Exception {
        if (l < 0L) {
            return false;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            dataAccessObjectSession.setForeignKeyChecks(0);
            boolean bl = dataAccessObjectSession.deleteByPrimaryKey(Post.class, l);
            dataAccessObjectSession.commit();
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            if (dataAccessObjectSession != null) {
                dataAccessObjectSession.setForeignKeyChecks(1);
            }
            this.closeSession(dataAccessObjectSession);
        }
    }

    public Post findByID(long l) throws Exception {
        return (Post)((Object)this.createSession().load(Post.class, l));
    }

    public List findAll() throws Exception {
        return this.createSession().list(Post.class);
    }

    public Post findByPostName(String string) throws Exception {
        List list = this.createSession().listByFieldValue(Post.class, FIELD_POSTNAME, (Object)string);
        if (!list.isEmpty()) {
            return (Post)((Object)list.get(0));
        }
        return null;
    }

    public boolean update(Post post) throws Exception {
        if (post == null) {
            return false;
        }
        if (this.findByID(post.getId()) == null) {
            return false;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>(1);
        hashMap.put("id", post.getId());
        return this.createSession().updateByFields((Object)post, hashMap);
    }
}

