/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.base.FRContext;
import com.fr.data.dao.DAOBean;
import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.FSContext;
import com.fr.fs.base.PlatformFunctionProcessor;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.FavoriteNode;
import com.fr.fs.base.entity.HomePage;
import com.fr.fs.base.entity.LoginUser;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.basic.SystemAttr;
import com.fr.fs.cache.UserCacheImpl;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.HomePageControl;
import com.fr.fs.control.LoginUserControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.control.dao.UserDAO;
import com.fr.fs.control.systemmanager.SystemManagerFavoriteAndADHOC;
import com.fr.fs.web.platform.entry.Entry;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.ExtraClassManager;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.providers.dao.PasswordValidator;
import com.fr.stable.CodeUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.file.XMLFileManagerProvider;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.web.Device;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserControl {
    private static UserControl uc;

    public static UserControl getInstance() {
        if (uc == null) {
            uc = new UserControl();
        }
        return uc;
    }

    public Set<Long> getUsersByJRoleID(long l) {
        return UserCacheImpl.getInstance().getUsersByJob(l);
    }

    public long getSuperManagerID() {
        return -999L;
    }

    public User getUser(String string, String string2) throws Exception {
        if (string != null && ComparatorUtils.equals((String)string, (String)PrivilegeManager.getProviderInstance().getRootManagerName())) {
            return string2 != null && UserControl.isRootManagerPasswordMatch(string2) ? this.getSysManagerUser() : null;
        }
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return FSConfig.getProviderInstance().getControl().getUserDAO().findByUserNameAndPassWord(string, string2);
    }

    public static boolean isRootManagerPasswordMatch(String string) {
        PasswordValidator passwordValidator = PrivilegeManager.getProviderInstance().getCustomPasswordValidatorProcessor();
        String string2 = PrivilegeManager.getProviderInstance().getRootManagerPassword();
        if (passwordValidator != null) {
            return passwordValidator.validatePassword(string2, string);
        }
        return ComparatorUtils.equals((String)string, (String)string2);
    }

    public User getByUserName(String string) throws Exception {
        if (string != null && ComparatorUtils.equals((String)string, (String)PrivilegeManager.getProviderInstance().getRootManagerName())) {
            return this.getSysManagerUser();
        }
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return FSConfig.getProviderInstance().getControl().getUserDAO().findByUserName(string);
    }

    public User getUser(long l) throws Exception {
        if (l == this.getSuperManagerID()) {
            return this.getSysManagerUser();
        }
        if (l < 0L) {
            return null;
        }
        return UserCacheImpl.getInstance().getUserById(l);
    }

    public User getUserByNameCacheFirst(String string) throws Exception {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        if (ComparatorUtils.equals((String)string, (String)PrivilegeManager.getProviderInstance().getRootManagerName())) {
            return this.getSysManagerUser();
        }
        return UserCacheImpl.getInstance().getUserByName(string);
    }

    public User getUserByMobile(String string) throws Exception {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return FSConfig.getProviderInstance().getControl().getUserDAO().findByMobile(string);
    }

    public Long getUser(String string) throws Exception {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        if (ComparatorUtils.equals((String)string, (String)PrivilegeManager.getProviderInstance().getRootManagerName())) {
            return this.getSuperManagerID();
        }
        User user = FSConfig.getProviderInstance().getControl().getUserDAO().findByUserName(string);
        return user == null ? -1L : user.getId();
    }

    public <T> T getOpenDAO(Class<? extends T> clazz) {
        return FSConfig.getProviderInstance().getControl().getOpenDAO(clazz);
    }

    public void login(long l) throws Exception {
        UserCacheImpl.getInstance().cache(l);
    }

    public void logout(long l) {
        UserCacheImpl.getInstance().removeCache(l);
    }

    public boolean addUser(User user) throws Exception {
        if (user == null || ComparatorUtils.equals((String)UserControl.getInstance().getSysManagerUser().getUsername(), (String)user.getUsername())) {
            return false;
        }
        user.setPassword(this.encodePassword(user.getPassword(), user.getUsername()));
        FSContext.setUsingFS();
        user.setId(-1L);
        FSConfig.getProviderInstance().getControl().getUserDAO().save(user);
        long l = user.getId();
        if (l >= 0L) {
            UserCacheImpl.getInstance().cache(l);
            UserCacheImpl.getInstance().addNoRoleUser(l);
        }
        return user.getId() >= 0L;
    }

    public boolean deleteUser(long l) throws Exception {
        if (l >= 0L) {
            String string = FSConfig.getProviderInstance().getControl().getUserDAO().findByID(l).getUsername();
            boolean bl = FSConfig.getProviderInstance().getControl().getUserDAO().deleteByID(l);
            if (bl) {
                LoginUserControl.deleteLoginUser(LoginUserControl.getLoginUser(string));
                try {
                    UserCacheImpl.getInstance().removeCache(l);
                }
                catch (Exception exception) {
                    UserCacheImpl.getInstance().removeAllCache();
                }
            }
            return bl;
        }
        return false;
    }

    public boolean updateUserAuthInfo(User user) throws Exception {
        boolean bl;
        long l = user.getId();
        String string = user.getUsername();
        String string2 = user.getPassword();
        String string3 = user.getRealname();
        String string4 = user.getEmail();
        String string5 = user.getMobile();
        if (this.isValidateUser(l, string, string3)) {
            return false;
        }
        UserDAO userDAO = FSConfig.getProviderInstance().getControl().getUserDAO();
        User user2 = userDAO.findByID(l);
        boolean bl2 = bl = !ComparatorUtils.equals((String)string, (String)user2.getUsername());
        if (bl) {
            this.updateLoginUserInfo(user2.getUsername(), string);
        }
        string2 = !bl && string2 == null ? user2.getPassword() : this.encodePassword(string2, string);
        return UserCacheImpl.getInstance().refreshCacheInfo(l, string, string2, string3, string5, string4);
    }

    private void updateLoginUserInfo(String string, String string2) throws Exception {
        if (LoginUserControl.hasLoginUser(string)) {
            LoginUser loginUser = LoginUserControl.getLoginUser(string);
            loginUser.setUsername(string2);
            LoginUserControl.saveOrUpdateLoginUser(loginUser);
        }
    }

    public boolean updateUserPersonalInfo(User user) throws Exception {
        if (user.getId() == UserControl.getInstance().getSuperManagerID()) {
            PrivilegeManager.getProviderInstance().setUserInfo(user.getRealname(), user.getBirthday(), user.isMale(), user.getMobile(), user.getWorkphone(), user.getEmail());
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)PrivilegeManager.getProviderInstance());
            return true;
        }
        if (user.getId() < 0L) {
            return false;
        }
        return FSConfig.getProviderInstance().getControl().getUserDAO().update(user.getId(), user.isMale(), user.getBirthday(), user.getMobile(), user.getEmail());
    }

    public boolean updatePassword(long l, String string, String string2) throws Exception {
        if (l == this.getSuperManagerID() && ComparatorUtils.equals((String)string, (String)PrivilegeManager.getProviderInstance().getRootManagerPassword())) {
            PrivilegeManager.getProviderInstance().setRootManagerPassword(string2);
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)PrivilegeManager.getProviderInstance());
            return true;
        }
        if (l < 0L) {
            return false;
        }
        User user = this.getUser(l);
        if (user != null) {
            String string3 = user.getUsername();
            String string4 = user.getPassword();
            String string5 = this.encodePassword(string, string3);
            if (this.isPass(string5, string, string4)) {
                string2 = FSConfig.getProviderInstance().getControl().getPv() == PasswordValidator.EMPTY_PASSWORD_VALIDATOR ? CodeUtils.customPasswordEncode((String)string2) : this.encodePassword(string2, string3);
                return FSConfig.getProviderInstance().getControl().getUserDAO().updatePassword(l, string2);
            }
            throw new RuntimeException("Password is not right!");
        }
        throw new RuntimeException("User not exist!");
    }

    private boolean isPass(String string, String string2, String string3) {
        return ComparatorUtils.equals((String)string, (String)string3) || ComparatorUtils.equals((String)CodeUtils.customPasswordEncode((String)string2), (String)string3) || ComparatorUtils.equals((String)string3, (String)string2);
    }

    public String encodePassword(String string) {
        if (string == null) {
            return null;
        }
        return FSConfig.getProviderInstance().getControl().getPv().encodePassword(string);
    }

    public String encodePassword(String string, String string2) {
        PasswordValidator passwordValidator = FSConfig.getProviderInstance().getControl().getPv();
        if (passwordValidator.shouldIgnoreUsername()) {
            if (string == null) {
                return null;
            }
            return passwordValidator.encodePassword(string);
        }
        if (string == null) {
            string = "123456";
        }
        return passwordValidator.encodePassword(string, string2);
    }

    public FArray getAllSRoleNames(long l) throws Exception {
        Set<CustomRole> set = this.getSRoles(l);
        FArray fArray = new FArray();
        if (set != null) {
            for (CustomRole customRole : set) {
                fArray.add((Object)customRole.getRolename());
            }
        }
        return fArray;
    }

    public List findAllUser() throws Exception {
        return FSConfig.getProviderInstance().getControl().getUserDAO().findAllSortByUserName();
    }

    public List findAllUserWithoutSort() throws Exception {
        return FSConfig.getProviderInstance().getControl().getUserDAO().findAll();
    }

    public JSONArray getAllMailUser(Boolean bl) throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = this.findAllUser();
        for (int i = 0; i < list.size(); ++i) {
            User user = (User)((Object)list.get(i));
            if (!StringUtils.isNotBlank((String)user.getEmail())) continue;
            JSONObject jSONObject = new JSONObject();
            if (bl.booleanValue()) {
                jSONObject.put("text", (Object)(user.getRealname() + "(" + user.getUsername() + ")"));
            } else {
                jSONObject.put("text", (Object)user.getUsername());
            }
            jSONObject.put("value", (Object)user.getEmail());
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray;
    }

    public JSONArray getAllMailUser() throws Exception {
        return this.getAllMailUser(false);
    }

    public List findAllAuthUser(long l) throws Exception {
        List list = this.findAllUser();
        if (l == this.getSuperManagerID()) {
            return list;
        }
        ArrayList<DAOBean> arrayList = new ArrayList<DAOBean>();
        if (list != null) {
            HashSet<User> hashSet = new HashSet<User>();
            Set set = this.getAllDepAndCRolePrivilege(l);
            for (DAOBean dAOBean : set) {
                hashSet.addAll(this.findAllRoleUsers((RoleDepAndCRolePrivilege)dAOBean));
            }
            hashSet.addAll(this.getNoRoleUsers());
            for (DAOBean dAOBean : list) {
                if (!hashSet.contains(dAOBean)) continue;
                arrayList.add(dAOBean);
            }
        }
        return arrayList;
    }

    protected Set<User> findAllRoleUsers(RoleDepAndCRolePrivilege roleDepAndCRolePrivilege) throws Exception {
        Set<User> set = new HashSet<User>();
        if (roleDepAndCRolePrivilege.getType() == 1) {
            Department department = DepartmentControl.getInstance().getDepartment(roleDepAndCRolePrivilege.getDeporcroleid());
            if (department != null) {
                set = DepartmentControl.getInstance().getUsers(department.getId());
            }
        } else if (roleDepAndCRolePrivilege.getType() == 2) {
            Set<RelationObject> set2 = CustomRoleControl.getInstance().getUsers(roleDepAndCRolePrivilege.getDeporcroleid(), true);
            for (RelationObject relationObject : set2) {
                User user = (User)((Object)relationObject.getValue(User.class));
                set.add(user);
            }
        }
        return set;
    }

    protected Set<User> getNoRoleUsers() throws Exception {
        return UserCacheImpl.getInstance().getNoRoleUsers();
    }

    public JSONArray getAllUserInfo4D() throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = this.findAllUser();
        HashMap<Object, HashSet<User>> hashMap = new HashMap<Object, HashSet<User>>(32);
        HashSet<User> hashSet = new HashSet<User>();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                User user = (User)((Object)list.get(i));
                if (user.getId() == this.getSuperManagerID()) continue;
                Set set = this.getJobs(user.getId());
                boolean bl = false;
                if (set != null) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        bl = true;
                        RelationObject relationObject = (RelationObject)iterator.next();
                        HashSet<User> hashSet2 = (HashSet<User>)hashMap.get(relationObject.getValue(Department.class));
                        if (hashSet2 == null) {
                            hashSet2 = new HashSet<User>();
                            hashMap.put(relationObject.getValue(Department.class), hashSet2);
                        }
                        hashSet2.add(user);
                    }
                }
                if (bl) continue;
                hashSet.add(user);
            }
        }
        this.dealWithDepartmentUser(jSONArray, hashMap);
        this.dealWithNoDepUser(jSONArray, hashSet);
        return jSONArray;
    }

    public Set getJobs(long l) throws Exception {
        if (l < 0L) {
            return null;
        }
        return FSConfig.getProviderInstance().getControl().getUserDAO().getJobSet(l);
    }

    public Set getDepartPostUsers(long l, long l2) throws Exception {
        if (l < 0L || l2 < 0L) {
            return null;
        }
        return FSConfig.getProviderInstance().getControl().getUserDAO().getUserSet(l, l2);
    }

    public String getCacheDepart(long l) throws Exception {
        if (l < 0L) {
            return null;
        }
        Set set = this.getJobs(l);
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            RelationObject relationObject = (RelationObject)iterator.next();
            return DepartmentControl.getInstance().getDepartmentShowName((Long)relationObject.getValue(Department.class));
        }
        return null;
    }

    public FArray getUserDP(long l) throws Exception {
        Set set = this.getJobs(l);
        if (set != null) {
            Iterator iterator = set.iterator();
            FArray fArray = new FArray();
            while (iterator.hasNext()) {
                String string;
                JSONObject jSONObject = new JSONObject();
                RelationObject relationObject = (RelationObject)iterator.next();
                String string2 = DepartmentControl.getInstance().getDepartmentShowName((Long)relationObject.getValue(Department.class), ",");
                if (string2 == null || (string = PostControl.getInstance().getPostName((Long)relationObject.getValue(Post.class))) == null) continue;
                fArray.add((Object)jSONObject.put("departments", (Object)string2).put("jobTitle", (Object)string));
            }
            return fArray.length() > 0 ? fArray : null;
        }
        return null;
    }

    public FArray getUserDPWithAllDepartment(long l) throws Exception {
        Set set = this.getJobs(l);
        if (set != null) {
            Iterator iterator = set.iterator();
            FArray fArray = new FArray();
            while (iterator.hasNext()) {
                RelationObject relationObject = (RelationObject)iterator.next();
                Long l2 = (Long)relationObject.getValue(Department.class);
                Long l3 = (Long)relationObject.getValue(Post.class);
                List<CompanyRole> list = CompanyRoleControl.getInstance().getJRole(l2, l3);
                if (list == null || list.isEmpty()) continue;
                for (CompanyRole companyRole : list) {
                    String string;
                    String string2 = DepartmentControl.getInstance().getDepartmentShowName(companyRole.getDepartmentId(), ",");
                    if (string2 == null || (string = PostControl.getInstance().getPostName(companyRole.getPostId())) == null) continue;
                    JSONObject jSONObject = new JSONObject();
                    fArray.add((Object)jSONObject.put("departments", (Object)string2).put("jobTitle", (Object)string));
                }
            }
            return fArray.length() > 0 ? fArray : null;
        }
        return null;
    }

    public long addDepartmentAndPost2User(long l, long l2, long l3) throws Exception {
        if (l < 0L) {
            return -1L;
        }
        RelationObject relationObject = RelationObject.getInstance((DAOBean[])new DAOBean[]{new Department(l2), new Post(l3)});
        if (FSConfig.getProviderInstance().getControl().getUserDAO().addJob(l, relationObject)) {
            try {
                UserCacheImpl.getInstance().cacheJob(l, l2, l3);
                UserCacheImpl.getInstance().removeNoRoleUser(l);
            }
            catch (Exception exception) {
                UserCacheImpl.getInstance().removeCache(l);
            }
            return relationObject.getId();
        }
        return -1L;
    }

    public boolean removeDepartmentAndPost2User(long l, long l2, long l3) throws Exception {
        if (l2 < 0L || l3 < 0L) {
            return false;
        }
        if (l >= 0L) {
            RelationObject relationObject = RelationObject.getInstance((DAOBean[])new DAOBean[]{new Department(l2), new Post(l3)});
            if (!FSConfig.getProviderInstance().getControl().getUserDAO().removeJob(l, relationObject)) {
                return false;
            }
            try {
                UserCacheImpl.getInstance().refreshCacheJob(l);
                UserCacheImpl.getInstance().checkAndAddNoRoleUser(l);
            }
            catch (Exception exception) {
                UserCacheImpl.getInstance().removeCache(l);
            }
            return true;
        }
        return false;
    }

    public boolean removeDepartmentAndPost2User(long l) throws Exception {
        if (l < 0L) {
            return false;
        }
        long l2 = FSConfig.getProviderInstance().getControl().getUserDAO().removeJob(l);
        if (l2 >= 0L) {
            try {
                UserCacheImpl.getInstance().refreshCacheJob(l2);
            }
            catch (Exception exception) {
                UserCacheImpl.getInstance().removeCache(l2);
            }
            return true;
        }
        return false;
    }

    public boolean updateDepartmentAndPost2User(long l, long l2, long l3) throws Exception {
        if (!this.isValidateDepUser(l, l2, l3)) {
            return false;
        }
        RelationObject relationObject = FSConfig.getProviderInstance().getControl().getUserDAO().updateJob(l, l2, l3);
        if (relationObject != null) {
            long l4 = (Long)relationObject.getValue(User.class);
            long l5 = (Long)relationObject.getValue(Department.class);
            if (l4 != l2) {
                try {
                    UserCacheImpl.getInstance().refreshCacheJob(l4);
                }
                catch (Exception exception) {
                    UserCacheImpl.getInstance().removeCache(l4);
                }
                try {
                    UserCacheImpl.getInstance().cacheJob(l2, l5, l3);
                }
                catch (Exception exception) {
                    UserCacheImpl.getInstance().removeCache(l2);
                }
            } else {
                try {
                    UserCacheImpl.getInstance().refreshCacheJob(l2);
                }
                catch (Exception exception) {
                    UserCacheImpl.getInstance().removeCache(l2);
                }
            }
            return true;
        }
        return false;
    }

    public Set<CustomRole> getSRoles(long l) throws Exception {
        Set<CustomRole> set = UserCacheImpl.getInstance().getSRoles(l);
        if (set == null) {
            return new HashSet<CustomRole>();
        }
        return set;
    }

    public boolean addSRole(long l, long l2) throws Exception {
        if (l < 0L) {
            return false;
        }
        CustomRole customRole = CustomRoleControl.getInstance().getCustomRole(l2);
        if (FSConfig.getProviderInstance().getControl().getUserDAO().addSRole(l, customRole)) {
            try {
                UserCacheImpl.getInstance().cacheSRole(l, customRole);
            }
            catch (Exception exception) {
                UserCacheImpl.getInstance().removeCache(l);
            }
            return true;
        }
        return false;
    }

    public boolean removeSRole(long l, long l2) throws Exception {
        if (l < 0L) {
            return false;
        }
        CustomRole customRole = CustomRoleControl.getInstance().getCustomRole(l2);
        if (FSConfig.getProviderInstance().getControl().getUserDAO().removeSRole(l, customRole)) {
            try {
                UserCacheImpl.getInstance().removeCacheSRole(l, customRole);
            }
            catch (Exception exception) {
                UserCacheImpl.getInstance().removeCache(l);
            }
            return true;
        }
        return false;
    }

    public Set getAllEntryPrivileges(long l) throws Exception {
        this.recordAuthFunc(l);
        return UserCacheImpl.getInstance().getAllEntryPrivileges(l);
    }

    public Set getAllTemplatePrivileges(long l) throws Exception {
        this.recordAuthFunc(l);
        return UserCacheImpl.getInstance().getAllTemplatePrivileges(l);
    }

    public JSONArray getAllDepAndCRoleInfo(long l) throws Exception {
        if (l == CustomRoleControl.getInstance().getSuperCustomRoleID()) {
            JSONArray jSONArray = CompanyRoleControl.getInstance().getAllCompanyRoleInfoWithDepAll();
            JSONArray jSONArray2 = CustomRoleControl.getInstance().getAllCustomRoleInfo();
            int n = jSONArray2.length();
            for (int i = 0; i < n; ++i) {
                jSONArray.put(jSONArray2.get(i));
            }
            return jSONArray;
        }
        JSONArray jSONArray = new JSONArray();
        Set set = this.getAllDepAndCRolePrivilege(l);
        for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
            int n;
            int n2;
            Object object;
            if (roleDepAndCRolePrivilege.getDeporcroleid() == -1L && roleDepAndCRolePrivilege.getType() == 0) {
                object = CompanyRoleControl.getInstance().getAllCompanyRoleInfo();
                n2 = object.length();
                for (n = 0; n < n2; ++n) {
                    jSONArray.put(object.get(n));
                }
                continue;
            }
            if (roleDepAndCRolePrivilege.getDeporcroleid() == -2L && roleDepAndCRolePrivilege.getType() == 0) {
                object = CustomRoleControl.getInstance().getAllCustomRoleInfo();
                n2 = object.length();
                for (n = 0; n < n2; ++n) {
                    jSONArray.put(object.get(n));
                }
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() == 1) {
                object = CompanyRoleControl.getInstance().getAllCompanyRole();
                n2 = object.size();
                for (n = 0; n < n2; ++n) {
                    CompanyRole companyRole = (CompanyRole)((Object)object.get(n));
                    if (companyRole.getDepartmentId() != roleDepAndCRolePrivilege.getDeporcroleid()) continue;
                    JSONObject jSONObject = companyRole.createJSONConfig();
                    String string = DepartmentControl.getInstance().getDepartmentShowName(companyRole.getDepartmentId(), ",");
                    String string2 = PostControl.getInstance().getPostName(companyRole.getPostId());
                    if (string == null || string2 == null) continue;
                    jSONObject.put("departmentname", (Object)string);
                    jSONObject.put("postname", (Object)string2);
                    jSONArray.put((Object)jSONObject);
                }
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() != 2 || (object = CustomRoleControl.getInstance().getCustomRole(roleDepAndCRolePrivilege.getDeporcroleid())) == null) continue;
            jSONArray.put((Object)((CustomRole)((Object)object)).createJSONConfig());
        }
        return jSONArray;
    }

    public Set getAllModulePrivileges(long l) throws Exception {
        return UserCacheImpl.getInstance().getAllModulePrivileges(l);
    }

    public Set<RoleHomePagePrivilege> getAllHomePagePrivileges(long l) throws Exception {
        this.recordAuthFunc(l);
        return UserCacheImpl.getInstance().getAllHomePagePrivileges(l);
    }

    public Set<RoleDataConnectionPrivilege> getAllDataConnectionPrivileges(long l) throws Exception {
        this.recordAuthFunc(l);
        return UserCacheImpl.getInstance().getAllDataConnectionPrivileges(l);
    }

    private void recordAuthFunc(long l) {
        if (l == UserControl.getInstance().getSuperManagerID()) {
            return;
        }
        FunctionProcessor functionProcessor = ExtraClassManager.getInstance().getFunctionProcessor();
        if (functionProcessor != null) {
            functionProcessor.recordFunction(PlatformFunctionProcessor.AUTHORITY_CONTROL);
        }
    }

    public Set<String> getAllDataConnectionPrivilegeNames(long l) throws Exception {
        Set<RoleDataConnectionPrivilege> set = UserCacheImpl.getInstance().getAllDataConnectionPrivileges(l);
        HashSet<String> hashSet = new HashSet<String>();
        for (RoleDataConnectionPrivilege roleDataConnectionPrivilege : set) {
            hashSet.add(roleDataConnectionPrivilege.getName());
        }
        return hashSet;
    }

    public boolean hasModulePrivilege(long l, long l2) {
        return UserCacheImpl.getInstance().containModulePrivilege(l, l2);
    }

    public boolean hasEntryPrivilege(long l, int n, long l2) {
        return UserCacheImpl.getInstance().containEntryPrivilege(l, n, l2);
    }

    public List getFavoriteNodes(long l) throws Exception {
        if (l == this.getSuperManagerID()) {
            return SystemManagerFavoriteAndADHOC.getInstance().findSysFavoriteNodes();
        }
        if (l < 0L) {
            return null;
        }
        return FSConfig.getProviderInstance().getControl().getFavoriteNodeDAO().findByUserID(l);
    }

    public JSONArray getFavoriteNodesInfo(long l, long l2) throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = this.getFavoriteNodes(l);
        if (list != null) {
            for (FavoriteNode favoriteNode : list) {
                JSONObject jSONObject;
                Entry entry = EntryControl.getInstance().getEntry(favoriteNode.getType(), favoriteNode.getEntryid());
                if (entry == null || !this.checkFavoriteNodeToAdd(jSONObject = entry.createJSONConfig(), l2)) continue;
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("id", favoriteNode.getId());
                jSONObject2.put("entry", (Object)jSONObject);
                jSONArray.put((Object)jSONObject2);
            }
        }
        return jSONArray;
    }

    private boolean checkFavoriteNodeToAdd(JSONObject jSONObject, long l) throws JSONException {
        boolean bl = true;
        if (jSONObject.has("mobileDeviceConfig")) {
            if ((jSONObject.getLong("mobileDeviceConfig") & jSONObject.getLong("parentDeviceConfig") & l) == 0L) {
                bl = false;
            }
        } else if ((1L & l) == 0L) {
            bl = false;
        }
        return bl;
    }

    public long addFavoriteNode(long l, int n, long l2) throws Exception {
        if (l == this.getSuperManagerID()) {
            FavoriteNode favoriteNode = new FavoriteNode(l, n, l2);
            SystemManagerFavoriteAndADHOC.getInstance().saveFavoriteNode(favoriteNode);
            return favoriteNode.getId();
        }
        if (l < 0L || l2 < 0L) {
            return -1L;
        }
        FavoriteNode favoriteNode = new FavoriteNode(l, n, l2);
        favoriteNode.setId(-1L);
        FSConfig.getProviderInstance().getControl().getFavoriteNodeDAO().save(favoriteNode);
        return favoriteNode.getId();
    }

    public boolean deleteFavoriteNode(long l, long l2) throws Exception {
        if (l == this.getSuperManagerID()) {
            return SystemManagerFavoriteAndADHOC.getInstance().deleteFavoriteNodeById(l2);
        }
        return FSConfig.getProviderInstance().getControl().getFavoriteNodeDAO().deleteByID(l2);
    }

    private User getSysManagerUser() {
        User user = new User(PrivilegeManager.getProviderInstance().getRootManagerName(), PrivilegeManager.getProviderInstance().getRootManagerPassword(), PrivilegeManager.getProviderInstance().getRootManagerRealname(), PrivilegeManager.getProviderInstance().getRootManagerBirthday(), PrivilegeManager.getProviderInstance().isRootManagerMale(), PrivilegeManager.getProviderInstance().getRootManagerMobile(), PrivilegeManager.getProviderInstance().getRootManagerWorkphone(), PrivilegeManager.getProviderInstance().getRootManagerEmail());
        user.setId(this.getSuperManagerID());
        return user;
    }

    private boolean hasUserPrivilege(Set<RoleDepAndCRolePrivilege> set, User user) throws Exception {
        long l = user.getId();
        for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
            Object object;
            if (roleDepAndCRolePrivilege.getType() == 1) {
                object = DepartmentControl.getInstance().getDepartment(roleDepAndCRolePrivilege.getDeporcroleid());
                if (object == null) continue;
                JSONArray jSONArray = DepartmentControl.getInstance().getUserAndPostsInfo(object.getId());
                int n = jSONArray.length();
                for (int i = 0; i < n; ++i) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i);
                    if (jSONObject.getLong("userid") != l) continue;
                    return true;
                }
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() != 2 || !(object = CustomRoleControl.getInstance().getUsersID(roleDepAndCRolePrivilege.getDeporcroleid())).contains(new Long(user.getId()))) continue;
            return true;
        }
        return false;
    }

    private boolean isNoDeptOrRoleUser(User user) throws Exception {
        Set<Long> set = this.getAllCompanyRoleIDs(user.getId());
        FArray fArray = this.getAllSRoleNames(user.getId());
        return set.isEmpty() && fArray.length() == 0;
    }

    private boolean isValidateUser(long l, String string, String string2) {
        return l < 0L || StringUtils.isBlank((String)string) || StringUtils.isBlank((String)string2);
    }

    public Set<Long> getAllCompanyRoleIDs(long l) throws Exception {
        return UserCacheImpl.getInstance().getAllCompanyRoleIDs(l);
    }

    private boolean isValidateDepUser(long l, long l2, long l3) {
        return l >= 0L && l2 >= 0L && l3 >= 0L;
    }

    private void dealWithDepartmentUser(JSONArray jSONArray, Map map) throws JSONException {
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("departmentname", (Object)DepartmentControl.getInstance().getDepartmentShowName((Long)entry.getKey()));
            Set set2 = (Set)entry.getValue();
            if (set2 != null) {
                JSONArray jSONArray2 = new JSONArray();
                jSONObject.put("users", (Object)jSONArray2);
                for (User user : set2) {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("id", user.getId());
                    jSONObject2.put("text", (Object)user.getUsername());
                    jSONArray2.put((Object)jSONObject2);
                }
            }
            jSONArray.put((Object)jSONObject);
        }
    }

    private Set getAllDepAndCRolePrivilege(long l) throws Exception {
        return UserCacheImpl.getInstance().getAllDepAndCRolePrivileges(l);
    }

    private void dealWithNoDepUser(JSONArray jSONArray, Set set) throws JSONException {
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("departmentname", (Object)Inter.getLocText((String)"FS-User-No_Department"));
            JSONArray jSONArray2 = new JSONArray();
            jSONObject.put("users", (Object)jSONArray2);
            while (iterator.hasNext()) {
                User user = (User)((Object)iterator.next());
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("id", user.getId());
                jSONObject2.put("text", (Object)user.getUsername());
                jSONArray2.put((Object)jSONObject2);
            }
            jSONArray.put((Object)jSONObject);
        }
    }

    public String getHomePageURL(long l, String string, Device device) throws Exception {
        SystemAttr systemAttr = FSConfig.getProviderInstance().getSystemAttr();
        String string2 = systemAttr.getHomePageURL(device);
        if (l != -999L) {
            long l2 = 0L;
            Set<RoleHomePagePrivilege> set = this.getAllHomePagePrivileges(l);
            for (RoleHomePagePrivilege roleHomePagePrivilege : set) {
                HomePage homePage = HomePageControl.getInstance().getHomePage(roleHomePagePrivilege.getHomePageId());
                if (homePage.getSortindex() <= l2) continue;
                l2 = homePage.getSortindex();
                string2 = homePage.getUrl(device);
            }
        }
        return this.dealWithUrl(string2, string, device);
    }

    private String dealWithUrl(String string, String string2, Device device) {
        if (device.isPC() && StringUtils.isEmpty((String)string)) {
            return "about:blank";
        }
        if (string == null) {
            return "";
        }
        if (StringUtils.isEmpty((String)string2)) {
            return string;
        }
        if (string.indexOf("?") > 0) {
            return string + "&fr_check_url=" + string2;
        }
        return string + "?fr_check_url=" + string2;
    }

    public Set getUserJobSetByUserId(long l) throws Exception {
        return FSConfig.getProviderInstance().getControl().getUserDAO().getJobSet(l);
    }

    public Set getUserRoleSetByUserId(long l) throws Exception {
        return FSConfig.getProviderInstance().getControl().getUserDAO().getSRoleSet(l);
    }

    public boolean update(long l, String string, String string2, String string3, String string4, String string5) throws Exception {
        FSConfig.getProviderInstance().getControl().getUserDAO().update(l, string, string2, string3, string4, string5);
        return UserCacheImpl.getInstance().refreshCacheInfo(l, string, string2, string3, string4, string5);
    }

    public void deleteSroleFromUser(long l, long l2) throws Exception {
        if (l < 0L) {
            return;
        }
        CustomRole customRole = CustomRoleControl.getInstance().getCustomRole(l2);
        if (FSConfig.getProviderInstance().getControl().getUserDAO().removeSRole(l, customRole)) {
            try {
                UserCacheImpl.getInstance().removeCacheSRole(l, customRole);
            }
            catch (Exception exception) {
                UserCacheImpl.getInstance().removeCache(l);
            }
        }
    }

    public void deleteDepartmentAndPostFromUser(long l, long l2, long l3) throws Exception {
        if (l < 0L) {
            return;
        }
        RelationObject relationObject = RelationObject.getInstance((DAOBean[])new DAOBean[]{new Department(l2), new Post(l3)});
        if (FSConfig.getProviderInstance().getControl().getUserDAO().removeJob(l, relationObject)) {
            try {
                UserCacheImpl.getInstance().refreshCacheJob(l);
                UserCacheImpl.getInstance().removeNoRoleUser(l);
            }
            catch (Exception exception) {
                UserCacheImpl.getInstance().removeCache(l);
            }
        }
    }
}

