/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.PlateFactory;
import com.fr.fs.RoleCheckUtils;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.RoleBean;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.CustomRoleCacheImpl;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.IDLockCreator;
import com.fr.fs.cache.UserCacheImpl;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.DepartmentControl;
import com.fr.fs.control.HomePageControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.PostControl;
import com.fr.fs.web.FSConstants;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomRoleControl {
    private final Object SORT_LOCK = new Object();
    private static CustomRoleControl sc;
    private final IDLockCreator sroleDaoIDLockCreator = new IDLockCreator();

    public static CustomRoleControl getInstance() {
        if (sc == null) {
            sc = new CustomRoleControl();
        }
        return sc;
    }

    public long getSuperCustomRoleID() {
        return -999L;
    }

    public String getSupperRoleName() {
        return "SUPERROLE";
    }

    public CustomRole getCustomRole(long l) throws Exception {
        if (l == this.getSuperCustomRoleID()) {
            CustomRole customRole = new CustomRole(l);
            customRole.setRolename(this.getSupperRoleName());
            customRole.setDescription(FSConstants.CUSTOMROLE.COMPATIABLE_SUPER_SROLE_NAME);
            return customRole;
        }
        return FSConfig.getProviderInstance().getControl().getCustomRoleDAO().findByID(l);
    }

    public Set<CustomRole> getCustomRoleSet(long l) throws Exception {
        HashSet<CustomRole> hashSet = new HashSet<CustomRole>();
        List<CustomRole> list = this.getAllCustomRole();
        for (CustomRole customRole : list) {
            if (!this.getUsersID(customRole.getId()).contains(l)) continue;
            hashSet.add(customRole);
        }
        return hashSet;
    }

    public boolean addCustomRole(CustomRole customRole) throws Exception {
        if (customRole == null) {
            return false;
        }
        customRole.setId(-1L);
        FSConfig.getProviderInstance().getControl().getCustomRoleDAO().save(customRole);
        try {
            CustomRoleCacheImpl.getInstance().cacheNew(customRole);
        }
        catch (Exception exception) {
            CustomRoleCacheImpl.getInstance().reInitCache();
            return false;
        }
        return true;
    }

    public List<CustomRole> getAllCustomRole() throws Exception {
        return CustomRoleCacheImpl.getInstance().getAllCustomRole();
    }

    public JSONArray getCustomRoleInfoPrivilege(long l) throws Exception {
        if (l == this.getSuperCustomRoleID()) {
            return this.getAllCustomRoleInfo();
        }
        JSONArray jSONArray = new JSONArray();
        Set<Object> set = new HashSet();
        try {
            set = UserCacheImpl.getInstance().getAllDepAndCRolePrivileges(l);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        List<CustomRole> list = this.getAllCustomRole();
        if (list != null) {
            int n = list.size();
            block2: for (int i = 0; i < n; ++i) {
                CustomRole customRole = list.get(i);
                for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
                    if (roleDepAndCRolePrivilege.getDeporcroleid() == -2L && roleDepAndCRolePrivilege.getType() == 0) {
                        return this.getAllCustomRoleInfo();
                    }
                    if (roleDepAndCRolePrivilege.getType() != 2 || customRole.getId() != roleDepAndCRolePrivilege.getDeporcroleid()) continue;
                    jSONArray.put((Object)customRole.createJSONConfig());
                    continue block2;
                }
            }
        }
        return jSONArray;
    }

    public JSONArray getAllCustomRoleInfo() throws Exception {
        JSONArray jSONArray = new JSONArray();
        List<CustomRole> list = this.getAllCustomRole();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                CustomRole customRole = list.get(i);
                jSONArray.put((Object)customRole.createJSONConfig());
            }
        }
        return jSONArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCustomRole(long l) throws Exception {
        boolean bl;
        if (l < 0L && l > -1000L) {
            return false;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        List<EntryTypeAndID> list = CustomRoleControl.getInstance().getAllEntryPrivileges(l);
        List<RoleModulePrivilege> list2 = CustomRoleControl.getInstance().getAllModulePrivileges(l);
        List<String> list3 = CustomRoleControl.getInstance().getAllDepAndCRolePrivilegeDescriptions(l);
        if (list.size() > 0) {
            CustomRoleControl.getInstance().updateEntryPrivileges(l, null, new HashSet<EntryTypeAndID>(list));
        }
        if (list2.size() > 0) {
            CustomRoleControl.getInstance().updateModulePrivileges(l, null, new HashSet<RoleModulePrivilege>(list2));
        }
        if (list3.size() > 0) {
            CustomRoleControl.getInstance().updateDepAndCRolePrivileges(l, null, new HashSet<String>(list3));
        }
        try {
            Object object2 = object;
            synchronized (object2) {
                bl = FSConfig.getProviderInstance().getControl().getCustomRoleDAO().deleteByID(l);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        if (bl) {
            try {
                CustomRoleCacheImpl.getInstance().removeCache(l);
            }
            catch (Exception exception) {
                CustomRoleCacheImpl.getInstance().reInitCache();
            }
            try {
                UserCacheImpl.getInstance().refreshAfterDelSRole(l);
            }
            catch (Exception exception) {
                UserCacheImpl.getInstance().removeAllCache();
            }
        }
        return bl;
    }

    public String getCustomRoleName(long l) {
        if (l == this.getSuperCustomRoleID()) {
            return this.getSupperRoleName();
        }
        return CustomRoleCacheImpl.getInstance().getSRoleName(l);
    }

    public boolean updateCustomRoleName(long l, String string) throws Exception {
        if (FSConfig.getProviderInstance().getControl().getCustomRoleDAO().updateRoleName(l, string)) {
            try {
                CustomRoleCacheImpl.getInstance().refreshCustomRoleName(l, string);
            }
            catch (Exception exception) {
                CustomRoleCacheImpl.getInstance().reInitCache();
            }
        }
        return false;
    }

    public CustomRole findByCustomRoleName(String string) throws Exception {
        return FSConfig.getProviderInstance().getControl().getCustomRoleDAO().findByRoleName(string);
    }

    public List<EntryTypeAndID> getAllEntryPrivileges(long l) {
        if (l == this.getSuperCustomRoleID()) {
            ArrayList<EntryTypeAndID> arrayList = new ArrayList<EntryTypeAndID>(1);
            arrayList.add(EntryTypeAndID.getInstance(0, -1L, 1L, 1L, 1L));
            return arrayList;
        }
        return CustomRoleCacheImpl.getInstance().getAllEntryPrivileges(l);
    }

    public List<JSONObject> getAllEntryPrivilegesJO(long l) {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        List<EntryTypeAndID> list = this.getAllEntryPrivileges(l);
        for (EntryTypeAndID entryTypeAndID : list) {
            try {
                arrayList.add(entryTypeAndID.toJSONObject());
            }
            catch (JSONException jSONException) {
                FRLogger.getLogger().error(jSONException.getMessage());
            }
        }
        return arrayList;
    }

    public List<String> getAllESPrivilegeDescriptions(long l) {
        if (l == this.getSuperCustomRoleID()) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add("0-1");
            return arrayList;
        }
        return CustomRoleCacheImpl.getInstance().getAllESPrivilegeDescriptions(l);
    }

    public List<EntryTypeAndID> getAllEntryPrivileges4Obj(long l) {
        if (l == this.getSuperCustomRoleID()) {
            ArrayList<EntryTypeAndID> arrayList = new ArrayList<EntryTypeAndID>(1);
            arrayList.add(EntryTypeAndID.getInstance(0, -1L, 1L, 1L, 1L));
            return arrayList;
        }
        return CustomRoleCacheImpl.getInstance().getAllEntryPrivileges(l);
    }

    public JSONArray getAllDepAndCRoleInfo(long l) throws Exception {
        if (l == this.getSuperCustomRoleID()) {
            JSONArray jSONArray = CompanyRoleControl.getInstance().getAllCompanyRoleInfo();
            JSONArray jSONArray2 = this.getAllCustomRoleInfo();
            int n = jSONArray2.length();
            for (int i = 0; i < n; ++i) {
                jSONArray.put(jSONArray2.get(i));
            }
            return jSONArray;
        }
        JSONArray jSONArray = new JSONArray();
        List<RoleDepAndCRolePrivilege> list = CustomRoleCacheImpl.getInstance().getAllDepAndCRolePrivileges(l);
        for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : list) {
            RoleBean roleBean;
            if (roleDepAndCRolePrivilege.getType() == 1) {
                roleBean = CompanyRoleControl.getInstance().getJRole(roleDepAndCRolePrivilege.getRoleid());
                JSONObject jSONObject = ((CompanyRole)roleBean).createJSONConfig();
                String string = DepartmentControl.getInstance().getDepartmentShowName(((CompanyRole)roleBean).getDepartmentId(), ",");
                String string2 = PostControl.getInstance().getPostName(((CompanyRole)roleBean).getPostId());
                if (string == null || string2 == null) continue;
                jSONObject.put("departmentname", (Object)string);
                jSONObject.put("postname", (Object)string2);
                jSONArray.put((Object)jSONObject);
                continue;
            }
            if (roleDepAndCRolePrivilege.getType() != 2) continue;
            roleBean = CustomRoleControl.getInstance().getCustomRole(roleDepAndCRolePrivilege.getRoleid());
            jSONArray.put((Object)((CustomRole)roleBean).createJSONConfig());
        }
        return jSONArray;
    }

    public List getAllModulePrivilegesJO(long l) {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        List<RoleModulePrivilege> list = this.getAllModulePrivileges(l);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(list.get(i).toJSONObject());
        }
        return arrayList;
    }

    public List<RoleDepAndCRolePrivilege> getAllDepAndCRolePrivileges(long l) {
        return CustomRoleCacheImpl.getInstance().getAllDepAndCRolePrivileges(l);
    }

    public List<String> getAllDepAndCRolePrivilegeDescriptions(long l) {
        return CustomRoleCacheImpl.getInstance().getAllDepAndCRolePrivilegeDescriptions(l);
    }

    public List getAllDepAndCRolePrivileges(long l, boolean bl) throws JSONException {
        return CustomRoleCacheImpl.getInstance().getAllDepAndCRolePrivileges(l, bl);
    }

    public Set<RoleDataConnectionPrivilege> getAllDataConnectionPrivileges(long l) {
        return CustomRoleCacheImpl.getInstance().getAllDataConnectionPrivileges(l);
    }

    public List<RoleTemplatePrivilege> getAllTemplatePrivileges(long l) {
        return CustomRoleCacheImpl.getInstance().getAllTemplatePrivileges(l);
    }

    public List<RoleModulePrivilege> getAllModulePrivileges(long l) {
        if (l == this.getSuperCustomRoleID()) {
            return ModuleControl.getInstance().getAllRoleModulePrivilege();
        }
        return CustomRoleCacheImpl.getInstance().getAllModulePrivileges(l);
    }

    public List<RoleHomePagePrivilege> getAllHomePagePrivileges(long l) {
        if (l == this.getSuperCustomRoleID()) {
            return HomePageControl.getInstance().getAllRoleHomePagePrivilege();
        }
        return CustomRoleCacheImpl.getInstance().getAllHomePagePrivileges(l);
    }

    public List<String> getAllPlatePrivileges(long l, String string) {
        if (l == this.getSuperCustomRoleID()) {
            return PlateFactory.getPlateByName(string).getAllPrivilegesID();
        }
        return CustomRoleCacheImpl.getInstance().getAllPrivilegesWithPlateName(l, string);
    }

    public boolean containModulePrivilege(long l, long l2) {
        if (l == this.getSuperCustomRoleID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        return CustomRoleCacheImpl.getInstance().containModulePrivilege(l, l2);
    }

    public boolean containHomPagePrivilege(long l, long l2) {
        if (l == this.getSuperCustomRoleID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        return CustomRoleCacheImpl.getInstance().containHomePagePrivilege(l, l2);
    }

    public boolean containPlatePrivilege(long l, long l2, String string) {
        if (l == this.getSuperCustomRoleID()) {
            return true;
        }
        if (l2 < 0L) {
            return false;
        }
        return CustomRoleCacheImpl.getInstance().containPlatePrivilege(l, l2, string);
    }

    public boolean containEntryPrivilege(long l, int n, long l2) {
        if (l == this.getSuperCustomRoleID()) {
            return true;
        }
        if (l2 < -1L) {
            return false;
        }
        return CustomRoleCacheImpl.getInstance().containEntryPrivilege(l, n, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModulePrivileges(long l, Set<RoleModulePrivilege> set, Set<RoleModulePrivilege> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<RoleModulePrivilege> arrayList = new ArrayList<RoleModulePrivilege>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<RoleModulePrivilege> arrayList2 = new ArrayList<RoleModulePrivilege>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCustomRoleDAO().updateModulePrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCacheImpl.getInstance().refreshModulePrivileges(l, FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getModulePrivileges(l));
        }
        catch (Exception exception) {
            CustomRoleCacheImpl.getInstance().reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHomePagePrivileges(long l, Set<RoleHomePagePrivilege> set, Set<RoleHomePagePrivilege> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<RoleHomePagePrivilege> arrayList = new ArrayList<RoleHomePagePrivilege>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<RoleHomePagePrivilege> arrayList2 = new ArrayList<RoleHomePagePrivilege>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCustomRoleDAO().updateHomePagePrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCacheImpl.getInstance().refreshHomePagePrivileges(l, FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getHomePagePrivileges(l));
        }
        catch (Exception exception) {
            CustomRoleCacheImpl.getInstance().reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDepAndCRolePrivileges(long l, Set<String> set, Set<String> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCustomRoleDAO().updateDepAndCrolePrivilege(l, arrayList, arrayList2);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCacheImpl.getInstance().refreshDepAndCRolePrivileges(l, FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getDepAndCrolePrivileges(l));
        }
        catch (Exception exception) {
            CustomRoleCacheImpl.getInstance().reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataConnectionPrivileges(long l, Set set, Set set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCustomRoleDAO().updateDataConnectionPrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCacheImpl.getInstance().refreshDataConnectionPrivileges(l, FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getDataConnectionPrivileges(l));
        }
        catch (Exception exception) {
            CustomRoleCacheImpl.getInstance().reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlatePrivileges(long l, Set set, Set set2, String string) throws Exception {
        if (RoleCheckUtils.isNotNormalID(l)) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<RoleEntryPrivilege> arrayList = new ArrayList<RoleEntryPrivilege>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<RoleEntryPrivilege> arrayList2 = new ArrayList<RoleEntryPrivilege>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCustomRoleDAO().updatePlatePrivileges(l, arrayList, arrayList2, string);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCacheImpl.getInstance().refreshPrivilegesWithPlateName(l, FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getPrivilegesWithPlateName(l, string), string);
        }
        catch (Exception exception) {
            CustomRoleCacheImpl.getInstance().reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntryPrivileges(long l, Set<EntryTypeAndID> set, Set<EntryTypeAndID> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<EntryTypeAndID> arrayList = new ArrayList<EntryTypeAndID>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<EntryTypeAndID> arrayList2 = new ArrayList<EntryTypeAndID>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCustomRoleDAO().updateEntryPrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCacheImpl.getInstance().refreshEntryPrivileges(l, FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getEntryPrivileges(l));
        }
        catch (Exception exception) {
            CustomRoleCacheImpl.getInstance().reInitCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTemplatePrivileges(long l, Set<RoleTemplatePrivilege> set, Set<RoleTemplatePrivilege> set2) throws Exception {
        if (l < 0L) {
            return;
        }
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<RoleTemplatePrivilege> arrayList = new ArrayList<RoleTemplatePrivilege>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<RoleTemplatePrivilege> arrayList2 = new ArrayList<RoleTemplatePrivilege>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCustomRoleDAO().updateTemplatePrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCacheImpl.getInstance().refreshTemplatePrivileges(l, FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getTemplatePrivileges(l));
        }
        catch (Exception exception) {
            CustomRoleCacheImpl.getInstance().reInitCache();
        }
    }

    public void removeAllTemplatePrivileges() throws Exception {
        FSConfig.getProviderInstance().getControl().getCustomRoleDAO().removeAllTemplatePrivileges();
    }

    public void removeTemplatePrivileges(long l) throws Exception {
        FSConfig.getProviderInstance().getControl().getCustomRoleDAO().removeTemplatePrivileges(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateESPrivileges(long l, Set<EntryTypeAndID> set, Set<EntryTypeAndID> set2) throws Exception {
        Object object = this.sroleDaoIDLockCreator.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                ArrayList<EntryTypeAndID> arrayList = new ArrayList<EntryTypeAndID>();
                if (set != null) {
                    arrayList.addAll(set);
                }
                ArrayList<EntryTypeAndID> arrayList2 = new ArrayList<EntryTypeAndID>();
                if (set2 != null) {
                    arrayList2.addAll(set2);
                }
                FSConfig.getProviderInstance().getControl().getCustomRoleDAO().updateESPrivileges(l, arrayList, arrayList2);
            }
        }
        finally {
            this.sroleDaoIDLockCreator.releaseIDLock();
        }
        try {
            CustomRoleCacheImpl.getInstance().refreshESPrivileges(l, FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getESPrivileges(l));
        }
        catch (Exception exception) {
            CustomRoleCacheImpl.getInstance().reInitCache();
        }
    }

    public Set getUsersID(long l) throws Exception {
        HashSet<Long> hashSet = new HashSet<Long>();
        Set<RelationObject> set = this.getUsers(l, true);
        if (set != null) {
            for (RelationObject relationObject : set) {
                User user = (User)((Object)relationObject.getValue(User.class));
                hashSet.add(new Long(user.getId()));
            }
        }
        return hashSet;
    }

    public Set<RelationObject> getUsers(long l, boolean bl) throws Exception {
        return FSConfig.getProviderInstance().getControl().getCustomRoleDAO().getUserSet(l, bl);
    }

    public JSONArray getUsersInfo(long l) throws Exception {
        JSONArray jSONArray = new JSONArray();
        Set<RelationObject> set = this.getUsers(l, true);
        if (set != null) {
            for (RelationObject relationObject : set) {
                User user = (User)((Object)relationObject.getValue(User.class));
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("userid", user.getId());
                jSONObject.put("text", (Object)user.getUsername());
                jSONArray.put((Object)jSONObject);
            }
        }
        return jSONArray;
    }

    public void addUsers(long l, long[] lArray) throws Exception {
        if (l < 0L || lArray == null) {
            return;
        }
        HashSet<User> hashSet = new HashSet<User>();
        for (int i = 0; i < lArray.length; ++i) {
            hashSet.add(new User(lArray[i]));
        }
        FSConfig.getProviderInstance().getControl().getCustomRoleDAO().addUsers(l, hashSet);
        UserCacheImpl.getInstance().refreshAfterAddSRole(lArray, l);
    }

    public void removeUsers(long l, long[] lArray) throws Exception {
        if (l < 0L || lArray == null) {
            return;
        }
        HashSet<User> hashSet = new HashSet<User>();
        for (int i = 0; i < lArray.length; ++i) {
            hashSet.add(new User(lArray[i]));
        }
        FSConfig.getProviderInstance().getControl().getCustomRoleDAO().removeUsers(l, hashSet);
        UserCacheImpl.getInstance().refreshAfterDelSRoleUser(lArray, l);
    }

    public boolean isUserInRole(long l, long l2) {
        return FSConfig.getProviderInstance().getControl().getCustomRoleDAO().isUserInRole(l, l2);
    }

    public void reset() {
        sc = null;
    }

    public void sortCustomRole(long l, int n) throws Exception {
        CustomRole customRole;
        if (l > 0L && n >= 0 && (customRole = CustomRoleControl.getInstance().getCustomRole(l)) != null) {
            this.sortCustomRoleOrder(customRole, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortCustomRoleOrder(CustomRole customRole, int n) throws Exception {
        Object object = this.SORT_LOCK;
        synchronized (object) {
            CustomRole[] customRoleArray = CustomRoleControl.getInstance().getAllSortedSRole();
            int n2 = customRoleArray.length;
            n = n2 - Math.min(n, n2);
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (customRoleArray[i].getId() != customRole.getId()) continue;
                for (n3 = i; n3 < n2 - 1; ++n3) {
                    customRoleArray[n3] = customRoleArray[n3 + 1];
                }
                for (n3 = n2 - 1; n3 > n; --n3) {
                    customRoleArray[n3] = customRoleArray[n3 - 1];
                }
                customRoleArray[n] = customRole;
                for (n3 = 0; n3 < n2; ++n3) {
                    customRoleArray[n3].setSortindex(n3 + 1);
                    if (!FSConfig.getProviderInstance().getControl().getCustomRoleDAO().update(customRoleArray[n3])) continue;
                    CustomRoleCacheImpl.getInstance().cacheUpdate(customRoleArray[n3]);
                }
            }
        }
    }

    public CustomRole[] getAllSortedSRole() {
        List<CustomRole> list;
        try {
            list = CustomRoleControl.getInstance().getAllCustomRole();
        }
        catch (Exception exception) {
            return new CustomRole[0];
        }
        CustomRole[] customRoleArray = list.toArray(new CustomRole[list.size()]);
        Arrays.sort(customRoleArray, RoleBean.RoleSORTComparator.getInstance());
        return customRoleArray;
    }

    public boolean resetSortIndex() {
        try {
            CustomRoleCacheImpl.getInstance().resetSortIndex();
            FSConfig.getProviderInstance().getControl().getCustomRoleDAO().resetSortIndex();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

