/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.comparator;

import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.User;
import com.fr.fs.base.entity.UserRelation;
import com.fr.fs.cache.DepartmentTreeNode;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONObject;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparatorHelper {
    public static final Comparator<User> USER_USERNAME_COMPARATOR = new Comparator<User>(){

        @Override
        public int compare(User user, User user2) {
            if (user == null || user2 == null) {
                return ComparatorHelper.compareIfHasNull((Object)user, (Object)user2);
            }
            return ComparatorUtils.compareCommonType((Object)user.getUsername(), (Object)user2.getUsername());
        }
    };
    public static final Comparator<User> USER_REALNAME_COMPARATOR = new Comparator<User>(){

        @Override
        public int compare(User user, User user2) {
            if (user == null || user2 == null) {
                return ComparatorHelper.compareIfHasNull((Object)user, (Object)user2);
            }
            return ComparatorUtils.compareCommonType((Object)user.getRealname(), (Object)user2.getRealname());
        }
    };
    public static final Comparator<UserRelation> USER_DEPART_COMPARATOR = new Comparator<UserRelation>(){

        @Override
        public int compare(UserRelation userRelation, UserRelation userRelation2) {
            if (userRelation == null || userRelation2 == null) {
                return ComparatorHelper.compareIfHasNull(userRelation, userRelation2);
            }
            int n = ComparatorUtils.compareCommonType((Object)userRelation.getDepart(), (Object)userRelation2.getDepart());
            if (n == 0) {
                return ComparatorHelper.compareByUsername(userRelation, userRelation2);
            }
            return n;
        }
    };
    public static final Comparator<UserRelation> USER_ROLE_COMPARATOR = new Comparator<UserRelation>(){

        @Override
        public int compare(UserRelation userRelation, UserRelation userRelation2) {
            if (userRelation == null || userRelation2 == null) {
                return ComparatorHelper.compareIfHasNull(userRelation, userRelation2);
            }
            int n = ComparatorUtils.compareCommonType((Object)userRelation.getRole(), (Object)userRelation2.getRole());
            if (n == 0) {
                return ComparatorHelper.compareByUsername(userRelation, userRelation2);
            }
            return n;
        }
    };
    public static final Comparator<User> USER_NAME_USERNAME_COMPARATOR = new Comparator<User>(){

        @Override
        public int compare(User user, User user2) {
            if (user == null || user2 == null) {
                return ComparatorHelper.compareIfHasNull((Object)user, (Object)user2);
            }
            int n = ComparatorUtils.compareCommonType((Object)user.getRealname(), (Object)user2.getRealname());
            return n == 0 ? ComparatorUtils.compareCommonType((Object)user.getUsername(), (Object)user2.getUsername()) : n;
        }
    };
    public static final Comparator<JSONObject> JSON_USER_RU_COMPARATOR = ComparatorHelper.createJSONComparator("realname", "username");
    public static final Comparator<JSONObject> JSON_USER_USERNAME_COMPARATOR = ComparatorHelper.createJSONComparator("username");
    public static final Comparator<JSONObject> JSON_USER_EMAIL_COMPARATOR = ComparatorHelper.createJSONComparator("text");
    public static final Comparator<DepartmentTreeNode> DEPART_NODE_COMPARATOR = new Comparator<DepartmentTreeNode>(){

        @Override
        public int compare(DepartmentTreeNode departmentTreeNode, DepartmentTreeNode departmentTreeNode2) {
            if (departmentTreeNode == null || departmentTreeNode2 == null) {
                return ComparatorHelper.compareIfHasNull(departmentTreeNode, departmentTreeNode2);
            }
            Department department = departmentTreeNode.getDepartment();
            Department department2 = departmentTreeNode2.getDepartment();
            if (department != null && department2 != null) {
                return ComparatorUtils.compareCommonType((Object)department.getName(), (Object)department2.getName());
            }
            return ComparatorHelper.compareIfHasNull((Object)department, (Object)department2);
        }
    };
    public static final Comparator<Post> POST_NAME_COMPARATOR = new Comparator<Post>(){

        @Override
        public int compare(Post post, Post post2) {
            if (post == null || post2 == null) {
                return ComparatorHelper.compareIfHasNull((Object)post, (Object)post2);
            }
            return ComparatorUtils.compareCommonType((Object)post.getPostname(), (Object)post2.getPostname());
        }
    };

    private static int compareByUsername(UserRelation userRelation, UserRelation userRelation2) {
        User user = userRelation.getUser();
        User user2 = userRelation2.getUser();
        if (user != null && user2 != null) {
            return ComparatorUtils.compareCommonType((Object)user.getUsername(), (Object)user2.getUsername());
        }
        return 0;
    }

    public static Comparator<JSONObject> createJSONComparator(final String string) {
        return new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject jSONObject, JSONObject jSONObject2) {
                if (jSONObject == null || jSONObject2 == null) {
                    return ComparatorHelper.compareIfHasNull(jSONObject, jSONObject2);
                }
                return ComparatorUtils.compareCommonType((Object)jSONObject.opt(string), (Object)jSONObject2.opt(string));
            }
        };
    }

    public static Comparator<JSONObject> createJSONComparator(final String string, final String string2) {
        return new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject jSONObject, JSONObject jSONObject2) {
                if (jSONObject == null || jSONObject2 == null) {
                    return ComparatorHelper.compareIfHasNull(jSONObject, jSONObject2);
                }
                int n = ComparatorUtils.compareCommonType((Object)jSONObject.opt(string), (Object)jSONObject2.opt(string));
                return n == 0 ? ComparatorUtils.compareCommonType((Object)jSONObject.opt(string2), (Object)jSONObject2.opt(string2)) : n;
            }
        };
    }

    private static int compareIfHasNull(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        return object == null ? -1 : 1;
    }
}

