/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.fs.base.entity.PlatformManageModule;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.cache.ModuleCache;
import com.fr.fs.cache.ModuleCacheProvider;
import com.fr.general.GeneralContext;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.EnvChangedListener;
import java.util.List;
import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleCacheImpl
implements ModuleCacheProvider {
    private static ModuleCacheProvider moduleCacheProvider;

    public static ModuleCacheProvider getInstance() {
        if (moduleCacheProvider == null) {
            ModuleCacheImpl.initCacheImpl();
        }
        return moduleCacheProvider;
    }

    private static synchronized void initCacheImpl() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                moduleCacheProvider = new ModuleCacheImpl();
                RPC.registerSkeleton((Object)moduleCacheProvider);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                moduleCacheProvider = (ModuleCacheProvider)RPC.getProxy(ModuleCacheImpl.class, (String)string);
                break;
            }
            default: {
                moduleCacheProvider = new ModuleCacheImpl();
            }
        }
    }

    @Override
    public void clearModuleCache() {
        ModuleCache.clearModuleCache();
    }

    @Override
    public void initCacheTree() throws Exception {
        ModuleCache.initCacheTree();
    }

    @Override
    public void reInit() throws Exception {
        ModuleCache.reInit();
    }

    @Override
    public JSONArray getModuleRootShowInfo(long l) throws Exception {
        return ModuleCache.getModuleRootShowInfo(l);
    }

    @Override
    public JSONArray getRootNodeInfo() throws JSONException {
        return ModuleCache.getRootNodeInfo();
    }

    @Override
    public JSONObject getNodeInfo(long l, long l2, Locale locale) throws Exception {
        return ModuleCache.getNodeInfo(l, l2, locale);
    }

    @Override
    public JSONArray getAuthorizedModuleItemsFromPrivilegeSet(Set<RoleModulePrivilege> set) throws JSONException {
        return ModuleCache.getAuthorizedModuleItemsFromPrivilegeSet(set);
    }

    @Override
    public List<PlatformManageModule> getAllModules() {
        return ModuleCache.getAllModules();
    }

    @Override
    public List<PlatformManageModule> getClonedAllModules() {
        return ModuleCache.getClonedAllModules();
    }

    @Override
    public List<PlatformManageModule> getAllModules(boolean bl) {
        return ModuleCache.getAllModules(bl);
    }

    @Override
    public void cache(PlatformManageModule platformManageModule) {
        ModuleCache.cache(platformManageModule);
    }

    @Override
    public void removeCache(long l) {
        ModuleCache.removeCache(l);
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                ModuleCacheImpl.moduleCacheProvider = null;
            }
        });
    }
}

