/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.fs.base.entity.LoginUser;
import com.fr.fs.cache.LoginUserCache;
import com.fr.fs.cache.LoginUserCacheProvider;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginUserCacheImpl
implements LoginUserCacheProvider {
    private static LoginUserCacheProvider loginUserCacheProvider;

    public static LoginUserCacheProvider getInstance() {
        if (loginUserCacheProvider == null) {
            LoginUserCacheImpl.initCacheImpl();
        }
        return loginUserCacheProvider;
    }

    private static synchronized void initCacheImpl() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                loginUserCacheProvider = new LoginUserCacheImpl();
                RPC.registerSkeleton((Object)loginUserCacheProvider);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                loginUserCacheProvider = (LoginUserCacheProvider)RPC.getProxy(LoginUserCacheImpl.class, (String)string);
                break;
            }
            default: {
                loginUserCacheProvider = new LoginUserCacheImpl();
            }
        }
    }

    @Override
    public void initLoginUserCache() throws Exception {
        LoginUserCache.initLoginUserCache();
    }

    @Override
    public void reInit() throws Exception {
        LoginUserCache.reInit();
    }

    @Override
    public boolean containCache(String string) {
        return LoginUserCache.containCache(string);
    }

    @Override
    public int getLoginUserCount() {
        return LoginUserCache.getLoginUserCount();
    }

    @Override
    public List<LoginUser> getAllLoginUserList() {
        return LoginUserCache.getAllLoginUserList();
    }

    @Override
    public List<LoginUser> getAllLoginUserListSorted() {
        return LoginUserCache.getAllLoginUserListSorted();
    }

    @Override
    public LoginUser getLoginUser(String string) {
        return LoginUserCache.getLoginUser(string);
    }

    @Override
    public void cache(LoginUser loginUser) {
        LoginUserCache.cache(loginUser);
    }

    @Override
    public void removeCache(String string) {
        LoginUserCache.removeCache(string);
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                LoginUserCacheImpl.loginUserCacheProvider = null;
            }
        });
    }
}

