/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.fs.base.entity.LoginUser;
import com.fr.fs.dao.properties.LoginUserDAO;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginUserCache {
    private static LoginUserDAO uDao = LoginUserDAO.getInstance();
    private static final Map<String, LoginUser> LOGIN_USER_MAP = new ConcurrentHashMap<String, LoginUser>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLoginUserCache() throws Exception {
        Map<String, LoginUser> map = LOGIN_USER_MAP;
        synchronized (map) {
            try {
                List<LoginUser> list = uDao.findAll();
                for (LoginUser loginUser : list) {
                    LOGIN_USER_MAP.put(loginUser.getUsername(), loginUser);
                }
            }
            catch (Exception exception) {
                LOGIN_USER_MAP.clear();
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reInit() throws Exception {
        Map<String, LoginUser> map = LOGIN_USER_MAP;
        synchronized (map) {
            LOGIN_USER_MAP.clear();
            LoginUserCache.initLoginUserCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containCache(String string) {
        Map<String, LoginUser> map = LOGIN_USER_MAP;
        synchronized (map) {
            return LOGIN_USER_MAP.get(string) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLoginUserCount() {
        Map<String, LoginUser> map = LOGIN_USER_MAP;
        synchronized (map) {
            return LOGIN_USER_MAP.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LoginUser> getAllLoginUserList() {
        Map<String, LoginUser> map = LOGIN_USER_MAP;
        synchronized (map) {
            Set<Map.Entry<String, LoginUser>> set = LOGIN_USER_MAP.entrySet();
            ArrayList<LoginUser> arrayList = new ArrayList<LoginUser>(LOGIN_USER_MAP.size());
            for (Map.Entry<String, LoginUser> entry : set) {
                arrayList.add(entry.getValue());
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LoginUser> getAllLoginUserListSorted() {
        Map<String, LoginUser> map = LOGIN_USER_MAP;
        synchronized (map) {
            Set<Map.Entry<String, LoginUser>> set = LOGIN_USER_MAP.entrySet();
            ArrayList<LoginUser> arrayList = new ArrayList<LoginUser>(LOGIN_USER_MAP.size());
            for (Map.Entry<String, LoginUser> entry : set) {
                arrayList.add(entry.getValue());
            }
            Collections.sort(arrayList, SORTINFOComparator.getInstance());
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginUser getLoginUser(String string) {
        Map<String, LoginUser> map = LOGIN_USER_MAP;
        synchronized (map) {
            return LOGIN_USER_MAP.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(LoginUser loginUser) {
        Map<String, LoginUser> map = LOGIN_USER_MAP;
        synchronized (map) {
            if (loginUser == null) {
                return;
            }
            LOGIN_USER_MAP.put(loginUser.getUsername(), loginUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCache(String string) {
        Map<String, LoginUser> map = LOGIN_USER_MAP;
        synchronized (map) {
            if (StringUtils.isEmpty((String)string)) {
                return;
            }
            LoginUser loginUser = LOGIN_USER_MAP.get(string);
            if (loginUser != null) {
                LOGIN_USER_MAP.remove(string);
            }
        }
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                LOGIN_USER_MAP.clear();
            }
        });
    }

    private static class SORTINFOComparator
    implements Comparator {
        private static SORTINFOComparator SC = new SORTINFOComparator();

        private SORTINFOComparator() {
        }

        public static SORTINFOComparator getInstance() {
            return SC;
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof LoginUser) || !(object2 instanceof LoginUser)) {
                return 0;
            }
            LoginUser loginUser = (LoginUser)((Object)object);
            LoginUser loginUser2 = (LoginUser)((Object)object2);
            return loginUser.getUsername().compareTo(loginUser2.getUsername());
        }
    }
}

