/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.auth;

import com.fr.fs.auth.AuthenticateObjectType;
import com.fr.privilege.Authentication;
import com.fr.privilege.providers.HttpAuthenticationProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class HttpAuthenticateObjectType
implements AuthenticateObjectType {
    private static final String XML_TAG = "HttpAuthenticateObjectType";
    private String httpUrl;

    public String getHttpUrl() {
        return this.httpUrl;
    }

    public void setHttpUrl(String string) {
        this.httpUrl = string;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && XML_TAG.equals(string = xMLableReader.getTagName())) {
            this.httpUrl = xMLableReader.getAttrAsString("httpUrl", null);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("httpUrl", this.httpUrl);
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean authentication(Authentication authentication) throws Exception {
        HttpAuthenticationProvider httpAuthenticationProvider = new HttpAuthenticationProvider();
        httpAuthenticationProvider.setUrl(this.httpUrl);
        return httpAuthenticationProvider.authenticate(authentication);
    }

    public boolean authenticationWithoutPassword() {
        return true;
    }

    public String markType() {
        return "http";
    }
}

