/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.auth;

import com.fr.general.LicChangedListener;
import com.fr.general.VT4FR;
import com.fr.json.JSONException;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizeAttr
implements XMLable {
    public static final String XML_TAG = "AuthorizeAttr";
    private static boolean supportMultiPrivilege = true;
    private boolean hasGradeAuth = supportMultiPrivilege;
    private boolean gradeAuthority = false;
    private boolean editReportAuthority = false;
    private boolean dataConnectionAuthority = false;

    public boolean hasMultiPrivilege() {
        return this.hasGradeAuth;
    }

    public boolean isGradeAuthority() {
        return this.hasMultiPrivilege() && this.gradeAuthority;
    }

    public void setGradeAuthority(boolean bl) {
        this.gradeAuthority = this.hasMultiPrivilege() && bl;
    }

    public boolean isEditReportAuthority() {
        return this.hasMultiPrivilege() && this.editReportAuthority;
    }

    public boolean isDataConnectionAuthority() {
        return this.dataConnectionAuthority;
    }

    public void setDataConnectionAuthority(boolean bl) {
        this.dataConnectionAuthority = bl;
    }

    public void setEditReportAuthority(boolean bl) {
        this.editReportAuthority = this.hasMultiPrivilege() && bl;
    }

    public void fillAttrToMap(Map<String, Object> map) throws JSONException {
        map.put("hasGradeAuthority", this.hasMultiPrivilege());
        map.put("gradeAuthority", this.isGradeAuthority());
        map.put("editReportAuthority", this.isEditReportAuthority());
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            this.setGradeAuthority(xMLableReader.getAttrAsBoolean("gradeAuthority", false));
            this.setEditReportAuthority(xMLableReader.getAttrAsBoolean("editReportAuthority", false));
            this.setDataConnectionAuthority(xMLableReader.getAttrAsBoolean("dataConnectionAuthority", false));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("gradeAuthority", this.gradeAuthority);
        xMLPrintWriter.attr("editReportAuthority", this.editReportAuthority);
        xMLPrintWriter.attr("dataConnectionAuthority", this.dataConnectionAuthority);
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static {
        supportMultiPrivilege = VT4FR.isLicAvailable((byte[])StableUtils.getBytes()) && VT4FR.MULTI_PRIVILEGE.support();
        VT4FR.addLicChangedListener((LicChangedListener)new LicChangedListener(){

            public void licChange() {
                supportMultiPrivilege = VT4FR.isLicAvailable((byte[])StableUtils.getBytes()) && VT4FR.MULTI_PRIVILEGE.support();
            }
        });
    }
}

