/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.web;

import com.fr.base.TemplateUtils;
import com.fr.base.chart.BaseChartCollection;
import com.fr.base.chart.ChartWebSource;
import com.fr.chart.chartattr.ChartCollection;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.js.ChartHyperlink;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.core.UUID;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;

public class ChartHyperPoplink
extends ChartHyperlink {
    private static final long serialVersionUID = 8024209654350751479L;
    private String chartDigTitle = "";
    private BaseChartCollection cc;
    private transient String ID = UUID.randomUUID().toString().replaceAll("-", "_");

    public void setChartDigTitle(String string) {
        this.chartDigTitle = string;
    }

    public String getChartDigTitle() {
        return this.chartDigTitle;
    }

    public String getChartOpCmd() {
        return "pop_chart";
    }

    public boolean isRealeted() {
        return false;
    }

    public void setChartCollection(BaseChartCollection baseChartCollection) {
        this.cc = baseChartCollection;
    }

    public BaseChartCollection getChartCollection() {
        return this.cc;
    }

    protected String actionJS(Repository repository) {
        HashMap<String, ChartHyperPoplink> hashMap = new HashMap<String, ChartHyperPoplink>();
        hashMap.put("ChartHyperlink_Value", this);
        String string = "ChartHyperlink__" + this.ID;
        ChartWebSource.putChartSource((String)repository.getSessionID(), (String)string, hashMap);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("chartCMD", this.getChartOpCmd());
        hashMap2.put("sourceID", string);
        try {
            hashMap2.put("data", this.createParaJSON(repository).toString());
        }
        catch (Exception exception) {
            FRLogger.getLogger().error("Error in Pop Chart Para");
        }
        hashMap2.put("successFunction", this.getSuccessFunction(repository));
        try {
            return TemplateUtils.renderParameter4Tpl((String)TemplateUtils.readTemplate2String((String)"/com/fr/chart/web/chartHyperlinkJS.tpl", (String)"UTF-8"), hashMap2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error("Error in HyperlinkJS.");
            return "";
        }
    }

    protected JSONObject createParaJSON(Repository repository) throws JSONException {
        JSONObject jSONObject = super.createParaJSON(repository);
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = jSONObject.get(string);
            if (object == null || !(object instanceof String)) continue;
            try {
                jSONObject.put(string, (Object)this.encodePrecentPlus((String)object));
            }
            catch (Exception exception) {
                FRLogger.getLogger().log(Level.INFO, exception.getMessage(), (Throwable)exception);
            }
        }
        return jSONObject;
    }

    private String encodePrecentPlus(String string) {
        if (string != null) {
            string = string.replace("+", "%2B");
            string = string.replace("%", "%25");
        }
        return string;
    }

    public JSONObject createJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.createJSONObject(repository);
        jSONObject.put("chartCMD", (Object)this.getChartOpCmd());
        HashMap<String, ChartHyperPoplink> hashMap = new HashMap<String, ChartHyperPoplink>();
        hashMap.put("ChartHyperlink_Value", this);
        String string = "ChartHyperlink__" + this.ID;
        ChartWebSource.putChartSource((String)repository.getSessionID(), (String)string, hashMap);
        jSONObject.put("ChartHyperlink_ID", (Object)string);
        jSONObject.put("sessionid", (Object)repository.getSessionID());
        return jSONObject;
    }

    protected String getHyperlinkType() {
        return "chartpop";
    }

    protected JSONObject createPara(Repository repository) throws JSONException {
        JSONObject jSONObject = JSONObject.create();
        this.putExtendParameters(repository, jSONObject, true);
        this.para2JSON(jSONObject, true);
        return jSONObject;
    }

    private String getSuccessFunction(Repository repository) {
        return "success:function(popIframeJS){(FR).showIframeDialog(popIframeJS)}";
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("PopChart")) {
            this.setChartDigTitle(xMLableReader.getAttrAsString("title", ""));
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode() && "ChartCollection".equals(xMLableReader.getTagName())) {
                        ChartHyperPoplink.this.setChartCollection((ChartCollection)((Object)xMLableReader.readXMLObject((XMLReadable)new ChartCollection())));
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("JavaScript").attr("class", ((Object)((Object)this)).getClass().getName());
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("PopChart").attr("title", this.getChartDigTitle());
        if (this.getChartCollection() != null) {
            xMLPrintWriter.startTAG("ChartCollection");
            this.getChartCollection().writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof ChartHyperPoplink && ComparatorUtils.equals((String)((ChartHyperPoplink)((Object)object)).getChartDigTitle(), (String)this.getChartDigTitle()) && ComparatorUtils.equals((Object)((ChartHyperPoplink)((Object)object)).getChartCollection(), (Object)this.getChartCollection());
    }
}

