/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4XY;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.Marker;
import com.fr.chart.chartglyph.MarkerGlyph;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class XYScatterPlotGlyph
extends RectanglePlotGlyph {
    private static final long serialVersionUID = 64495889773358205L;
    private static final double MARKER_SIZE = 5.0;
    private boolean isCurve = false;

    public void setCurve(boolean bl) {
        this.isCurve = bl;
    }

    public void layoutDataSeriesGlyph(int n) {
        int n2 = this.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            int n3 = this.calculateLineDataCount(dataSeries);
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n3];
            n3 = 0;
            GeneralPath generalPath = new GeneralPath();
            GeneralPath generalPath2 = new GeneralPath(1);
            boolean bl = true;
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                DataPoint4XY dataPoint4XY = (DataPoint4XY)dataSeries.getDataPoint(j);
                if (dataPoint4XY.isValueIsNull()) {
                    if (!this.isNullValueBreak()) continue;
                    bl = true;
                    continue;
                }
                float f = (float)this.getxAxisGlyph().getPoint2D(dataPoint4XY.getX()).getX();
                float f2 = (float)this.getStartY(dataPoint4XY);
                dArray[n3] = f;
                dArray2[n3] = f2;
                ++n3;
                bl = this.movePathAndMakeSureIsStartPoint(generalPath2, generalPath, bl, f, f2);
                this.makeSureGlyph4Draw(dataPoint4XY, f, f2);
                this.dealDataPointLabel(dataPoint4XY, n);
            }
            if (this.isCurve) {
                this.dealCurveLinePath(generalPath, generalPath2, dataSeries);
            } else {
                this.dealCommonLinePath(generalPath, dataSeries);
            }
            this.trendLineFitting(dArray, dArray2, dataSeries);
        }
        this.dealLabelBoundsInOrder();
    }

    protected double getStartY(DataPoint dataPoint) {
        AxisGlyph axisGlyph = this.getyAxisGlyph();
        if (axisGlyph == null) {
            return 0.0;
        }
        if (axisGlyph.getBounds() == null) {
            return axisGlyph.getPoint2D(dataPoint.getValue()).getY();
        }
        return axisGlyph.getBounds().getY() + axisGlyph.getPoint2D(dataPoint.getValue()).getY();
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n) {
        return this.getDataPointLabelBoundsWithPosition4Line(dimension2D, rectangle2D, n);
    }

    private int calculateLineDataCount(DataSeries dataSeries) {
        int n = 0;
        for (int i = 0; i < dataSeries.getDataPointCount(); ++i) {
            if (dataSeries.getDataPoint(i).isValueIsNull()) continue;
            ++n;
        }
        return n;
    }

    private boolean movePathAndMakeSureIsStartPoint(GeneralPath generalPath, GeneralPath generalPath2, boolean bl, float f, float f2) {
        if (this.isCurve) {
            if (bl) {
                ChartUtils.curveTo(generalPath2, generalPath);
                generalPath.reset();
                generalPath.moveTo(f, f2);
                generalPath2.moveTo(f, f2);
                bl = false;
            } else {
                generalPath.lineTo(f, f2);
            }
        } else if (bl) {
            generalPath2.moveTo(f, f2);
            bl = false;
        } else {
            generalPath2.lineTo(f, f2);
        }
        return bl;
    }

    private void makeSureGlyph4Draw(DataPoint dataPoint, float f, float f2) {
        MarkerGlyph markerGlyph = new MarkerGlyph(){

            protected boolean isNeedBorderBG() {
                return false;
            }
        };
        markerGlyph.dealCondition4Line(this.getConditionCollection(), dataPoint, this.createColors4Series());
        markerGlyph.setShape(new Rectangle2D.Double((double)f - 5.0, (double)f2 - 5.0, 10.0, 10.0));
        markerGlyph.getMarker().plotBackground = Marker.SCATTER_PLOT_BACKROUNG;
        dataPoint.setDrawImpl(markerGlyph);
    }

    public boolean equals(Object object) {
        return object instanceof XYScatterPlotGlyph && super.equals(object) && ((XYScatterPlotGlyph)object).isCurve == this.isCurve;
    }

    public Object clone() throws CloneNotSupportedException {
        XYScatterPlotGlyph xYScatterPlotGlyph = (XYScatterPlotGlyph)super.clone();
        return xYScatterPlotGlyph;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("isCurve", this.isCurve);
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return "XYScatterPlotGlyph";
    }

    public String getChartType() {
        return "Scatter";
    }
}

