/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.background.IntervalColorBackground;
import com.fr.chart.base.AttrAxisPosition;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.LineStyleInfo;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.ChartAlertValueGlyph;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSheet;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.FoldLine;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.ValueAxisGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.core.IteratorChain;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RectanglePlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = 5255907684426431466L;
    private static final double MIN_SECOND = 0.2;
    private static final double MAX_SECOND = 0.8;
    private AxisGlyph xAxisGlyph;
    private AxisGlyph yAxisGlyph;
    private AxisGlyph secondAxisGlyph;
    private boolean interactiveAxisTooltip = false;
    private Color horizontalIntervalBackgroundColor;
    private Color verticalIntervalBackgroundColor = null;

    public void setyAxisGlyph(AxisGlyph axisGlyph) {
        this.yAxisGlyph = axisGlyph;
    }

    public AxisGlyph getyAxisGlyph() {
        return this.yAxisGlyph;
    }

    public void setSecondAxisGlyph(AxisGlyph axisGlyph) {
        this.secondAxisGlyph = axisGlyph;
    }

    public AxisGlyph getSecondAxisGlyph() {
        return this.secondAxisGlyph;
    }

    public void setHorizontalIntervalBackgroundColor(Color color) {
        this.horizontalIntervalBackgroundColor = color;
    }

    public void setVerticalIntervalBackgroundColor(Color color) {
        this.verticalIntervalBackgroundColor = color;
    }

    public void setInteractiveAxisTooltip(boolean bl) {
        this.interactiveAxisTooltip = bl;
    }

    @Override
    public void layoutAxisGlyph(int n) {
        this.layoutDoubleAxisGlyph(this.getxAxisGlyph(), this.getyAxisGlyph(), this.getSecondAxisGlyph(), n);
    }

    protected void layoutDoubleAxisGlyph(AxisGlyph axisGlyph, AxisGlyph axisGlyph2, AxisGlyph axisGlyph3, int n) {
        Rectangle2D rectangle2D = this.getBounds();
        Rectangle2D rectangle2D2 = this.getBounds();
        this.initAxisGlyphBoundsAndZeroBounds(axisGlyph, rectangle2D);
        this.initAxisGlyphBoundsAndZeroBounds(axisGlyph2, rectangle2D);
        this.initAxisGlyphBoundsAndZeroBounds(axisGlyph3, rectangle2D);
        this.dealPlotBoundsWithAxisGlyph(axisGlyph, rectangle2D2, n);
        this.dealPlotBoundsWithAxisGlyph(axisGlyph2, rectangle2D2, n);
        this.dealPlotBoundsWithAxisGlyph(axisGlyph3, rectangle2D2, n);
        this.dealPlotBoundsWidthAxisInHorizontal(axisGlyph, rectangle2D2);
        this.dealPlotBoundsWidthAxisInHorizontal(axisGlyph2, rectangle2D2);
        this.dealPlotBoundsWidthAxisInHorizontal(axisGlyph3, rectangle2D2);
        this.calculateAxisGlyphAttr(axisGlyph, rectangle2D2);
        if (axisGlyph.isLabelWrap) {
            this.dealWithWrapPlotBounds(axisGlyph, rectangle2D2);
            this.calculateAxisGlyphAttr(axisGlyph, rectangle2D2);
        }
        this.calculateAxisGlyphAttr(axisGlyph2, rectangle2D2);
        this.calculateAxisGlyphAttr(axisGlyph3, rectangle2D2);
        this.dealSecondAxisGlyphWithZero(axisGlyph2, axisGlyph3);
        this.setBounds(rectangle2D2);
    }

    private void dealWithWrapPlotBounds(AxisGlyph axisGlyph, Rectangle2D rectangle2D) {
        double d = axisGlyph.dealWithPlotBounds();
        if (d <= 0.0) {
            return;
        }
        axisGlyph.calculateBoundsWidthOrientationAndTitle(rectangle2D, d, new Dimension(0, 0));
    }

    protected void initAxisGlyphBoundsAndZeroBounds(AxisGlyph axisGlyph, Rectangle2D rectangle2D) {
        if (axisGlyph != null) {
            axisGlyph.setBounds(rectangle2D);
            axisGlyph.setPlotZeroBounds(rectangle2D);
        }
    }

    protected void dealPlotBoundsWithAxisGlyph(AxisGlyph axisGlyph, Rectangle2D rectangle2D, int n) {
        if (axisGlyph != null) {
            axisGlyph.dealPlotBoundsWithAxisLabel(rectangle2D, n);
        }
    }

    protected void dealPlotBoundsWidthAxisInHorizontal(AxisGlyph axisGlyph, Rectangle2D rectangle2D) {
        if (axisGlyph != null) {
            axisGlyph.dealPlotBoundsWithLabelInHorizontal(rectangle2D);
        }
    }

    protected void calculateAxisGlyphAttr(AxisGlyph axisGlyph, Rectangle2D rectangle2D) {
        if (axisGlyph != null) {
            axisGlyph.calculateAxisGlyph(rectangle2D);
        }
    }

    private void dealSecondAxisGlyphWithZero(AxisGlyph axisGlyph, AxisGlyph axisGlyph2) {
        if (axisGlyph2 != null && ((ValueAxisGlyph)axisGlyph2).isAlignZeroValue()) {
            double d;
            Point2D point2D = axisGlyph.getPointInBounds(0.0);
            Point2D point2D2 = axisGlyph2.getPointInBounds(0.0);
            boolean bl = axisGlyph.getPosition() == 2 || axisGlyph.getPosition() == 4;
            double d2 = bl ? point2D.getY() : point2D.getX();
            double d3 = d = bl ? point2D2.getY() : point2D2.getX();
            if (d2 != d) {
                double d4;
                Rectangle2D rectangle2D = axisGlyph.getBounds();
                double d5 = d4 = bl ? rectangle2D.getHeight() : rectangle2D.getWidth();
                if (d2 > d4 * 0.2 && d2 < d4 * 0.8) {
                    this.dealAxisGlyphZeroPoint(axisGlyph2, bl, d2);
                } else {
                    this.dealAxisGlyphZeroPoint(axisGlyph, bl, (d2 + d) / 2.0);
                    this.dealAxisGlyphZeroPoint(axisGlyph2, bl, (d2 + d) / 2.0);
                }
            }
        }
    }

    private void dealAxisGlyphZeroPoint(AxisGlyph axisGlyph, boolean bl, double d) {
        if (axisGlyph == null) {
            return;
        }
        Rectangle2D rectangle2D = axisGlyph.getBounds();
        double d2 = bl ? rectangle2D.getHeight() : rectangle2D.getWidth();
        Point2D point2D = axisGlyph.getPointInBounds(0.0);
        double d3 = bl ? point2D.getY() : point2D.getX();
        double d4 = 1.0;
        if (d3 > d) {
            d4 = d / d3;
            Point2D point2D2 = axisGlyph.getOrigin();
            point2D2.setLocation(point2D2.getX(), d2 * d4);
        } else if (d3 < d) {
            d4 = (d2 - d) / (d2 - d3);
        }
        axisGlyph.setAxisLength(d2 * d4);
        axisGlyph.setUnitLen(axisGlyph.getUnitLen() * d4);
    }

    public AxisGlyph getSeriesAxisGlyph(int n) {
        AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, this.getSeries(n));
        ChartAxisPosition chartAxisPosition = attrAxisPosition.getAxisPosition();
        return ComparatorUtils.equals((Object)((Object)chartAxisPosition), (Object)((Object)ChartAxisPosition.AXIS_RIGHT)) ? this.getSecondAxisGlyph() : this.getyAxisGlyph();
    }

    @Override
    public double getPreLeft4DataSheet(int n) {
        double d = this.xAxisGlyph == null ? 0.0 : this.xAxisGlyph.getPreLeftWidth4DataSheet(n);
        double d2 = this.yAxisGlyph == null ? 0.0 : this.yAxisGlyph.getPreLeftWidth4DataSheet(n);
        double d3 = this.secondAxisGlyph == null ? 0.0 : this.secondAxisGlyph.getPreLeftWidth4DataSheet(n);
        return d + d2 + d3;
    }

    protected void dealCurveLinePath(GeneralPath generalPath, GeneralPath generalPath2, DataSeries dataSeries) {
        ChartUtils.curveTo(generalPath, generalPath2);
        this.dealLinePath(generalPath, dataSeries);
    }

    protected void dealCommonLinePath(GeneralPath generalPath, DataSeries dataSeries) {
        this.dealLinePath(generalPath, dataSeries);
    }

    protected DataSheetGlyph createSheetGlyphAndNotShowAxisGlyph(DataSheet dataSheet, LegendItem[] legendItemArray) {
        AxisGlyph axisGlyph = this.getxAxisGlyph();
        if (axisGlyph != null) {
            axisGlyph.notShowAllAttr();
        }
        DataSheetGlyph dataSheetGlyph = new DataSheetGlyph(this, legendItemArray);
        dataSheetGlyph.setFont(dataSheet.getFont());
        dataSheetGlyph.setFormat(dataSheet.getFormat());
        dataSheetGlyph.setGeneralInfo(dataSheet);
        return dataSheetGlyph;
    }

    private void dealLinePath(GeneralPath generalPath, DataSeries dataSeries) {
        FoldLine foldLine = new FoldLine(generalPath);
        dataSeries.setDrawImpl(foldLine);
        LineStyleInfo lineStyleInfo = foldLine.getLineStyleInfo();
        this.initCondition(lineStyleInfo, dataSeries);
    }

    private void initCondition(LineStyleInfo lineStyleInfo, DataSeries dataSeries) {
        this.getConditionCollection().changeStyleConditionWithInfo(lineStyleInfo, dataSeries, this.createColors4Series());
    }

    public void setxAxisGlyph(AxisGlyph axisGlyph) {
        this.xAxisGlyph = axisGlyph;
    }

    public AxisGlyph getxAxisGlyph() {
        return this.xAxisGlyph;
    }

    @Override
    public double getPreGap4AxisTopUnit() {
        return this.isAxisShowUnit(this.yAxisGlyph) || this.isAxisShowUnit(this.secondAxisGlyph) ? 18.0 : 0.0;
    }

    private boolean isAxisShowUnit(AxisGlyph axisGlyph) {
        return axisGlyph != null && axisGlyph.getShowUnit() != null;
    }

    @Override
    public double getPreGap4AxisRightUnit() {
        return this.xAxisGlyph != null && this.xAxisGlyph.getShowUnit() != null ? 18.0 : 0.0;
    }

    @Override
    public Iterator selectableChildren() {
        ArrayList<AxisGlyph> arrayList = new ArrayList<AxisGlyph>();
        if (this.getxAxisGlyph() != null) {
            arrayList.add(this.getxAxisGlyph());
        }
        if (this.getyAxisGlyph() != null) {
            arrayList.add(this.getyAxisGlyph());
        }
        if (this.getSecondAxisGlyph() != null) {
            arrayList.add(this.getSecondAxisGlyph());
        }
        ArrayList<ChartAlertValueGlyph> arrayList2 = new ArrayList<ChartAlertValueGlyph>();
        this.getAllAlertValueGlyph(arrayList2);
        ArrayList arrayList3 = new ArrayList();
        if (!arrayList2.isEmpty()) {
            arrayList3.add(arrayList2.iterator());
        }
        if (super.selectableChildren().hasNext()) {
            arrayList3.add(super.selectableChildren());
        }
        if (!arrayList.isEmpty()) {
            arrayList3.add(arrayList.iterator());
        }
        return new IteratorChain(arrayList3.toArray(new Iterator[0]));
    }

    private void getAllAlertValueGlyph(ArrayList<ChartAlertValueGlyph> arrayList) {
        AxisGlyph[] axisGlyphArray = new AxisGlyph[]{this.xAxisGlyph, this.yAxisGlyph, this.secondAxisGlyph};
        for (int i = 0; i < axisGlyphArray.length; ++i) {
            if (!(axisGlyphArray[i] instanceof ValueAxisGlyph)) continue;
            ValueAxisGlyph valueAxisGlyph = (ValueAxisGlyph)axisGlyphArray[i];
            ChartAlertValueGlyph[] chartAlertValueGlyphArray = valueAxisGlyph.getAlertValues();
            for (int j = 0; j < chartAlertValueGlyphArray.length; ++j) {
                arrayList.add(chartAlertValueGlyphArray[j]);
            }
        }
    }

    @Override
    public void draw(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawInfo(graphics);
        super.draw(graphics2D, n);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisGlyph(this.xAxisGlyph, graphics, n);
        this.drawAxisGlyph(this.yAxisGlyph, graphics, n);
        this.drawAxisGlyph(this.secondAxisGlyph, graphics, n);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    private void drawAxisGlyph(AxisGlyph axisGlyph, Graphics graphics, int n) {
        if (axisGlyph != null) {
            axisGlyph.draw(graphics, n);
        }
    }

    @Override
    public void drawInfo(Graphics graphics) {
        this.paint(graphics);
        this.paintXBackground(graphics);
        this.paintYBackground(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawBackgroundGrid(graphics);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    private void paintXBackground(Graphics graphics) {
        if (this.verticalIntervalBackgroundColor != null) {
            IntervalColorBackground intervalColorBackground = new IntervalColorBackground(this.verticalIntervalBackgroundColor, 3);
            intervalColorBackground.setIntervalLength(this.getVerticalIntervalLength());
            intervalColorBackground.paint(graphics, this.getOutline4Fill());
        }
    }

    private void paintYBackground(Graphics graphics) {
        if (this.horizontalIntervalBackgroundColor != null) {
            IntervalColorBackground intervalColorBackground = new IntervalColorBackground(this.horizontalIntervalBackgroundColor, 2);
            intervalColorBackground.setIntervalLength(this.getHorizontalIntervalLength());
            intervalColorBackground.paint(graphics, this.getOutline4Fill());
        }
    }

    private double getHorizontalIntervalLength() {
        if (this.xAxisGlyph.getPosition() == 3 || this.xAxisGlyph.getPosition() == 1) {
            return this.yAxisGlyph.getUnitLen() * this.yAxisGlyph.getMainUnit();
        }
        return this.xAxisGlyph.getUnitLen() * this.xAxisGlyph.getMainUnit();
    }

    private double getVerticalIntervalLength() {
        if (this.xAxisGlyph.getPosition() == 3 || this.xAxisGlyph.getPosition() == 1) {
            return this.xAxisGlyph.getUnitLen() * this.xAxisGlyph.getMainUnit();
        }
        return this.yAxisGlyph.getUnitLen() * this.yAxisGlyph.getMainUnit();
    }

    public void drawBackgroundGrid(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawAxisGrid(this.yAxisGlyph, graphics2D);
        this.drawAxisGrid(this.xAxisGlyph, graphics2D);
        this.drawAxisGrid(this.secondAxisGlyph, graphics2D);
    }

    private void drawAxisGrid(AxisGlyph axisGlyph, Graphics2D graphics2D) {
        if (axisGlyph == null) {
            return;
        }
        Rectangle2D rectangle2D = axisGlyph.getBounds();
        if (rectangle2D == null) {
            return;
        }
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        axisGlyph.drawAxisGrid(graphics2D);
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
    }

    @Override
    public boolean isZoom() {
        if (this.xAxisGlyph != null) {
            return this.xAxisGlyph.isZoom();
        }
        return false;
    }

    @Override
    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("interactiveAxisTooltip", this.interactiveAxisTooltip);
        if (this.horizontalIntervalBackgroundColor != null) {
            jSONObject.put("horizontalIntervalBackgroundColor", (Object)StableUtils.javaColorToCSSColor((Color)this.horizontalIntervalBackgroundColor));
        }
        if (this.verticalIntervalBackgroundColor != null) {
            jSONObject.put("verticalIntervalBackgroundColor", (Object)StableUtils.javaColorToCSSColor((Color)this.verticalIntervalBackgroundColor));
        }
        if (this.xAxisGlyph != null) {
            jSONObject.put("xAxisGlyphType", (Object)this.xAxisGlyph.getJSAxisType());
            jSONObject.put("xAxisGlyph", (Object)this.xAxisGlyph.toJSONObject(repository));
        }
        if (this.yAxisGlyph != null) {
            jSONObject.put("yAxisGlyphType", (Object)this.yAxisGlyph.getJSAxisType());
            jSONObject.put("yAxisGlyph", (Object)this.yAxisGlyph.toJSONObject(repository));
        }
        if (this.secondAxisGlyph != null) {
            jSONObject.put("secondAxisGlyphType", (Object)this.secondAxisGlyph.getJSAxisType());
            jSONObject.put("secondAxisGlyph", (Object)this.secondAxisGlyph.toJSONObject(repository));
        }
        return jSONObject;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof RectanglePlotGlyph && super.equals(object) && ComparatorUtils.equals((Object)((RectanglePlotGlyph)object).xAxisGlyph, (Object)this.xAxisGlyph) && ComparatorUtils.equals((Object)((RectanglePlotGlyph)object).secondAxisGlyph, (Object)this.secondAxisGlyph) && ComparatorUtils.equals((Object)((RectanglePlotGlyph)object).horizontalIntervalBackgroundColor, (Object)this.horizontalIntervalBackgroundColor) && ComparatorUtils.equals((Object)((RectanglePlotGlyph)object).yAxisGlyph, (Object)this.yAxisGlyph) && ((RectanglePlotGlyph)object).interactiveAxisTooltip == this.interactiveAxisTooltip;
    }
}

