/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.GraphHelper;
import com.fr.base.Utils;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.AxisHelper;
import com.fr.chart.chartglyph.NumberAxisGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class RadarAxisGlyph
extends NumberAxisGlyph {
    private static final long serialVersionUID = -2702639014404531055L;
    private static final double LABEL_WIDTH = 8.0;
    private static final double HEIGHT = 12.0;
    private static final double CIR_ANGLE = 360.0;
    private static final double ANGLE = 90.0;
    private double diameter = 0.0;
    private double radian = 0.0;
    private int categoryCount;
    private List labelList = new ArrayList();
    private boolean isAllMaxMin = true;
    private double[] radarMax = new double[]{100.0};
    private double[] radarMin = new double[0];

    public String getJSAxisType() {
        return "RadarAxisGlyph";
    }

    public String getAxisName() {
        return "RadarAxis";
    }

    public void setRadarMax(double[] dArray) {
        this.radarMax = dArray;
    }

    public void setRadarMin(double[] dArray) {
        this.radarMin = dArray;
    }

    public void setAllMaxMin(boolean bl) {
        this.isAllMaxMin = bl;
    }

    public void setCategoryCount(int n) {
        this.categoryCount = n;
    }

    public void setD(double d) {
        this.diameter = d;
    }

    public void setRadian(double d) {
        this.radian = d;
    }

    public Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        Line2D[] line2DArray = this.getAxisLines();
        for (int i = 0; i < line2DArray.length; ++i) {
            generalPath.append(line2DArray[i], false);
        }
        return generalPath;
    }

    public double getCrossValue() {
        return this.minValue;
    }

    public double getArrowValue() {
        return this.maxValue;
    }

    public void addCategoryLabel(Object object) {
        this.labelList.add(object);
    }

    public void init(Rectangle2D rectangle2D) {
        this.setBounds(rectangle2D);
        this.setOrigin(new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY()));
        this.setD(Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()));
        this.setRadian(Math.toRadians(360.0 / (double)this.categoryCount));
        this.setAxisLength(this.diameter / 2.0);
    }

    public void dealPlotBoundsWithAxisLabel(Rectangle2D rectangle2D, int n) {
        double d = 8.0;
        double d2 = 8.0;
        int n2 = this.labelList.size();
        for (int i = 0; i < n2; ++i) {
            String string = Utils.objectToString(this.labelList.get(i));
            double d3 = GlyphUtils.calculateTextDimensionWithRotation(string, new TextAttr(), n).getWidth();
            if (i < n2 / 2) {
                d = Math.max(d3, d);
                continue;
            }
            d2 = Math.max(d3, d2);
        }
        double d4 = 12.0;
        d = Math.max(d, d4);
        d2 = Math.max(d2, d4);
        rectangle2D.setRect(rectangle2D.getX() + d, rectangle2D.getY() + d4, rectangle2D.getWidth() - d - d2, rectangle2D.getHeight() - d4);
    }

    public void calculateAxisLengthUnit() {
        this.unitLength = this.axisLength / (this.getMaxValue() - this.getMinValue());
    }

    private double getCateMin(int n) {
        if (n >= 0 && this.radarMin != null && this.radarMin.length > n) {
            return this.radarMin[n];
        }
        return this.getCrossValue();
    }

    private double getCateMax(int n) {
        if (n >= 0 && this.radarMax.length > n) {
            return this.radarMax[n];
        }
        return this.getMaxValue();
    }

    protected double getMaxLabelWidthAndInitStartEndLabelDim(int n) {
        if (!this.isShowAxisLabel) {
            return 0.0;
        }
        double d = 8.0;
        for (int i = 0; i < this.categoryCount; ++i) {
            double d2;
            double d3 = this.getCateMin(i);
            BigDecimal bigDecimal = AxisHelper.calculateIncrement(d3, d2 = this.getCateMax(i));
            if (bigDecimal.doubleValue() <= 0.0) continue;
            BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d3));
            BigDecimal bigDecimal3 = bigDecimal;
            for (double d4 = d3; d4 <= d2; d4 += bigDecimal.doubleValue()) {
                double d5 = this.getAxisLabelWidth(this.value2String((bigDecimal2 = bigDecimal2.add(bigDecimal3)).doubleValue()), n);
                d = d5 < d ? d : d5;
            }
        }
        return d;
    }

    protected boolean shouldBeHeight() {
        TextAttr textAttr = this.getTextAttr();
        if (textAttr == null) {
            return false;
        }
        return textAttr.getAlignText() == 1;
    }

    public Point2D getPointInBounds(int n, double d) {
        double d2 = this.getCateMin(n);
        double d3 = this.getCateMax(n);
        if (d < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        return this.getPoint2D(n, d);
    }

    private Point2D getPoint2D(int n, double d) {
        double d2 = this.getCateMin(n);
        double d3 = this.getCateMax(n);
        double d4 = d - d2;
        double d5 = this.axisLength / (d3 - d2);
        return new Point2D.Double(this.originPoint.getX() + Math.cos(this.radian * (double)n + 1.5707963267948966) * d4 * d5, this.originPoint.getY() - Math.sin(this.radian * (double)n + 1.5707963267948966) * d4 * d5);
    }

    public void drawAxisGrid(Graphics graphics) {
        if (!this.isAllMaxMin) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getMainGridStyle() != 0 && this.getMainUnit() > 0.0 && this.getMainGridColor() != null) {
            Stroke stroke = graphics2D.getStroke();
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(this.getMainGridColor());
            graphics2D.setStroke(GraphHelper.getStroke((int)this.getMainGridStyle()));
            for (double d = this.getCrossValue(); d <= this.getMaxValue(); d += this.getMainUnit()) {
                Line2D[] line2DArray = this.getGridLine(d);
                for (int i = 0; i < line2DArray.length; ++i) {
                    graphics2D.draw(line2DArray[i]);
                }
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
    }

    public void paintRadarBackground(Graphics graphics, Color color) {
        if (!this.isAllMaxMin) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getMainUnit() > 0.0 && color != null) {
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(color);
            for (double d = this.getCrossValue(); d <= this.getMaxValue() - this.getMainUnit(); d += this.getMainUnit() * 2.0) {
                GeneralPath generalPath = this.getRadarPath(d, this.getMainUnit());
                graphics2D.fill(generalPath);
            }
            graphics2D.setPaint(paint);
        }
    }

    public Line2D[] getGridLine(double d) {
        Line2D[] line2DArray = new Line2D[this.categoryCount];
        for (int i = 0; i < this.categoryCount; ++i) {
            line2DArray[i] = i == this.categoryCount - 1 ? new Line2D.Double(this.getPoint2D(i, d), this.getPoint2D(0, d)) : new Line2D.Double(this.getPoint2D(i, d), this.getPoint2D(i + 1, d));
        }
        return line2DArray;
    }

    private GeneralPath getRadarPath(double d, double d2) {
        int n;
        GeneralPath generalPath = new GeneralPath(0);
        for (n = 0; n < this.categoryCount; ++n) {
            if (n == 0) {
                generalPath.moveTo((float)this.getPoint2D(n, d).getX(), (float)this.getPoint2D(n, d).getY());
            } else {
                generalPath.lineTo((float)this.getPoint2D(n, d).getX(), (float)this.getPoint2D(n, d).getY());
            }
            if (n != this.categoryCount - 1) continue;
            generalPath.lineTo((float)this.getPoint2D(0, d).getX(), (float)this.getPoint2D(0, d).getY());
        }
        for (n = 0; n < this.categoryCount; ++n) {
            generalPath.lineTo((float)this.getPoint2D(n, d + d2).getX(), (float)this.getPoint2D(n, d + d2).getY());
            if (n != this.categoryCount - 1) continue;
            generalPath.lineTo((float)this.getPoint2D(0, d + d2).getX(), (float)this.getPoint2D(0, d + d2).getY());
        }
        generalPath.closePath();
        return generalPath;
    }

    protected void drawAxisLine(Graphics graphics, int n) {
        if (this.getLineColor() == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        GeneralPath generalPath = new GeneralPath();
        Line2D[] line2DArray = this.getAxisLines();
        for (int i = 0; i < line2DArray.length; ++i) {
            graphics2D.setPaint(this.getLineColor());
            graphics2D.setStroke(GraphHelper.getStroke((int)this.getLineStyle()));
            graphics2D.draw(line2DArray[i]);
            this.drawArrow(graphics2D, line2DArray[i].getP1(), line2DArray[i].getP2());
            if (this.isArrowShow()) {
                this.drawCateLabel(graphics2D, i, line2DArray[i].getP2(), 16.0, generalPath, n);
                continue;
            }
            this.drawCateLabel(graphics2D, i, line2DArray[i].getP2(), 0.0, generalPath, n);
        }
        this.drawTicks(graphics2D, generalPath, n);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    protected void drawTicks(Graphics graphics, int n) {
    }

    protected void drawTicks(Graphics graphics, GeneralPath generalPath, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.lineColor);
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 0);
        for (int i = 0; i < this.categoryCount; ++i) {
            double d;
            int n2 = 0;
            n2 = this.getLabelNumber() > 0 ? this.getLabelNumber() : 1;
            double d2 = this.getCateMin(i);
            double d3 = this.getCateMax(i);
            BigDecimal bigDecimal = this.isCustomMainUnit() ? this.getBigDecimalMainUnit() : AxisHelper.calculateIncrement(d2, d3);
            double d4 = this.isCustomSecUnit() ? this.getSecUnit() : bigDecimal.doubleValue() / 5.0;
            BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d2));
            BigDecimal bigDecimal3 = bigDecimal;
            BigDecimal bigDecimal4 = new BigDecimal(Double.toString(n2));
            double d5 = this.checkDivUnit(graphics2D, n);
            for (d = d2; d <= d3; d += bigDecimal.doubleValue() * (double)n2) {
                if (i == 0 || !this.isAllMaxMin) {
                    this.drawTickLine(graphics2D, this.getTickLine(i, d, 5, this.getTickMarkType()), basicStroke);
                    this.drawFirstAxisLabel(graphics, i, bigDecimal2.doubleValue(), d5, generalPath, n);
                }
                bigDecimal2 = bigDecimal2.add(bigDecimal3.multiply(bigDecimal4));
            }
            for (d = d2 + d4; d <= d3; d += d4) {
                if (i != 0 && this.isAllMaxMin) continue;
                this.drawTickLine(graphics2D, this.getTickLine(i, d, 3, this.getSecTickMarkType()), basicStroke);
            }
        }
        graphics2D.setPaint(paint);
    }

    private double checkDivUnit(Graphics2D graphics2D, int n) {
        double d = 1.0;
        String string = this.getShowUnit();
        if (string != null) {
            d = AxisHelper.getDivideUnit(string);
            string = ChartConstants.getUnitKey2Value(string);
            TextGlyph textGlyph = new TextGlyph(Inter.getLocText((String)"Chart-Use_Unit") + ":" + string, new TextAttr());
            double d2 = this.bounds.getX();
            double d3 = this.bounds.getY();
            Dimension2D dimension2D = textGlyph.preferredDimension(n);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, dimension2D.getWidth(), dimension2D.getHeight());
            textGlyph.setBounds(double_);
            textGlyph.draw(graphics2D, n);
        }
        return d;
    }

    private void drawCateLabel(Graphics graphics, int n, Point2D point2D, double d, GeneralPath generalPath, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        String string = this.labelList.get(n).toString();
        Point2D.Double double_ = new Point2D.Double(point2D.getX() + Math.cos(this.radian * (double)n + 1.5707963267948966) * d, point2D.getY() - Math.sin(this.radian * (double)n + 1.5707963267948966) * d);
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string, new TextAttr(), n2);
        double d2 = ((double)n * 360.0 / (double)this.categoryCount + 90.0) % 360.0;
        double d3 = ((Point2D)double_).getY();
        double d4 = ((Point2D)double_).getX();
        double d5 = 2.0;
        if (!this.isAllMaxMin) {
            d5 = 4.0 + GlyphUtils.calculateTextDimensionWithRotation(this.getRealMaxValueText(n), new TextAttr(), n2).getWidth();
        }
        if (d2 > 90.0 && d2 < 270.0) {
            d4 = d4 - d5 - dimension2D.getWidth();
        } else if (d2 > 0.0 && d2 < 90.0) {
            d3 -= dimension2D.getHeight() / 2.0;
        } else if (d2 > 270.0 && d2 < 360.0) {
            d3 -= dimension2D.getHeight() / 2.0;
        } else if (d2 == 90.0) {
            d4 -= dimension2D.getWidth() / 2.0;
            d3 -= dimension2D.getHeight() * 3.0 / 2.0;
        } else if (d2 == 270.0) {
            d4 -= dimension2D.getWidth() / 2.0;
        }
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d4, d3, dimension2D.getWidth(), dimension2D.getHeight());
        if (!generalPath.intersects(double_2)) {
            generalPath.append(double_2, false);
            GlyphUtils.drawStrings(graphics2D, string, new TextAttr(), double_2, n2);
        }
    }

    private String getRealMaxValueText(int n) {
        int n2 = this.getLabelNumber() > 0 ? this.getLabelNumber() : 1;
        double d = this.getCateMin(n);
        double d2 = this.getCateMax(n);
        BigDecimal bigDecimal = this.isCustomMainUnit() ? this.getBigDecimalMainUnit() : AxisHelper.calculateIncrement(d, d2);
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d));
        BigDecimal bigDecimal3 = bigDecimal;
        BigDecimal bigDecimal4 = new BigDecimal(Double.toString(n2));
        double d3 = 1.0;
        String string = this.getShowUnit();
        if (string != null) {
            d3 = AxisHelper.getDivideUnit(string);
        }
        double d4 = d;
        while (d4 <= d2) {
            d4 += bigDecimal.doubleValue() * (double)n2;
            bigDecimal2 = bigDecimal2.add(bigDecimal3.multiply(bigDecimal4));
        }
        double d5 = bigDecimal2.doubleValue();
        return this.value2String(d5 / d3);
    }

    private Line2D getTickLine(int n, double d, int n2, int n3) {
        Point2D point2D = this.getPoint2D(n, d);
        Point2D.Double double_ = new Point2D.Double(point2D.getX() - (double)n2 / 2.0 * Math.cos((double)n * this.radian), point2D.getY() + (double)n2 / 2.0 * Math.sin((double)n * this.radian));
        Point2D.Double double_2 = new Point2D.Double(point2D.getX() + (double)n2 / 2.0 * Math.cos((double)n * this.radian), point2D.getY() - (double)n2 / 2.0 * Math.sin((double)n * this.radian));
        if (n3 == 3) {
            return new Line2D.Double(double_, double_2);
        }
        if (n3 == 1) {
            return new Line2D.Double(double_, point2D);
        }
        if (n3 == 2) {
            return new Line2D.Double(point2D, double_2);
        }
        return new Line2D.Double(point2D, point2D);
    }

    protected void drawFirstAxisLabel(Graphics graphics, int n, double d, double d2, GeneralPath generalPath, int n2) {
        if (!this.isShowAxisLabel()) {
            return;
        }
        Point2D point2D = this.getPoint2D(n, d);
        String string = this.value2String(d / d2);
        TextAttr textAttr = this.getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string, textAttr, n2);
        double d3 = 4.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() - d3, point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
        if (this.getLabelNumber() != 0) {
            GlyphUtils.drawStrings(graphics, string, textAttr, double_, n2);
        } else if (!generalPath.intersects(double_)) {
            generalPath.append(double_, false);
            GlyphUtils.drawStrings(graphics, string, textAttr, double_, n2);
        }
    }

    private Line2D[] getAxisLines() {
        Line2D[] line2DArray = new Line2D[this.categoryCount];
        for (int i = 0; i < this.categoryCount; ++i) {
            line2DArray[i] = new Line2D.Double(this.getPoint2D(i, this.getCateMin(i)), this.getPoint2D(i, this.getCateMax(i)));
        }
        return line2DArray;
    }

    protected void drawAxisTitle(Graphics graphics, int n) {
    }

    public boolean equals(Object object) {
        return object instanceof RadarAxisGlyph && super.equals(object) && ((RadarAxisGlyph)object).diameter == this.diameter && ((RadarAxisGlyph)object).radian == this.radian && ((RadarAxisGlyph)object).categoryCount == this.categoryCount && ((RadarAxisGlyph)object).isAllMaxMin == this.isAllMaxMin && ComparatorUtils.equals((Object)((RadarAxisGlyph)object).labelList, (Object)this.labelList);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("D", this.diameter);
        jSONObject.put("radian", this.radian);
        jSONObject.put("categoryCount", this.categoryCount);
        if (this.labelList != null && this.labelList.size() > 0) {
            jSONObject.put("labelList", (Object)this.labelList.toArray());
        }
        jSONObject.put("radarMax", (Object)this.radarMax);
        jSONObject.put("radarMin", (Object)this.radarMin);
        jSONObject.put("isAllMaxMin", this.isAllMaxMin);
        return jSONObject;
    }

    public double getPreLeftWidth4DataSheet(int n) {
        return 0.0;
    }
}

