/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.ColorInfo;
import com.fr.chart.chartglyph.Cylinder;
import com.fr.chart.chartglyph.Object3D;
import com.fr.chart.chartglyph.Projection;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.general.ComparatorUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.batik.ext.awt.RadialGradientPaint;

public class Pie3D
extends SpecialGlyph
implements Object3D {
    private static final long serialVersionUID = 4123668892673753116L;
    private Projection projection = new Projection();
    private List cylinderList = new ArrayList();

    private void drawBottom(Graphics2D graphics2D) {
        for (int i = 0; i < this.getCylinderCount(); ++i) {
            Cylinder cylinder = this.getCylinder(i);
            if (cylinder.getExtent() == 0.0) continue;
            ColorInfo colorInfo = cylinder.getColorInfo();
            Color color = colorInfo.getSeriesAttrColor().getSeriesColor();
            if (color != null) {
                colorInfo.getSeriesAttrColor().setSeriesColor(color.darker().darker());
            }
            colorInfo.paint(graphics2D, cylinder.bottom());
            colorInfo.getSeriesAttrColor().setSeriesColor(color);
        }
    }

    private void drawBack(Graphics2D graphics2D) {
        for (int i = 0; i < this.getCylinderCount(); ++i) {
            Cylinder cylinder = this.getCylinder(i);
            if (cylinder.getExtent() == 0.0) continue;
            ColorInfo colorInfo = cylinder.getColorInfo();
            Color color = colorInfo.getSeriesAttrColor().getSeriesColor();
            if (color != null) {
                colorInfo.getSeriesAttrColor().setSeriesColor(color.darker().darker());
            }
            colorInfo.paint(graphics2D, cylinder.back());
            colorInfo.getSeriesAttrColor().setSeriesColor(color);
        }
    }

    private void drawSide(Graphics2D graphics2D, Cylinder.CylinderSide[] cylinderSideArray) {
        for (int i = 0; i < cylinderSideArray.length; ++i) {
            Cylinder cylinder = cylinderSideArray[i].cylinder;
            if (cylinder.getExtent() == 0.0) continue;
            ColorInfo colorInfo = cylinder.getColorInfo();
            Color color = colorInfo.getSeriesAttrColor().getSeriesColor();
            if (color != null) {
                colorInfo.getSeriesAttrColor().setSeriesColor(color.darker().darker());
            }
            if (cylinderSideArray[i].isStart) {
                colorInfo.paint(graphics2D, cylinder.getStartSide());
            } else {
                colorInfo.paint(graphics2D, cylinder.getEndSide());
            }
            colorInfo.getSeriesAttrColor().setSeriesColor(color);
        }
    }

    private Cylinder.CylinderSide[] sortCylinderSide() {
        Object[] objectArray = new Cylinder.CylinderSide[this.getCylinderCount() * 2];
        for (int i = 0; i < this.getCylinderCount(); ++i) {
            objectArray[2 * i] = new Cylinder.CylinderSide(this.getCylinder(i), true);
            objectArray[2 * i + 1] = new Cylinder.CylinderSide(this.getCylinder(i), false);
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    private void drawPositive(Graphics2D graphics2D) {
        for (int i = 0; i < this.getCylinderCount(); ++i) {
            Color color;
            Cylinder cylinder = this.getCylinder(i);
            if (cylinder.getExtent() == 0.0 || (color = cylinder.getColorInfo().getSeriesAttrColor().getSeriesColor()) == null) continue;
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(ChartUtils.getColorFromBaseColor(color, 0.0, 0.1, -0.1));
            graphics2D.fill(cylinder.front());
            graphics2D.setPaint(paint);
        }
    }

    private void drawTop(Graphics2D graphics2D) {
        Paint paint = graphics2D.getPaint();
        for (int i = 0; i < this.getCylinderCount(); ++i) {
            Color color;
            Cylinder cylinder = this.getCylinder(i);
            if (cylinder.getExtent() == 0.0 || (color = cylinder.getColorInfo().getSeriesAttrColor().getSeriesColor()) == null) continue;
            Arc2D arc2D = cylinder.top();
            double d = arc2D.getWidth();
            double d2 = arc2D.getHeight();
            double d3 = arc2D.getWidth() / 2.0;
            double d4 = d / 2.0 / d3;
            double d5 = d2 / 2.0 / d3;
            graphics2D.scale(d4, d5);
            Color color2 = ChartUtils.getColorFromBaseColor(color, 0.0, -0.2, 0.25);
            float[] fArray = new float[]{0.0f, 1.0f};
            Color[] colorArray = new Color[]{color2, color};
            if ((float)d3 < Float.MIN_VALUE) continue;
            RadialGradientPaint radialGradientPaint = new RadialGradientPaint((float)(arc2D.getCenterX() / d4), (float)(arc2D.getCenterY() / d5), (float)d3, fArray, colorArray);
            graphics2D.setPaint((Paint)radialGradientPaint);
            graphics2D.fill(new Arc2D.Double(arc2D.getX() / d4, arc2D.getY() / d5, d, d, arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.getArcType()));
            graphics2D.scale(1.0 / d4, 1.0 / d5);
        }
        graphics2D.setPaint(paint);
    }

    public void draw(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawBottom(graphics2D);
        this.drawBack(graphics2D);
        this.drawSide(graphics2D, this.sortCylinderSide());
        this.drawPositive(graphics2D);
        this.drawTop(graphics2D);
    }

    public void drawWithoutSide(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawPositive(graphics2D);
        this.drawTop(graphics2D);
    }

    public Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.getCylinderCount(); ++i) {
            generalPath.append(this.getCylinder(i).getShape(), false);
        }
        return generalPath;
    }

    public void addCylinder(Cylinder cylinder) {
        this.cylinderList.add(cylinder);
    }

    public Cylinder getCylinder(int n) {
        return (Cylinder)this.cylinderList.get(n);
    }

    public int getCylinderCount() {
        return this.cylinderList.size();
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public void clearCylinder() {
        this.cylinderList.clear();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Pie3D)) {
            return false;
        }
        Pie3D pie3D = (Pie3D)object;
        if (!ComparatorUtils.equals((Object)pie3D.getProjection(), (Object)this.getProjection())) {
            return false;
        }
        if (pie3D.getCylinderCount() != this.getCylinderCount()) {
            return false;
        }
        for (int i = 0; i < pie3D.getCylinderCount(); ++i) {
            if (pie3D.getCylinder(i) == null || ComparatorUtils.equals((Object)pie3D.getCylinder(i), (Object)this.getCylinder(i))) continue;
            return false;
        }
        return true;
    }

    public Point2D topCenterPoint(Point2D point2D) {
        return this.getCylinder(0).topCenterPoint(point2D);
    }
}

