/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.base.AreaColor;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartDefaultConfig;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.MapHotAreaColor;
import com.fr.chart.chartglyph.MeterInterval;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ModColumnRowProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeterStyle
implements XMLable {
    public static final int METER_NORMAL = 0;
    public static final int METER_BLUE = 1;
    public static final int METER_SIMPLE = 2;
    private static final long serialVersionUID = -7636054199242127287L;
    public static final int AUTO = 0;
    public static final int CUSTOM = 1;
    public static final String XML_TAG = "MeterStyle";
    public static final float DEFAULT_BORDER_SIZE = 3.0f;
    public static final float DEFAULT_CIRCLE_SIZE = 10.0f;
    public static final int PIE270 = 270;
    public static final int CUSTOMSHAPE = 1;
    public static final int CIRCLE = 360;
    public static final int PIE = 180;
    public static final double START = 0.0;
    public static final double END = 450.0;
    public static final double SIZE = 50.0;
    private static final int DEFAULT_TITLE_FONT_SIZE = 10;
    private static final int DEFAULT_VALUE_FONT_SIZE = 18;
    private static final int DEFAULT_UNIT_FONT_SIZE = 12;
    private int dialShape = 180;
    private int maxArrowAngle = 180;
    private int meterAngle = 180;
    private int designType = 0;
    private Formula startValue = new Formula("0.0");
    private Formula endValue = new Formula("450.0");
    private Formula tickSize = new Formula("50.0");
    private String units = Inter.getLocText((String)"FR-Chart-Meter_Yuan");
    private Format unitFormat;
    private boolean tickLabelsVisible = true;
    private TextAttr titleTextAttr = new TextAttr();
    private TextAttr valueTextAttr = new TextAttr();
    private TextAttr unitTextAttr = new TextAttr();
    private List intervals;
    private int order = 0;
    private MapHotAreaColor hotAreaColor = null;
    private int meterType = 0;
    private boolean isShowTitle = true;

    public MeterStyle() {
        this.setIntervals(new ArrayList());
        this.titleTextAttr = new TextAttr(FRFont.getInstance((String)"Microsoft Yahei", (int)0, (float)10.0f));
        this.valueTextAttr = new TextAttr(FRFont.getInstance((String)"Century Gothic", (int)1, (float)18.0f));
        this.unitTextAttr = new TextAttr(FRFont.getInstance((String)"Microsoft Yahei", (int)0, (float)12.0f));
    }

    public int getDesignType() {
        return this.designType;
    }

    public void setDesignTyle(int n) {
        this.designType = n;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public MapHotAreaColor getMapHotAreaColor() {
        return this.hotAreaColor;
    }

    public void setMapHotAreaColor(MapHotAreaColor mapHotAreaColor) {
        this.hotAreaColor = mapHotAreaColor;
    }

    public int getDialShape() {
        return this.dialShape;
    }

    public void setDialShape(int n) {
        this.dialShape = n;
    }

    public int getMeterAngle() {
        return this.meterAngle;
    }

    public void setMeterAngle(int n) {
        this.meterAngle = n;
    }

    public void setMeterType(int n) {
        this.meterType = n;
    }

    public int getMeterType() {
        return this.meterType;
    }

    public void setMaxArrowAngle(int n) {
        this.maxArrowAngle = n;
    }

    public int getMaxArrowAngle() {
        return this.maxArrowAngle;
    }

    public Formula getStartValue() {
        return this.startValue;
    }

    public double getStartValueResult() {
        double d = 0.0;
        Number number = ChartBaseUtils.formula2Number(this.startValue);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public void setStartValue(Formula formula) {
        this.startValue = formula;
    }

    public double getEndValueFormula() {
        double d = 450.0;
        Number number = ChartBaseUtils.formula2Number(this.getEndValue());
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Formula getEndValue() {
        return this.endValue;
    }

    public void setEndValue(Formula formula) {
        this.endValue = formula;
    }

    public Formula getTickSize() {
        return this.tickSize;
    }

    public double getTickSizeFormula() {
        double d = 50.0;
        Number number = ChartBaseUtils.formula2Number(this.getTickSize());
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public void setTickSize(Formula formula) {
        this.tickSize = formula;
    }

    public boolean isCustomMeter() {
        return false;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String string) {
        this.units = string;
    }

    public void setUnitFormat(Format format) {
        this.unitFormat = format;
    }

    public Format getUnitFormat() {
        return this.unitFormat;
    }

    public void setTickLabelsVisible(boolean bl) {
        this.tickLabelsVisible = bl;
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTitleTextAttr(TextAttr textAttr) {
        this.titleTextAttr = textAttr;
    }

    public TextAttr getTitleTextAttr() {
        return this.titleTextAttr;
    }

    public void addInterval(MeterInterval meterInterval) {
        this.intervals.add(meterInterval);
    }

    public int getIntervalCount() {
        return this.intervals != null ? this.intervals.size() : 0;
    }

    public MeterInterval getInterval(int n) {
        if (n < 0 || n >= this.getIntervalCount()) {
            return null;
        }
        return (MeterInterval)this.intervals.get(n);
    }

    public void clearAllInterval() {
        if (this.intervals == null) {
            return;
        }
        this.intervals.clear();
    }

    public void convertAreaColor2List(double d) {
        if (this.getDesignType() == 0) {
            if (d < 0.0) {
                double d2;
                double d3 = d2 = d * 3.0;
                double d4 = 0.0;
                this.startValue.setResult((Object)new Double(d2));
                this.endValue.setResult((Object)new Double(0.0));
                MeterInterval meterInterval = new MeterInterval(Inter.getLocText((String)"FR-Chart-Meter_Field"), new Formula("" + d3), new Formula("" + d3 * 2.0 / 3.0));
                meterInterval.setBackgroundColor(new Color(231, 71, 62));
                this.addInterval(meterInterval);
                meterInterval = new MeterInterval(Inter.getLocText((String)"FR-Chart-Meter_Field"), new Formula("" + d3 * 2.0 / 3.0), new Formula("" + d3 / 3.0));
                meterInterval.setBackgroundColor(new Color(252, 210, 9));
                this.addInterval(meterInterval);
                meterInterval = new MeterInterval(Inter.getLocText((String)"FR-Chart-Meter_Field"), new Formula("" + d3 / 3.0), new Formula("" + d4));
                meterInterval.setBackgroundColor(new Color(77, 184, 73));
                this.addInterval(meterInterval);
                this.hotAreaColor = new MapHotAreaColor();
            } else {
                double d5 = d * 3.0 / 2.0;
                double d6 = 0.0;
                double d7 = d5;
                this.startValue.setResult((Object)new Double(d6));
                this.endValue.setResult((Object)new Double(d5));
                MeterInterval meterInterval = new MeterInterval(Inter.getLocText((String)"FR-Chart-Meter_Field"), new Formula("" + d6), new Formula("" + d7 / 3.0));
                meterInterval.setBackgroundColor(new Color(231, 71, 62));
                this.addInterval(meterInterval);
                meterInterval = new MeterInterval(Inter.getLocText((String)"FR-Chart-Meter_Field"), new Formula("" + d7 / 3.0), new Formula("" + 2.0 * d7 / 3.0));
                meterInterval.setBackgroundColor(new Color(252, 210, 9));
                this.addInterval(meterInterval);
                meterInterval = new MeterInterval(Inter.getLocText((String)"FR-Chart-Meter_Field"), new Formula("" + 2.0 * d7 / 3.0), new Formula("" + d7));
                meterInterval.setBackgroundColor(new Color(77, 184, 73));
                this.addInterval(meterInterval);
                this.hotAreaColor = new MapHotAreaColor();
            }
        } else {
            int n = this.hotAreaColor.getAreaNumber();
            List list = this.hotAreaColor.getAreaColorList();
            AreaColor areaColor = (AreaColor)list.get(0);
            this.endValue.setResult((Object)areaColor.getMinNum());
            areaColor = (AreaColor)list.get(n - 1);
            this.startValue.setResult((Object)areaColor.getMaxNum());
            for (int i = n - 1; i >= 0; --i) {
                AreaColor areaColor2 = (AreaColor)list.get(i);
                MeterInterval meterInterval = new MeterInterval();
                meterInterval.setBeginValue(areaColor2.getMax());
                meterInterval.setEndValue(areaColor2.getMin());
                meterInterval.setBackgroundColor(areaColor2.getAreaColor());
                this.addInterval(meterInterval);
            }
        }
    }

    public void convertList2AreaColor() {
        if (this.designType == 1 && this.hotAreaColor != null) {
            this.hotAreaColor.setUseType(1);
            int n = this.intervals.size();
            this.hotAreaColor.setAreaNumber(n);
            this.hotAreaColor.clearColor();
            for (int i = n - 1; i >= 0; --i) {
                MeterInterval meterInterval = (MeterInterval)this.intervals.get(i);
                AreaColor areaColor = new AreaColor(meterInterval.getEndValueResult(), meterInterval.getStartValueResult(), meterInterval.getBackgroundColor());
                this.hotAreaColor.addAreaColor(areaColor);
            }
        }
    }

    public void setIntervals(List list) {
        this.intervals = list;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        this.writerAttr(xMLPrintWriter);
        if (this.hotAreaColor != null) {
            this.hotAreaColor.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    protected void writerAttr(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attr").attr("meterAngle", this.meterAngle).attr("maxArrowAngle", this.maxArrowAngle).attr("units", this.getUnits()).attr("order", this.order).attr("designType", this.designType).attr("tickLabelsVisible", this.tickLabelsVisible).attr("dialShape", this.dialShape).attr("isShowTitle", this.isShowTitle).attr("meterType", this.meterType);
        if (this.startValue != null) {
            xMLPrintWriter.attr("startValue", this.startValue.toString());
        }
        if (this.getEndValue() != null) {
            xMLPrintWriter.attr("endValue", this.getEndValue().toString());
        }
        if (this.getTickSize() != null) {
            xMLPrintWriter.attr("tickSize", this.getTickSize().toString());
        }
        xMLPrintWriter.end();
        if (this.titleTextAttr != null) {
            this.titleTextAttr.writeXML(xMLPrintWriter);
        }
        if (this.valueTextAttr != null) {
            xMLPrintWriter.startTAG("valueTextAttr");
            this.valueTextAttr.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.unitTextAttr != null) {
            xMLPrintWriter.startTAG("unitTextAttr");
            this.unitTextAttr.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.intervals != null && this.intervals.size() > 0) {
            xMLPrintWriter.startTAG("IntervalList");
            int n = this.intervals.size();
            for (int i = 0; i < n; ++i) {
                MeterInterval meterInterval = (MeterInterval)this.intervals.get(i);
                meterInterval.writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attr".equals(string)) {
                this.setOrder(xMLableReader.getAttrAsInt("order", 0));
                this.setDesignTyle(xMLableReader.getAttrAsInt("designType", 0));
                this.setMeterAngle(xMLableReader.getAttrAsInt("meterAngle", 180));
                this.setMaxArrowAngle(xMLableReader.getAttrAsInt("maxArrowAngle", 180));
                this.setStartValue(new Formula(xMLableReader.getAttrAsString("startValue", "0")));
                this.setEndValue(new Formula(xMLableReader.getAttrAsString("endValue", "400")));
                this.setTickSize(new Formula(xMLableReader.getAttrAsString("tickSize", "50")));
                this.isShowTitle = xMLableReader.getAttrAsBoolean("isShowTitle", true);
                this.meterType = xMLableReader.getAttrAsInt("meterType", 0);
                String string2 = xMLableReader.getAttrAsString("units", null);
                if (string2 != null) {
                    this.setUnits(string2);
                }
                this.setTickLabelsVisible(xMLableReader.getAttrAsBoolean("tickLabelsVisible", true));
                string2 = xMLableReader.getAttrAsString("dialShape", null);
                if (string2 != null) {
                    this.dialShape = this.chartXMLType(string2);
                    if (this.dialShape == 180 && this.meterAngle != 180) {
                        this.dialShape = 1;
                    }
                    if (this.dialShape == 360 && this.meterAngle != 360) {
                        this.dialShape = 1;
                        this.meterAngle = 360;
                    }
                }
            } else if ("TextAttr".equals(string)) {
                this.titleTextAttr = (TextAttr)xMLableReader.readXMLObject((XMLReadable)new TextAttr());
            } else if ("valueTextAttr".equals(string)) {
                this.valueTextAttr = (TextAttr)xMLableReader.readXMLObject((XMLReadable)new TextAttr());
            } else if ("unitTextAttr".equals(string)) {
                this.unitTextAttr = (TextAttr)xMLableReader.readXMLObject((XMLReadable)new TextAttr());
            } else if ("IntervalList".equals(string)) {
                this.readInterval(xMLableReader);
            } else if (ComparatorUtils.equals((String)string, (String)"MapHotAreaColor")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        MeterStyle.this.hotAreaColor = (MapHotAreaColor)xMLableReader.readXMLObject((XMLReadable)new MapHotAreaColor());
                    }
                });
            }
        }
    }

    private void readInterval(XMLableReader xMLableReader) {
        this.intervals.clear();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && "MeterInterval".equals(xMLableReader.getTagName())) {
                    MeterStyle.this.intervals.add(xMLableReader.readXMLObject((XMLReadable)new MeterInterval()));
                }
            }
        });
    }

    private int chartXMLType(String string) {
        int n = 180;
        if ("PIE270".equals(string)) {
            n = 270;
        } else if ("CustomShape".equals(string)) {
            n = 1;
        } else if ("CIRCLE".equals(string)) {
            n = 360;
        } else if ("PIE".equals(string)) {
            n = 180;
        }
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        MeterStyle meterStyle = (MeterStyle)super.clone();
        if (this.startValue != null) {
            meterStyle.startValue = (Formula)this.startValue.clone();
        }
        if (this.endValue != null) {
            meterStyle.endValue = (Formula)this.endValue.clone();
        }
        if (this.tickSize != null) {
            meterStyle.tickSize = (Formula)this.tickSize.clone();
        }
        meterStyle.meterType = this.meterType;
        meterStyle.isShowTitle = this.isShowTitle;
        if (this.titleTextAttr != null) {
            meterStyle.titleTextAttr = (TextAttr)this.titleTextAttr.clone();
        }
        if (this.unitTextAttr != null) {
            meterStyle.unitTextAttr = (TextAttr)this.unitTextAttr.clone();
        }
        if (this.valueTextAttr != null) {
            meterStyle.valueTextAttr = (TextAttr)this.valueTextAttr.clone();
        }
        if (this.unitFormat != null) {
            meterStyle.unitFormat = (Format)this.unitFormat.clone();
        }
        if (this.intervals != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < this.getIntervalCount(); ++i) {
                arrayList.add(this.getInterval(i).clone());
            }
            meterStyle.setIntervals(arrayList);
        }
        if (this.hotAreaColor != null) {
            meterStyle.hotAreaColor = (MapHotAreaColor)this.hotAreaColor.clone();
        }
        return meterStyle;
    }

    public boolean equals(Object object) {
        return object instanceof MeterStyle && ComparatorUtils.equals((String)object.getClass().getName(), (String)this.getClass().getName()) && ComparatorUtils.equals((Object)((MeterStyle)object).endValue, (Object)this.endValue) && ComparatorUtils.equals((Object)((MeterStyle)object).tickSize, (Object)this.tickSize) && ((MeterStyle)object).dialShape == this.dialShape && ((MeterStyle)object).maxArrowAngle == this.maxArrowAngle && ((MeterStyle)object).meterAngle == this.meterAngle && ComparatorUtils.equals((String)((MeterStyle)object).units, (String)this.units) && ComparatorUtils.equals((Object)((MeterStyle)object).unitFormat, (Object)this.unitFormat) && ComparatorUtils.equals((Object)((MeterStyle)object).intervals, (Object)this.intervals) && ComparatorUtils.equals((Object)((MeterStyle)object).titleTextAttr, (Object)this.titleTextAttr) && ComparatorUtils.equals((Object)((MeterStyle)object).unitTextAttr, (Object)this.unitTextAttr) && ComparatorUtils.equals((Object)((MeterStyle)object).valueTextAttr, (Object)this.valueTextAttr) && ((MeterStyle)object).tickLabelsVisible == this.tickLabelsVisible && ComparatorUtils.equals((Object)((MeterStyle)object).startValue, (Object)this.startValue) && ((MeterStyle)object).order == this.order && ((MeterStyle)object).designType == this.designType && ComparatorUtils.equals((Object)((MeterStyle)object).hotAreaColor, (Object)this.hotAreaColor) && ((MeterStyle)object).meterType == this.meterType && ((MeterStyle)object).isShowTitle == this.isShowTitle;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("startValue", (Object)ChartBaseUtils.formula2Number(this.startValue));
        jSONObject.put("endValue", (Object)ChartBaseUtils.formula2Number(this.endValue));
        jSONObject.put("tickSize", (Object)ChartBaseUtils.formula2Number(this.tickSize));
        jSONObject.put("meterAngle", this.meterAngle);
        jSONObject.put("maxArrowAngle", this.maxArrowAngle);
        jSONObject.put("dialShape", this.dialShape);
        jSONObject.put("tickLabelsVisible", this.tickLabelsVisible);
        jSONObject.put("units", (Object)this.units);
        jSONObject.put("order", this.order);
        jSONObject.put("designType", this.getDesignType());
        jSONObject.put("meterType", this.meterType);
        jSONObject.put("isShowTitle", this.isShowTitle);
        if (this.unitFormat != null) {
            jSONObject.put("unitFormat", (Object)ChartBaseUtils.format2JS(this.unitFormat, repository));
        }
        jSONObject.put("titleTextAttr", (Object)this.titleTextAttr.toJSONObject());
        jSONObject.put("valueTextAttr", (Object)this.valueTextAttr.toJSONObject());
        jSONObject.put("unitTextAttr", (Object)this.unitTextAttr.toJSONObject());
        if (this.hotAreaColor == null) {
            this.doCompa();
        }
        if (this.intervals != null && this.intervals.size() > 0) {
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            for (int i = 0; i < this.intervals.size(); ++i) {
                arrayList.add(this.getInterval(i).toJSONObject());
            }
            jSONObject.put("intervals", (Object)arrayList.toArray());
        }
        return jSONObject;
    }

    public JSONObject exportSeriesConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        HashMap<String, Object> hashMap = ChartDefaultConfig.METER_STYLE_DEFAULT;
        jSONObject.put("meterType", this.meterType);
        jSONObject.put("units", (Object)this.units);
        if (this.meterType == 0 && !ComparatorUtils.equals((Object)this.maxArrowAngle, (Object)hashMap.get("maxArrowAngle"))) {
            jSONObject.put("maxArrowAngle", this.maxArrowAngle);
        }
        if (!ComparatorUtils.equals((Object)this.isShowTitle, (Object)hashMap.get("isShowTitle"))) {
            jSONObject.put("isShowTitle", this.isShowTitle);
        }
        if (!ComparatorUtils.equals((Object)this.order, (Object)hashMap.get("order"))) {
            jSONObject.put("order", this.order);
        }
        if (!ComparatorUtils.equals((Object)this.titleTextAttr, (Object)hashMap.get("titleTextAttr"))) {
            jSONObject.put("titleTextAttr", (Object)this.titleTextAttr.changedAttrToJSONObject());
        }
        if (!ComparatorUtils.equals((Object)this.valueTextAttr, (Object)hashMap.get("valueTextAttr"))) {
            jSONObject.put("valueTextAttr", (Object)this.valueTextAttr.changedAttrToJSONObject());
        }
        if (!ComparatorUtils.equals((Object)this.unitTextAttr, (Object)hashMap.get("unitTextAttr"))) {
            jSONObject.put("unitTextAttr", (Object)this.unitTextAttr.changedAttrToJSONObject());
        }
        if (this.designType != 0 && this.intervals != null) {
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            for (int i = 0; i < this.intervals.size(); ++i) {
                arrayList.add(this.getInterval(i).toJSONObject());
            }
            jSONObject.put("intervals", (Object)arrayList.toArray());
        }
        return jSONObject;
    }

    private void doCompa() {
        this.clearAllInterval();
        for (int i = 0; i < 3; ++i) {
            MeterInterval meterInterval = new MeterInterval(Inter.getLocText((String)"FR-Chart-Meter_Field"), new Formula("0"), new Formula("0"));
            this.addInterval(meterInterval);
        }
    }

    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        if (this.startValue != null) {
            list.addAll(Arrays.asList(this.startValue.dependence(calculatorProvider)));
        }
        if (this.endValue != null) {
            list.addAll(Arrays.asList(this.endValue.dependence(calculatorProvider)));
        }
        if (this.tickSize != null) {
            list.addAll(Arrays.asList(this.tickSize.dependence(calculatorProvider)));
        }
        int n = this.getIntervalCount();
        for (int i = 0; i < n; ++i) {
            MeterInterval meterInterval = this.getInterval(i);
            meterInterval.dependence(calculatorProvider, list);
        }
        if (this.hotAreaColor != null) {
            this.hotAreaColor.dependence(calculatorProvider, list);
        }
    }

    public void dealFormula(Calculator calculator) {
        if (this.startValue != null) {
            Utils.dealFormulaValue((Object)this.startValue, (Calculator)calculator);
        }
        if (this.endValue != null) {
            Utils.dealFormulaValue((Object)this.endValue, (Calculator)calculator);
        }
        if (this.tickSize != null) {
            Utils.dealFormulaValue((Object)this.tickSize, (Calculator)calculator);
        }
        int n = this.getIntervalCount();
        for (int i = 0; i < n; ++i) {
            MeterInterval meterInterval = this.getInterval(i);
            meterInterval.dealFormula(calculator);
        }
        if (this.hotAreaColor != null) {
            this.hotAreaColor.dealFormula(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        if (this.startValue != null) {
            GeneralUtils.dealBuidExecuteSequence((Object)this.startValue, (List)list, (CalculatorProvider)calculator);
        }
        if (this.endValue != null) {
            GeneralUtils.dealBuidExecuteSequence((Object)this.endValue, (List)list, (CalculatorProvider)calculator);
        }
        if (this.tickSize != null) {
            GeneralUtils.dealBuidExecuteSequence((Object)this.tickSize, (List)list, (CalculatorProvider)calculator);
        }
        int n = this.getIntervalCount();
        for (int i = 0; i < n; ++i) {
            MeterInterval meterInterval = this.getInterval(i);
            meterInterval.buidExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.startValue != null) {
            this.startValue.modColumnRow((ModColumnRowProvider)mOD_COLUMN_ROW);
        }
        if (this.endValue != null) {
            this.endValue.modColumnRow((ModColumnRowProvider)mOD_COLUMN_ROW);
        }
        if (this.tickSize != null) {
            this.tickSize.modColumnRow((ModColumnRowProvider)mOD_COLUMN_ROW);
        }
        int n = this.getIntervalCount();
        for (int i = 0; i < n; ++i) {
            MeterInterval meterInterval = this.getInterval(i);
            meterInterval.modFormulaString(mOD_COLUMN_ROW);
        }
    }

    public String getMeterStyleType() {
        return XML_TAG;
    }

    public TextAttr getValueTextAttr() {
        return this.valueTextAttr;
    }

    public void setValueTextAttr(TextAttr textAttr) {
        this.valueTextAttr = textAttr;
    }

    public TextAttr getUnitTextAttr() {
        return this.unitTextAttr;
    }

    public void setUnitTextAttr(TextAttr textAttr) {
        this.unitTextAttr = textAttr;
    }

    public void setShowCateName(boolean bl) {
        this.isShowTitle = bl;
    }

    public boolean isShowCateName() {
        return this.isShowTitle;
    }
}

