/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.GlyphUtils;
import com.fr.chart.chartglyph.BlueMeter;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.Meter;
import com.fr.chart.chartglyph.MeterStyle;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.SimpleMeter;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class MeterPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = -7720249461263542792L;
    public static final double GAP = 0.0;
    private MeterStyle meterStyle;

    public void layoutAxisGlyph(int n) {
    }

    public void setMeterStyle(MeterStyle meterStyle) {
        this.meterStyle = meterStyle;
    }

    public MeterStyle getMeterStyle() {
        return this.meterStyle;
    }

    public void layoutDataSeriesGlyph(int n) {
        Rectangle2D rectangle2D = this.getBounds();
        int n2 = this.getSeriesSize();
        int n3 = this.getCategoryCount();
        double d = 0.0;
        double d2 = 0.0;
        if (n2 > 1) {
            d2 = 0.0;
        }
        if (n3 > 1) {
            d = 0.0;
        }
        double d3 = (rectangle2D.getHeight() - (double)(n2 + 1) * d2) / (double)n2;
        double d4 = (rectangle2D.getWidth() - (double)(n3 + 1) * d) / (double)n3;
        for (int i = 0; i < n2; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            for (int j = 0; j < n3; ++j) {
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                this.layoutDataPoint(dataPoint, d4, d3, i, j, n);
            }
        }
    }

    private void layoutDataPoint(DataPoint dataPoint, double d, double d2, int n, int n2, int n3) {
        String string = dataPoint.getCategoryName();
        TextGlyph textGlyph = new TextGlyph(string, this.getMeterStyle().getTitleTextAttr());
        Meter meter = this.getMeterStyle().getMeterType() == 1 ? new BlueMeter(textGlyph, dataPoint.getValue(), this.getMeterStyle()) : (this.meterStyle.getMeterType() == 2 ? new SimpleMeter(textGlyph, dataPoint.getValue(), this.getMeterStyle()) : new Meter(textGlyph, dataPoint.getValue(), this.getMeterStyle()));
        dataPoint.setDrawImpl(meter);
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.getMeterStyle().getTitleTextAttr(), n3);
        if (!this.getMeterStyle().isShowCateName()) {
            dimension2D = new Dimension(0, 0);
            meter.setTitle(null);
        }
        meter.setBounds(new Rectangle2D.Double((double)n2 * d + (double)(n2 + 1) * 0.0, (double)n * d2 + (double)(n + 1) * 0.0 + dimension2D.getHeight(), d, d2 - dimension2D.getHeight()));
        dataPoint.setDataLabel(null);
    }

    public void draw(Graphics graphics, int n) {
        this.drawInfo(graphics);
        super.draw(graphics, n);
    }

    public boolean equals(Object object) {
        return object instanceof MeterPlotGlyph && super.equals(object) && ComparatorUtils.equals((Object)((MeterPlotGlyph)object).meterStyle, (Object)this.meterStyle);
    }

    public Object clone() throws CloneNotSupportedException {
        MeterPlotGlyph meterPlotGlyph = (MeterPlotGlyph)super.clone();
        if (this.meterStyle != null) {
            meterPlotGlyph.meterStyle = (MeterStyle)this.meterStyle.clone();
        }
        return meterPlotGlyph;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        if (this.meterStyle != null) {
            jSONObject.put("meterStyleType", (Object)this.meterStyle.getMeterStyleType());
            jSONObject.put("meterStyle", (Object)this.meterStyle.toJSONObject(repository));
        }
        return jSONObject;
    }

    public String getPlotGlyphType() {
        return "MeterPlotGlyph";
    }

    public String getPlotDetailType() {
        if (this.meterStyle.getMeterType() == 2) {
            return "SimpleMeterPlotGlyph";
        }
        if (this.meterStyle.getMeterType() == 1) {
            return "BlueMeterPlotGlyph";
        }
        return "CustomMeterPlotGlyph";
    }

    public String getChartType() {
        return "Meter";
    }

    public boolean isSupportLegend() {
        return false;
    }
}

