/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartEquationType;
import com.fr.chart.chartglyph.LinearEquation;

public class LogEquation
extends LinearEquation {
    public void fitting(double[] dArray, double[] dArray2) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > 0.0)) continue;
            ++n;
        }
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > 0.0)) continue;
            dArray3[n] = Math.log(dArray[i]);
            dArray4[n] = dArray2[i];
            ++n;
        }
        super.fitting(dArray3, dArray4);
    }

    public double execute(double d) {
        if (d <= 0.0) {
            return Double.NaN;
        }
        return this.val[0] * Math.log(d) + this.val[1];
    }

    public String toString() {
        if (this.val[1] < 0.0) {
            return this.val[0] + " * LN(x) - " + -this.val[1];
        }
        return this.val[0] + " * LN(x) + " + this.val[1];
    }

    public ChartEquationType getEquationType() {
        return ChartEquationType.LOG;
    }
}

