/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.BaseXMLUtils;
import com.fr.base.GraphHelper;
import com.fr.base.background.ColorBackground;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.Marker;
import com.fr.chart.chartglyph.MarkerFactory;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;

public class LineMarkerIcon
implements XMLable {
    private static final long serialVersionUID = -888457366895932017L;
    public static final String XML_TAG = "LineMarkerIcon";
    private int lineStyle = 0;
    private Background background;
    private Marker marker = null;
    private float alpha = 1.0f;

    public LineMarkerIcon() {
    }

    public LineMarkerIcon(Background background, int n, Marker marker) {
        this.setBackground(background);
        this.setLineStyle(n);
        this.setMarker(marker);
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void paint(Graphics graphics, int n) {
        boolean bl;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
        boolean bl2 = true;
        boolean bl3 = this.getMarker() != null && this.getMarker().isNullMarker();
        boolean bl4 = bl = this.getLineStyle() != 0 && this.background != null;
        if (bl3 && bl) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(GraphHelper.getStroke((int)this.getLineStyle()));
            this.background.drawWithGradientLine((Graphics)graphics2D, (Shape)new Line2D.Double(0.0, (double)n / 2.0, n, (double)n / 2.0));
            bl2 = false;
            graphics2D.setStroke(stroke);
        }
        if (this.getMarker() != null) {
            this.getMarker().paint(graphics2D, (double)n / 2.0, (double)n / 2.0);
            bl2 = false;
        }
        if (bl2 && this.background != null) {
            this.background.paint((Graphics)graphics2D, (Shape)new Rectangle(0, 0, n, n));
        }
        graphics2D.setComposite(composite);
        graphics2D.setPaint(paint);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                this.setAlpha(xMLableReader.getAttrAsFloat("alpha", 1.0f));
                this.setLineStyle(xMLableReader.getAttrAsInt("lineStyle", 0));
                String string2 = xMLableReader.getAttrAsString("color", null);
                if (string2 != null) {
                    this.setBackground((Background)ColorBackground.getInstance((Color)new Color(Integer.parseInt(string2), true)));
                }
            } else if (string.equals("Background")) {
                this.background = BaseXMLUtils.readBackground((XMLableReader)xMLableReader);
            } else if (string.equals("Marker")) {
                this.setMarker(MarkerFactory.readMarker(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("alpha", this.getAlpha()).attr("lineStyle", this.getLineStyle()).end();
        BaseXMLUtils.writeBackground((XMLPrintWriter)xMLPrintWriter, (Background)this.getBackground());
        if (this.getMarker() != null) {
            MarkerFactory.writeMarker(xMLPrintWriter, this.getMarker());
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof LineMarkerIcon && ((LineMarkerIcon)object).alpha == this.alpha && ((LineMarkerIcon)object).lineStyle == this.lineStyle && ComparatorUtils.equals((Object)((LineMarkerIcon)object).marker, (Object)this.marker) && ComparatorUtils.equals((Object)((LineMarkerIcon)object).background, (Object)this.background);
    }

    public Object clone() throws CloneNotSupportedException {
        LineMarkerIcon lineMarkerIcon = (LineMarkerIcon)super.clone();
        if (this.background != null) {
            lineMarkerIcon.background = (Background)this.background.clone();
        }
        if (this.marker != null) {
            lineMarkerIcon.marker = (Marker)this.marker.clone();
        }
        return lineMarkerIcon;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("lineStyle", this.lineStyle);
        jSONObject.put("alpha", (double)this.alpha);
        if (this.marker != null) {
            jSONObject.put("markerType", (Object)this.marker.getMarkerType());
            jSONObject.put("marker", (Object)this.marker.toJSONObject(repository));
        }
        if (this.background != null) {
            jSONObject.put("background", (Object)ChartBaseUtils.background2JS(repository, this.background));
        }
        return jSONObject;
    }
}

