/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.DoubleDimension2D;
import com.fr.base.FRContext;
import com.fr.base.GraphHelper;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Stock;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RectangleGlyph;
import com.fr.chart.chartglyph.StockPlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DataSheetGlyph
extends RectangleGlyph {
    private static final long serialVersionUID = -6888178799836147561L;
    protected static final double PADDING_GAP = 4.0;
    protected static final double MAX_CATE_LINE = 4.0;
    private static final double MAX_WIDTH = 4.0;
    private List seriesList = new ArrayList();
    private LegendItem[] items;
    private FRFont font = null;
    protected Format format = null;
    private double beginX;
    protected double unitLength;
    protected double seriesRowHeight;
    private double endLegendWidth;
    protected double crossValue;
    protected double arrowValue;
    protected double cateRowCout;

    public DataSheetGlyph() {
    }

    public DataSheetGlyph(PlotGlyph plotGlyph) {
        this(plotGlyph, null);
    }

    public DataSheetGlyph(PlotGlyph plotGlyph, LegendItem[] legendItemArray) {
        this.setDataWithLegendItems(plotGlyph, legendItemArray);
    }

    public int getSeriesSize() {
        return this.seriesList == null ? 0 : this.seriesList.size();
    }

    protected DataSeries getSeries(int n) {
        return n > -1 && n < this.getSeriesSize() ? (DataSeries)this.seriesList.get(n) : null;
    }

    public int getCategoryCount() {
        return this.getSeries(0) == null ? 0 : this.getSeries(0).getDataPointCount();
    }

    public Iterator selectableChildren() {
        return Collections.EMPTY_LIST.iterator();
    }

    public void setFont(FRFont fRFont) {
        this.font = fRFont;
    }

    public FRFont getFont() {
        return this.font == null ? FRFont.getInstance() : this.font;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public double getBeginX() {
        return this.beginX;
    }

    public void setBeginX(double d) {
        this.beginX = d;
    }

    public double getHeight() {
        return this.seriesRowHeight;
    }

    public void setHeight(double d) {
        this.seriesRowHeight = d;
    }

    public void setCrossValue(double d) {
        this.crossValue = d;
    }

    public void setArrowValue(double d) {
        this.arrowValue = d;
    }

    public void setUnitLength(double d) {
        this.unitLength = d;
    }

    public Dimension2D getPrefferedSize(ChartGlyph chartGlyph, int n) {
        if (this.getSeriesSize() < 1) {
            return new Dimension();
        }
        this._initSeriesRowHeightAndEndLegendWidth(chartGlyph, n);
        String string = this.getMaxCateString(n);
        double d = this.getCharNumber(new TextAttr(this.getFont()), (int)this.unitLength, n);
        if (d == 0.0) {
            this.cateRowCout = 1.0;
        } else {
            double d2 = Math.max(Math.ceil((double)string.length() / d), 1.0);
            this.cateRowCout = Math.min(4.0, d2);
        }
        return new DoubleDimension2D(this.endLegendWidth + 4.0 * 2.0, (this.seriesRowHeight + 4.0 * 2.0) * (double)this.seriesList.size() + this.cateRowCout * this.getCateRowHeight() + 4.0 * 2.0);
    }

    private String getMaxCateString(int n) {
        int n2 = ((DataSeries)this.seriesList.get(0)).getDataPointCount();
        Dimension2D dimension2D = new Dimension();
        String string = "";
        for (int i = 0; i < n2; ++i) {
            String string2 = ((DataSeries)this.seriesList.get(0)).getDataPoint(i).getCategoryName();
            Dimension2D dimension2D2 = GlyphUtils.calculateTextDimensionWithNoRotation(string2, this.getCateTextAttr(), n);
            if (!(dimension2D2.getWidth() > ((Dimension2D)dimension2D).getWidth())) continue;
            dimension2D = dimension2D2;
            string = string2;
        }
        return string;
    }

    protected void _initSeriesRowHeightAndEndLegendWidth(ChartGlyph chartGlyph, int n) {
        this.seriesRowHeight = Double.MIN_VALUE;
        double d = Double.MIN_VALUE;
        double d2 = chartGlyph.getBounds().getWidth() / 4.0;
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            Dimension2D dimension2D = null;
            dimension2D = this.items != null && this.getSeriesSize() == this.items.length ? this.items[i].prefferedSize(this.getLegendFont(), n) : GlyphUtils.calculateTextDimensionWithNoRotation(this.getSeries(i).getSeriesName(), new TextAttr(this.getLegendFont()), n);
            if (dimension2D.getWidth() > d) {
                d = Math.min(dimension2D.getWidth(), d2);
            }
            if (!(dimension2D.getHeight() > this.seriesRowHeight)) continue;
            this.seriesRowHeight = dimension2D.getHeight();
        }
        this.endLegendWidth = d;
    }

    protected int getCharNumber(TextAttr textAttr, int n, int n2) {
        if (n <= 0) {
            return 0;
        }
        double d = GlyphUtils.calculateTextDimensionWithNoRotation(Inter.getLocText((String)"FR-Chart-Chart_Text"), textAttr, n2).getWidth();
        return (int)((double)n / d);
    }

    private void setDataWithLegendItems(PlotGlyph plotGlyph, LegendItem[] legendItemArray) {
        this.initSeriesList(plotGlyph);
        if (legendItemArray != null) {
            try {
                this.items = new LegendItem[legendItemArray.length];
                for (int i = 0; i < legendItemArray.length; ++i) {
                    this.items[i] = (LegendItem)legendItemArray[i].clone();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRContext.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
            }
        }
    }

    public void setDataWithoutLegendItems(PlotGlyph plotGlyph) {
        this.initSeriesList(plotGlyph);
    }

    private void initSeriesList(PlotGlyph plotGlyph) {
        this.seriesList.clear();
        if (plotGlyph != null) {
            int n = plotGlyph.getSeriesSize();
            for (int i = 0; i < n; ++i) {
                this.seriesList.add(plotGlyph.getSeries(i));
            }
        }
    }

    public void doLayout(PlotGlyph plotGlyph) {
        Rectangle2D rectangle2D = this.getBounds();
        if (plotGlyph instanceof CategoryPlotGlyph) {
            AxisGlyph axisGlyph = ((CategoryPlotGlyph)plotGlyph).getxAxisGlyph();
            AxisGlyph axisGlyph2 = ((CategoryPlotGlyph)plotGlyph).getyAxisGlyph();
            int n = axisGlyph.position;
            if (n == 1 || n == 3) {
                this.beginX = axisGlyph.getBounds().getX() + plotGlyph.getBounds().getX();
                this.unitLength = axisGlyph.getBounds().getWidth() / (double)plotGlyph.getCategoryCount();
                rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), this.beginX + axisGlyph.axisLength - this.getBounds().getX(), rectangle2D.getHeight());
            } else {
                this.beginX = axisGlyph2.getBounds().getX() + plotGlyph.getBounds().getX();
                this.unitLength = (this.getBounds().getX() + this.getBounds().getWidth() - this.beginX) / (double)plotGlyph.getCategoryCount();
                rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), this.beginX + axisGlyph2.axisLength - this.getBounds().getX(), rectangle2D.getHeight());
            }
            this.crossValue = axisGlyph.getCrossValue();
            this.arrowValue = axisGlyph.getArrowValue();
        } else if (plotGlyph instanceof StockPlotGlyph) {
            AxisGlyph axisGlyph = ((StockPlotGlyph)plotGlyph).getxAxisGlyph();
            this.beginX = axisGlyph.getBounds().getX() + plotGlyph.getBounds().getX();
            this.unitLength = axisGlyph.unitLength;
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), this.beginX + axisGlyph.axisLength - this.getBounds().getX(), rectangle2D.getHeight());
            this.crossValue = axisGlyph.getCrossValue();
            this.arrowValue = axisGlyph.getArrowValue();
        }
        this.setBounds(rectangle2D);
    }

    public void draw(Graphics graphics, int n) {
        double d;
        if (this.getSeriesSize() < 1) {
            return;
        }
        Color color = graphics.getColor();
        graphics.setColor(this.getBorderColor());
        Rectangle2D rectangle2D = this.getBounds();
        double d2 = this.getCateRowHeight() * this.cateRowCout + 4.0 * 2.0;
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getY() + d2;
        this._newLine(graphics, d3, d4, d3, rectangle2D.getY() + rectangle2D.getHeight());
        this._newLine(graphics, d3, rectangle2D.getY() + rectangle2D.getHeight(), d3 + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
        this._newLine(graphics, rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
        this._newLine(graphics, this.beginX, rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY());
        for (d = this.beginX; d < rectangle2D.getX() + rectangle2D.getWidth(); d += this.unitLength) {
            this._newLine(graphics, d, rectangle2D.getY(), d, rectangle2D.getY() + rectangle2D.getHeight());
        }
        for (d = 0.0; d < (double)this.seriesList.size(); d += 1.0) {
            double d5 = rectangle2D.getY() + d2 + (this.seriesRowHeight + 4.0 * 2.0) * d;
            this._newLine(graphics, rectangle2D.getX(), d5, rectangle2D.getX() + rectangle2D.getWidth(), d5);
        }
        this.drawSeriese(graphics, n);
        this.drawLabel4Category(graphics, n);
        this.drawLabel4DataPoint(graphics, n);
        graphics.setColor(color);
    }

    protected void _newLine(Graphics graphics, double d, double d2, double d3, double d4) {
        Line2D.Double double_ = new Line2D.Double(d, d2, d3, d4);
        GraphHelper.draw((Graphics)graphics, (Shape)double_, (int)1);
    }

    protected FRFont getLegendFont() {
        return this.getFont();
    }

    protected TextAttr getCateTextAttr() {
        return new TextAttr(this.getFont());
    }

    protected double getCateRowHeight() {
        return this.seriesRowHeight;
    }

    private void drawSeriese(Graphics graphics, int n) {
        Rectangle2D rectangle2D = this.getBounds();
        double d = this.getCateRowHeight() * this.cateRowCout + 4.0 * 2.0;
        FRFont fRFont = this.getLegendFont();
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            Object object;
            double d2 = d + rectangle2D.getY() + (this.seriesRowHeight + 8.0) * (double)i + 4.0;
            if (this.items != null && this.getSeriesSize() == this.items.length) {
                object = this.items[i].prefferedSize(fRFont, n);
                this.items[i].setBounds(new Rectangle2D.Double(rectangle2D.getX() + 4.0, d2, Math.min(((Dimension2D)object).getWidth(), this.endLegendWidth), ((Dimension2D)object).getHeight()));
                boolean bl = this.items[i].isDrawInCut();
                this.items[i].setDrawInCut(true);
                this.items[i].draw(graphics, fRFont, n);
                this.items[i].setDrawInCut(bl);
                continue;
            }
            object = this.getSeries(i).getSeriesName();
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)object, new TextAttr(fRFont), n);
            GlyphUtils.drawStrings(graphics, (String)object, new TextAttr(fRFont), new Rectangle2D.Double(rectangle2D.getX() + 4.0, d2, dimension2D.getWidth(), dimension2D.getHeight()), n);
        }
    }

    protected void drawLabel4Category(Graphics graphics, int n) {
        TextAttr textAttr = this.getCateTextAttr();
        int n2 = this.getCharNumber(textAttr, (int)this.unitLength, n);
        if (n2 <= 0) {
            return;
        }
        String string = "";
        Object object = new DoubleDimension2D(0.0, 0.0);
        block0: for (int i = 0; i < this.getCategoryCount() && (double)i < this.arrowValue; ++i) {
            int n3 = (int)((double)i - this.crossValue);
            if (n3 < 0) continue;
            String string2 = this.getSeries(0).getDataPoint(i).getCategoryName();
            double d = this.beginX + (double)n3 * this.unitLength;
            int n4 = 0;
            while (true) {
                if (!((double)n4 < 4.0)) continue block0;
                int n5 = Math.min((n4 + 1) * n2, string2.length());
                string = string2.substring(n4 * n2, n5);
                object = GlyphUtils.calculateTextDimensionWithNoRotation(string, textAttr, n);
                Rectangle2D.Double double_ = new Rectangle2D.Double(d + (this.unitLength - ((Dimension2D)object).getWidth()) / 2.0, this.bounds.getY() + (this.getCateRowHeight() - ((Dimension2D)object).getHeight()) / 2.0 + (double)n4 * this.getCateRowHeight() + 4.0, ((Dimension2D)object).getWidth(), ((Dimension2D)object).getHeight());
                GlyphUtils.drawStrings(graphics, string, textAttr, double_, n);
                if (n5 >= string2.length()) continue block0;
                ++n4;
            }
        }
    }

    protected void drawLabel4DataPoint(Graphics graphics, int n) {
        Rectangle2D rectangle2D = this.getBounds();
        double d = this.getCateRowHeight() * this.cateRowCout + 4.0 * 2.0;
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            double d2 = d + rectangle2D.getY() + (this.seriesRowHeight + 8.0) * (double)i + 4.0;
            for (int j = 0; j < this.getCategoryCount() && (double)j < this.arrowValue; ++j) {
                DataPoint dataPoint = dataSeries.getDataPoint(j);
                int n2 = (int)((double)j - this.crossValue);
                if (n2 < 0 || dataPoint.isValueIsNull()) continue;
                String string = String.valueOf(dataPoint.getValueByUnit());
                if (dataPoint instanceof DataPoint4Stock) {
                    string = String.valueOf(((DataPoint4Stock)dataPoint).getStockValues()[4]);
                }
                if (this.format != null) {
                    string = this.format.format(Double.valueOf(string));
                }
                Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, new TextAttr(this.getFont()), n);
                GlyphUtils.drawStrings(graphics, string, new TextAttr(this.getFont()), new Rectangle2D.Double(this.beginX + (double)n2 * this.unitLength + (this.unitLength - dimension2D.getWidth()) / 2.0, d2, dimension2D.getWidth(), dimension2D.getHeight()), n);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DataSheetGlyph dataSheetGlyph = (DataSheetGlyph)super.clone();
        dataSheetGlyph.items = new LegendItem[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            dataSheetGlyph.items[i] = (LegendItem)this.items[i].clone();
        }
        return dataSheetGlyph;
    }

    public boolean equals(Object object) {
        return object instanceof DataSheetGlyph && super.equals(object) && ComparatorUtils.equals((Object)((DataSheetGlyph)object).seriesList, (Object)this.seriesList) && ComparatorUtils.equals((Object[])((DataSheetGlyph)object).items, (Object[])this.items) && ComparatorUtils.equals((Object)((DataSheetGlyph)object).font, (Object)this.font) && ComparatorUtils.equals((Object)((DataSheetGlyph)object).format, (Object)this.format);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        if (this.items != null && this.items.length > 0) {
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < this.items.length; ++i) {
                jSONArray.put((Object)this.items[i].toJSONObject(repository));
            }
            jSONObject.put("items", (Object)jSONArray);
        }
        if (this.font != null) {
            jSONObject.put("font", (Object)this.font.toJSONObject());
        }
        if (this.format != null) {
            jSONObject.put("format", (Object)ChartBaseUtils.format2JS(this.format, repository));
        }
        return jSONObject;
    }
}

