/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.BarDataWithAxisGlyph;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DateAxisGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Date;

public abstract class BarPlotGlyph
extends CategoryPlotGlyph {
    private static final long serialVersionUID = 6835951801934449612L;
    private static final double GAP = 0.13;
    private static final double MAX_WIDTH = 40.0;
    private static final double LABEL_BAR_GAP = 3.0;
    protected boolean isHorizontal = false;
    protected double seriesOverlapPercent = -0.2;
    protected double categoryIntervalPercent = 1.0;

    public void setHorizontal(boolean bl) {
        this.isHorizontal = bl;
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public void setSeriesOverlapPercent(double d) {
        this.seriesOverlapPercent = d;
    }

    public void setCategoryIntervalPercent(double d) {
        this.categoryIntervalPercent = d;
    }

    protected Rectangle2D getBarShape(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, int n, BarDataWithAxisGlyph barDataWithAxisGlyph) {
        double d = categoryPlotGlyph.getBarPercent(barDataWithAxisGlyph.barNumber);
        double d2 = categoryPlotGlyph.getBarStartPercent(d, n, barDataWithAxisGlyph);
        double d3 = this.getDataPointPercentValue(dataSeries.getSeriesIndex(), n);
        double d4 = barDataWithAxisGlyph.yAxisGlyph.getCrossValueInPlot();
        double d5 = barDataWithAxisGlyph.xAxisGlyph.getUnitLen() * d;
        double d6 = this.calculateCateStart(barDataWithAxisGlyph, d, d2);
        double[] dArray = this.calculateValueStartAndLength(dataSeries, categoryPlotGlyph, barDataWithAxisGlyph, d3, d4, n);
        if (this.isHorizontal()) {
            return new Rectangle2D.Double(dArray[0], d6, dArray[1], d5);
        }
        return new Rectangle2D.Double(d6, dArray[0], d5, dArray[1]);
    }

    private double calculateCateStart(BarDataWithAxisGlyph barDataWithAxisGlyph, double d, double d2) {
        if (this.isHorizontal()) {
            if (this.getxAxisGlyph().hasAxisReversed()) {
                return barDataWithAxisGlyph.xAxisGlyph.getPoint2D(d2).getY();
            }
            return barDataWithAxisGlyph.xAxisGlyph.getPoint2D(d2 + d).getY();
        }
        if (this.getxAxisGlyph().hasAxisReversed()) {
            return barDataWithAxisGlyph.xAxisGlyph.getPoint2D(d2 + d).getX();
        }
        return barDataWithAxisGlyph.xAxisGlyph.getPoint2D(d2).getX();
    }

    private double[] calculateValueStartAndLength(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, BarDataWithAxisGlyph barDataWithAxisGlyph, double d, double d2, int n) {
        if (this.isStacked()) {
            return this.valueStartAndLength4Stacked(dataSeries, categoryPlotGlyph, barDataWithAxisGlyph, d, n);
        }
        return this.valueStartAndLength4Unstacked(dataSeries, barDataWithAxisGlyph, d, d2, n);
    }

    private double[] valueStartAndLength4Stacked(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, BarDataWithAxisGlyph barDataWithAxisGlyph, double d, int n) {
        double d2;
        double d3;
        boolean bl = this.getyAxisGlyph().hasAxisReversed();
        if (d >= 0.0) {
            double d4 = categoryPlotGlyph.getPreSum4Bar(dataSeries.getSeriesIndex(), n, false);
            d3 = this.isHorizontal() ? (bl ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d4 + d).getX() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d4).getX()) : (bl ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d4).getY() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d4 + d).getY());
            d2 = barDataWithAxisGlyph.yAxisGlyph.get2ValueLength(d4, d4 + d);
        } else {
            double d5 = categoryPlotGlyph.getPreSum4Bar(dataSeries.getSeriesIndex(), n, true);
            d3 = this.isHorizontal() ? (bl ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d5).getX() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d5 + d).getX()) : (bl ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d5 + d).getY() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d5).getY());
            d2 = barDataWithAxisGlyph.yAxisGlyph.get2ValueLength(d5 + d, d5);
        }
        return new double[]{d3, d2};
    }

    private double[] valueStartAndLength4Unstacked(DataSeries dataSeries, BarDataWithAxisGlyph barDataWithAxisGlyph, double d, double d2, int n) {
        double d3 = d > d2 ? (this.isHorizontal() ? (this.getyAxisGlyph().hasAxisReversed() ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d).getX() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d2).getX()) : (this.getyAxisGlyph().hasAxisReversed() ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d2).getY() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d).getY())) : (this.isHorizontal() ? (this.getyAxisGlyph().hasAxisReversed() ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d2).getX() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d).getX()) : (this.getyAxisGlyph().hasAxisReversed() ? barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d).getY() : barDataWithAxisGlyph.yAxisGlyph.getPointInBounds(d2).getY()));
        double d4 = barDataWithAxisGlyph.yAxisGlyph.get2ValueLength(d, d2);
        return new double[]{d3, d4};
    }

    public double getBarPercent(int n) {
        return 1.0 / ((double)n - (double)(n - 1) * this.seriesOverlapPercent + this.categoryIntervalPercent);
    }

    public double getBarStartPercent(double d, int n, BarDataWithAxisGlyph barDataWithAxisGlyph) {
        return d * (1.0 - this.seriesOverlapPercent) * (double)barDataWithAxisGlyph.barIndex + 0.5 * this.categoryIntervalPercent * d + (double)barDataWithAxisGlyph.xAxisGlyph.getTickIndex4Value(n);
    }

    protected Rectangle2D getBarShape4GanttPlot(double d, double d2, int n, AxisGlyph axisGlyph, AxisGlyph axisGlyph2, int n2, int n3) {
        double d3 = this.getBarPercent(n2);
        double d4 = d3 * (1.0 - this.seriesOverlapPercent) * (double)n3 + (double)axisGlyph.getTickIndex4Value(n) + 0.5 * this.categoryIntervalPercent * d3;
        Date date = ChartBaseUtils.long2Date((long)d, 6);
        double d5 = ChartBaseUtils.date2Int(date, ((DateAxisGlyph)axisGlyph2).getMainType());
        Date date2 = ChartBaseUtils.long2Date((long)d2, 6);
        double d6 = ChartBaseUtils.date2Int(date2, ((DateAxisGlyph)axisGlyph2).getMainType());
        double d7 = axisGlyph2.getPointInBounds(d5).getX();
        double d8 = axisGlyph.getPointInBounds(d4).getY();
        double d9 = axisGlyph2.getPointInBounds(d6).getX() - d7;
        double d10 = axisGlyph.getUnitLen() * d3;
        double d11 = axisGlyph.getPointInBounds(n).getY();
        double d12 = d11 + axisGlyph.getUnitLen();
        double d13 = 3.0;
        double d14 = 40.0;
        if (d8 < d11 + d13) {
            d10 -= (d11 + d13 - d8) * 2.0;
            d8 = d11 + d13;
        }
        if (d8 + d10 > d12 - d13) {
            d10 -= (d8 + d10 - d12 + d13) * 2.0;
            d8 = d12 - d13 - d10;
        }
        if (d10 > d14) {
            d8 += (d10 - d14) / 2.0;
            d10 = d14;
        }
        return new Rectangle2D.Double(d7, d8, d9, d10);
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, DataPoint dataPoint, int n) {
        if (this.isHorizontal()) {
            return this.getLabelBoundsInHorizontal(dimension2D, rectangle2D, dataPoint, n);
        }
        return this.getLabelBoundsInVertical(dimension2D, rectangle2D, dataPoint, n);
    }

    protected Rectangle2D getLabelBoundsInVertical(Dimension2D dimension2D, Rectangle2D rectangle2D, DataPoint dataPoint, int n) {
        boolean bl;
        double d = 0.0;
        boolean bl2 = this.getyAxisGlyph().hasAxisReversed();
        boolean bl3 = bl = dataPoint.getValue() < 0.0;
        if (bl ^= bl2) {
            switch (n) {
                case 5: {
                    d = rectangle2D.getY() + rectangle2D.getHeight() - 3.0 - dimension2D.getHeight();
                    break;
                }
                case 6: {
                    d = rectangle2D.getY() + rectangle2D.getHeight() + 3.0;
                    break;
                }
                default: {
                    d = rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0;
                    break;
                }
            }
        } else {
            switch (n) {
                case 5: {
                    d = rectangle2D.getY() + 3.0;
                    break;
                }
                case 6: {
                    d = rectangle2D.getY() - dimension2D.getHeight() - 3.0;
                    break;
                }
                default: {
                    d = rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0;
                }
            }
        }
        return new Rectangle2D.Double(rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0, d, dimension2D.getWidth(), dimension2D.getHeight());
    }

    protected Rectangle2D getLabelBoundsInHorizontal(Dimension2D dimension2D, Rectangle2D rectangle2D, DataPoint dataPoint, int n) {
        boolean bl;
        double d = 0.0;
        boolean bl2 = this.getyAxisGlyph().hasAxisReversed();
        boolean bl3 = bl = dataPoint.getValue() < 0.0;
        if (bl ^= bl2) {
            switch (n) {
                case 5: {
                    d = rectangle2D.getX() + 3.0;
                    break;
                }
                case 6: {
                    d = rectangle2D.getX() - dimension2D.getWidth() - 3.0;
                    break;
                }
                default: {
                    d = rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0;
                    break;
                }
            }
        } else {
            switch (n) {
                case 5: {
                    d = rectangle2D.getX() + rectangle2D.getWidth() - dimension2D.getWidth() - 3.0;
                    break;
                }
                case 6: {
                    d = rectangle2D.getX() + rectangle2D.getWidth() + 3.0;
                    break;
                }
                default: {
                    d = rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0;
                }
            }
        }
        return new Rectangle2D.Double(d, rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight()) / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
    }

    public boolean equals(Object object) {
        return object instanceof BarPlotGlyph && super.equals(object) && ((BarPlotGlyph)object).isHorizontal == this.isHorizontal && ((BarPlotGlyph)object).seriesOverlapPercent == this.seriesOverlapPercent && ((BarPlotGlyph)object).categoryIntervalPercent == this.categoryIntervalPercent;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("seriesOverlapPercent", this.seriesOverlapPercent);
        jSONObject.put("isHorizontal", this.isHorizontal);
        jSONObject.put("categoryIntervalPercent", this.categoryIntervalPercent);
        return jSONObject;
    }

    public String getSmallIconType() {
        if (this.isHorizontal()) {
            return "Bar";
        }
        return "Column";
    }
}

