/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartComparatorUtils;
import com.fr.chart.base.ChartDefaultConfig;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.Cubic;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.chart.chartglyph.ValueAxisGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AxisGlyph
extends SpecialGlyph {
    private static final long serialVersionUID = -1928073768268210599L;
    protected static final double PIE_ANGLE = 180.0;
    protected static final int VERTICAL_ANGLE = 90;
    protected static final float TICK_WIDTH = 1.0f;
    protected static final int MAIN_TICK_LENGTH = 5;
    protected static final int SEC_TICK_LENGTH = 3;
    protected static final double MAX_AXIS_LABEL_HEIGHT = 0.28;
    protected static final double MAX_AXIS_LABEL_WIDTH = 0.28;
    protected static final int TOP_AND_DOWN_GAP = 6;
    protected Dimension2D titleDim = new Dimension(0, 0);
    protected transient Point2D originPoint;
    protected transient double unitLength;
    protected transient double axisLength;
    protected transient double axisGridLength;
    public static final double MIN_TICK_LENGTH = 1.0;
    public static final int DEFAULT_SAMPLING_TIME = 1;
    protected transient Rectangle2D plotZeroBounds;
    protected transient Rectangle2D plotLastBounds;
    protected transient Rectangle2D bounds;
    protected transient double axisLabelWidth = 8.0;
    protected transient Dimension2D startLabelDim = new Dimension(0, 0);
    protected transient Dimension2D endLabelDim = new Dimension(0, 0);
    protected int tickMarkType = 2;
    protected int secTickMarkType = 1;
    protected int position = 3;
    protected boolean axisReversed = false;
    protected int mainGridStyle = 0;
    protected Color mainGridColor = null;
    protected Color lineColor = new Color(176, 176, 176);
    protected int lineStyle = 1;
    protected TextAttr textAttr = new TextAttr();
    protected Format format;
    protected int labelNumber = 0;
    protected boolean isShowAxisLabel = true;
    protected boolean isArrowShow = false;
    protected boolean isCustomMinValue = false;
    protected double minValue = 0.0;
    protected boolean isCustomMaxValue = false;
    protected double maxValue = 0.0;
    protected BigDecimal mainUnit = new BigDecimal("1");
    private boolean isCustomMainUnit = false;
    private boolean isCustomSecUnit = false;
    private double secUnit = 0.2;
    private String axisType = "";
    private boolean drawBetweenTick = false;
    private boolean isZoom = false;
    protected TextGlyph titleGlyph = null;
    private transient Cubic cubic;
    protected transient Cubic threeDBase;
    protected boolean isLabelWrap = false;

    public void notShowAllAttr() {
        this.setTickMarkType(0);
        this.setShowAxisLabel(false);
        this.setTitleGlyph(null);
        this.setArrowShow(false);
        this.setLineColor(null);
        this.setLineStyle(0);
    }

    public abstract void initMinMaxValue(double var1, double var3);

    public abstract void drawAxisGrid(Graphics var1);

    protected void drawAfterPlot4AlertValues(Graphics2D graphics2D, int n) {
    }

    protected abstract void drawAxisLine(Graphics var1, int var2);

    protected abstract void calculateAxisLengthUnit();

    protected abstract double getMaxLabelWidthAndInitStartEndLabelDim(int var1);

    protected abstract void drawTicks(Graphics var1, int var2);

    public abstract double getCrossValue();

    public abstract double getArrowValue();

    public abstract String getJSAxisType();

    public abstract String getAxisName();

    public void dealPlotBoundsWithAxisLabel(Rectangle2D rectangle2D, int n) {
        double d = this.getCateLabelWidth(rectangle2D, n);
        if (d > 0.0) {
            d += 4.0;
        }
        this.setAxisLabelWidth(d += this.getTickLengthShow());
        this.calculateTitleDimesion(n);
        if (this.getBounds() == null) {
            this.setBounds(rectangle2D);
        }
        this.calculateBoundsWidthOrientationAndTitle(rectangle2D, d, this.titleDim);
        this.calBoundsWithMoreLabel4Cate(rectangle2D);
    }

    public void dealPlotBoundsWithLabelInHorizontal(Rectangle2D rectangle2D) {
        if (this.getPosition() == 2 || this.getPosition() == 4) {
            this.dealPlotBoundsLabelLeftRight(rectangle2D);
        } else {
            this.dealPlotBoundsLabelTopBottom(rectangle2D);
        }
    }

    public void dealPlotBoundsWithAxisTitle(Rectangle2D rectangle2D, int n) {
        this.calculateTitleDimesion(n);
        if (this.getBounds() == null) {
            this.setBounds(rectangle2D);
        }
        this.calculateBoundsWidthOrientationAndTitle(rectangle2D, 0.0, this.titleDim);
    }

    public void dealPlotBoundsWithLabel(Rectangle2D rectangle2D, int n) {
        double d = this.getCateLabelWidth(rectangle2D, n);
        if (d > 0.0) {
            d += 4.0;
        }
        this.setAxisLabelWidth(d += this.getTickLengthShow());
        Dimension dimension = new Dimension(0, 0);
        this.calculateBoundsWidthOrientationAndTitle(rectangle2D, d, dimension);
        this.calBoundsWithMoreLabel4Cate(rectangle2D);
    }

    protected double getCateLabelWidth(Rectangle2D rectangle2D, int n) {
        double d = this.getMaxLabelWidthAndInitStartEndLabelDim(n);
        if (this.shouldBeHeight()) {
            return Math.min(rectangle2D.getHeight() * 0.28, d);
        }
        return Math.min(rectangle2D.getWidth() * 0.28, d);
    }

    private void dealPlotBoundsLabelLeftRight(Rectangle2D rectangle2D) {
        double d;
        double d2;
        double d3;
        double d4 = this.endLabelDim.getHeight() / 2.0;
        if (d4 > (d3 = rectangle2D.getY() - this.plotZeroBounds.getY())) {
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY() + d4 - d3, rectangle2D.getWidth(), rectangle2D.getHeight() - d4 + d3);
        }
        if ((d2 = this.startLabelDim.getHeight() / 2.0) > (d = this.plotZeroBounds.getY() + this.plotZeroBounds.getHeight() - rectangle2D.getY() - rectangle2D.getHeight()) && Math.round(d) > 0L) {
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() - d2 + d);
        }
    }

    private void dealPlotBoundsLabelTopBottom(Rectangle2D rectangle2D) {
        double d;
        double d2;
        double d3;
        double d4 = this.endLabelDim.getWidth() / 2.0;
        if (d4 > (d3 = this.plotZeroBounds.getX() + this.plotZeroBounds.getWidth() - rectangle2D.getX() - rectangle2D.getWidth())) {
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() - d4 + d3, rectangle2D.getHeight());
        }
        if ((d2 = this.startLabelDim.getWidth() / 2.0) > (d = rectangle2D.getX() - this.plotZeroBounds.getX())) {
            rectangle2D.setFrame(rectangle2D.getX() + d2 - d, rectangle2D.getY(), rectangle2D.getWidth() - d2 + d, rectangle2D.getHeight());
        }
    }

    protected double getTickLengthShow() {
        return Math.max(this.getTickLength4Type(this.tickMarkType, 5), this.getTickLength4Type(this.secTickMarkType, 3));
    }

    private double getTickLength4Type(int n, int n2) {
        double d = 0.0;
        switch (n) {
            case 2: {
                d = n2;
                break;
            }
            case 3: {
                d = n2 / 2;
            }
        }
        return d;
    }

    protected void calculateTitleDimesion(int n) {
        if (this.titleGlyph != null && this.titleGlyph.isVisible()) {
            this.titleDim = this.titleGlyph.preferredDimension(n);
        }
    }

    protected void calBoundsWithMoreLabel4Cate(Rectangle2D rectangle2D) {
    }

    public void calculateBoundsWidthOrientationAndTitle(Rectangle2D rectangle2D, double d, Dimension2D dimension2D) {
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        double d6 = dimension2D.getWidth() > 0.0 ? dimension2D.getWidth() + 4.0 : 0.0;
        double d7 = dimension2D.getHeight() > 0.0 ? dimension2D.getHeight() + 4.0 : 0.0;
        switch (this.getPosition()) {
            case 2: {
                d2 += d + d6;
                d4 -= d + d6;
                break;
            }
            case 3: {
                d5 -= d + d7;
                break;
            }
            case 4: {
                d4 -= d + d6;
                break;
            }
            default: {
                d3 += d + d7;
                d5 -= d + d7;
            }
        }
        rectangle2D.setRect(d2, d3, d4, d5);
    }

    public void calculateAxisGlyph(Rectangle2D rectangle2D) {
        this.init(rectangle2D);
        this.calculateAxisLengthUnit();
        this.plotLastBounds = rectangle2D;
    }

    protected double dealWithPlotBounds() {
        return 0.0;
    }

    protected void init(Rectangle2D rectangle2D) {
        switch (this.getPosition()) {
            case 2: {
                this.leftCase(rectangle2D);
                break;
            }
            case 3: {
                this.bottomCase(rectangle2D);
                break;
            }
            case 4: {
                this.rightCase(rectangle2D);
                break;
            }
            default: {
                this.topCase(rectangle2D);
            }
        }
    }

    private void topCase(Rectangle2D rectangle2D) {
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, -this.axisLabelWidth, rectangle2D.getWidth(), this.axisLabelWidth);
        Point2D.Double double_2 = !this.hasAxisReversed() ? new Point2D.Double(0.0, this.axisLabelWidth) : new Point2D.Double(rectangle2D.getWidth(), this.axisLabelWidth);
        this.setAttr(double_, double_2, d, d2);
    }

    private void rightCase(Rectangle2D rectangle2D) {
        Point2D.Double double_;
        Rectangle2D.Double double_2;
        double d;
        double d2;
        boolean bl = this instanceof ValueAxisGlyph;
        if (this.getCubic() == null || !bl) {
            d2 = rectangle2D.getHeight();
            d = rectangle2D.getWidth();
            double_2 = new Rectangle2D.Double(rectangle2D.getWidth(), 0.0, this.axisLabelWidth, rectangle2D.getHeight());
            double_ = !this.hasAxisReversed() ? new Point2D.Double(0.0, rectangle2D.getHeight()) : new Point2D.Double(0.0, 0.0);
        } else {
            d2 = this.getCubic().getHeight();
            d = this.getCubic().getWidth() - this.axisLabelWidth;
            double_2 = new Rectangle2D.Double(0.0, 0.0, this.axisLabelWidth, d2);
            double_ = new Point2D.Double(this.axisLabelWidth, d2);
        }
        this.setAttr(double_2, double_, d2, d);
    }

    private void bottomCase(Rectangle2D rectangle2D) {
        Point2D.Double double_;
        Rectangle2D.Double double_2;
        double d;
        double d2;
        boolean bl = this instanceof ValueAxisGlyph;
        if (this.getCubic() == null || !bl) {
            d2 = rectangle2D.getWidth();
            d = rectangle2D.getHeight();
            double_2 = new Rectangle2D.Double(0.0, rectangle2D.getHeight(), rectangle2D.getWidth(), this.axisLabelWidth);
            double_ = !this.hasAxisReversed() ? new Point2D.Double(0.0, 0.0) : new Point2D.Double(rectangle2D.getWidth(), 0.0);
        } else {
            d2 = this.getCubic().getWidth();
            d = this.getCubic().getHeight() - this.axisLabelWidth;
            double_2 = new Rectangle2D.Double(0.0, d, d2, this.axisLabelWidth);
            double_ = new Point2D.Double(0.0, d);
        }
        this.setAttr(double_2, double_, d2, d);
    }

    private void leftCase(Rectangle2D rectangle2D) {
        Point2D.Double double_;
        Rectangle2D.Double double_2;
        double d;
        double d2;
        boolean bl = this instanceof ValueAxisGlyph;
        if (this.getCubic() == null || !bl) {
            d2 = rectangle2D.getHeight();
            d = rectangle2D.getWidth();
            double_2 = new Rectangle2D.Double(-this.axisLabelWidth, 0.0, this.axisLabelWidth, rectangle2D.getHeight());
            double_ = !this.hasAxisReversed() ? new Point2D.Double(this.axisLabelWidth, rectangle2D.getHeight()) : new Point2D.Double(this.axisLabelWidth, 0.0);
        } else {
            d2 = this.getCubic().getHeight();
            d = this.getCubic().getWidth() - this.axisLabelWidth;
            double_2 = new Rectangle2D.Double(0.0, 0.0, this.axisLabelWidth, d2);
            double_ = new Point2D.Double(this.axisLabelWidth, d2);
        }
        this.setAttr(double_2, double_, d2, d);
    }

    protected void setAttr(Rectangle2D rectangle2D, Point2D point2D, double d, double d2) {
        this.setBounds(rectangle2D);
        this.setOrigin(point2D);
        this.setAxisLength(d);
        this.setAxisGridLength(d2);
    }

    protected double getAxisLabelWidth(String string, int n) {
        Dimension2D dimension2D = this.getAxisLabelDim(string, n);
        return this.shouldBeHeight() ? dimension2D.getHeight() : dimension2D.getWidth();
    }

    protected Dimension2D getAxisLabelDim(String string, int n) {
        if (string == null) {
            return new Dimension(0, 0);
        }
        TextAttr textAttr = this.getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        return GlyphUtils.calculateTextDimensionWithRotation(string, textAttr, n);
    }

    protected boolean shouldBeHeight() {
        return this.getPosition() == 1 || this.getPosition() == 3;
    }

    protected String value2String(double d) {
        Format format = this.getFormat();
        String string = format != null ? format.format(new Double(d)) : ChartBaseUtils.generalFormat(d);
        return string;
    }

    public Point2D getOrigin() {
        return this.originPoint;
    }

    protected void setOrigin(Point2D point2D) {
        this.originPoint = point2D;
    }

    public double getCrossValueInPlot() {
        return 0.0;
    }

    public double getAxisLength() {
        return this.axisLength;
    }

    public void setAxisLength(double d) {
        this.axisLength = d;
    }

    public void setCustomSecUnit(boolean bl) {
        this.isCustomSecUnit = bl;
    }

    protected boolean isCustomSecUnit() {
        return this.isCustomSecUnit;
    }

    public double getUnitLen() {
        return this.unitLength;
    }

    public void setUnitLen(double d) {
        this.unitLength = d;
    }

    protected double getAxisGridLength() {
        return this.axisGridLength;
    }

    protected void setAxisGridLength(double d) {
        this.axisGridLength = d;
    }

    public void setTitleGlyph(TextGlyph textGlyph) {
        this.titleGlyph = textGlyph;
    }

    public abstract double getPreLeftWidth4DataSheet(int var1);

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    public void setPlotZeroBounds(Rectangle2D rectangle2D) {
        this.plotZeroBounds = rectangle2D;
    }

    public Rectangle2D getPlotZeroBounds() {
        return this.plotZeroBounds;
    }

    public Rectangle2D getPlotLastBounds() {
        return this.plotLastBounds;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinMaxValue(double d, double d2) {
        this.minValue = d;
        this.maxValue = d2;
    }

    public void setCustomMinValue(boolean bl) {
        this.isCustomMinValue = bl;
    }

    protected boolean isCustomMinValue() {
        return this.isCustomMinValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setCustomMaxValue(boolean bl) {
        this.isCustomMaxValue = bl;
    }

    protected boolean isCustomMaxValue() {
        return this.isCustomMaxValue;
    }

    public void setZoom(boolean bl) {
        this.isZoom = bl;
    }

    public boolean isZoom() {
        return this.isZoom;
    }

    public void setTickMarkType(int n) {
        this.tickMarkType = n;
    }

    public int getTickMarkType() {
        return this.tickMarkType;
    }

    public void setSecTickMarkType(int n) {
        this.secTickMarkType = n;
    }

    public int getSecTickMarkType() {
        return this.secTickMarkType;
    }

    public void setMainGridStyle(int n) {
        this.mainGridStyle = n;
    }

    public int getMainGridStyle() {
        return this.mainGridStyle;
    }

    public void setMainGridColor(Color color) {
        this.mainGridColor = color;
    }

    public Color getMainGridColor() {
        return this.mainGridColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setTextAttr(TextAttr textAttr) {
        this.textAttr = textAttr;
    }

    public TextAttr getTextAttr() {
        return this.textAttr;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean hasAxisReversed() {
        return this.axisReversed;
    }

    public void setAxisReversed(boolean bl) {
        this.axisReversed = bl;
    }

    public void setLabelNumber(int n) {
        this.labelNumber = n;
    }

    public int getLabelNumber() {
        return this.labelNumber;
    }

    public void setLabelWrap(boolean bl) {
        this.isLabelWrap = bl;
    }

    public void setArrowShow(boolean bl) {
        this.isArrowShow = bl;
    }

    public boolean isArrowShow() {
        return this.isArrowShow;
    }

    public void setShowAxisLabel(boolean bl) {
        this.isShowAxisLabel = bl;
    }

    public boolean isShowAxisLabel() {
        return this.isShowAxisLabel;
    }

    public boolean isLog() {
        return false;
    }

    public void setLog(boolean bl) {
    }

    public boolean isPercentage() {
        return false;
    }

    public void setAxisType(String string) {
        this.axisType = string;
    }

    public String getAxisType() {
        return this.axisType;
    }

    public void setMainUnit(BigDecimal bigDecimal) {
        this.mainUnit = bigDecimal;
    }

    public double getMainUnit() {
        return this.mainUnit.doubleValue();
    }

    public BigDecimal getBigDecimalMainUnit() {
        return this.mainUnit;
    }

    public void setCustomMainUnit(boolean bl) {
        this.isCustomMainUnit = bl;
    }

    public boolean isCustomMainUnit() {
        return this.isCustomMainUnit;
    }

    public Dimension2D getTitleDim() {
        return this.titleDim;
    }

    public Point2D getPointInBounds(double d) {
        if (d < this.getCrossValue()) {
            d = this.getCrossValue();
        }
        if (d > this.getArrowValue()) {
            d = this.getArrowValue();
        }
        return this.getPoint2D(d);
    }

    public double get2ValueLength(double d, double d2) {
        Point2D point2D = this.getPointInBounds(d);
        Point2D point2D2 = this.getPointInBounds(d2);
        if (this.position == 2 || this.position == 4) {
            return Math.abs(point2D.getY() - point2D2.getY());
        }
        return this.getOtherPoint2ValueLength(point2D, point2D2);
    }

    protected double getOtherPoint2ValueLength(Point2D point2D, Point2D point2D2) {
        return Math.abs(point2D.getX() - point2D2.getX());
    }

    public int getTickIndex4Value(int n) {
        return n;
    }

    public Point2D getPoint2D(double d) {
        Point2D.Double double_ = null;
        d -= this.getCrossValue();
        if (this.getPosition() == 2) {
            double d2 = this.getBounds().getY();
            double_ = d2 == this.originPoint.getY() || this.hasAxisReversed() ? new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() + this.unitLength * d) : new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() - this.unitLength * d);
        } else if (this.getPosition() == 4) {
            double d3 = this.hasAxisReversed() ? this.unitLength * d : -this.unitLength * d;
            double_ = new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() + d3);
        } else if (this.getPosition() == 1 || this.getPosition() == 3) {
            double d4 = this.hasAxisReversed() ? -this.unitLength * d : this.unitLength * d;
            double_ = new Point2D.Double(this.originPoint.getX() + d4, this.originPoint.getY());
        }
        return double_;
    }

    protected Line2D getTickLine(double d, int n, int n2) {
        Point2D point2D = this.getPoint2D(d);
        return this.getTickLineByCenterPoint(point2D, n, n2);
    }

    protected Line2D getTickLineByCenterPoint(Point2D point2D, int n, int n2) {
        Point2D.Double double_ = new Point2D.Double(point2D.getX() - (double)n, point2D.getY());
        Point2D.Double double_2 = new Point2D.Double(point2D.getX() + (double)n, point2D.getY());
        Point2D.Double double_3 = new Point2D.Double(point2D.getX(), point2D.getY() - (double)n);
        Point2D.Double double_4 = new Point2D.Double(point2D.getX(), point2D.getY() + (double)n);
        if (n2 == 3) {
            Point2D.Double double_5 = new Point2D.Double(point2D.getX() - (double)(n / 2), point2D.getY());
            Point2D.Double double_6 = new Point2D.Double(point2D.getX() + (double)(n / 2), point2D.getY());
            Point2D.Double double_7 = new Point2D.Double(point2D.getX(), point2D.getY() - (double)(n / 2));
            Point2D.Double double_8 = new Point2D.Double(point2D.getX(), point2D.getY() + (double)(n / 2));
            if (this.getPosition() == 2 || this.getPosition() == 4) {
                return new Line2D.Double(double_5, double_6);
            }
            return new Line2D.Double(double_7, double_8);
        }
        if (n2 == 1) {
            if (this.getPosition() == 2) {
                return new Line2D.Double(point2D, double_2);
            }
            if (this.getPosition() == 1) {
                return new Line2D.Double(point2D, double_4);
            }
            if (this.getPosition() == 4) {
                return new Line2D.Double(point2D, double_);
            }
            return new Line2D.Double(point2D, double_3);
        }
        if (n2 == 2) {
            if (this.getPosition() == 2) {
                return new Line2D.Double(point2D, double_);
            }
            if (this.getPosition() == 1) {
                return new Line2D.Double(point2D, double_3);
            }
            if (this.getPosition() == 4) {
                return new Line2D.Double(point2D, double_2);
            }
            return this.getOtherPositionTickLine(point2D, double_4, double_);
        }
        return null;
    }

    protected Line2D getOtherPositionTickLine(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        return new Line2D.Double(point2D, point2D2);
    }

    public void setDrawBetweenTick(boolean bl) {
        this.drawBetweenTick = bl;
    }

    public boolean isDrawBetweenTick() {
        return this.drawBetweenTick;
    }

    public void setCubic(Cubic cubic) {
        this.cubic = cubic;
    }

    public Cubic getCubic() {
        return this.cubic;
    }

    public Cubic getThreeDBase() {
        return this.threeDBase;
    }

    public void setThreeDBase(Cubic cubic) {
        this.threeDBase = cubic;
    }

    public void setSecUnit(double d) {
        this.secUnit = d;
    }

    public double getSecUnit() {
        return this.secUnit;
    }

    public String getShowUnit() {
        return null;
    }

    protected void drawLabel(Graphics graphics, double d, double d2, String string, int n) {
        if (!this.isShowAxisLabel) {
            return;
        }
        Rectangle2D rectangle2D = this.getLabelBounds(d, d2, string, n);
        String string2 = this.changeAxisLabelStringWithLabelBounds(string, rectangle2D, n);
        GlyphUtils.drawStrings(graphics, string2, this.textAttr, rectangle2D, n);
    }

    protected void drawLabelWrapWhenNeed(Graphics graphics, double d, double d2, String string, int n) {
        if (!this.isShowAxisLabel) {
            return;
        }
        if (this.textAttr.getAlignText() == 0) {
            this.drawTextHorizontalWrap(graphics, d, d2, string, n);
        } else if (this.textAttr.getAlignText() == 1) {
            this.drawTextVerticalWrap(graphics, d, d2, string, n);
        }
    }

    private void drawTextVerticalWrap(Graphics graphics, double d, double d2, String string, int n) {
        double d3;
        double d4 = 4.0 + this.getTickLengthShow();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string, this.textAttr, n);
        double d5 = d3 = this.shouldBeHeight() ? this.axisLabelWidth - d4 : this.unitLength - 6.0;
        if (dimension2D.getHeight() <= d3) {
            Rectangle2D rectangle2D = this.getLabelBounds(d, d2, string, n);
            String string2 = this.changeAxisLabelStringWithLabelBounds(string, rectangle2D, n);
            GlyphUtils.drawStrings(graphics, string2, this.textAttr, rectangle2D, n);
            return;
        }
        this.drawLabelVerticalWrap(graphics, d, d2, string, n);
    }

    private void drawLabelVerticalWrap(Graphics graphics, double d, double d2, String string, int n) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 4.0 + this.getTickLengthShow();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation("a", this.textAttr, n);
        if (this.shouldBeHeight()) {
            d3 = this.unitLength - dimension2D.getWidth();
            d4 = this.axisLabelWidth - d5;
        } else {
            d3 = this.axisLabelWidth - d5;
            d4 = this.unitLength - 6.0;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        double d6 = this.calculateWidthUsed(string, d4, d3, n, arrayList);
        Point2D point2D = this.getPoint2D(d + d2);
        int n2 = this.getPosition();
        Point point = n2 == 2 ? new Point((int)(point2D.getX() - d5), (int)(point2D.getY() - d4 / 2.0)) : new Point((int)(point2D.getX() + d6 / 2.0), (int)(point2D.getY() + d5));
        double d7 = point.getX();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            Dimension2D dimension2D2 = GlyphUtils.calculateTextDimensionWithRotation(string2, this.textAttr, n);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d7 - dimension2D2.getWidth(), point.getY(), dimension2D2.getWidth(), dimension2D2.getHeight());
            GlyphUtils.drawStrings(graphics, string2, this.textAttr, double_, n);
            d7 -= dimension2D2.getWidth() + 3.0;
        }
    }

    private double calculateWidthUsed(String string, double d, double d2, int n, ArrayList<String> arrayList) {
        double d3 = -3.0;
        double d4 = 0.0;
        block0: do {
            d3 += 3.0;
            for (int i = 1; i <= string.length(); ++i) {
                boolean bl;
                Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string.substring(0, i), this.textAttr, n);
                boolean bl2 = bl = dimension2D.getWidth() >= d2 || dimension2D.getHeight() > d;
                if (i == 1 && bl) {
                    string = "";
                    arrayList.add("\u2026");
                    dimension2D = GlyphUtils.calculateTextDimensionWithRotation("\u2026", this.textAttr, n);
                    d3 += dimension2D.getWidth();
                    continue block0;
                }
                double d5 = dimension2D.getHeight();
                if (d5 > d && i != 1) {
                    arrayList.add(string.substring(0, i - 1));
                    string = string.substring(i - 1);
                    d3 += dimension2D.getWidth();
                    d4 = dimension2D.getWidth();
                    continue;
                }
                if (i != string.length()) continue;
                arrayList.add(string);
                string = "";
                d3 += dimension2D.getWidth();
                d4 = dimension2D.getWidth();
            }
        } while (d3 < d2 && StringUtils.isNotEmpty((String)string));
        if (StringUtils.isEmpty((String)string)) {
            return d3;
        }
        arrayList.remove(arrayList.size() - 1);
        if (arrayList.isEmpty()) {
            arrayList.add("\u2026");
        } else {
            String string2 = arrayList.get(arrayList.size() - 1);
            arrayList.remove(arrayList.size() - 1);
            arrayList.add(this.calculateStr4VerticalWithEllipse(d, string2, n));
        }
        return d3 - d4 - 3.0;
    }

    private String calculateStr4VerticalWithEllipse(double d, String string, int n) {
        for (int i = 1; i < string.length() + 1; ++i) {
            String string2 = string.substring(0, i) + "\u2026";
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string2, this.textAttr, n);
            if (!(dimension2D.getHeight() > d)) continue;
            if (i == 0) {
                return "\u2026";
            }
            return string.substring(0, i - 1) + "\u2026";
        }
        return string;
    }

    private void drawTextHorizontalWrap(Graphics graphics, double d, double d2, String string, int n) {
        double d3 = 4.0 + this.getTickLengthShow();
        if (this.shouldBeHeight()) {
            Rectangle2D rectangle2D = this.getLabelBounds(d, d2, string, n);
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation("a", this.textAttr, n);
            Dimension2D dimension2D2 = GlyphUtils.calculateTextDimensionWithRotation(string, this.textAttr, n);
            if (dimension2D2.getWidth() <= this.unitLength - dimension2D.getWidth()) {
                String string2 = this.changeAxisLabelStringWithLabelBounds(string, rectangle2D, n);
                GlyphUtils.drawStrings(graphics, string2, this.textAttr, rectangle2D, n);
            } else {
                this.drawLabelWrap4AxisTopOrDown(graphics, d, d2, rectangle2D, dimension2D, string, n);
            }
        } else {
            Rectangle2D rectangle2D = this.getLabelBounds4WrapWhenAxisLeftOrRight(d, d2, string, n);
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation("a", this.textAttr, n);
            Dimension2D dimension2D3 = GlyphUtils.calculateTextDimensionWithRotation(string, this.textAttr, n);
            double d4 = this.axisLabelWidth - d3;
            if (dimension2D3.getWidth() < d4) {
                String string3 = this.changeAxisLabelStringWithLabelBounds(string, rectangle2D, n);
                GlyphUtils.drawStrings(graphics, string3, this.textAttr, rectangle2D, n);
            } else {
                this.drawLabelWrap4AxisLeftOrRight(graphics, d, d2, rectangle2D, dimension2D, string, n);
            }
        }
    }

    private void drawLabelWrap4AxisLeftOrRight(Graphics graphics, double d, double d2, Rectangle2D rectangle2D, Dimension2D dimension2D, String string, int n) {
        double d3 = rectangle2D.getY();
        double d4 = this.unitLength - 6.0;
        double d5 = 4.0 + this.getTickLengthShow();
        double d6 = this.axisLabelWidth - d5;
        double d7 = this.originPoint.getX() - d5;
        while (d3 + dimension2D.getHeight() + 4.0 < rectangle2D.getY() + d4) {
            Rectangle2D rectangle2D2;
            Object object;
            int n2 = this.calculateLoactionWithOutEllipsis(string, n, d6);
            if (n2 == 0) {
                object = this.getLabelBounds4WrapWhenAxisLeftOrRight(d, d2, "\u2026", n);
                GlyphUtils.drawStrings(graphics, "\u2026", this.textAttr, (Rectangle2D)object, n);
                break;
            }
            object = string.substring(0, n2);
            if (n2 == string.length()) {
                rectangle2D2 = this.getLabelBounds4WrapWhenAxisLeftOrRight(d, d2, (String)object, n);
                GlyphUtils.drawStrings(graphics, (String)object, this.textAttr, new Rectangle2D.Double(rectangle2D2.getX(), d3, rectangle2D2.getWidth(), rectangle2D2.getHeight()), n);
                break;
            }
            if (d3 + (dimension2D.getHeight() + 4.0) * 2.0 > rectangle2D.getY() + d4) {
                n2 = this.calculateLocationWithEllipsis(string, n, d6);
                object = string.substring(0, n2) + "\u2026";
                rectangle2D2 = this.getLabelBounds4WrapWhenAxisLeftOrRight(d, d2, (String)object, n);
                GlyphUtils.drawStrings(graphics, (String)object, this.textAttr, new Rectangle2D.Double(d7 - rectangle2D2.getWidth(), d3, rectangle2D2.getWidth(), rectangle2D2.getHeight()), n);
            } else {
                rectangle2D2 = this.getLabelBounds4WrapWhenAxisLeftOrRight(d, d2, (String)object, n);
                GlyphUtils.drawStrings(graphics, (String)object, this.textAttr, new Rectangle2D.Double(d7 - rectangle2D2.getWidth(), d3, rectangle2D2.getWidth(), rectangle2D2.getHeight()), n);
            }
            string = string.substring(n2);
            d3 += dimension2D.getHeight() + 4.0;
        }
    }

    private void drawLabelWrap4AxisTopOrDown(Graphics graphics, double d, double d2, Rectangle2D rectangle2D, Dimension2D dimension2D, String string, int n) {
        double d3 = rectangle2D.getY();
        while (d3 + dimension2D.getHeight() + 4.0 < rectangle2D.getY() + this.axisLabelWidth) {
            Rectangle2D rectangle2D2;
            Object object;
            int n2 = this.calculateLoactionWithOutEllipsis(string, n, this.unitLength - dimension2D.getWidth());
            if (n2 == 0) {
                object = this.getLabelBounds(d, d2, "\u2026", n);
                GlyphUtils.drawStrings(graphics, "\u2026", this.textAttr, (Rectangle2D)object, n);
                break;
            }
            object = string.substring(0, n2);
            if (n2 == string.length()) {
                rectangle2D2 = this.getLabelBounds(d, d2, (String)object, n);
                GlyphUtils.drawStrings(graphics, (String)object, this.textAttr, new Rectangle2D.Double(rectangle2D2.getX(), d3, rectangle2D2.getWidth(), rectangle2D2.getHeight()), n);
                break;
            }
            if (d3 + (dimension2D.getHeight() + 4.0) * 2.0 > rectangle2D.getY() + this.axisLabelWidth) {
                n2 = this.calculateLocationWithEllipsis(string, n, this.unitLength - dimension2D.getWidth());
                object = string.substring(0, n2) + "\u2026";
                rectangle2D2 = this.getLabelBounds(d, d2, (String)object, n);
                GlyphUtils.drawStrings(graphics, (String)object, this.textAttr, new Rectangle2D.Double(rectangle2D2.getX(), d3, rectangle2D2.getWidth(), rectangle2D2.getHeight()), n);
            } else {
                rectangle2D2 = this.getLabelBounds(d, d2, (String)object, n);
                GlyphUtils.drawStrings(graphics, (String)object, this.textAttr, new Rectangle2D.Double(rectangle2D2.getX(), d3, rectangle2D2.getWidth(), rectangle2D2.getHeight()), n);
            }
            string = string.substring(n2);
            d3 += dimension2D.getHeight() + 4.0;
        }
    }

    private int calculateLoactionWithOutEllipsis(String string, int n, double d) {
        for (int i = 0; i <= string.length(); ++i) {
            String string2 = string.substring(0, i);
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string2, this.textAttr, n);
            if (!(dimension2D.getWidth() > d)) continue;
            if (i == 0) {
                return 0;
            }
            return i - 1;
        }
        return string.length();
    }

    protected int calculateLocationWithEllipsis(String string, int n, double d) {
        for (int i = 0; i < string.length() + 1; ++i) {
            String string2 = string.substring(0, i) + "\u2026";
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string2, this.textAttr, n);
            if (!(dimension2D.getWidth() > d)) continue;
            if (i == 0) {
                return 0;
            }
            return i - 1;
        }
        return string.length();
    }

    protected String changeAxisLabelStringWithLabelBounds(String string, Rectangle2D rectangle2D, int n) {
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string, this.textAttr, n);
        if (this.shouldBeHeight()) {
            if (dimension2D.getHeight() > rectangle2D.getHeight()) {
                for (int i = 0; i < string.length(); ++i) {
                    String string2 = string.substring(0, i) + "\u2026";
                    Dimension2D dimension2D2 = GlyphUtils.calculateTextDimensionWithRotation(string2, this.textAttr, n);
                    if (!(dimension2D2.getHeight() > rectangle2D.getHeight())) continue;
                    if (i == 0) {
                        return "\u2026";
                    }
                    return string.substring(0, i - 1) + "\u2026";
                }
            }
            return string;
        }
        if (dimension2D.getWidth() > rectangle2D.getWidth()) {
            for (int i = 0; i < string.length(); ++i) {
                String string3 = string.substring(0, i) + "\u2026";
                Dimension2D dimension2D3 = GlyphUtils.calculateTextDimensionWithRotation(string3, this.textAttr, n);
                if (!(dimension2D3.getWidth() > rectangle2D.getWidth())) continue;
                if (i == 0) {
                    return "\u2026";
                }
                return string.substring(0, i - 1) + "\u2026";
            }
        }
        return string;
    }

    protected void drawLabel(Graphics graphics, double d, double d2, String string, GeneralPath generalPath, int n) {
        if (!this.isShowAxisLabel) {
            return;
        }
        Rectangle2D rectangle2D = this.getLabelBounds(d, d2, string, n);
        String string2 = this.changeAxisLabelStringWithLabelBounds(string, rectangle2D, n);
        if (this.getLabelNumber() != 0) {
            GlyphUtils.drawStrings(graphics, string2, this.textAttr, rectangle2D, n);
        } else if (!generalPath.intersects(rectangle2D)) {
            generalPath.append(rectangle2D, false);
            GlyphUtils.drawStrings(graphics, string2, this.textAttr, rectangle2D, n);
        }
    }

    public int getTickSamplingTime() {
        int n = 1;
        double d = (this.getMaxValue() - this.getMinValue()) / this.mainUnit.doubleValue();
        while (this.axisLength > 1.0 && this.axisLength / Math.ceil(d / (double)n * this.getMainUnit()) < 1.0) {
            ++n;
        }
        return n;
    }

    protected Rectangle2D getLabelBounds4WrapWhenAxisLeftOrRight(double d, double d2, String string, int n) {
        int n2;
        if (this.plotLastBounds == null || this.shouldBeHeight()) {
            return null;
        }
        Point2D point2D = this.getPoint2D(d + d2);
        TextAttr textAttr = this.getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string, textAttr, n);
        double d3 = dimension2D.getHeight();
        double d4 = dimension2D.getWidth();
        double d5 = 4.0 + this.getTickLengthShow();
        double d6 = this.unitLength - 6.0;
        double d7 = this.axisLabelWidth - d5;
        if (!this.shouldBeHeight() && d4 > d7) {
            n2 = (int)(d4 / d7);
            d4 = d7;
            d3 += (d3 + 4.0) * (double)n2;
            d3 = Math.min(d3, d6);
        }
        Rectangle2D.Double double_ = (n2 = this.getPosition()) == 2 ? new Rectangle2D.Double(point2D.getX() - d4 - d5, point2D.getY() - d3 / 2.0, d4, d3) : new Rectangle2D.Double(point2D.getX() + d5, point2D.getY() - d3 / 2.0, d4, d3);
        return double_;
    }

    protected Rectangle2D getLabelBounds(double d, double d2, String string, int n) {
        if (this.plotLastBounds == null) {
            return null;
        }
        Point2D point2D = this.getPoint2D(d + d2);
        TextAttr textAttr = this.getTextAttr();
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string, textAttr, n);
        int n2 = this.getPosition();
        double d3 = 4.0 + this.getTickLengthShow();
        double d4 = dimension2D.getHeight();
        double d5 = dimension2D.getWidth();
        if (this.shouldBeHeight()) {
            if (textAttr.getAlignText() == 1) {
                d4 += (double)textAttr.getFRFont().getSize();
            }
            d4 = Math.min(d4, this.axisLabelWidth - d3);
        } else {
            d5 = Math.min(d5, this.axisLabelWidth - d3);
        }
        Rectangle2D rectangle2D = n2 == 2 ? new Rectangle2D.Double(point2D.getX() - d5 - d3, point2D.getY() - d4 / 2.0, d5, d4) : (n2 == 1 ? new Rectangle2D.Double(point2D.getX() - d5 / 2.0, point2D.getY() - d4 - d3, d5, d4) : (n2 == 4 ? new Rectangle2D.Double(point2D.getX() + d3, point2D.getY() - d4 / 2.0, d5, d4) : this.getOtherPositionLabelBounds(point2D, d5, d4, d3)));
        return rectangle2D;
    }

    protected Rectangle2D getOtherPositionLabelBounds(Point2D point2D, double d, double d2, double d3) {
        return new Rectangle2D.Double(point2D.getX() - d / 2.0, point2D.getY() + d3, d, d2);
    }

    protected void drawTickLine(Graphics graphics, Line2D line2D, BasicStroke basicStroke) {
        if (this.shouldDrawTickLine(line2D)) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(basicStroke);
            graphics2D.setPaint(this.lineColor);
            graphics2D.draw(line2D);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
    }

    protected boolean shouldDrawTickLine(Line2D line2D) {
        return line2D != null && this.lineColor != null && this.lineStyle != 0;
    }

    public void draw(Graphics graphics, int n) {
        if (this.getBounds() == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisLine(graphics2D, n);
        this.drawAxisTitle(graphics2D, n);
        this.drawAfterPlot4AlertValues(graphics2D, n);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public void drawWithOutAlert(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisLine(graphics2D, n);
        this.drawAxisTitle(graphics2D, n);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public void draw4ThreeD(Graphics graphics, int n) {
    }

    protected void drawAxisTitle(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.titleGlyph != null) {
            Rectangle2D rectangle2D = this.calculatorTitleBounds(n);
            this.titleGlyph.setBounds(rectangle2D);
            int n2 = this.titleGlyph.getTextAttr().getRotation();
            if (this.titleGlyph.getTextAttr().getAlignText() == 1) {
                if (this.getPosition() == 2) {
                    this.titleGlyph.getTextAttr().setRotation(90);
                } else if (this.getPosition() == 4) {
                    this.titleGlyph.getTextAttr().setRotation(-90);
                }
            }
            this.titleGlyph.drawAxisTitle(graphics2D, n);
            if (this.titleGlyph.getTextAttr().getAlignText() == 1) {
                this.titleGlyph.getTextAttr().setRotation(n2);
            }
        }
    }

    public void drawArrow(Graphics2D graphics2D, Point2D point2D, Point2D point2D2) {
        if (this.isArrowShow()) {
            double d;
            Point2D.Double double_ = new Point2D.Double(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
            Point2D.Double double_2 = new Point2D.Double();
            double d2 = point2D.distance(point2D2);
            double d3 = 9.0;
            double d4 = 15.0;
            double d5 = 7.0;
            double d6 = 3.0;
            ((Point2D)double_2).setLocation(d3 * ((Point2D)double_).getX() / d2, d3 * ((Point2D)double_).getY() / d2);
            Point2D.Double double_3 = new Point2D.Double(point2D2.getX() + ((Point2D)double_2).getX(), point2D2.getY() + ((Point2D)double_2).getY());
            ((Point2D)double_2).setLocation(d4 * ((Point2D)double_).getX() / d2, d4 * ((Point2D)double_).getY() / d2);
            Point2D.Double double_4 = new Point2D.Double(point2D2.getX() + ((Point2D)double_2).getX(), point2D2.getY() + ((Point2D)double_2).getY());
            ((Point2D)double_2).setLocation(d5 * ((Point2D)double_).getX() / d2, d5 * ((Point2D)double_).getY() / d2);
            Point2D.Double double_5 = new Point2D.Double(point2D2.getX() + ((Point2D)double_2).getX(), point2D2.getY() + ((Point2D)double_2).getY());
            Point2D.Double double_6 = new Point2D.Double(((Point2D)double_5).getX() + ((Point2D)double_).getY() / d2 * d6, ((Point2D)double_5).getY() - ((Point2D)double_).getX() / d2 * d6);
            Point2D.Double double_7 = new Point2D.Double(((Point2D)double_5).getX() - ((Point2D)double_).getY() / d2 * d6, ((Point2D)double_5).getY() + ((Point2D)double_).getX() / d2 * d6);
            boolean bl = this.position == 2 || this.position == 4;
            boolean bl2 = this.isRevertAndArrow();
            double d7 = 0.0;
            if (bl && bl2 && (d = ((Point2D)double_4).getY() + this.plotLastBounds.getY() - (this.plotLastBounds.getY() + this.getPlotLastBounds().getHeight())) > 0.0) {
                d7 = -d;
            }
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((double)((float)((Point2D)double_3).getX()), (double)((float)((Point2D)double_3).getY()) + d7);
            generalPath.lineTo((double)((float)((Point2D)double_6).getX()), (double)((float)((Point2D)double_6).getY()) + d7);
            generalPath.lineTo((double)((float)((Point2D)double_4).getX()), (double)((float)((Point2D)double_4).getY()) + d7);
            generalPath.lineTo((double)((float)((Point2D)double_7).getX()), (double)((float)((Point2D)double_7).getY()) + d7);
            generalPath.closePath();
            graphics2D.draw(new Line2D.Double(point2D2, new Point2D.Double(((Point2D)double_3).getX(), ((Point2D)double_3).getY() + d7)));
            graphics2D.draw(generalPath);
            graphics2D.fill(generalPath);
        }
    }

    protected boolean isRevertAndArrow() {
        return this.isArrowShow && this.axisReversed;
    }

    public Line2D[] getGridLine(double d) {
        Point2D point2D = this.getPoint2D(d);
        Line2D line2D = this.getPosition() == 2 ? new Line2D.Double(point2D.getX(), point2D.getY(), point2D.getX() + this.getAxisGridLength(), point2D.getY()) : (this.getPosition() == 4 ? new Line2D.Double(point2D.getX() - this.getAxisGridLength(), point2D.getY(), point2D.getX(), point2D.getY()) : (this.getPosition() == 1 ? new Line2D.Double(point2D.getX(), point2D.getY() + this.getAxisGridLength(), point2D.getX(), point2D.getY()) : this.getOtherPositionGridLine(point2D)));
        return new Line2D[]{line2D};
    }

    protected Line2D getOtherPositionGridLine(Point2D point2D) {
        return new Line2D.Double(point2D.getX(), point2D.getY() - this.getAxisGridLength(), point2D.getX(), point2D.getY());
    }

    public Shape getShape() {
        Rectangle2D rectangle2D = this.getBounds();
        if (rectangle2D == null) {
            return new Rectangle();
        }
        if (this.getPosition() == 4 || this.getPosition() == 2) {
            return this.getVerticalShapeWithLabel(rectangle2D);
        }
        return this.getHorizontalShapeWithLabel(rectangle2D);
    }

    private Shape getVerticalShapeWithLabel(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() - this.endLabelDim.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight() + this.endLabelDim.getHeight() / 2.0 + this.startLabelDim.getHeight() / 2.0);
    }

    private Shape getHorizontalShapeWithLabel(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX() - this.startLabelDim.getWidth() / 2.0, rectangle2D.getY(), rectangle2D.getWidth() + this.startLabelDim.getWidth() / 2.0 + this.endLabelDim.getWidth() / 2.0, rectangle2D.getHeight());
    }

    public void setAxisLabelWidth(double d) {
        this.axisLabelWidth = d;
    }

    public double getAxisLabelWidth() {
        return this.axisLabelWidth;
    }

    protected Rectangle2D calculatorTitleBounds(int n) {
        Rectangle2D rectangle2D = null;
        Dimension2D dimension2D = this.titleGlyph.preferredDimension(n);
        int n2 = this.titleGlyph.getPosition();
        rectangle2D = this.getPosition() == 1 ? this.getTopTitleBounds(dimension2D, n2) : (this.getPosition() == 2 ? this.getLeftTitleBounds(dimension2D, n2) : (this.getPosition() == 3 ? this.getBottomTitleBounds(dimension2D, n2) : (this.getPosition() == 4 ? this.getRightTitleBounds(dimension2D, n2) : this.getOtherPositionTitleBounds(dimension2D, n2))));
        return rectangle2D;
    }

    protected Rectangle2D getOtherPositionTitleBounds(Dimension2D dimension2D, int n) {
        return null;
    }

    protected Rectangle2D getTopTitleBounds(Dimension2D dimension2D, int n) {
        return new Rectangle2D.Double(this.getTopBottomX(n), -4.0 - dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight());
    }

    protected double getTopBottomX(int n) {
        double d = (this.axisLength - this.titleDim.getWidth()) / 2.0;
        if (n == 2) {
            d = -8.0;
        } else if (n == 4) {
            d = this.axisLength - this.titleDim.getWidth() + 8.0;
        }
        return d;
    }

    protected Rectangle2D getBottomTitleBounds(Dimension2D dimension2D, int n) {
        return new Rectangle2D.Double(this.getTopBottomX(n), this.getAxisLabelWidth() + 4.0, dimension2D.getWidth(), dimension2D.getHeight());
    }

    protected Rectangle2D getLeftTitleBounds(Dimension2D dimension2D, int n) {
        return new Rectangle2D.Double(-dimension2D.getWidth() - 4.0, this.getLeftRightY(n), dimension2D.getWidth(), dimension2D.getHeight());
    }

    protected double getLeftRightY(int n) {
        double d = (this.axisLength - this.titleDim.getHeight()) / 2.0;
        if (n == 2) {
            d = -8.0;
        } else if (n == 4) {
            d = this.axisLength - this.titleDim.getHeight() + 8.0;
        }
        return d;
    }

    protected Rectangle2D getRightTitleBounds(Dimension2D dimension2D, int n) {
        return new Rectangle2D.Double(this.getAxisLabelWidth() + 4.0, this.getLeftRightY(n), dimension2D.getWidth(), dimension2D.getHeight());
    }

    public boolean equals(Object object) {
        return object instanceof AxisGlyph && ComparatorUtils.equals((String)object.getClass().getName(), (String)this.getClass().getName()) && ((AxisGlyph)object).maxValue == this.maxValue && ((AxisGlyph)object).minValue == this.minValue && ((AxisGlyph)object).isArrowShow == this.isArrowShow && ((AxisGlyph)object).isCustomMaxValue == this.isCustomMaxValue && ((AxisGlyph)object).isCustomMinValue == this.isCustomMinValue && ((AxisGlyph)object).axisGridLength == this.axisGridLength && ((AxisGlyph)object).isShowAxisLabel == this.isShowAxisLabel && ((AxisGlyph)object).axisLabelWidth == this.axisLabelWidth && ((AxisGlyph)object).axisLength == this.axisLength && ((AxisGlyph)object).labelNumber == this.labelNumber && ((AxisGlyph)object).lineStyle == this.lineStyle && ((AxisGlyph)object).mainGridStyle == this.mainGridStyle && ((AxisGlyph)object).position == this.position && ((AxisGlyph)object).secTickMarkType == this.secTickMarkType && ((AxisGlyph)object).secUnit == this.secUnit && ComparatorUtils.equals((Object)((AxisGlyph)object).mainUnit, (Object)this.mainUnit) && ((AxisGlyph)object).tickMarkType == this.tickMarkType && ((AxisGlyph)object).isZoom == this.isZoom && ((AxisGlyph)object).unitLength == this.unitLength && ComparatorUtils.equals((Object)((AxisGlyph)object).titleDim, (Object)this.titleDim) && ChartComparatorUtils.equals(((AxisGlyph)object).bounds, this.bounds) && ComparatorUtils.equals((Object)((AxisGlyph)object).originPoint, (Object)this.originPoint) && ComparatorUtils.equals((Object)((AxisGlyph)object).lineColor, (Object)this.lineColor) && ComparatorUtils.equals((String)((AxisGlyph)object).axisType, (String)this.axisType) && ComparatorUtils.equals((Object)((AxisGlyph)object).textAttr, (Object)this.textAttr) && ComparatorUtils.equals((Object)((AxisGlyph)object).format, (Object)this.format) && ComparatorUtils.equals((Object)((AxisGlyph)object).titleGlyph, (Object)this.titleGlyph) && ComparatorUtils.equals((Object)((AxisGlyph)object).mainGridColor, (Object)this.mainGridColor) && ((AxisGlyph)object).axisReversed == this.axisReversed;
    }

    @Override
    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("axisType", (Object)this.getJSAxisType());
        jSONObject.put("isShowAxisLabel", this.isShowAxisLabel);
        jSONObject.put("isLabelWrap", this.isLabelWrap);
        jSONObject.put("lineStyle", this.lineStyle);
        jSONObject.put("mainGridStyle", this.mainGridStyle);
        jSONObject.put("position", this.position);
        jSONObject.put("secTickMarkType", this.secTickMarkType);
        jSONObject.put("tickMarkType", this.tickMarkType);
        if (this.format != null) {
            jSONObject.put("format", (Object)ChartBaseUtils.format2JS(this.format, repository));
        }
        jSONObject.put("lineColor", (Object)StableUtils.javaColorToCSSColor((Color)this.lineColor));
        if (this.mainGridColor != null) {
            jSONObject.put("mainGridColor", (Object)StableUtils.javaColorToCSSColor((Color)this.mainGridColor));
        }
        if (this.textAttr != null) {
            jSONObject.put("textAttr", (Object)this.textAttr.toJSONObject());
        }
        jSONObject.put("isArrowShow", this.isArrowShow);
        jSONObject.put("labelNumber", this.labelNumber);
        jSONObject.put("isCustomMinValue", this.isCustomMinValue());
        jSONObject.put("minValue", this.getMinValue());
        jSONObject.put("isCustomMaxValue", this.isCustomMaxValue());
        jSONObject.put("maxValue", this.getMaxValue());
        if (this.titleGlyph != null) {
            jSONObject.put("titleGlyph", (Object)this.titleGlyph.toJSONObject(repository));
        }
        jSONObject.put("isCustomSecUnit", this.isCustomSecUnit);
        jSONObject.put("smallTickLength", this.getSecUnit());
        jSONObject.put("isCustomMainUnit", this.isCustomMainUnit);
        jSONObject.put("tickLength", this.getMainUnit());
        jSONObject.put("drawBetweenTick", this.drawBetweenTick);
        jSONObject.put("isZoom", this.isZoom);
        jSONObject.put("axisReversed", this.axisReversed);
        return jSONObject;
    }

    private void putLabelInfo(HashMap<String, Object> hashMap, JSONObject jSONObject) throws JSONException {
        if (!ComparatorUtils.equals((Object)hashMap.get("textAttr"), (Object)this.textAttr)) {
            HashMap<String, Object> hashMap2;
            if (this.textAttr.getFRFont() != null) {
                jSONObject.put("font", (Object)this.textAttr.getFRFont().changedAttrToJSONObject());
            }
            if (!ComparatorUtils.equals((Object)(hashMap2 = ChartDefaultConfig.TEXT_ATTR_DEFAULT).get("rotation"), (Object)this.textAttr.getRotation())) {
                jSONObject.put("rotation", this.textAttr.getRotation());
            }
            if (!ComparatorUtils.equals((Object)hashMap2.get("alignText"), (Object)this.textAttr.getAlignText())) {
                jSONObject.put("alignText", this.textAttr.getAlignText());
            }
        }
        if (!ComparatorUtils.equals((Object)hashMap.get("isShowAxisLabel"), (Object)this.isShowAxisLabel)) {
            jSONObject.put("isShowAxisLabel", this.isShowAxisLabel);
        }
        if (!ComparatorUtils.equals((Object)hashMap.get("labelNumber"), (Object)this.labelNumber)) {
            jSONObject.put("gap", this.labelNumber);
        }
        if (!ComparatorUtils.equals((Object)hashMap.get("isCustomMinValue"), (Object)this.isCustomMinValue)) {
            jSONObject.put("isCustomMinValue", this.isCustomMinValue());
        }
        if (this.isCustomMinValue() && !ComparatorUtils.equals((Object)hashMap.get("minValue"), (Object)this.getMinValue())) {
            jSONObject.put("minValue", this.getMinValue());
        }
        if (!ComparatorUtils.equals((Object)hashMap.get("isCustomMaxValue"), (Object)this.isCustomMaxValue)) {
            jSONObject.put("isCustomMaxValue", this.isCustomMaxValue());
        }
        if (this.isCustomMaxValue() && !ComparatorUtils.equals((Object)hashMap.get("maxValue"), (Object)this.getMaxValue())) {
            jSONObject.put("maxValue", this.getMaxValue());
        }
        if (!ComparatorUtils.equals((Object)hashMap.get("drawBetweenTick"), (Object)this.drawBetweenTick)) {
            jSONObject.put("drawBetweenTick", this.drawBetweenTick);
        }
        if (!ComparatorUtils.equals((Object)hashMap.get("format"), (Object)this.format) && this.format != null) {
            jSONObject.put("format", (Object)ChartBaseUtils.format2JS(this.format));
        }
    }

    private void putLineInfo(HashMap<String, Object> hashMap, JSONObject jSONObject) throws JSONException {
        if (!ComparatorUtils.equals((Object)hashMap.get("lineStyle"), (Object)this.lineStyle)) {
            jSONObject.put("lineStyle", this.lineStyle);
        }
        if (!ComparatorUtils.equals((Object)hashMap.get("lineColor"), (Object)this.lineColor)) {
            jSONObject.put("lineColor", (Object)StableUtils.javaColorToCSSColor((Color)this.lineColor));
        }
        if (!ComparatorUtils.equals((Object)hashMap.get("tickMarkType"), (Object)this.tickMarkType)) {
            jSONObject.put("tickMarkType", this.tickMarkType);
        }
        if (!ComparatorUtils.equals((Object)hashMap.get("secTickMarkType"), (Object)this.secTickMarkType)) {
            jSONObject.put("secTickMarkType", this.secTickMarkType);
        }
        if (!ComparatorUtils.equals((Object)hashMap.get("isCustomMainUnit"), (Object)this.isCustomMainUnit)) {
            jSONObject.put("isCustomMainUnit", this.isCustomMainUnit);
        }
        if (this.isCustomMainUnit && !ComparatorUtils.equals((Object)hashMap.get("tickLength"), (Object)this.getMainUnit())) {
            jSONObject.put("tickLength", this.getMainUnit());
        }
        if (!ComparatorUtils.equals((Object)hashMap.get("isCustomSecUnit"), (Object)this.isCustomSecUnit)) {
            jSONObject.put("isCustomSecUnit", this.isCustomSecUnit);
        }
        if (this.isCustomSecUnit && !ComparatorUtils.equals((Object)hashMap.get("smallTickLength"), (Object)this.getSecUnit())) {
            jSONObject.put("smallTickLength", this.getSecUnit());
        }
    }
}

