/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.FCloneable;
import com.fr.stable.StringUtils;
import java.io.Serializable;

public class StockLabel
implements FCloneable,
Serializable {
    public static final String VOLUMEN = Inter.getLocText((String)"Chart-Stock_Volume");
    public static final String OPEN = Inter.getLocText((String)"Chart-Stock_Open");
    public static final String HIGHT = Inter.getLocText((String)"Chart-Stock_High");
    public static final String LOW = Inter.getLocText((String)"Chart-Stock_Low");
    public static final String CLOSE = Inter.getLocText((String)"FR-Chart-Stock_Close");
    private String volumeLabel = VOLUMEN;
    private String openLabel = OPEN;
    private String highLabel = HIGHT;
    private String lowLabel = LOW;
    private String closeLabel = CLOSE;
    private String volumnTip = "(" + VOLUMEN + ")";
    private String openTip = "(" + OPEN + ")";
    private String highTip = "(" + HIGHT + ")";
    private String lowTip = "(" + LOW + ")";
    private String closeTip = "(" + CLOSE + ")";

    public StockLabel() {
    }

    public StockLabel(String string, String string2, String string3, String string4, String string5) {
        this.volumeLabel = StringUtils.isEmpty((String)string) ? VOLUMEN : string;
        this.openLabel = StringUtils.isEmpty((String)string2) ? OPEN : string2;
        this.highLabel = StringUtils.isEmpty((String)string3) ? HIGHT : string3;
        this.lowLabel = StringUtils.isEmpty((String)string4) ? LOW : string4;
        this.closeLabel = StringUtils.isEmpty((String)string5) ? CLOSE : string5;
        this.dealWithLabelRule();
    }

    private void dealWithLabelRule() {
        if (!ComparatorUtils.equals((String)this.volumeLabel, (String)VOLUMEN)) {
            this.volumeLabel = StringUtils.cutStringEndWith((String)this.volumeLabel, (String)this.volumnTip);
        }
        if (!ComparatorUtils.equals((String)this.openLabel, (String)OPEN)) {
            this.openLabel = StringUtils.cutStringEndWith((String)this.openLabel, (String)this.openTip);
        }
        if (!ComparatorUtils.equals((String)this.highLabel, (String)HIGHT)) {
            this.highLabel = StringUtils.cutStringEndWith((String)this.highLabel, (String)this.highTip);
        }
        if (!ComparatorUtils.equals((String)this.lowLabel, (String)LOW)) {
            this.lowLabel = StringUtils.cutStringEndWith((String)this.lowLabel, (String)this.lowTip);
        }
        if (!ComparatorUtils.equals((String)this.closeLabel, (String)CLOSE)) {
            this.closeLabel = StringUtils.cutStringEndWith((String)this.closeLabel, (String)this.closeTip);
        }
    }

    public String getVolumeLabel() {
        return this.volumeLabel;
    }

    public String getOpenLabel() {
        return this.openLabel;
    }

    public String getHighLabel() {
        return this.highLabel;
    }

    public String getLowLabel() {
        return this.lowLabel;
    }

    public String getCloseLabel() {
        return this.closeLabel;
    }

    public boolean equals(Object object) {
        return object instanceof StockLabel && ComparatorUtils.equals((String)((StockLabel)object).getVolumeLabel(), (String)this.getVolumeLabel()) && ComparatorUtils.equals((String)((StockLabel)object).getOpenLabel(), (String)this.getOpenLabel()) && ComparatorUtils.equals((String)((StockLabel)object).getHighLabel(), (String)this.getHighLabel()) && ComparatorUtils.equals((String)((StockLabel)object).getLowLabel(), (String)this.getLowLabel()) && ComparatorUtils.equals((String)((StockLabel)object).getCloseLabel(), (String)this.getCloseLabel());
    }

    public Object clone() throws CloneNotSupportedException {
        StockLabel stockLabel = (StockLabel)super.clone();
        stockLabel.volumeLabel = this.volumeLabel;
        stockLabel.openLabel = this.openLabel;
        stockLabel.highLabel = this.highLabel;
        stockLabel.lowLabel = this.lowLabel;
        stockLabel.closeLabel = this.closeLabel;
        return stockLabel;
    }
}

