/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.Utils;
import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.chart.chartdata.TableDataDefinition;
import com.fr.data.core.DataCoreUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public abstract class NormalTableDataDefinition
extends TableDataDefinition {
    private static final long serialVersionUID = -1211079023903447407L;
    protected transient int firstLabelCol;
    protected transient int secondCol;
    protected transient int thirdCol;
    protected transient Object[] categoryLabels;
    protected transient Object[] secondLabels;
    protected transient Object[] thirdLabels;
    private String categoryName;
    private ArrayList moreCateLabels = new ArrayList();
    private HashMap<Object, Integer> categoryIndexMap = new HashMap();

    protected int add2ColumnListWithName(DataModel dataModel, List list, String string, DataProcessor dataProcessor) throws TableDataException {
        int n = DataCoreUtils.getColumnIndexByName((DataModel)dataModel, (String)string);
        if (n != -1) {
            list.addAll(Arrays.asList(dataProcessor.getDistinctValues(dataModel, n)));
        } else {
            list.add(string);
        }
        return n;
    }

    protected void initAllCateLabels(DataModel dataModel, DataProcessor dataProcessor) throws TableDataException {
        int n;
        int n2;
        ArrayList arrayList = new ArrayList();
        this.firstLabelCol = this.add2ColumnListWithName(dataModel, arrayList, this.getCategoryName(), dataProcessor);
        Object[] objectArray = arrayList.toArray();
        ArrayList arrayList2 = new ArrayList();
        if (this.getMoreCateWithIndex(0) != null) {
            this.secondCol = this.add2ColumnListWithName(dataModel, arrayList2, Utils.objectToString((Object)this.getMoreCateWithIndex(0)), dataProcessor);
        }
        this.secondLabels = arrayList2.toArray(new Object[arrayList2.size()]);
        ArrayList arrayList3 = new ArrayList();
        if (this.getMoreCateWithIndex(1) != null) {
            this.thirdCol = this.add2ColumnListWithName(dataModel, arrayList3, Utils.objectToString((Object)this.getMoreCateWithIndex(1)), dataProcessor);
        }
        this.thirdLabels = arrayList3.toArray(new Object[arrayList3.size()]);
        int n3 = objectArray.length;
        int n4 = n2 = this.secondLabels != null ? this.secondLabels.length : 1;
        if (n2 > 0) {
            n3 *= n2;
        }
        int n5 = n = this.thirdLabels != null ? this.thirdLabels.length : 1;
        if (n > 0) {
            n3 *= n;
        }
        this.categoryLabels = new Object[n3];
        int n6 = objectArray.length;
        for (int i = 0; i < n3; ++i) {
            Object object;
            this.categoryLabels[i] = object = objectArray[i % n6];
            if (i >= n6) continue;
            this.categoryIndexMap.put(object, i);
        }
    }

    protected int getCategoryIndex(DataModel dataModel, int n) throws TableDataException {
        int n2;
        Object object = dataModel.getValueAt(n, this.firstLabelCol);
        int n3 = this.categoryIndexMap.get(object);
        Object object2 = dataModel.getValueAt(n, this.secondCol);
        int n4 = this.check4IndexInObjects(object2, this.secondLabels);
        Object object3 = dataModel.getValueAt(n, this.thirdCol);
        int n5 = this.check4IndexInObjects(object3, this.thirdLabels);
        int n6 = this.categoryLabels == null ? 1 : this.categoryLabels.length;
        int n7 = this.secondLabels == null ? 1 : this.secondLabels.length;
        int n8 = n2 = this.thirdLabels == null ? 1 : this.thirdLabels.length;
        if (n2 > 0 && n7 > 0) {
            return n3 + n4 * n6 / (n2 * n7) + n5 * n6 / n2;
        }
        if (n7 > 0) {
            return n3 + n4 * n6 / n7;
        }
        return n3;
    }

    private int check4IndexInObjects(Object object, Object[] objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (!ComparatorUtils.equals((Object)object, (Object)objectArray[i])) continue;
            return i;
        }
        return 0;
    }

    protected Object[] getMoreLabelWithIndex(DataModel dataModel, int n, DataProcessor dataProcessor) throws TableDataException {
        int n2 = this.getMoreCateSize();
        for (int i = 0; i < n2; ++i) {
            ArrayList arrayList = new ArrayList();
            this.add2ColumnListWithName(dataModel, arrayList, Utils.objectToString((Object)this.getMoreCateWithIndex(i)), dataProcessor);
            if (i != n) continue;
            return arrayList.toArray(new Object[arrayList.size()]);
        }
        return new Object[0];
    }

    public JSONObject createDataConfig() throws JSONException {
        JSONObject jSONObject = super.createDataConfig();
        jSONObject.put("categoryName", (Object)this.categoryName);
        if (this.moreCateLabels != null && !this.moreCateLabels.isEmpty()) {
            JSONArray jSONArray = new JSONArray();
            int n = this.moreCateLabels.size();
            for (int i = 0; i < n; ++i) {
                jSONArray.put((Object)Utils.objectToString(this.moreCateLabels.get(i)));
            }
            jSONObject.put("moreCateLabels", (Object)jSONArray);
        }
        return jSONObject;
    }

    public void setCategoryName(String string) {
        this.categoryName = string;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void addMoreCate(String string) {
        this.moreCateLabels.add(string);
    }

    public int getMoreCateSize() {
        return this.moreCateLabels.size();
    }

    public Object getMoreCateWithIndex(int n) {
        return n < this.moreCateLabels.size() ? this.moreCateLabels.get(n) : null;
    }

    public void clearMoreCate() {
        this.moreCateLabels.clear();
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.getCategoryName() != null) {
            xMLPrintWriter.startTAG("CategoryName").attr("value", this.getCategoryName()).end();
        }
        if (!this.moreCateLabels.isEmpty()) {
            xMLPrintWriter.startTAG("TableMoreCate");
            int n = this.moreCateLabels.size();
            for (int i = 0; i < n; ++i) {
                xMLPrintWriter.startTAG("oneMoreCate");
                xMLPrintWriter.attr("cateName", Utils.objectToString(this.moreCateLabels.get(i)));
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals((String)"CategoryName", (String)string)) {
                String string2 = xMLableReader.getAttrAsString("value", null);
                if (string2 != null) {
                    this.setCategoryName(string2);
                }
            } else if (ComparatorUtils.equals((String)"TableMoreCate", (String)string)) {
                this.clearMoreCate();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (ComparatorUtils.equals((String)"oneMoreCate", (String)xMLableReader.getTagName())) {
                            String string = xMLableReader.getAttrAsString("cateName", "");
                            NormalTableDataDefinition.this.addMoreCate(string);
                        }
                    }
                });
            }
        }
    }

    public boolean equals(Object object) {
        return object instanceof NormalTableDataDefinition && ComparatorUtils.equals((String)((NormalTableDataDefinition)object).categoryName, (String)this.categoryName) && ComparatorUtils.equals((Object)((NormalTableDataDefinition)object).moreCateLabels, (Object)this.moreCateLabels) && super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        NormalTableDataDefinition normalTableDataDefinition = (NormalTableDataDefinition)super.clone();
        normalTableDataDefinition.moreCateLabels = (ArrayList)this.moreCateLabels.clone();
        return normalTableDataDefinition;
    }
}

